/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.rho.modules.sys.service.c.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.date.LocalDateTimeUtil;
import cn.hutool.core.io.FileUtil;
import cn.hutool.core.util.StrUtil;
import cn.smarthse.framework.mybatisPlus.service.impl.ServiceImpl;
import cn.smarthse.rho.modules.sys.dao.c.CDoseDataMapper;
import cn.smarthse.rho.modules.sys.entity.c.CDoseData;
import cn.smarthse.rho.modules.sys.entity.c.CStaffBaseInfo;
import cn.smarthse.rho.modules.sys.enums.RhoRiskCycleEnum;
import cn.smarthse.rho.modules.sys.enums.risk.RiskWarningStatusEnum;
import cn.smarthse.rho.modules.sys.model.c.param.CDoseQueryParam;
import cn.smarthse.rho.modules.sys.model.c.param.rayCert.DoseSdInfoParam;
import cn.smarthse.rho.modules.sys.model.c.param.staff.CheckStaffRelationParam;
import cn.smarthse.rho.modules.sys.model.c.param.staff.relocation.StaffRelocateParam;
import cn.smarthse.rho.modules.sys.model.c.vo.CDoseBigStatisticsVo;
import cn.smarthse.rho.modules.sys.model.c.vo.CDoseDataVo;
import cn.smarthse.rho.modules.sys.model.c.vo.rayCert.DoseSdInfo;
import cn.smarthse.rho.modules.sys.model.home.vo.HomeData34;
import cn.smarthse.rho.modules.sys.model.r.vo.CalculateVo;
import cn.smarthse.rho.modules.sys.model.sys.vo.SysFileVo;
import cn.smarthse.rho.modules.sys.service.c.ICDoseDataService;
import cn.smarthse.rho.modules.sys.service.sys.ISysFileService;
import cn.smarthse.rho.modules.sys.utils.risk.WarningTypeUtil;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.time.LocalDateTime;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalUnit;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class CDoseDataServiceImpl
extends ServiceImpl<CDoseDataMapper, CDoseData>
implements ICDoseDataService {
    @Autowired
    private ISysFileService sysFileService;

    @Override
    public PageInfo<CDoseDataVo> getDoseListForArchive(CDoseQueryParam param) {
        PageHelper.startPage((int)param.getPage(), (int)param.getLimit());
        List<CDoseDataVo> list = ((CDoseDataMapper)this.baseMapper).getDoseListForArchive(param);
        return new PageInfo(list);
    }

    @Override
    public CDoseData getLastDoseCheckData(Long staffBaseInfoId) {
        return ((CDoseDataMapper)this.baseMapper).getLastDoseCheckData(staffBaseInfoId);
    }

    @Override
    public CDoseData getLastValidData(Long staffBaseInfoId) {
        return ((CDoseDataMapper)this.baseMapper).getLastValidData(staffBaseInfoId);
    }

    @Override
    public CalculateVo calculate(CDoseData entity) {
        if (entity.getCheckDate() == null) {
            return null;
        }
        LocalDateTime startDate = LocalDateTimeUtil.of((TemporalAccessor)entity.getCheckDate());
        LocalDateTime expireDate = this.calculateExpireDate(entity);
        Integer warnType = this.calculateWarnType(entity);
        CalculateVo calculate = new CalculateVo();
        calculate.setWarningType(warnType);
        calculate.setExpireTime(expireDate);
        calculate.setStartTime(startDate);
        return calculate;
    }

    @Override
    public CalculateVo calculate2(CStaffBaseInfo entity) {
        if (entity.getCreateDate() == null) {
            return null;
        }
        CalculateVo calculate = new CalculateVo();
        calculate.setStartTime(entity.getCreateDate());
        Integer warningType = WarningTypeUtil.calculateNonDataWarningType((LocalDateTime)entity.getCreateDate());
        warningType = warningType.equals(RiskWarningStatusEnum.RED.getValue()) || warningType.equals(RiskWarningStatusEnum.ACTIVATE_LAW.getValue()) ? warningType : RiskWarningStatusEnum.NONE.getValue();
        calculate.setWarningType(warningType);
        return calculate;
    }

    private Integer calculateWarnType(CDoseData entity) {
        if (entity.getCheckDate() == null) {
            return null;
        }
        LocalDateTime now = LocalDateTime.now();
        LocalDateTime expireDate = this.calculateExpireDate(entity);
        return WarningTypeUtil.calculateHasDataWarningTypeForDose((LocalDateTime)now, (LocalDateTime)expireDate);
    }

    private LocalDateTime calculateExpireDate(CDoseData entity) {
        if (entity.getCheckDate() == null) {
            return null;
        }
        return LocalDateTimeUtil.offset((LocalDateTime)LocalDateTimeUtil.of((TemporalAccessor)entity.getCheckDate()), (long)RhoRiskCycleEnum.DOSE.getCycle(), (TemporalUnit)RhoRiskCycleEnum.DOSE.getUnit());
    }

    @Override
    public PageInfo<CDoseData> getDoseDataList(CDoseQueryParam param) {
        PageHelper.startPage((int)param.getPage(), (int)param.getLimit());
        List<CDoseData> list = ((CDoseDataMapper)this.baseMapper).getDoseDataList(param);
        return new PageInfo(list);
    }

    @Override
    public PageInfo<CDoseData> getOverDoseDataList(CDoseQueryParam param) {
        PageHelper.startPage((int)param.getPage(), (int)param.getLimit());
        List<CDoseData> list = ((CDoseDataMapper)this.baseMapper).getDoseDataList(param);
        return new PageInfo(list);
    }

    @Override
    public HomeData34 getHomeData34(Long cid) {
        return ((CDoseDataMapper)this.baseMapper).getHomeData34(cid);
    }

    @Override
    public CDoseBigStatisticsVo getBigDoseStatisticsData(Long cid) {
        return ((CDoseDataMapper)this.baseMapper).getbigDoseStatisticsData(cid);
    }

    @Override
    public CDoseData getLastData(Long staffBaseInfoId) {
        return ((CDoseDataMapper)this.baseMapper).getLastData(staffBaseInfoId);
    }

    @Override
    public CDoseData getLastDataForGenDoseRisk(Long staffBaseInfoId, LocalDateTime start) {
        return ((CDoseDataMapper)this.baseMapper).getLastDataForGenDoseRisk(staffBaseInfoId, start);
    }

    @Override
    public CDoseData getLastDataForGenCommonDoseRisk(Long staffBaseInfoId) {
        return ((CDoseDataMapper)this.baseMapper).getLastDataForGenCommonDoseRisk(staffBaseInfoId);
    }

    @Override
    public CDoseData getLastDataForGenErrorDoseRisk(Long staffBaseInfoId) {
        return ((CDoseDataMapper)this.baseMapper).getLastDataForGenErrorDoseRisk(staffBaseInfoId);
    }

    @Override
    public CDoseData getLastDataForDeleting(CheckStaffRelationParam param) {
        return ((CDoseDataMapper)this.baseMapper).getLastDataForDeleting(param);
    }

    @Override
    public CDoseData getSdDataForAdding(Long staffBaseInfoId) {
        return ((CDoseDataMapper)this.baseMapper).getSdDataForAdding(staffBaseInfoId);
    }

    @Override
    public DoseSdInfo getSdInfo(DoseSdInfoParam param) {
        CDoseData db = (CDoseData)this.getById(param.getDoseDataId());
        DoseSdInfo sdInfo = null;
        if (db != null) {
            sdInfo = new DoseSdInfo();
            sdInfo.setId(db.getId());
            sdInfo.setTechName(db.getTechName());
            sdInfo.setBeginDate(db.getBeginDate());
            sdInfo.setEndDate(db.getEndDate());
            sdInfo.setResult(db.getResult());
            sdInfo.setReturnReason(db.getReturnReason());
            sdInfo.setIsSdFile(db.getIsSdFile());
            sdInfo.setSdFileId(db.getSdFileId());
            List<SysFileVo> fileVoByIds = this.sysFileService.getFileVoByIds(String.valueOf(db.getSdFileId()));
            if (CollUtil.isNotEmpty(fileVoByIds)) {
                SysFileVo fileVo = fileVoByIds.get(0);
                sdInfo.setSdFileUrl(fileVo == null ? null : fileVo.getFullOssUrl());
                sdInfo.setSdFileName(fileVo == null ? null : (StrUtil.isBlank((CharSequence)fileVo.getFileName()) ? FileUtil.getName((String)fileVo.getFullOssUrl()) : fileVo.getFileName()));
            }
        }
        return sdInfo;
    }

    @Override
    public List<CDoseData> getListForRelocating(StaffRelocateParam param) {
        return ((CDoseDataMapper)this.baseMapper).getListForRelocating(param);
    }
}

