/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.rho.modules.sys.service.c.impl;

import cn.smarthse.framework.mybatisPlus.service.impl.ServiceImpl;
import cn.smarthse.rho.core.framework.bootstrap.properties.SysProperties;
import cn.smarthse.rho.core.framework.utils.AesUtil;
import cn.smarthse.rho.modules.sys.dao.c.CCertMapper;
import cn.smarthse.rho.modules.sys.entity.c.CCert;
import cn.smarthse.rho.modules.sys.model.c.vo.CertConditionVo;
import cn.smarthse.rho.modules.sys.model.c.vo.rayCert.RayCertAfterGenVo;
import cn.smarthse.rho.modules.sys.service.c.ICCertService;
import cn.smarthse.rho.modules.sys.service.sys.ISysFileService;
import javax.smarthse.framework.exception.ServiceException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class CCertServiceImpl
extends ServiceImpl<CCertMapper, CCert>
implements ICCertService {
    @Autowired
    private SysProperties sysProperties;
    @Autowired
    private ISysFileService sysFileService;

    @Override
    public RayCertAfterGenVo getAfterGenInfoBySbId(Long sbId) {
        CCert db = ((CCertMapper)this.baseMapper).getValidBySbId(sbId);
        if (db == null) {
            return null;
        }
        return this.getAfterGenInfo(db.getId());
    }

    @Override
    public RayCertAfterGenVo getAfterGenInfoBySoce(String scode) {
        Long certId = null;
        try {
            certId = Long.valueOf(AesUtil.decrypt((String)scode, (String)this.sysProperties.getRayCertAesKey()));
        }
        catch (Exception e) {
            throw new ServiceException("\u89e3\u6790\u5931\u8d25");
        }
        return this.getAfterGenInfo(certId);
    }

    @Override
    public RayCertAfterGenVo getAfterGenInfo(Long certId) {
        CCert cert = (CCert)this.getById(certId);
        if (cert == null) {
            return null;
        }
        CertConditionVo certCondition = this.getCertCondition(cert.getBaseId());
        RayCertAfterGenVo vo = new RayCertAfterGenVo();
        vo.setId(cert.getId());
        vo.setScode(AesUtil.encrypt((String)String.valueOf(vo.getId()), (String)this.sysProperties.getRayCertAesKey()));
        vo.setRaType(cert.getRaType());
        vo.setName(cert.getName());
        vo.setBirthday(cert.getBirthday());
        vo.setSex(cert.getSex());
        vo.setHealthCheckTime(cert.getHealthCheckTime());
        vo.setTrainingTime(cert.getTrainingTime());
        vo.setDoseCheckTime(cert.getDoseCheckTime());
        vo.setDoseBeginTime(cert.getDoseBeginTime());
        vo.setDoseEndTime(cert.getDoseEndTime());
        vo.setCname(cert.getCname());
        vo.setRaCert(cert.getRaCert());
        vo.setIssueUnitName(cert.getIssueUnitName());
        vo.setIssueTime(cert.getIssueTime());
        vo.setIsComplete(Integer.valueOf(certCondition == null ? 0 : certCondition.getIsComplete()));
        vo.setHeadUrl(this.sysFileService.getUrl(cert.getHeadId()));
        return vo;
    }

    @Override
    public CertConditionVo getCertCondition(Long staffBaseInfoId) {
        CertConditionVo hcCondition;
        CertConditionVo certCondition = ((CCertMapper)this.baseMapper).getCertCondition(staffBaseInfoId);
        if (certCondition == null) {
            certCondition = new CertConditionVo();
        }
        if ((hcCondition = ((CCertMapper)this.baseMapper).getCertConditionHc(staffBaseInfoId)) != null) {
            certCondition.setHealthCheckInfo(hcCondition.getHealthCheckInfo());
            certCondition.setHealthCheckTime(hcCondition.getHealthCheckTime());
            certCondition.setHealthCheckResult(hcCondition.getHealthCheckResult());
        }
        return certCondition;
    }
}

