/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.rho.modules.sys.service.bind.impl;

import cn.dev33.satoken.stp.StpUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.smarthse.framework.mybatisPlus.service.impl.ServiceImpl;
import cn.smarthse.modules.datacentre.provider.sms.ISMSProviderWelinkService;
import cn.smarthse.modules.sys.enumd.UserSystemWideEnum;
import cn.smarthse.rho.core.framework.ShiroCommonUtil;
import cn.smarthse.rho.core.framework.model.LayuiGridData;
import cn.smarthse.rho.core.framework.model.LayuiGridParam;
import cn.smarthse.rho.core.framework.utils.StringUtils;
import cn.smarthse.rho.modules.sys.dao.bind.ContactRebindAppealMapper;
import cn.smarthse.rho.modules.sys.entity.bind.ContactRebindAppeal;
import cn.smarthse.rho.modules.sys.entity.bind.SysUserBindLog;
import cn.smarthse.rho.modules.sys.enums.bind.ContactBindAuditStatusEnum;
import cn.smarthse.rho.modules.sys.enums.bind.UserBindLogTypeEnum;
import cn.smarthse.rho.modules.sys.model.bind.param.ContactRebindListParam;
import cn.smarthse.rho.modules.sys.model.bind.param.ContactRebindStatusParam;
import cn.smarthse.rho.modules.sys.model.bind.vo.ContactRebindAppealListVo;
import cn.smarthse.rho.modules.sys.model.sys.param.SysUserBindParam;
import cn.smarthse.rho.modules.sys.model.sys.vo.SysFileVo;
import cn.smarthse.rho.modules.sys.service.bind.IContactRebindAppealService;
import cn.smarthse.rho.modules.sys.service.sys.ISysFileService;
import cn.smarthse.rho.modules.sys.service.sys.ISysUserBindLogService;
import cn.smarthse.rho.modules.sys.service.sys.ISysUserBindService;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.smarthse.framework.exception.ServiceException;
import lombok.Generated;
import org.apache.dubbo.config.annotation.DubboReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class ContactRebindAppealServiceImpl
extends ServiceImpl<ContactRebindAppealMapper, ContactRebindAppeal>
implements IContactRebindAppealService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ContactRebindAppealServiceImpl.class);
    @Autowired
    @Lazy
    private ISysUserBindLogService sysUserBindLogService;
    @DubboReference(registry={"public_nacos"})
    private ISMSProviderWelinkService smsProvideMasService;
    private final ISysFileService sysFileService;
    private final ISysUserBindService sysUserBindService;

    @Override
    public void addAppeal(ContactRebindAppeal contactRebindAppeal) {
        ((ContactRebindAppealMapper)this.baseMapper).insert(contactRebindAppeal);
    }

    @Override
    public LayuiGridData<ContactRebindAppealListVo> getAppealListData(ContactRebindListParam param) {
        List<SysFileVo> fileList;
        PageHelper.startPage((int)param.getPage(), (int)param.getLimit());
        List<ContactRebindAppealListVo> list = ((ContactRebindAppealMapper)this.baseMapper).getAppealListData(param);
        if (CollectionUtil.isEmpty(list)) {
            return new LayuiGridData();
        }
        String idStr = list.stream().map(ContactRebindAppealListVo::getEvidenceId).filter(Objects::nonNull).distinct().map(String::valueOf).collect(Collectors.joining(","));
        if (StringUtils.isNotEmpty((String)idStr) && CollectionUtil.isNotEmpty(fileList = this.sysFileService.getFileVoByIds(idStr))) {
            Map<Long, SysFileVo> fileMap = fileList.stream().collect(Collectors.toMap(SysFileVo::getId, f -> f));
            list.stream().forEach(vo -> {
                SysFileVo fileVo = (SysFileVo)fileMap.get(vo.getEvidenceId());
                vo.setEvidenceUrl(fileVo != null ? fileVo.getFullOssUrl() : "");
                vo.setFileName(fileVo != null ? fileVo.getFileName() : "");
            });
        }
        return new LayuiGridData((Page)list, (LayuiGridParam)param);
    }

    @Override
    @Transactional
    public void changeAuditStatus(ContactRebindStatusParam param) {
        Integer status = param.getAuditStatus();
        ContactRebindAppeal appeal = (ContactRebindAppeal)((ContactRebindAppealMapper)this.baseMapper).selectById(param.getId());
        if (appeal == null) {
            throw new ServiceException("id\u53c2\u6570\u6709\u8bef\uff0c\u8be5\u6362\u7ed1\u7533\u8bf7\u4e0d\u5b58\u5728");
        }
        if (!appeal.getAuditStatus().equals(ContactBindAuditStatusEnum.AUDIT.getCode())) {
            throw new ServiceException("\u8be5\u6362\u7ed1\u7533\u8bf7\u5df2\u5ba1\u6838");
        }
        appeal.setAuditStatus(status);
        ContactRebindAppeal copyAppeal = new ContactRebindAppeal();
        BeanUtils.copyProperties((Object)appeal, (Object)copyAppeal);
        ((ContactRebindAppealMapper)this.baseMapper).updateById(appeal);
        if (status == 1) {
            SysUserBindParam bindParam = new SysUserBindParam();
            bindParam.setUserId(copyAppeal.getUserId());
            bindParam.setBindName(copyAppeal.getNewContactName());
            bindParam.setBindTel(copyAppeal.getNewContactPhone());
            bindParam.setSystemWideCode(UserSystemWideEnum.RHO_COMPANY.getCode());
            bindParam.setUserBindLogType(UserBindLogTypeEnum.APPEAL_PASS.getValue());
            bindParam.setAuditState(Byte.valueOf(status.byteValue()));
            bindParam.setOperatorId(param.getCurrentUserId());
            bindParam.setEvidenceId(copyAppeal.getEvidenceId());
            this.sysUserBindService.bindOrRebind(bindParam);
            this.smsProvideMasService.singleSendSms(copyAppeal.getNewContactPhone(), "\u3010\u6d59\u6c5f\u7701\u75be\u63a7\u5c40\u3011\u60a8\u7533\u8bf7\u7684\u624b\u673a\u53f7\u6362\u7ed1\u5df2\u901a\u8fc7\uff0c\u8bf7\u53ca\u65f6\u767b\u5f55\u201c\u653e\u5c04\u536b\u751f\u5728\u7ebf\u201d\u8fdb\u884c\u9a8c\u8bc1\u3002");
            StpUtil.logout((Object)ShiroCommonUtil.getLoginId((String)"company", (Long)copyAppeal.getUserId()));
            log.info("\u653e\u5c04\u536b\u751f\u5728\u7ebf==\u300b \u624b\u673a\u6362\u7ed1\u7533\u8bf7\u6210\u529f\uff0c\u6362\u7ed1\u624b\u673a{}", (Object)copyAppeal.getNewContactPhone());
        } else {
            SysUserBindLog log = new SysUserBindLog();
            log.setBindName(copyAppeal.getNewContactName());
            log.setBindTel(copyAppeal.getNewContactPhone());
            log.setSystemSource(UserSystemWideEnum.RHO_COMPANY.getCode());
            log.setCid(copyAppeal.getCid());
            log.setUserId(copyAppeal.getUserId());
            log.setType(UserBindLogTypeEnum.APPEAL_NOPASS.getValue());
            log.setAuditState(Byte.valueOf(ContactBindAuditStatusEnum.BACK.getCode().byteValue()));
            log.setIsValid(Integer.valueOf(1));
            log.setEvidenceId(copyAppeal.getEvidenceId());
            this.sysUserBindLogService.addRBindAppleLog(log);
            this.smsProvideMasService.singleSendSms(copyAppeal.getNewContactPhone(), "\u3010\u6d59\u6c5f\u7701\u75be\u63a7\u5c40\u3011\u60a8\u7533\u8bf7\u7684\u624b\u673a\u53f7\u6362\u7ed1\u56e0\u201c\u63d0\u4ea4\u7684\u300a\u624b\u673a\u53f7\u6362\u7ed1\u6388\u6743\u59d4\u6258\u4e66\u300b\u4e0d\u7b26\u5408\u8981\u6c42\u201d\u672a\u901a\u8fc7\uff0c\u8bf7\u91cd\u65b0\u63d0\u4ea4\u3002");
        }
    }

    @Override
    public Boolean selectUnAuditAppealByCid(Long userId) {
        return ((ContactRebindAppealMapper)this.baseMapper).selectUnAuditAppealByCid(userId) != null;
    }

    @Override
    @Transactional
    public void terminalAuditByCid(Long userId, Integer bindLogType) {
        ContactRebindAppeal appeal = ((ContactRebindAppealMapper)this.baseMapper).selectUnAuditAppealByCid(userId);
        if (appeal == null) {
            return;
        }
        appeal.setAuditStatus(ContactBindAuditStatusEnum.END.getCode());
        ((ContactRebindAppealMapper)this.baseMapper).updateById(appeal);
        SysUserBindLog log = new SysUserBindLog();
        log.setBindName(appeal.getNewContactName());
        log.setBindTel(appeal.getNewContactPhone());
        log.setSystemSource(UserSystemWideEnum.RHO_COMPANY.getCode());
        log.setCid(appeal.getCid());
        log.setUserId(appeal.getUserId());
        log.setType(bindLogType);
        log.setAuditState(Byte.valueOf(ContactBindAuditStatusEnum.END.getCode().byteValue()));
        log.setEvidenceId(appeal.getEvidenceId());
        log.setIsValid(Integer.valueOf(1));
        this.sysUserBindLogService.addRBindAppleLog(log);
    }

    @Override
    public ContactRebindAppeal getAppealByUserId(Long userId) {
        return ((ContactRebindAppealMapper)this.baseMapper).selectUnAuditAppealByCid(userId);
    }

    @Generated
    public ContactRebindAppealServiceImpl(ISysFileService sysFileService, ISysUserBindService sysUserBindService) {
        this.sysFileService = sysFileService;
        this.sysUserBindService = sysUserBindService;
    }
}

