/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.rho.modules.sys.service.b.impl;

import cn.smarthse.rho.modules.sys.converter.b.BChangeLicenseDeviceRelationConverter;
import cn.smarthse.rho.modules.sys.dao.b.BChangeLicenseDeviceRelationMapper;
import cn.smarthse.rho.modules.sys.entity.b.BChangeLicenseDeviceRelation;
import cn.smarthse.rho.modules.sys.entity.e.ERelation;
import cn.smarthse.rho.modules.sys.model.e.param.ERelationDto;
import cn.smarthse.rho.modules.sys.service.b.IBChangeLicenseDeviceRelationService;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class IBChangeLicenseDeviceRelationServiceImpl
extends ServiceImpl<BChangeLicenseDeviceRelationMapper, BChangeLicenseDeviceRelation>
implements IBChangeLicenseDeviceRelationService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(IBChangeLicenseDeviceRelationServiceImpl.class);
    @Autowired
    private BChangeLicenseDeviceRelationConverter converter;

    @Override
    @Transactional
    public void addLicenseChangeRelationForCompany(List<ERelationDto> relationDtoList, Long licenseId) {
        List licenseDeviceRelationList = this.converter.dtoList2LicenseRelationList(relationDtoList);
        licenseDeviceRelationList.forEach(licenseDeviceRelation -> {
            licenseDeviceRelation.setId(Long.valueOf(IdWorker.getId()));
            licenseDeviceRelation.setLicenseId(licenseId);
            licenseDeviceRelation.setIsMigrated(Integer.valueOf(0));
        });
        this.saveBatch(licenseDeviceRelationList);
    }

    @Override
    @Transactional
    public void deleteLicenseChangeRelationByLicenseId(Long licenseId) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(BChangeLicenseDeviceRelation::getLicenseId, (Object)licenseId);
        this.remove((Wrapper)wrapper);
    }

    @Override
    public void updateLicenseChangeRelationForCompany(List<ERelationDto> relationDtoList, Long licenseId) {
        this.deleteLicenseChangeRelationByLicenseId(licenseId);
        this.addLicenseChangeRelationForCompany(relationDtoList, licenseId);
    }

    @Override
    public List<ERelation> listRelationByLicenseId(Long licenseId) {
        return ((BChangeLicenseDeviceRelationMapper)this.baseMapper).listRelationByLicenseId(licenseId);
    }

    @Override
    public List<ERelationDto> listRelationDtoByLicenseId(Long licenseId) {
        return ((BChangeLicenseDeviceRelationMapper)this.baseMapper).listRelationDtoByLicenseId(licenseId);
    }

    @Generated
    public IBChangeLicenseDeviceRelationServiceImpl() {
    }
}

