/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.rho.modules.sys.service.b.impl;

import cn.smarthse.framework.mybatisPlus.service.impl.ServiceImpl;
import cn.smarthse.rho.core.framework.ShiroCommonUtil;
import cn.smarthse.rho.modules.sys.converter.b.BRayManageConverter;
import cn.smarthse.rho.modules.sys.dao.b.BRayManageMapper;
import cn.smarthse.rho.modules.sys.entity.b.BRayManage;
import cn.smarthse.rho.modules.sys.model.b.param.BRayManageEditParam;
import cn.smarthse.rho.modules.sys.model.b.param.BRayManageInfoParam;
import cn.smarthse.rho.modules.sys.model.b.vo.BRayManageVo;
import cn.smarthse.rho.modules.sys.provider.sys.ISysFileProvider;
import cn.smarthse.rho.modules.sys.service.b.IBCompanyErrorService;
import cn.smarthse.rho.modules.sys.service.b.IBOrgService;
import cn.smarthse.rho.modules.sys.service.b.IBRayManageService;
import java.time.LocalDateTime;
import javax.smarthse.framework.exception.ServiceException;
import lombok.Generated;
import org.apache.dubbo.config.annotation.DubboReference;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class BRayManageServiceImpl
extends ServiceImpl<BRayManageMapper, BRayManage>
implements IBRayManageService {
    private final BRayManageConverter bRayManageConverter;
    private final IBOrgService bOrgService;
    private final IBCompanyErrorService companyErrorService;
    @DubboReference
    private ISysFileProvider sysFileProvider;

    @Override
    @Transactional
    public BRayManageVo add(BRayManageEditParam param) {
        if (param.getId() != null) {
            throw new ServiceException("\u5b58\u50a8\u6570\u636e\u5f02\u5e38");
        }
        if (param.getCid() == null) {
            throw new ServiceException("\u7f3a\u5c11\u5355\u4f4did");
        }
        BRayManageVo info = ((BRayManageMapper)this.baseMapper).getInfo(new BRayManageInfoParam().setCid(param.getCid()));
        if (info != null) {
            throw new ServiceException("\u5df2\u7ecf\u5b58\u5728\u9886\u5bfc\u5c0f\u7ec4\uff0c\u65e0\u9700\u91cd\u590d\u6dfb\u52a0\uff0c\u82e5\u4fe1\u606f\u6709\u8bef\uff0c\u8bf7\u7f16\u8f91");
        }
        BRayManage bRayManage = this.bRayManageConverter.param2Entity(param);
        bRayManage.setCreateBy(param.getLoginUserId());
        bRayManage.setUpdateBy(param.getLoginUserId());
        this.save(bRayManage);
        this.companyErrorService.manualMaintenanceOne(param.getCid());
        return this.bRayManageConverter.entity2Vo(bRayManage);
    }

    @Override
    @Transactional
    public void addForFileUpload(Long cid) {
        if (cid == null) {
            throw new ServiceException("\u7f3a\u5c11\u5355\u4f4did");
        }
        BRayManageVo info = ((BRayManageMapper)this.baseMapper).getInfo(new BRayManageInfoParam().setCid(cid));
        if (info != null) {
            return;
        }
        BRayManage bRayManage = new BRayManage();
        bRayManage.setCid(cid);
        bRayManage.setCreateBy(ShiroCommonUtil.getJWTUserId());
        bRayManage.setUpdateBy(ShiroCommonUtil.getJWTUserId());
        this.save(bRayManage);
        this.companyErrorService.manualMaintenanceOne(cid);
    }

    @Override
    @Transactional
    public BRayManageVo edit(BRayManageEditParam param) {
        if (param.getId() == null) {
            throw new ServiceException("\u7f3a\u5c11id");
        }
        BRayManage db = (BRayManage)this.getById(param.getId());
        if (!param.getCid().equals(db.getCid())) {
            throw new ServiceException("\u5f02\u5e38!");
        }
        BRayManage bRayManage = this.bRayManageConverter.param2Entity(param);
        bRayManage.setEditTime(LocalDateTime.now());
        bRayManage.setCreateBy(param.getLoginUserId());
        bRayManage.setUpdateBy(param.getLoginUserId());
        this.updateById(bRayManage);
        this.companyErrorService.manualMaintenanceOne(param.getCid());
        return this.bRayManageConverter.entity2Vo(bRayManage);
    }

    @Generated
    public BRayManageServiceImpl(BRayManageConverter bRayManageConverter, IBOrgService bOrgService, IBCompanyErrorService companyErrorService) {
        this.bRayManageConverter = bRayManageConverter;
        this.bOrgService = bOrgService;
        this.companyErrorService = companyErrorService;
    }
}

