/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.rho.modules.sys.service.b.impl;

import cn.smarthse.framework.mybatisPlus.service.impl.ServiceImpl;
import cn.smarthse.rho.core.framework.model.LayuiGridData;
import cn.smarthse.rho.core.framework.model.LayuiGridParam;
import cn.smarthse.rho.modules.sys.converter.b.BPostConverter;
import cn.smarthse.rho.modules.sys.dao.b.BPostMapper;
import cn.smarthse.rho.modules.sys.entity.b.BPost;
import cn.smarthse.rho.modules.sys.enums.company.PostTypeEnum;
import cn.smarthse.rho.modules.sys.enums.user.UserTypeEnum;
import cn.smarthse.rho.modules.sys.model.b.param.BPostEditParam;
import cn.smarthse.rho.modules.sys.model.b.vo.BPostVo;
import cn.smarthse.rho.modules.sys.model.c.param.PostInfoParam;
import cn.smarthse.rho.modules.sys.model.c.param.PostQueryParam;
import cn.smarthse.rho.modules.sys.service.b.IBPostService;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import java.util.List;
import javax.smarthse.framework.exception.ServiceException;
import lombok.Generated;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class BPostServiceImpl
extends ServiceImpl<BPostMapper, BPost>
implements IBPostService {
    private final BPostConverter converter;

    @Override
    public void editInfo(BPostEditParam param) {
        BPost bPost = this.converter.editParam2Entity(param);
        if (bPost.getId() == null) {
            throw new ServiceException("\u53c2\u6570\u5f02\u5e38\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u540e\u91cd\u65b0\u7f16\u8f91");
        }
        Integer loginUserType = param.getLoginUserType();
        Long loginCid = param.getAfterSelectCid();
        BPost oldInfo = (BPost)this.getById(param.getId());
        if (oldInfo == null) {
            throw new ServiceException("\u6570\u636e\u5f02\u5e38");
        }
        if (!loginUserType.equals(UserTypeEnum.supervise.getValue())) {
            if (loginUserType.equals(UserTypeEnum.company.getValue())) {
                if (PostTypeEnum.DEFAULT.getValue().equals(oldInfo.getType())) {
                    throw new ServiceException("\u65e0\u6cd5\u7f16\u8f91\u7cfb\u7edf\u9ed8\u8ba4\u5c97\u4f4d");
                }
                if (!loginCid.equals(oldInfo.getCid())) {
                    throw new ServiceException("\u65e0\u6743\u9650\u7f16\u8f91");
                }
            } else {
                throw new ServiceException("\u65e0\u6cd5\u7f16\u8f91");
            }
        }
        this.updateById(bPost);
    }

    @Override
    public void addInfo(BPostEditParam param) {
        BPost bPost = this.converter.editParam2Entity(param);
        if (bPost.getId() != null) {
            throw new ServiceException("\u53c2\u6570\u5f02\u5e38\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u540e\u91cd\u65b0\u7f16\u8f91");
        }
        if (bPost.getType() == null) {
            throw new ServiceException("\u53c2\u6570\u5f02\u5e38\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u540e\u91cd\u65b0\u7f16\u8f91");
        }
        if (bPost.getType().equals(PostTypeEnum.DEFAULT.getValue())) {
            throw new ServiceException("\u4e0d\u53ef\u6dfb\u52a0\u9ed8\u8ba4\u5c97\u4f4d");
        }
        this.save(bPost);
    }

    @Override
    public LayuiGridData<BPostVo> getPage(PostQueryParam param) {
        PageHelper.startPage((int)param.getPage(), (int)param.getLimit());
        List<BPostVo> list = ((BPostMapper)this.baseMapper).getPage(param);
        return new LayuiGridData((Page)list, (LayuiGridParam)param);
    }

    @Override
    public BPostVo getPostInfo(PostInfoParam param) {
        Integer loginUserType = param.getLoginUserType();
        Long loginCid = param.getLoginCid();
        BPost bPost = (BPost)this.getById(param.getId());
        if (bPost != null && UserTypeEnum.company.getValue().equals(loginUserType)) {
            if (PostTypeEnum.COMPANY.getValue().equals(bPost.getType()) && !loginCid.equals(bPost.getCid())) {
                throw new ServiceException("\u65e0\u6cd5\u6743\u83b7\u53d6\u8be5\u5c97\u4f4d\u6570\u636e");
            }
            if (bPost.getType() == null && !loginCid.equals(bPost.getCid())) {
                throw new ServiceException("\u65e0\u6cd5\u6743\u83b7\u53d6\u8be5\u5c97\u4f4d\u6570\u636e");
            }
        }
        return this.converter.entity2Vo(bPost);
    }

    @Override
    public void removeInfo(BPostEditParam param) {
        if (param.getId() == null) {
            throw new ServiceException("\u53c2\u6570\u5f02\u5e38\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u540e\u91cd\u65b0\u7f16\u8f91");
        }
        Integer loginUserType = param.getLoginUserType();
        Long loginCid = param.getAfterSelectCid();
        BPost oldInfo = (BPost)this.getById(param.getId());
        if (oldInfo == null) {
            return;
        }
        if (!loginUserType.equals(UserTypeEnum.supervise.getValue())) {
            if (loginUserType.equals(UserTypeEnum.company.getValue())) {
                if (PostTypeEnum.DEFAULT.getValue().equals(oldInfo.getType())) {
                    throw new ServiceException("\u65e0\u6cd5\u5220\u9664\u7cfb\u7edf\u9ed8\u8ba4\u5c97\u4f4d");
                }
                if (!loginCid.equals(oldInfo.getCid())) {
                    throw new ServiceException("\u65e0\u6743\u5220\u9664");
                }
            } else {
                throw new ServiceException("\u65e0\u6cd5\u5220\u9664");
            }
        }
        this.removeById(param.getId());
    }

    @Override
    public BPost getPostInfoForImporting(Long cid, String postName) {
        return ((BPostMapper)this.baseMapper).getPostInfoForImporting(cid, postName);
    }

    @Generated
    public BPostServiceImpl(BPostConverter converter) {
        this.converter = converter;
    }
}

