/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.rho.modules.sys.service.b.impl;

import cn.hutool.core.util.StrUtil;
import cn.smarthse.framework.mybatisPlus.service.impl.ServiceImpl;
import cn.smarthse.rho.core.framework.model.BaseEntity;
import cn.smarthse.rho.modules.sys.converter.b.BOrgConverter;
import cn.smarthse.rho.modules.sys.dao.b.BOrgMapper;
import cn.smarthse.rho.modules.sys.entity.b.BOrg;
import cn.smarthse.rho.modules.sys.model.b.param.BOrgEditParam;
import cn.smarthse.rho.modules.sys.model.b.vo.BOrgVo;
import cn.smarthse.rho.modules.sys.service.b.IBCompanyErrorService;
import cn.smarthse.rho.modules.sys.service.b.IBOrgService;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import java.time.LocalDateTime;
import java.util.List;
import java.util.stream.Collectors;
import javax.smarthse.framework.exception.ServiceException;
import lombok.Generated;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class BOrgServiceImpl
extends ServiceImpl<BOrgMapper, BOrg>
implements IBOrgService {
    private final BOrgConverter bOrgConverter;
    @Autowired
    @Lazy
    private IBCompanyErrorService errorService;

    @Override
    public BOrg getByIdIncludeDel(Long id) {
        return ((BOrgMapper)this.baseMapper).getByIdIncludeDel(id);
    }

    @Override
    public BOrg getCompanyOrgByCascadeName(Long cid, String cascadeName, String separator) {
        if (StrUtil.isBlank((CharSequence)cascadeName)) {
            return null;
        }
        if (StrUtil.isBlank((CharSequence)separator)) {
            return ((BOrgMapper)this.baseMapper).getCompanyOrgByCascadeName(cid, cascadeName);
        }
        return ((BOrgMapper)this.baseMapper).getCompanyOrgByCascadeName(cid, StrUtil.replace((CharSequence)cascadeName, (CharSequence)separator, (CharSequence)","));
    }

    @Override
    public BOrg getMultipleAddressCompanyOrgByCascadeName(Long cid, String addressCascadeName, String separator) {
        if (StrUtil.isBlank((CharSequence)addressCascadeName)) {
            return null;
        }
        if (StrUtil.isNotBlank((CharSequence)separator)) {
            addressCascadeName = StrUtil.replace((CharSequence)addressCascadeName, (CharSequence)separator, (CharSequence)",");
        }
        List split = StrUtil.split((CharSequence)addressCascadeName, (CharSequence)",");
        String address = (String)split.get(0);
        String cascadeName = split.stream().skip(1L).collect(Collectors.joining(","));
        return ((BOrgMapper)this.baseMapper).getMultipleAddressCompanyOrgByCascadeName(cid, address, cascadeName);
    }

    @Override
    @Transactional
    public BOrgVo addInfo(BOrgEditParam param) {
        BOrg bOrg = this.bOrgConverter.param2Entity(param);
        bOrg.setEditTime(LocalDateTime.now());
        ((BOrgMapper)this.baseMapper).insert(bOrg);
        if (bOrg.getPid() != 0L) {
            BOrg parent = (BOrg)this.getById(bOrg.getPid());
            StringBuffer sb = new StringBuffer();
            sb.append(parent.getCascadeId()).append(",").append(bOrg.getId());
            StringBuffer sbName = new StringBuffer().append(parent.getCascadeName()).append(",").append(bOrg.getName());
            bOrg.setCascadeId(sb.toString());
            bOrg.setCascadeName(sbName.toString());
            ((BOrgMapper)this.baseMapper).updateById(bOrg);
        } else {
            bOrg.setCascadeId(String.valueOf(bOrg.getId()));
            bOrg.setCascadeName(bOrg.getName());
            ((BOrgMapper)this.baseMapper).updateById(bOrg);
        }
        if (bOrg.getCid() != null) {
            this.errorService.manualMaintenanceOne(bOrg.getCid());
        }
        return this.bOrgConverter.entity2Vo(bOrg);
    }

    @Override
    @Transactional
    public BOrgVo editInfo(BOrgEditParam param) {
        if (param.getId() == null) {
            throw new ServiceException("\u53c2\u6570\u9519\u8bef");
        }
        BOrg db = (BOrg)this.getById(param.getId());
        BOrg bOrg = this.bOrgConverter.param2Entity(param);
        bOrg.setEditTime(LocalDateTime.now());
        if (bOrg.getPid() != 0L) {
            BOrg parent = (BOrg)this.getById(bOrg.getPid());
            StringBuffer sb = new StringBuffer().append(parent.getCascadeId()).append(",").append(bOrg.getId());
            StringBuffer sbName = new StringBuffer().append(parent.getCascadeName()).append(",").append(bOrg.getName());
            bOrg.setCascadeId(sb.toString());
            ((BOrgMapper)this.baseMapper).updateById(bOrg);
        } else {
            bOrg.setCascadeId(String.valueOf(bOrg.getId()));
            ((BOrgMapper)this.baseMapper).updateById(bOrg);
        }
        ((BOrgMapper)this.baseMapper).maintainCascadeName(db.getCid());
        BOrg newest = (BOrg)this.getById(bOrg.getId());
        if (newest.getCid() != null) {
            this.errorService.manualMaintenanceOne(newest.getCid());
        }
        return this.bOrgConverter.entity2Vo(bOrg);
    }

    @Override
    @Transactional
    public void removeInfo(BOrgEditParam param) {
        if (param.getId() == null) {
            throw new ServiceException("\u53c2\u6570\u9519\u8bef");
        }
        BOrg newest = (BOrg)this.getById(param.getId());
        UpdateWrapper updateWrapper = new UpdateWrapper();
        ((LambdaUpdateWrapper)updateWrapper.lambda().set(BaseEntity::getIsValid, (Object)false)).like(BOrg::getCascadeId, (Object)param.getId());
        ((BOrgMapper)this.baseMapper).update((Wrapper)updateWrapper);
        UpdateWrapper updateWrapper2 = new UpdateWrapper();
        ((LambdaUpdateWrapper)updateWrapper2.lambda().set(BaseEntity::getIsValid, (Object)false)).eq(BOrg::getId, (Object)param.getId());
        ((BOrgMapper)this.baseMapper).update((Wrapper)updateWrapper2);
        if (newest.getCid() != null) {
            this.errorService.manualMaintenanceOne(newest.getCid());
        }
    }

    @Generated
    public BOrgServiceImpl(BOrgConverter bOrgConverter) {
        this.bOrgConverter = bOrgConverter;
    }
}

