/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.rho.modules.sys.service.b.impl;

import cn.hutool.core.collection.CollUtil;
import cn.smarthse.framework.mybatisPlus.service.impl.ServiceImpl;
import cn.smarthse.modules.datacentre.provider.system.ISysAreaProvideService;
import cn.smarthse.rho.core.framework.Constant;
import cn.smarthse.rho.core.framework.model.BaseEntity;
import cn.smarthse.rho.core.framework.model.LayuiGridData;
import cn.smarthse.rho.core.framework.model.LayuiGridParam;
import cn.smarthse.rho.modules.sys.dao.b.BCompanyMapper;
import cn.smarthse.rho.modules.sys.entity.b.BCompany;
import cn.smarthse.rho.modules.sys.enums.company.BusinessStatusEnum;
import cn.smarthse.rho.modules.sys.enums.company.CompanyLicenceStatusEnum;
import cn.smarthse.rho.modules.sys.model.b.param.BCompanyErrorMaintenanceParam;
import cn.smarthse.rho.modules.sys.model.b.param.CompanyPushManualParam;
import cn.smarthse.rho.modules.sys.model.b.param.CompanySyncParam;
import cn.smarthse.rho.modules.sys.model.b.param.hse.training.RhoCompanyUserPageParam;
import cn.smarthse.rho.modules.sys.model.b.param.license.ChangeLicenseCompanyParam;
import cn.smarthse.rho.modules.sys.model.b.vo.BCompanyVo;
import cn.smarthse.rho.modules.sys.model.b.vo.CompanySyncFswsHospitalInfoVo;
import cn.smarthse.rho.modules.sys.model.b.vo.CompanySyncVo;
import cn.smarthse.rho.modules.sys.model.b.vo.hse.training.RhoCompanyHseTrainingVo;
import cn.smarthse.rho.modules.sys.model.b.vo.license.ChangeLicenseCompanyListVo;
import cn.smarthse.rho.modules.sys.model.c.param.CheckOrgChooseQueryParam;
import cn.smarthse.rho.modules.sys.model.c.vo.ThirdOrgVo;
import cn.smarthse.rho.modules.sys.model.r.param.RiskMangerGenParam;
import cn.smarthse.rho.modules.sys.model.sys.param.BCompanyChooseListParam;
import cn.smarthse.rho.modules.sys.model.sys.param.SysCompanyEditParam;
import cn.smarthse.rho.modules.sys.model.sys.param.SysCompanyListParam;
import cn.smarthse.rho.modules.sys.model.sys.param.SysCompanyStatueEditParam;
import cn.smarthse.rho.modules.sys.model.sys.param.SysCompanyUserBusinessStatueEditParam;
import cn.smarthse.rho.modules.sys.model.sys.vo.BCompanyChooseVo;
import cn.smarthse.rho.modules.sys.model.sys.vo.SysCompanyListVo;
import cn.smarthse.rho.modules.sys.model.sys.vo.SysCompanyOneVo;
import cn.smarthse.rho.modules.sys.model.sys.vo.SysUserCompanyOneForSupVo;
import cn.smarthse.rho.modules.sys.service.b.IBCompanyAddressService;
import cn.smarthse.rho.modules.sys.service.b.IBCompanyService;
import cn.smarthse.rho.modules.sys.service.sys.ISysAreaService;
import cn.smarthse.rho.modules.sys.service.sys.ISysParamService;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.smarthse.framework.exception.ServiceException;
import lombok.Generated;
import org.apache.dubbo.config.annotation.DubboReference;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class BCompanyServiceImpl
extends ServiceImpl<BCompanyMapper, BCompany>
implements IBCompanyService {
    @Autowired
    private ISysAreaService sysAreaService;
    @Autowired
    private IBCompanyAddressService companyAddressService;
    @Autowired
    private ISysParamService sysParamService;
    @DubboReference(registry={"public_nacos"}, version="1.0.0")
    private ISysAreaProvideService sysAreaProvideService;

    @Override
    public Boolean isHasBelongTypeComByAreaId(Long areaId) {
        if (areaId == null) {
            throw new ServiceException("\u53c2\u6570\u5f02\u5e38");
        }
        Byte level = this.sysAreaProvideService.getAreaByIdV3(areaId).getLevel();
        if (level > 2) {
            return false;
        }
        return ((BCompanyMapper)this.baseMapper).getBelongTypeComCountsByAreaId(areaId, level) > 0L;
    }

    @Override
    public PageInfo<BCompanyVo> getListForZLB(SysCompanyListParam param) {
        PageHelper.startPage((int)param.getPage(), (int)param.getLimit());
        List<BCompanyVo> list = ((BCompanyMapper)this.baseMapper).getListForZLB(param);
        return new PageInfo(list);
    }

    @Override
    public PageInfo<BCompanyChooseVo> getChooseList(BCompanyChooseListParam param) {
        List list;
        PageHelper.startPage((int)param.getPage(), (int)param.getLimit());
        List<BCompanyChooseVo> rst = ((BCompanyMapper)this.baseMapper).getChooseList(param);
        if (Objects.equals(param.getQueryChildren(), Boolean.TRUE) && CollUtil.isNotEmpty(rst) && CollUtil.isNotEmpty((Collection)(list = this.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(BCompany::getCreditCode, (Collection)rst.stream().map(BCompanyChooseVo::getCreditCode).collect(Collectors.toList()))).eq(BaseEntity::getIsValid, (Object)Constant.ACTIVE_YES)).select(new SFunction[]{BCompany::getId, BCompany::getName, BCompany::getCreditCode, BCompany::getHospitalName}))))) {
            Map map = list.stream().collect(Collectors.groupingBy(BCompany::getCreditCode, Collectors.mapping(bCompany -> new BCompanyChooseVo().setId(bCompany.getId()).setName(bCompany.getName()).setCreditCode(bCompany.getCreditCode()).setHospitalName(bCompany.getHospitalName()), Collectors.toList())));
            for (BCompanyChooseVo dto : rst) {
                dto.getChildren().addAll(map.getOrDefault(dto.getCreditCode(), Collections.emptyList()));
            }
        }
        return new PageInfo(rst);
    }

    @Override
    public PageInfo<SysCompanyListVo> getSysCompanyListData(SysCompanyListParam param) {
        PageHelper.startPage((int)param.getPage(), (int)param.getLimit());
        List<SysCompanyListVo> list = ((BCompanyMapper)this.baseMapper).getSysCompanyListData(param);
        return new PageInfo(list);
    }

    @Override
    public SysCompanyOneVo getSysCompany(Long cid) {
        return ((BCompanyMapper)this.baseMapper).getSysCompany(cid);
    }

    @Override
    @Transactional
    public Boolean updateSysCompany(SysCompanyEditParam param) {
        BCompany exists = (BCompany)this.getById(param.getBranchCid());
        if (Objects.isNull(exists)) {
            throw new ServiceException("\u8be5\u9662\u533a\u5df2\u4e0d\u5b58\u5728\uff01");
        }
        if (this.isHaveThisBranchName(param.getBranchName(), param.getBranchCid()).booleanValue()) {
            throw new ServiceException("\u8be5\u9662\u533a\u540d\u79f0\u5df2\u5b58\u5728\uff01");
        }
        if (this.isHaveThisMedicalNucode(param.getMedicalNucode(), param.getBranchCid()).booleanValue()) {
            throw new ServiceException("\u8be5\u5168\u56fd\u552f\u4e00\u6807\u8bc6\u7801\u5df2\u5b58\u5728\uff01");
        }
        List list = this.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(BCompany::getCreditCode, (Object)exists.getCreditCode())).eq(BaseEntity::getIsValid, (Object)Constant.ACTIVE_YES));
        ArrayList<BCompany> updateList = new ArrayList<BCompany>(list.size());
        for (BCompany company : list) {
            BCompany dto = new BCompany();
            dto.setId(company.getId());
            if (Objects.equals(param.getBranchCid(), company.getId())) {
                dto.setName(param.getBranchName());
                dto.setMedicalNucode(param.getMedicalNucode());
            } else {
                dto.setName(company.getName());
                dto.setMedicalNucode(company.getMedicalNucode());
            }
            dto.setHospitalName(param.getHospitalName());
            dto.setUpdateBy(param.getLoginUserId());
            dto.setUpdateDate(LocalDateTime.now());
            updateList.add(dto);
        }
        return this.executeBatch(updateList, (sqlSession, entity) -> ((BCompanyMapper)sqlSession.getMapper(BCompanyMapper.class)).updateSysCompany((BCompany)entity));
    }

    @Override
    public Boolean isHaveThisBranchName(String branchName, Long excludeId) {
        return this.exists((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(BCompany::getName, (Object)branchName)).eq(BaseEntity::getIsValid, (Object)Constant.ACTIVE_YES)).ne(Objects.nonNull(excludeId), BCompany::getId, (Object)excludeId));
    }

    @Override
    public Boolean isHaveThisMedicalNucode(String medicalNucode, Long excludeId) {
        return ((BCompanyMapper)this.baseMapper).isHaveThisMedicalNucode(medicalNucode, excludeId);
    }

    @Override
    @Transactional
    public Boolean updateSysCompanyStatue(SysCompanyStatueEditParam param) {
        BCompany exists = (BCompany)this.getById(param.getBranchCid());
        if (exists == null) {
            throw new ServiceException("\u8be5\u9662\u533a\u5df2\u4e0d\u5b58\u5728\uff01");
        }
        BCompany record = new BCompany();
        record.setId(param.getBranchCid());
        record.setState(param.getState());
        record.setUpdateBy(param.getLoginUserId());
        record.setUpdateDate(LocalDateTime.now());
        return this.updateById(record);
    }

    @Override
    @Transactional
    public Boolean updateSysCompanyIsMain(SysCompanyStatueEditParam param) {
        BCompany company = (BCompany)this.getById(param.getBranchCid());
        if (Objects.isNull(company)) {
            throw new ServiceException("\u8be5\u9662\u533a\u5df2\u4e0d\u5b58\u5728\uff01");
        }
        int isMain = param.getState();
        List list = this.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(BCompany::getCreditCode, (Object)company.getCreditCode())).eq(BaseEntity::getIsValid, (Object)Constant.ACTIVE_YES));
        ArrayList<BCompany> updateList = new ArrayList<BCompany>(list.size());
        for (BCompany bCompany : list) {
            BCompany dto = new BCompany();
            dto.setId(bCompany.getId());
            dto.setUpdateBy(param.getLoginUserId());
            dto.setUpdateDate(LocalDateTime.now());
            dto.setIsMain(Integer.valueOf(dto.getId().equals(company.getId()) ? isMain : 0));
            dto.setMainId(isMain == 1 ? company.getId() : null);
            dto.setMainName(isMain == 1 ? company.getName() : null);
            updateList.add(dto);
        }
        return this.executeBatch(updateList, (sqlSession, entity) -> ((BCompanyMapper)sqlSession.getMapper(BCompanyMapper.class)).updateSysCompanyIsMain((BCompany)entity));
    }

    @Override
    @Transactional
    public Boolean updateSysCompanyBusinessStatue(SysCompanyUserBusinessStatueEditParam param) {
        BCompany exists = (BCompany)this.getById(param.getCid());
        if (exists == null) {
            throw new ServiceException("\u8be5\u9662\u533a\u5df2\u4e0d\u5b58\u5728\uff01");
        }
        BCompany record = new BCompany();
        record.setId(param.getCid());
        record.setBusinessStatus(param.getBusinessStatus());
        if (BusinessStatusEnum.CLOSE.getValue().equals(param.getBusinessStatus())) {
            record.setLicenceStatus(CompanyLicenceStatusEnum.CLOSE.getValue());
        }
        record.setUpdateBy(param.getLoginUserId());
        record.setUpdateDate(LocalDateTime.now());
        return this.updateById(record);
    }

    @Override
    public BCompany getByMedicalNucode(String medicalNucode) {
        QueryWrapper wrapper = new QueryWrapper();
        ((LambdaQueryWrapper)wrapper.lambda().eq(BCompany::getMedicalNucode, (Object)medicalNucode)).last("limit 1");
        return (BCompany)this.getOne((Wrapper)wrapper);
    }

    @Override
    public BCompany getNewestWandaCompanyInfo(String medicalNucode) {
        return ((BCompanyMapper)this.baseMapper).getNewestWandaCompanyInfo(medicalNucode);
    }

    @Override
    public List<CompanySyncVo> getWandaSyncInfo(CompanySyncParam param) {
        return ((BCompanyMapper)this.baseMapper).getWandaSyncInfo(param);
    }

    @Override
    public List<BCompany> getNeedRegisterAccountForWanda(CompanySyncParam param) {
        return ((BCompanyMapper)this.baseMapper).getNeedRegisterAccountForWanda(param);
    }

    @Override
    public void initHospitalName(CompanySyncParam param) {
        ((BCompanyMapper)this.baseMapper).initHospitalName(param);
    }

    @Override
    public List<String> getCreditCodeFromWanda(CompanySyncParam param) {
        return ((BCompanyMapper)this.baseMapper).getCreditCodeFromWanda(param);
    }

    @Override
    public BCompany getByCreditCodeAndName(String creditCode, String name) {
        return ((BCompanyMapper)this.baseMapper).getByCreditCodeAndName(creditCode, name);
    }

    @Override
    public List<CompanySyncFswsHospitalInfoVo> getNeedAddBaseInfoFromWandaFswsHospitalInfoTable(CompanySyncParam param) {
        return ((BCompanyMapper)this.baseMapper).getNeedAddBaseInfoFromWandaFswsHospitalInfoTable(param);
    }

    @Override
    public BCompany getByRhoHospitalIdIncludeDel(String rhoHospitalId) {
        return ((BCompanyMapper)this.baseMapper).getByRhoHospitalIdIncludeDel(rhoHospitalId);
    }

    @Override
    public BCompany getByName(String name) {
        QueryWrapper wrapper = new QueryWrapper();
        ((LambdaQueryWrapper)wrapper.lambda().eq(BCompany::getName, (Object)name)).last("limit 1");
        return (BCompany)this.getOne((Wrapper)wrapper);
    }

    @Override
    public BCompany getNewestByNameIncludeDel(String name) {
        return ((BCompanyMapper)this.baseMapper).getNewestByNameIncludeDel(name);
    }

    @Override
    public BCompany getByMedicalNucodeIncludeDel(String medicalNucode) {
        return ((BCompanyMapper)this.baseMapper).getByMedicalNucodeIncludeDel(medicalNucode);
    }

    @Override
    public List<BCompany> getListForGenCertRisk(RiskMangerGenParam param) {
        return ((BCompanyMapper)this.baseMapper).getListForGenCertRisk(param);
    }

    @Override
    public LayuiGridData<RhoCompanyHseTrainingVo> getRhoUserListForHseTrainingAdmin(RhoCompanyUserPageParam param) {
        if (param.getUserAreaId() == null || param.getUserAreaLevel() == null) {
            throw new ServiceException("\u65e0\u6cd5\u67e5\u8be2");
        }
        PageHelper.startPage((int)param.getPage(), (int)param.getLimit());
        List<RhoCompanyHseTrainingVo> list = ((BCompanyMapper)this.baseMapper).getRhoUserListForHseTrainingAdmin(param);
        for (RhoCompanyHseTrainingVo vo : list) {
            vo.setBusinessStateName(BusinessStatusEnum.getNameByValue((Integer)vo.getBusinessState()));
            vo.setVirtuallyDataSource(Integer.valueOf(0));
            vo.setVirtuallyDataSourceName("\u653e\u5c04\u536b\u751f\u5728\u7ebf");
        }
        return new LayuiGridData((Page)list, (LayuiGridParam)param);
    }

    @Override
    public BCompany getByIdIncludeDel(String id) {
        return ((BCompanyMapper)this.baseMapper).getByIdIncludeDel(id);
    }

    @Override
    public boolean isSameHospital(Long targetCid, Long sourceCid) {
        if (targetCid == null) {
            return false;
        }
        List<Long> list = this.getBranchListByCid(sourceCid);
        list = list.stream().filter(v -> targetCid.equals(v)).collect(Collectors.toList());
        return CollUtil.isNotEmpty(list);
    }

    @Override
    public List<Long> getBranchListByCid(Long cid) {
        return ((BCompanyMapper)this.baseMapper).getBranchListByCid(cid);
    }

    @Override
    public BCompany getByNameAndBranchCid(String companyName, Long currentCid) {
        return ((BCompanyMapper)this.baseMapper).getByNameAndBranchCid(companyName, currentCid);
    }

    @Override
    public BCompany getCompanyByName(String name) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.eq(BCompany::getName, (Object)name)).eq(BaseEntity::getIsValid, (Object)1)).last("limit 1");
        return (BCompany)this.getOne((Wrapper)wrapper);
    }

    @Override
    public LayuiGridData<ThirdOrgVo> getCheckOrgChooseList(CheckOrgChooseQueryParam param) {
        PageHelper.startPage((int)param.getPage(), (int)param.getLimit());
        List<ThirdOrgVo> list = ((BCompanyMapper)this.baseMapper).getCheckOrgChooseList(param);
        return new LayuiGridData((Page)list, (LayuiGridParam)param);
    }

    @Override
    @Transactional
    public void delByCidList(List<Long> idList, Long loginUserId) {
        if (CollUtil.isEmpty(idList)) {
            throw new ServiceException("\u8bf7\u9009\u62e9\u8981\u5220\u9664\u7684\u533b\u9662");
        }
        ((BCompanyMapper)this.baseMapper).update((Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().in(BCompany::getId, idList)).set(BaseEntity::getIsValid, (Object)0)).set(BaseEntity::getUpdateDate, (Object)LocalDateTime.now())).set(BaseEntity::getUpdateBy, (Object)loginUserId));
    }

    @Override
    public SysUserCompanyOneForSupVo getSysUserCompanyByCidForSup(Long cid) {
        return ((BCompanyMapper)this.baseMapper).getSysUserCompanyByCidForSup(cid);
    }

    @Override
    public List<BCompany> getNeedMaintanceAddressCompanyList() {
        return ((BCompanyMapper)this.baseMapper).getNeedMaintanceAddressCompanyList();
    }

    @Override
    public List<BCompany> getNeedInitAddressCompanyList() {
        return ((BCompanyMapper)this.baseMapper).getNeedInitAddressCompanyList();
    }

    @Override
    public List<BCompany> listForMtErrorInfo(BCompanyErrorMaintenanceParam param) {
        return ((BCompanyMapper)this.baseMapper).listForMtErrorInfo(param);
    }

    @Override
    public BCompany getOneForMtErrorInfo(Long cid) {
        return ((BCompanyMapper)this.baseMapper).getOneForMtErrorInfo(cid);
    }

    @Override
    public List<BCompany> listForMtManagerErrorInfo(BCompanyErrorMaintenanceParam param) {
        return ((BCompanyMapper)this.baseMapper).listForMtManagerErrorInfo(param);
    }

    @Override
    public BCompanyVo getBaseInfoForLicense(Long cid) {
        BCompany entity = (BCompany)this.getById(cid);
        if (entity == null) {
            return new BCompanyVo();
        }
        BCompanyVo result = new BCompanyVo();
        result.setId(entity.getId());
        result.setName(entity.getName());
        result.setCreditCode(entity.getCreditCode());
        result.setType(entity.getType());
        result.setBusinessStatus(entity.getBusinessStatus());
        result.setFloorNum(entity.getFloorNum());
        result.setRaEmployeeNum(this.getRaEmployeeNum(cid));
        result.setLegalName(entity.getLegalName());
        result.setLegalTel(entity.getLegalTel());
        result.setMainLeaderName(entity.getMainLeaderName());
        result.setMainLeaderTel(entity.getMainLeaderTel());
        result.setAreaId(entity.getAreaId());
        result.setRegisteredAreaId(entity.getRegisteredAreaId());
        result.setWorkArea(this.sysAreaService.getAreaById(result.getAreaId()));
        result.setRegisteredArea(this.sysAreaService.getAreaById(result.getRegisteredAreaId()));
        result.setAddressList(this.companyAddressService.getAddressVoList(cid));
        if (result.getType() != null) {
            result.setTypeName(this.sysParamService.getName(result.getType()));
        }
        return result;
    }

    @Override
    public Integer getRaEmployeeNum(Long cid) {
        return ((BCompanyMapper)this.baseMapper).getRaEmployeeNum(cid);
    }

    @Override
    public LayuiGridData<ChangeLicenseCompanyListVo> getListForChangeLicense(ChangeLicenseCompanyParam param) {
        PageHelper.startPage((int)param.getPage(), (int)param.getLimit());
        List<ChangeLicenseCompanyListVo> list = ((BCompanyMapper)this.baseMapper).getListForChangeLicense(param);
        if (CollUtil.isNotEmpty(list)) {
            for (ChangeLicenseCompanyListVo vo : list) {
                vo.setAddressList(this.companyAddressService.getAddressVoList(vo.getId()));
            }
        }
        return new LayuiGridData((Page)list, (LayuiGridParam)param);
    }

    @Override
    public List<Long> listForPushingInfo(CompanyPushManualParam listParam) {
        return ((BCompanyMapper)this.baseMapper).listForPushingInfo(listParam);
    }

    @Generated
    public BCompanyServiceImpl() {
    }
}

