/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.rho.modules.sys.service.b.impl;

import cn.hutool.core.util.StrUtil;
import cn.smarthse.framework.mybatisPlus.service.impl.ServiceImpl;
import cn.smarthse.rho.modules.sys.dao.b.BCompanyPushMapper;
import cn.smarthse.rho.modules.sys.entity.b.BCompany;
import cn.smarthse.rho.modules.sys.entity.wanda.BCompanyPush;
import cn.smarthse.rho.modules.sys.enums.staff.CmSourceEnum;
import cn.smarthse.rho.modules.sys.model.b.param.BCompanyPushParam;
import cn.smarthse.rho.modules.sys.model.b.param.CompanyPushManualParam;
import cn.smarthse.rho.modules.sys.model.wanda.push.param.WandaRhoCompanyPushInfo;
import cn.smarthse.rho.modules.sys.service.b.IBCompanyPushService;
import cn.smarthse.rho.modules.sys.service.b.IBCompanyService;
import cn.smarthse.rho.modules.sys.service.sys.ISysAreaService;
import cn.smarthse.rho.modules.sys.utils.company.CompanyPushUtil;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class BCompanyPushServiceImpl
extends ServiceImpl<BCompanyPushMapper, BCompanyPush>
implements IBCompanyPushService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BCompanyPushServiceImpl.class);
    @Autowired
    private ISysAreaService areaService;
    @Autowired
    @Lazy
    private IBCompanyService companyService;

    @Override
    @Transactional
    public void addPushData(BCompanyPushParam param) {
        if (param.getFlag() == null || param.getFlag() == 0) {
            return;
        }
        if (param.getCompany().getOutId() == null) {
            return;
        }
        if (param.getCompany().getId() == null) {
            log.error("\u65b0\u589e\u63a8\u9001\u6570\u636e\u5931\u8d25\uff0c\u672a\u627e\u5230id:{}", (Object)param.getCompany().getName());
            return;
        }
        BCompanyPush push = new BCompanyPush();
        BCompany c = param.getCompany();
        String areaAddress = this.areaService.getAreaAddress(param.getCompany().getAreaId(), ">");
        String fullAddress = StrUtil.isBlank((CharSequence)c.getAddress()) || StrUtil.isBlank((CharSequence)c.getRegisteredAddress()) ? areaAddress : areaAddress + "<" + c.getAddress();
        String areaRegisterAddress = this.areaService.getAreaAddress(param.getCompany().getRegisteredAreaId(), ">");
        String fullRegisterAddress = StrUtil.isBlank((CharSequence)c.getRegisteredAddress()) || StrUtil.isBlank((CharSequence)areaRegisterAddress) ? areaRegisterAddress : areaRegisterAddress + "<" + c.getAddress();
        push.setId(c.getId());
        push.setOutId(c.getOutId());
        push.setZwyHospitalId(c.getZwyHospitalId());
        push.setWandaDataSource(c.getSource() != null && c.getSource().intValue() == CmSourceEnum.WAND_ZWY.getValue().intValue() ? "2" : "1");
        push.setName(c.getName());
        push.setCreditCode(c.getCreditCode());
        push.setBusinessStatus(c.getBusinessStatus());
        push.setAreaId(c.getAreaId());
        push.setAddress(c.getAddress());
        push.setFullAddress(fullAddress);
        push.setRegisteredFullAddress(fullRegisterAddress);
        push.setOptType(param.getOptType());
        push.setOldSourceId(c.getOutId());
        push.setOptReason(param.getOptReason());
        push.setPushStatus(Integer.valueOf(1));
        push.setIsTest(c.getIsTest());
        this.saveOrUpdate(push);
    }

    @Override
    @Transactional
    public void pushCompanyInfo(BCompany old, BCompany newest) {
        if (CompanyPushUtil.canPush((BCompany)old, (BCompany)newest)) {
            BCompanyPushParam push = new BCompanyPushParam();
            push.setCompany(newest);
            push.setOptType("2");
            push.setOptReason("\u5b57\u6bb5\u53d8\u66f4");
            this.addPushData(push);
        }
    }

    @Override
    @Transactional
    public void pushCompanyInfo(List<BCompany> newestList) {
        newestList.forEach(cm -> {
            BCompanyPushParam push = new BCompanyPushParam();
            push.setCompany(cm);
            push.setOptType("1");
            push.setOptReason("\u5b57\u6bb5\u53d8\u66f4");
            this.addPushData(push);
        });
    }

    @Override
    @Transactional
    public void setRhoCompanyNeedFalse(List<String> successIdList) {
        ((BCompanyPushMapper)this.baseMapper).setRhoCompanyNeedFalse(successIdList);
    }

    @Override
    @Transactional
    public void setRhoCompanyException(List<String> idSet) {
        ((BCompanyPushMapper)this.baseMapper).setRhoCompanyException(idSet);
    }

    @Override
    public PageInfo<WandaRhoCompanyPushInfo> pageRhoCompanyData(Integer pageNum, Integer pageSize, boolean count) {
        PageHelper.startPage((int)pageNum, (int)pageSize, (boolean)count);
        List<WandaRhoCompanyPushInfo> pageInfo = ((BCompanyPushMapper)this.baseMapper).pageRhoCompanyData();
        return new PageInfo(pageInfo);
    }

    @Override
    @Transactional
    public void addPushDataByManual(CompanyPushManualParam listParam) {
        List<Long> cidList = this.companyService.listForPushingInfo(listParam);
        for (Long cid : cidList) {
            BCompany company = (BCompany)this.companyService.getById(cid);
            if (company == null) continue;
            BCompanyPushParam param = new BCompanyPushParam();
            param.setCompany(company);
            param.setOptType("1");
            param.setFlag(Integer.valueOf(1));
            this.addPushData(param);
        }
    }
}

