/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.rho.modules.sys.service.b.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.CreditCodeUtil;
import cn.hutool.core.util.PhoneUtil;
import cn.hutool.core.util.StrUtil;
import cn.smarthse.framework.mybatisPlus.service.impl.ServiceImpl;
import cn.smarthse.rho.core.framework.model.LayuiGridData;
import cn.smarthse.rho.core.framework.model.LayuiGridParam;
import cn.smarthse.rho.modules.sys.dao.b.BCompanyErrorMapper;
import cn.smarthse.rho.modules.sys.entity.b.BCompany;
import cn.smarthse.rho.modules.sys.entity.b.BCompanyAddress;
import cn.smarthse.rho.modules.sys.entity.b.BCompanyError;
import cn.smarthse.rho.modules.sys.model.b.param.BCompanyErrorMaintenanceParam;
import cn.smarthse.rho.modules.sys.model.b.param.company.err.CompanyErrInfoParam;
import cn.smarthse.rho.modules.sys.model.b.vo.company.err.CompanyErrorVo;
import cn.smarthse.rho.modules.sys.model.c.param.staff.CompanyErrorStatisticParam;
import cn.smarthse.rho.modules.sys.model.c.vo.companyErr.CompanyErrorStatisticVo;
import cn.smarthse.rho.modules.sys.model.sys.vo.SysAreaVo;
import cn.smarthse.rho.modules.sys.service.b.IBCompanyAddressService;
import cn.smarthse.rho.modules.sys.service.b.IBCompanyErrorService;
import cn.smarthse.rho.modules.sys.service.b.IBCompanyService;
import cn.smarthse.rho.modules.sys.service.c.ICStaffBaseInfoService;
import cn.smarthse.rho.modules.sys.service.sys.ISysAreaService;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class BCompanyErrorServiceImpl
extends ServiceImpl<BCompanyErrorMapper, BCompanyError>
implements IBCompanyErrorService {
    @Autowired
    private IBCompanyErrorService self;
    @Autowired
    private IBCompanyService companyService;
    @Autowired
    private IBCompanyAddressService companyAddressService;
    @Autowired
    private ICStaffBaseInfoService staffBaseInfoService;
    @Autowired
    private ISysAreaService sysAreaService;

    @Override
    @Transactional
    public void manualMaintenanceOne(Long cid) {
        if (cid == null) {
            return;
        }
        BCompanyErrorMaintenanceParam param = new BCompanyErrorMaintenanceParam();
        param.setCid(cid);
        this.self.maintenance(param);
    }

    @Override
    @Transactional
    public void manualMaintenanceList(List<Long> cidList) {
        if (CollUtil.isEmpty(cidList)) {
            return;
        }
        BCompanyErrorMaintenanceParam param = new BCompanyErrorMaintenanceParam();
        param.setCidList(cidList);
        this.self.maintenance(param);
    }

    @Override
    @Transactional
    public void maintenance(BCompanyErrorMaintenanceParam param) {
        this.self.init(param);
        this.self.initDataUp(param);
        this.self.maintenancePartBaseInfoBySql(param);
        this.self.maintenancePartBaseInfoByJava(param);
        this.self.maintenanceEMachineRoomPart(param);
        this.self.maintenanceEDevicePart(param);
    }

    @Override
    @Transactional
    public void init(BCompanyErrorMaintenanceParam param) {
        ((BCompanyErrorMapper)this.baseMapper).initData(param);
    }

    @Override
    @Transactional
    public void initDataUp(BCompanyErrorMaintenanceParam param) {
        ((BCompanyErrorMapper)this.baseMapper).initDataUp(param);
    }

    @Override
    @Transactional
    public void maintenancePartBaseInfoBySql(BCompanyErrorMaintenanceParam param) {
        ((BCompanyErrorMapper)this.baseMapper).maintenancePartBaseInfo(param);
        ((BCompanyErrorMapper)this.baseMapper).maintenancePartBaseInfoForOrg(param);
        ((BCompanyErrorMapper)this.baseMapper).maintenancePartBaseInfoForRayGroup(param);
        ((BCompanyErrorMapper)this.baseMapper).maintenancePartBaseInfoForStaff(param);
        ((BCompanyErrorMapper)this.baseMapper).maintenancePartBaseInfoForStaffByStaffErrorTable(param);
    }

    @Override
    @Transactional
    public void maintenancePartBaseInfoByJava(BCompanyErrorMaintenanceParam param) {
        List<BCompany> companyList = this.companyService.listForMtErrorInfo(param);
        ArrayList<BCompanyError> companyErrorList = new ArrayList<BCompanyError>();
        for (BCompany temp : companyList) {
            BCompany company = this.companyService.getOneForMtErrorInfo(temp.getId());
            BCompanyError companyError = new BCompanyError();
            String creditCode = company.getCreditCode();
            String legalTel = company.getLegalTel();
            String mainLeaderTel = company.getMainLeaderTel();
            companyError.setId(company.getErrorId());
            companyError.setCreditCodeErr(Integer.valueOf(StrUtil.isBlank((CharSequence)creditCode) ? 1 : (!CreditCodeUtil.isCreditCode((CharSequence)creditCode) ? 2 : 0)));
            companyError.setLegalTelErr(Integer.valueOf(StrUtil.isBlank((CharSequence)legalTel) ? 1 : (!PhoneUtil.isPhone((CharSequence)legalTel) ? 2 : 0)));
            companyError.setMainLeaderTelErr(Integer.valueOf(StrUtil.isBlank((CharSequence)mainLeaderTel) ? 1 : (!PhoneUtil.isPhone((CharSequence)mainLeaderTel) ? 2 : 0)));
            List<BCompanyAddress> addressList = this.companyAddressService.getAddressListByCidForMtCompanyErrorInfo(company.getId());
            if (CollUtil.isEmpty(addressList)) {
                companyError.setAddressErr(Integer.valueOf(1));
            } else {
                for (BCompanyAddress address : addressList) {
                    if (StrUtil.isBlank((CharSequence)address.getAddress())) {
                        companyError.setAddressErr(Integer.valueOf(1));
                    }
                    if (address.getLevel() != null && address.getLevel() >= 4) continue;
                    companyError.setAreaIdErr(Integer.valueOf(2));
                }
                if (companyError.getAreaIdErr() == null) {
                    companyError.setAreaIdErr(Integer.valueOf(0));
                }
                if (companyError.getAddressErr() == null) {
                    companyError.setAddressErr(Integer.valueOf(0));
                }
            }
            companyErrorList.add(companyError);
            if (companyErrorList.size() < 500) continue;
            this.updateBatchById(companyErrorList);
            companyErrorList.clear();
        }
        if (companyErrorList.size() > 0) {
            this.updateBatchById(companyErrorList);
        }
    }

    @Override
    public void maintenanceEMachineRoomPart(BCompanyErrorMaintenanceParam param) {
        ((BCompanyErrorMapper)this.baseMapper).maintenanceEMachineRoomPart(param);
    }

    @Override
    public void maintenanceEDevicePart(BCompanyErrorMaintenanceParam param) {
        ((BCompanyErrorMapper)this.baseMapper).maintenanceEDevicePart(param);
    }

    @Override
    public CompanyErrorVo getErrInfo(CompanyErrInfoParam param) {
        return ((BCompanyErrorMapper)this.baseMapper).getErrInfo(param);
    }

    @Override
    public CompanyErrorStatisticVo getStatisticsTotal(CompanyErrorStatisticParam param) {
        CompanyErrorStatisticVo total = ((BCompanyErrorMapper)this.baseMapper).getStatisticsTotal(param);
        if (total == null) {
            total = new CompanyErrorStatisticVo();
            SysAreaVo area = this.sysAreaService.getAreaById(param.getAreaId());
            if (area != null) {
                total.setAreaId(area.getId());
                total.setAreaName(area.getName());
            }
        }
        return total;
    }

    @Override
    public LayuiGridData<CompanyErrorStatisticVo> statisticCompanyError(CompanyErrorStatisticParam param) {
        LayuiGridData<CompanyErrorStatisticVo> result = null;
        result = param.getShowAllType() == null || param.getShowAllType() == 0 ? this.statisticCompanyErrorCommon(param) : this.statisticCompanyErrorForAllOneLevel(param);
        return result;
    }

    public LayuiGridData<CompanyErrorStatisticVo> statisticCompanyErrorCommon(CompanyErrorStatisticParam param) {
        PageHelper.startPage((int)param.getPage(), (int)param.getLimit());
        List<CompanyErrorStatisticVo> areaList = ((BCompanyErrorMapper)this.baseMapper).getStatisticsAreaList(param);
        if (CollUtil.isEmpty(areaList)) {
            return new LayuiGridData(null, (LayuiGridParam)param);
        }
        List areaIdList = areaList.stream().map(v -> v.getAreaId()).collect(Collectors.toList());
        param.setAreaIdList(areaIdList);
        List<CompanyErrorStatisticVo> dataReportList = ((BCompanyErrorMapper)this.baseMapper).statisticCompanyError(param);
        Map<Long, List<CompanyErrorStatisticVo>> dataReportListMap = dataReportList.stream().collect(Collectors.groupingBy(CompanyErrorStatisticVo::getAreaId));
        for (CompanyErrorStatisticVo vo : areaList) {
            if (!dataReportListMap.containsKey(vo.getAreaId())) continue;
            CompanyErrorStatisticVo vo2 = dataReportListMap.get(vo.getAreaId()).get(0);
            vo.setCompanyTotalNum(vo2.getCompanyTotalNum());
            vo.setCompanyErrorNum(vo2.getCompanyErrorNum());
            vo.setCompanyBaseInfoErrNum(vo2.getCompanyBaseInfoErrNum());
            vo.setStaffInfoErrorNum(vo2.getStaffInfoErrorNum());
            vo.setRoomInfoErrorNum(vo2.getRoomInfoErrorNum());
            vo.setDeviceInfoErrorNum(vo2.getDeviceInfoErrorNum());
            vo.setRayGroupInfoErrorNum(vo2.getRayGroupInfoErrorNum());
        }
        if (param.getLevel() == 2) {
            CompanyErrorStatisticVo cityLevelData = ((BCompanyErrorMapper)this.baseMapper).statisticCompanyErrorForCityLevel(param);
            if (cityLevelData == null) {
                cityLevelData = new CompanyErrorStatisticVo();
                cityLevelData.setAreaId(param.getAreaId());
                cityLevelData.setAreaName(param.getAreaName());
            }
            cityLevelData.setAreaName(cityLevelData.getAreaName() + "\u672c\u7ea7");
            cityLevelData.setIsCityLevel(Integer.valueOf(1));
            areaList.add(0, cityLevelData);
        }
        return new LayuiGridData((Page)areaList, (LayuiGridParam)param);
    }

    public LayuiGridData<CompanyErrorStatisticVo> statisticCompanyErrorForAllOneLevel(CompanyErrorStatisticParam param) {
        PageHelper.startPage((int)param.getPage(), (int)param.getLimit());
        List<CompanyErrorStatisticVo> areaList = ((BCompanyErrorMapper)this.baseMapper).getStatisticsAreaListForAllOneLevel(param);
        if (CollUtil.isEmpty(areaList)) {
            return new LayuiGridData(null, (LayuiGridParam)param);
        }
        List areaIdList = areaList.stream().map(v -> v.getAreaId()).collect(Collectors.toList());
        param.setAreaIdList(areaIdList);
        List<CompanyErrorStatisticVo> dataReportList = ((BCompanyErrorMapper)this.baseMapper).statisticCompanyErrorForAllOneLevel(param);
        Map<Long, List<CompanyErrorStatisticVo>> dataReportListMap = dataReportList.stream().collect(Collectors.groupingBy(CompanyErrorStatisticVo::getAreaId));
        for (CompanyErrorStatisticVo vo : areaList) {
            if (!dataReportListMap.containsKey(vo.getAreaId())) continue;
            CompanyErrorStatisticVo vo2 = dataReportListMap.get(vo.getAreaId()).get(0);
            vo.setCompanyTotalNum(vo2.getCompanyTotalNum());
            vo.setCompanyErrorNum(vo2.getCompanyErrorNum());
            vo.setCompanyBaseInfoErrNum(vo2.getCompanyBaseInfoErrNum());
            vo.setStaffInfoErrorNum(vo2.getStaffInfoErrorNum());
            vo.setRoomInfoErrorNum(vo2.getRoomInfoErrorNum());
            vo.setDeviceInfoErrorNum(vo2.getDeviceInfoErrorNum());
            vo.setRayGroupInfoErrorNum(vo2.getRayGroupInfoErrorNum());
        }
        if (param.getLevel() == 2) {
            CompanyErrorStatisticVo cityLevelData = ((BCompanyErrorMapper)this.baseMapper).statisticCompanyErrorForCityLevel(param);
            if (cityLevelData == null) {
                cityLevelData = new CompanyErrorStatisticVo();
                cityLevelData.setAreaId(param.getAreaId());
                cityLevelData.setAreaName(param.getAreaName());
            }
            cityLevelData.setAreaName(cityLevelData.getAreaName() + "\u672c\u7ea7");
            cityLevelData.setIsCityLevel(Integer.valueOf(1));
            areaList.add(0, cityLevelData);
        }
        return new LayuiGridData((Page)areaList, (LayuiGridParam)param);
    }

    @Generated
    public BCompanyErrorServiceImpl() {
    }
}

