/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.rho.modules.sys.service.b.impl;

import cn.smarthse.rho.core.framework.model.BaseEntity;
import cn.smarthse.rho.modules.sys.dao.b.BCompanyErrorDeviceMapper;
import cn.smarthse.rho.modules.sys.entity.b.BCompany;
import cn.smarthse.rho.modules.sys.entity.b.BCompanyErrorDevice;
import cn.smarthse.rho.modules.sys.entity.e.EDevice;
import cn.smarthse.rho.modules.sys.entity.e.EDeviceRay;
import cn.smarthse.rho.modules.sys.entity.e.EDeviceSource;
import cn.smarthse.rho.modules.sys.entity.e.ESourceNonSealed;
import cn.smarthse.rho.modules.sys.entity.e.ESourceSealed;
import cn.smarthse.rho.modules.sys.enums.company.EdeviceDiagnosisTypeEnum;
import cn.smarthse.rho.modules.sys.enums.company.EdeviceTypeEnum;
import cn.smarthse.rho.modules.sys.enums.risk.BCompanyErrorDeviceCodeEnum;
import cn.smarthse.rho.modules.sys.model.b.param.BCompanyErrorMaintenanceParam;
import cn.smarthse.rho.modules.sys.model.e.param.ERelationDto;
import cn.smarthse.rho.modules.sys.service.b.IBCompanyErrorDeviceService;
import cn.smarthse.rho.modules.sys.service.e.IEDeviceCommonService;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import lombok.Generated;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
@Transactional(readOnly=true)
public class BCompanyErrorDeviceServiceImpl
extends ServiceImpl<BCompanyErrorDeviceMapper, BCompanyErrorDevice>
implements IBCompanyErrorDeviceService {
    @Autowired
    private IEDeviceCommonService deviceCommonService;

    @Override
    @Transactional
    public void initCompanyDeviceError(BCompanyErrorMaintenanceParam param) {
        List<BCompany> companyList = ((BCompanyErrorDeviceMapper)this.baseMapper).listCompany(param);
        companyList.forEach(company -> {
            List<EDevice> deviceList = ((BCompanyErrorDeviceMapper)this.baseMapper).listDeviceByCid(company.getId(), param.getDeviceId());
            deviceList.forEach(this::checkDeviceError);
        });
    }

    @Transactional
    public void checkDeviceError(EDevice device) {
        ArrayList<BCompanyErrorDevice> errorInfoList = new ArrayList<BCompanyErrorDevice>();
        Long deviceId = device.getId();
        Long cid = device.getCid();
        Integer deviceType = device.getType();
        if (Objects.equals(deviceType, EdeviceTypeEnum.DEVICE_RAY.getValue())) {
            List<ERelationDto> eRelationDtos = ((BCompanyErrorDeviceMapper)this.baseMapper).listCurRelationByTypeForTask(4, deviceId);
            EDeviceRay ray = ((BCompanyErrorDeviceMapper)this.baseMapper).getDeviceRayByDid(deviceId);
            if (!StringUtils.hasLength((String)device.getName())) {
                errorInfoList.add(new BCompanyErrorDevice(cid, deviceId, BCompanyErrorDeviceCodeEnum.DEVICE_ERR_CODE_1.getCode()));
            }
            if (ray == null || !StringUtils.hasLength((String)ray.getModel())) {
                errorInfoList.add(new BCompanyErrorDevice(cid, deviceId, BCompanyErrorDeviceCodeEnum.DEVICE_ERR_CODE_2.getCode()));
            }
            if (!StringUtils.hasLength((String)device.getFactory())) {
                errorInfoList.add(new BCompanyErrorDevice(cid, deviceId, BCompanyErrorDeviceCodeEnum.DEVICE_ERR_CODE_3.getCode()));
            }
            if (!StringUtils.hasLength((String)device.getFactoryNo())) {
                errorInfoList.add(new BCompanyErrorDevice(cid, deviceId, BCompanyErrorDeviceCodeEnum.DEVICE_ERR_CODE_4.getCode()));
            }
            if (ray == null || !StringUtils.hasLength((String)ray.getParameters())) {
                errorInfoList.add(new BCompanyErrorDevice(cid, deviceId, BCompanyErrorDeviceCodeEnum.DEVICE_ERR_CODE_5.getCode()));
            }
            if (device.getStatus() == null) {
                errorInfoList.add(new BCompanyErrorDevice(cid, deviceId, BCompanyErrorDeviceCodeEnum.DEVICE_ERR_CODE_6.getCode()));
            }
            if (ray == null || ray.getMobilityType() == null) {
                errorInfoList.add(new BCompanyErrorDevice(cid, deviceId, BCompanyErrorDeviceCodeEnum.DEVICE_ERR_CODE_7.getCode()));
            }
            if (ray == null || ray.getCategory() == null) {
                errorInfoList.add(new BCompanyErrorDevice(cid, deviceId, BCompanyErrorDeviceCodeEnum.DEVICE_ERR_CODE_8.getCode()));
            }
            if (ray == null || ray.getDiagnosisType() == null) {
                errorInfoList.add(new BCompanyErrorDevice(cid, deviceId, BCompanyErrorDeviceCodeEnum.DEVICE_ERR_CODE_9.getCode()));
            }
            if (ray == null || ray.getDiagnosisType() != null && (EdeviceDiagnosisTypeEnum.isXRAYForError((Integer)Integer.valueOf(ray.getDiagnosisType())) || EdeviceDiagnosisTypeEnum.isINTERVENTIONALForError((Integer)Integer.valueOf(ray.getDiagnosisType()))) && ray.getCheckType() == null) {
                errorInfoList.add(new BCompanyErrorDevice(cid, deviceId, BCompanyErrorDeviceCodeEnum.DEVICE_ERR_CODE_10.getCode()));
            }
            if (ray == null || ray.getProductionDate() == null) {
                errorInfoList.add(new BCompanyErrorDevice(cid, deviceId, BCompanyErrorDeviceCodeEnum.DEVICE_ERR_CODE_11.getCode()));
            }
            if (device.getStatus() != null && device.getStatus() == 1 && ray != null && (ray.getIsBedside() == null || ray.getIsBedside() != 1) && CollectionUtils.isEmpty(eRelationDtos)) {
                errorInfoList.add(new BCompanyErrorDevice(cid, deviceId, BCompanyErrorDeviceCodeEnum.DEVICE_ERR_CODE_12.getCode()));
            }
            if (!StringUtils.hasLength((String)device.getUseDepartmentId())) {
                errorInfoList.add(new BCompanyErrorDevice(cid, deviceId, BCompanyErrorDeviceCodeEnum.DEVICE_ERR_CODE_13.getCode()));
            }
            if (ray == null || !StringUtils.hasLength((String)ray.getPersonInCharge())) {
                errorInfoList.add(new BCompanyErrorDevice(cid, deviceId, BCompanyErrorDeviceCodeEnum.DEVICE_ERR_CODE_14.getCode()));
            }
        } else if (Objects.equals(deviceType, EdeviceTypeEnum.SOURCE_NON_SEALED.getValue())) {
            relationList = ((BCompanyErrorDeviceMapper)this.baseMapper).listCurRelationByTypeForTask(1, deviceId);
            ESourceNonSealed sourceNonSealed = ((BCompanyErrorDeviceMapper)this.baseMapper).getNonSealedByDid(deviceId);
            if (!StringUtils.hasLength((String)device.getName())) {
                errorInfoList.add(new BCompanyErrorDevice(cid, deviceId, BCompanyErrorDeviceCodeEnum.DEVICE_ERR_CODE_15.getCode()));
            }
            if (sourceNonSealed == null || sourceNonSealed.getPhysicalState() == null) {
                errorInfoList.add(new BCompanyErrorDevice(cid, deviceId, BCompanyErrorDeviceCodeEnum.DEVICE_ERR_CODE_16.getCode()));
            }
            if (sourceNonSealed == null || sourceNonSealed.getData1() == null || sourceNonSealed.getData2() == null) {
                errorInfoList.add(new BCompanyErrorDevice(cid, deviceId, BCompanyErrorDeviceCodeEnum.DEVICE_ERR_CODE_17.getCode()));
            }
            if (sourceNonSealed == null || sourceNonSealed.getData3() == null || sourceNonSealed.getData4() == null) {
                errorInfoList.add(new BCompanyErrorDevice(cid, deviceId, BCompanyErrorDeviceCodeEnum.DEVICE_ERR_CODE_18.getCode()));
            }
            if (!StringUtils.hasLength((String)device.getUseDepartmentId())) {
                errorInfoList.add(new BCompanyErrorDevice(cid, deviceId, BCompanyErrorDeviceCodeEnum.DEVICE_ERR_CODE_19.getCode()));
            }
            if (sourceNonSealed == null || !StringUtils.hasLength((String)sourceNonSealed.getPersonInCharge())) {
                errorInfoList.add(new BCompanyErrorDevice(cid, deviceId, BCompanyErrorDeviceCodeEnum.DEVICE_ERR_CODE_20.getCode()));
            }
            if (CollectionUtils.isEmpty(relationList)) {
                errorInfoList.add(new BCompanyErrorDevice(cid, deviceId, BCompanyErrorDeviceCodeEnum.DEVICE_ERR_CODE_21.getCode()));
            }
        } else if (Objects.equals(deviceType, EdeviceTypeEnum.SOURCE_SEALED.getValue())) {
            relationList = ((BCompanyErrorDeviceMapper)this.baseMapper).listCurRelationByTypeForTask(1, deviceId);
            ESourceSealed sourceSealed = ((BCompanyErrorDeviceMapper)this.baseMapper).getSourceSealedByDid(deviceId);
            if (!StringUtils.hasLength((String)device.getName())) {
                errorInfoList.add(new BCompanyErrorDevice(cid, deviceId, BCompanyErrorDeviceCodeEnum.DEVICE_ERR_CODE_22.getCode()));
            }
            if (sourceSealed == null || sourceSealed.getData1() == null || sourceSealed.getData2() == null) {
                errorInfoList.add(new BCompanyErrorDevice(cid, deviceId, BCompanyErrorDeviceCodeEnum.DEVICE_ERR_CODE_23.getCode()));
            }
            if (sourceSealed == null || sourceSealed.getMeasurementDate() == null) {
                errorInfoList.add(new BCompanyErrorDevice(cid, deviceId, BCompanyErrorDeviceCodeEnum.DEVICE_ERR_CODE_24.getCode()));
            }
            if (device.getFactory() == null) {
                errorInfoList.add(new BCompanyErrorDevice(cid, deviceId, BCompanyErrorDeviceCodeEnum.DEVICE_ERR_CODE_25.getCode()));
            }
            if (device.getStatus() == null) {
                errorInfoList.add(new BCompanyErrorDevice(cid, deviceId, BCompanyErrorDeviceCodeEnum.DEVICE_ERR_CODE_26.getCode()));
            }
            if (!StringUtils.hasLength((String)device.getUseDepartmentId())) {
                errorInfoList.add(new BCompanyErrorDevice(cid, deviceId, BCompanyErrorDeviceCodeEnum.DEVICE_ERR_CODE_27.getCode()));
            }
            if (!StringUtils.hasLength((String)device.getUseTo())) {
                errorInfoList.add(new BCompanyErrorDevice(cid, deviceId, BCompanyErrorDeviceCodeEnum.DEVICE_ERR_CODE_28.getCode()));
            }
            if (sourceSealed == null || !StringUtils.hasLength((String)sourceSealed.getPersonInCharge())) {
                errorInfoList.add(new BCompanyErrorDevice(cid, deviceId, BCompanyErrorDeviceCodeEnum.DEVICE_ERR_CODE_29.getCode()));
            }
            if (CollectionUtils.isEmpty(relationList)) {
                errorInfoList.add(new BCompanyErrorDevice(cid, deviceId, BCompanyErrorDeviceCodeEnum.DEVICE_ERR_CODE_30.getCode()));
            }
        } else if (Objects.equals(deviceType, EdeviceTypeEnum.DEVICE_SOURCE.getValue())) {
            List<ERelationDto> roomRelationList = ((BCompanyErrorDeviceMapper)this.baseMapper).listCurRelationByTypeForTask(4, deviceId);
            List<ERelationDto> sourceRelationList = ((BCompanyErrorDeviceMapper)this.baseMapper).listCurRelationByTypeForTask(5, deviceId);
            EDeviceSource deviceSource = ((BCompanyErrorDeviceMapper)this.baseMapper).getDeviceSourceByDid(deviceId);
            if (!StringUtils.hasLength((String)device.getName())) {
                errorInfoList.add(new BCompanyErrorDevice(cid, deviceId, BCompanyErrorDeviceCodeEnum.DEVICE_ERR_CODE_31.getCode()));
            }
            if (!StringUtils.hasLength((String)device.getFactoryNo())) {
                errorInfoList.add(new BCompanyErrorDevice(cid, deviceId, BCompanyErrorDeviceCodeEnum.DEVICE_ERR_CODE_32.getCode()));
            }
            if (deviceSource == null || !StringUtils.hasLength((String)deviceSource.getModel())) {
                errorInfoList.add(new BCompanyErrorDevice(cid, deviceId, BCompanyErrorDeviceCodeEnum.DEVICE_ERR_CODE_33.getCode()));
            }
            if (!StringUtils.hasLength((String)device.getFactory())) {
                errorInfoList.add(new BCompanyErrorDevice(cid, deviceId, BCompanyErrorDeviceCodeEnum.DEVICE_ERR_CODE_34.getCode()));
            }
            if (deviceSource == null || !StringUtils.hasLength((String)deviceSource.getDiagnosisType())) {
                errorInfoList.add(new BCompanyErrorDevice(cid, deviceId, BCompanyErrorDeviceCodeEnum.DEVICE_ERR_CODE_35.getCode()));
            }
            if (device.getStatus() == null) {
                errorInfoList.add(new BCompanyErrorDevice(cid, deviceId, BCompanyErrorDeviceCodeEnum.DEVICE_ERR_CODE_36.getCode()));
            }
            if (device.getStatus() != null && device.getStatus() == 1 && CollectionUtils.isEmpty(roomRelationList)) {
                errorInfoList.add(new BCompanyErrorDevice(cid, deviceId, BCompanyErrorDeviceCodeEnum.DEVICE_ERR_CODE_37.getCode()));
            }
            if (!StringUtils.hasLength((String)device.getUseDepartmentId())) {
                errorInfoList.add(new BCompanyErrorDevice(cid, deviceId, BCompanyErrorDeviceCodeEnum.DEVICE_ERR_CODE_38.getCode()));
            }
            if (deviceSource == null || !StringUtils.hasLength((String)deviceSource.getPersonInCharge())) {
                errorInfoList.add(new BCompanyErrorDevice(cid, deviceId, BCompanyErrorDeviceCodeEnum.DEVICE_ERR_CODE_39.getCode()));
            }
            if (CollectionUtils.isEmpty(sourceRelationList)) {
                errorInfoList.add(new BCompanyErrorDevice(cid, deviceId, BCompanyErrorDeviceCodeEnum.DEVICE_ERR_CODE_40.getCode()));
            }
        }
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryWrapper.eq(BCompanyErrorDevice::getDid, (Object)deviceId)).eq(BaseEntity::getIsValid, (Object)1);
        List dbErrorList = this.list((Wrapper)queryWrapper);
        if (!CollectionUtils.isEmpty((Collection)dbErrorList)) {
            List<BCompanyErrorDevice> toAdd;
            List<BCompanyErrorDevice> toRemove = dbErrorList.stream().filter(dbError -> errorInfoList.stream().noneMatch(currentError -> Objects.equals(currentError.getErrCode(), dbError.getErrCode()))).toList();
            if (!toRemove.isEmpty()) {
                List<Long> removeIds = toRemove.stream().map(BCompanyErrorDevice::getId).toList();
                this.removeByIds(removeIds);
            }
            if (!(toAdd = errorInfoList.stream().filter(currentError -> dbErrorList.stream().noneMatch(dbError -> Objects.equals(dbError.getErrCode(), currentError.getErrCode()))).toList()).isEmpty()) {
                this.saveBatch(toAdd);
            }
        } else {
            this.saveBatch(errorInfoList);
        }
        queryWrapper.clear();
        ((LambdaQueryWrapper)queryWrapper.eq(BCompanyErrorDevice::getDid, (Object)deviceId)).eq(BaseEntity::getIsValid, (Object)1);
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        updateWrapper.eq(EDevice::getId, (Object)deviceId);
        if (this.list((Wrapper)queryWrapper).isEmpty()) {
            updateWrapper.set(EDevice::getInformationStatus, (Object)1);
        } else {
            updateWrapper.set(EDevice::getInformationStatus, (Object)0);
        }
        this.deviceCommonService.update((Wrapper)updateWrapper);
    }

    @Generated
    public BCompanyErrorDeviceServiceImpl() {
    }
}

