/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.rho.modules.sys.service.b.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import cn.smarthse.framework.mybatisPlus.service.impl.ServiceImpl;
import cn.smarthse.rho.core.framework.model.LayuiGridData;
import cn.smarthse.rho.core.framework.model.LayuiGridParam;
import cn.smarthse.rho.modules.sys.dao.b.BCompanyBulletinMapper;
import cn.smarthse.rho.modules.sys.entity.b.BCompanyBulletin;
import cn.smarthse.rho.modules.sys.model.b.param.BCompanyBulletinParam;
import cn.smarthse.rho.modules.sys.model.b.vo.BCompanyBulletinListVo;
import cn.smarthse.rho.modules.sys.model.sys.vo.SysFileVo;
import cn.smarthse.rho.modules.sys.service.b.IBCompanyBulletinService;
import cn.smarthse.rho.modules.sys.service.b.IBCompanyErrorService;
import cn.smarthse.rho.modules.sys.service.b.IBRayManageService;
import cn.smarthse.rho.modules.sys.service.sys.ISysFileService;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.smarthse.framework.exception.ServiceException;
import lombok.Generated;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class BCompanyBulletinServiceImpl
extends ServiceImpl<BCompanyBulletinMapper, BCompanyBulletin>
implements IBCompanyBulletinService {
    private final ISysFileService sysFileService;
    @Autowired
    @Lazy
    private IBCompanyErrorService companyErrorService;
    private final IBRayManageService rayManageService;

    @Override
    public LayuiGridData<BCompanyBulletinListVo> getBulletinList(BCompanyBulletinParam param) {
        List<SysFileVo> fileList;
        Set fileIdSet;
        if (param.getType() == null || param.getType() != 1 && param.getType() != 2) {
            throw new ServiceException("\u516c\u544a\u680f\u6587\u4ef6\u7c7b\u578b\u4e3a\u7a7a\u4e0d\u5408\u6cd5");
        }
        if (param.getCid() == null) {
            throw new ServiceException("cid\u4e0d\u80fd\u4e3a\u7a7a");
        }
        PageHelper.startPage((int)param.getPage(), (int)param.getLimit());
        List<BCompanyBulletinListVo> list = ((BCompanyBulletinMapper)this.baseMapper).getBulletinList(param);
        if (CollectionUtil.isNotEmpty(list) && CollectionUtil.isNotEmpty(fileIdSet = list.stream().filter(item -> item.getFileId() != null).map(BCompanyBulletinListVo::getFileId).collect(Collectors.toSet())) && CollectionUtil.isNotEmpty(fileList = this.sysFileService.getFileVoByIds(fileIdSet.stream().map(String::valueOf).collect(Collectors.joining(","))))) {
            Map<Long, SysFileVo> fileMap = fileList.stream().collect(Collectors.toMap(SysFileVo::getId, f -> f));
            list.forEach(vo -> {
                SysFileVo sysFileVo;
                if (vo.getFileId() != null && (sysFileVo = (SysFileVo)fileMap.get(vo.getFileId())) != null) {
                    vo.setFileName(sysFileVo.getFileName());
                    vo.setFileUrl(sysFileVo.getFullOssUrl());
                    vo.setFileExt(sysFileVo.getFileExt());
                }
            });
        }
        return new LayuiGridData((Page)list, (LayuiGridParam)param);
    }

    @Override
    @Transactional
    public void addOrEditBulletin(BCompanyBulletinParam param) {
        if (param.getCid() == null) {
            throw new ServiceException("cid\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (param.getType() == null || param.getType() != 1 && param.getType() != 2) {
            throw new ServiceException("\u516c\u544a\u680f\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\u6216\u4e0d\u5408\u6cd5");
        }
        if (param.getOperatorId() == null) {
            throw new ServiceException("\u64cd\u4f5c\u4ebaid\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (param.getFileId() == null) {
            throw new ServiceException("\u9644\u4ef6id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (param.getId() == null) {
            if (param.getType() == 1 && param.getCategoryCode() == null) {
                throw new ServiceException("\u7ba1\u7406\u5236\u5ea6\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (param.getType() == 2 && StrUtil.isBlank((CharSequence)param.getName())) {
                throw new ServiceException("\u64cd\u4f5c\u89c4\u7a0b\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (param.getType() == 1 && ((BCompanyBulletinMapper)this.baseMapper).isExistCategoryCodeByCid(param.getCid(), param.getCategoryCode())) {
                throw new ServiceException("\u8be5\u7ba1\u7406\u5236\u5ea6\u7c7b\u578b\u6587\u4ef6\u5df2\u5b58\u5728\uff0c\u4e0d\u80fd\u91cd\u590d\u6dfb\u52a0");
            }
            BCompanyBulletin bulletin = new BCompanyBulletin();
            bulletin.setId(Long.valueOf(IdWorker.getId()));
            bulletin.setCid(param.getCid());
            if (param.getType() == 2) {
                bulletin.setName(param.getName());
            }
            bulletin.setCategoryCode(param.getCategoryCode());
            bulletin.setFileId(param.getFileId());
            bulletin.setType(param.getType());
            bulletin.setCreateBy(param.getOperatorId());
            bulletin.setCreateDate(LocalDateTime.now());
            bulletin.setUpdateBy(param.getOperatorId());
            bulletin.setUpdateDate(LocalDateTime.now());
            this.save(bulletin);
        } else {
            BCompanyBulletin bulletin = new BCompanyBulletin();
            bulletin.setId(param.getId());
            if (StrUtil.isNotBlank((CharSequence)param.getName())) {
                bulletin.setName(param.getName());
            }
            if (param.getFileId() != null) {
                bulletin.setFileId(param.getFileId());
            }
            bulletin.setUpdateBy(param.getOperatorId());
            bulletin.setUpdateDate(LocalDateTime.now());
            this.updateById(bulletin);
        }
        if (ObjectUtil.equal((Object)param.getType(), (Object)1) && ObjectUtil.equal((Object)param.getCategoryCode(), (Object)1)) {
            this.rayManageService.addForFileUpload(param.getCid());
            this.companyErrorService.manualMaintenanceOne(param.getCid());
        }
    }

    @Override
    @Transactional
    public void removeBulletin(BCompanyBulletinParam param) {
        if (param.getId() == null) {
            throw new ServiceException("id\u4e3a\u7a7a,\u5220\u9664\u5931\u8d25");
        }
        if (param.getType() == null) {
            throw new ServiceException("\u7c7b\u578b\u4e3a\u7a7a,\u5220\u9664\u5931\u8d25");
        }
        if (param.getType() == 1) {
            throw new ServiceException("\u7c7b\u578b\u4e3a\u7ba1\u7406\u5236\u5ea6,\u5220\u9664\u5931\u8d25");
        }
        if (param.getCid() == null) {
            throw new ServiceException("cid\u4e3a\u7a7a,\u5220\u9664\u5931\u8d25");
        }
        BCompanyBulletin dbBullutin = (BCompanyBulletin)this.getById(param.getId());
        if (dbBullutin == null) {
            throw new ServiceException("\u6570\u636e\u4e0d\u5b58\u5728,\u5220\u9664\u5931\u8d25");
        }
        this.removeById(param.getId());
    }

    @Override
    @Transactional
    public void rayManageFileSyncToBulletin() {
        List<BCompanyBulletin> list = ((BCompanyBulletinMapper)this.baseMapper).needSyncToBulletinList();
        if (CollectionUtil.isNotEmpty(list)) {
            list.forEach(bulletin -> bulletin.setId(Long.valueOf(IdWorker.getId())));
            try {
                this.saveBatch(list);
            }
            catch (Exception e) {
                this.log.error("\u653e\u5c04\u9632\u62a4\u7ba1\u7406\u9886\u5bfc\u5c0f\u7ec4-\u6210\u7acb\u6587\u4ef6 \u540c\u6b65\u5230\u516c\u544a\u680f\u6587\u4ef6\u8868\u5931\u8d25,\u8bf7\u91cd\u8bd5", (Throwable)e);
                throw new ServiceException("\u653e\u5c04\u9632\u62a4\u7ba1\u7406\u9886\u5bfc\u5c0f\u7ec4-\u6210\u7acb\u6587\u4ef6 \u540c\u6b65\u5230\u516c\u544a\u680f\u6587\u4ef6\u8868\u5931\u8d25,\u8bf7\u91cd\u8bd5");
            }
        }
    }

    @Override
    public BCompanyBulletin getOneByParam(BCompanyBulletinParam param) {
        return ((BCompanyBulletinMapper)this.baseMapper).getOneByParam(param);
    }

    @Generated
    public BCompanyBulletinServiceImpl(ISysFileService sysFileService, IBRayManageService rayManageService) {
        this.sysFileService = sysFileService;
        this.rayManageService = rayManageService;
    }
}

