/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.rho.modules.sys.service.b.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import cn.smarthse.framework.mybatisPlus.service.impl.ServiceImpl;
import cn.smarthse.modules.datacentre.enums.CompanyBelongTypeEnum;
import cn.smarthse.modules.datacentre.provider.system.ISysAreaProvideService;
import cn.smarthse.modules.health.supervise.entity.basic.Organization;
import cn.smarthse.modules.health.supervise.service.basic.IOrganizationService;
import cn.smarthse.modules.platform.model.v3.sysArea.SysAreaV3OneVo;
import cn.smarthse.rho.modules.sys.dao.b.BCompanyAddressMapper;
import cn.smarthse.rho.modules.sys.entity.b.BCompany;
import cn.smarthse.rho.modules.sys.entity.b.BCompanyAddress;
import cn.smarthse.rho.modules.sys.model.b.param.BCompanyAddressEditParam;
import cn.smarthse.rho.modules.sys.model.b.vo.OrgCompanyAddressVo;
import cn.smarthse.rho.modules.sys.model.b.vo.company.CompanyAddressVo;
import cn.smarthse.rho.modules.sys.model.sys.vo.SysAreaVo;
import cn.smarthse.rho.modules.sys.service.b.IBCompanyAddressService;
import cn.smarthse.rho.modules.sys.service.b.IBCompanyErrorService;
import cn.smarthse.rho.modules.sys.service.b.IBCompanyService;
import cn.smarthse.rho.modules.sys.service.e.IEMachineRoomCommonService;
import cn.smarthse.rho.modules.sys.service.sys.ISysAreaService;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import javax.smarthse.framework.exception.ServiceException;
import lombok.Generated;
import org.apache.dubbo.config.annotation.DubboReference;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class BCompanyAddressServiceImpl
extends ServiceImpl<BCompanyAddressMapper, BCompanyAddress>
implements IBCompanyAddressService {
    private final ISysAreaService areaService;
    private final IBCompanyService companyService;
    private final IEMachineRoomCommonService machineRoomCommonService;
    @Lazy
    @Autowired
    private IBCompanyErrorService companyErrorService;
    @DubboReference(registry={"public_nacos"}, version="1.0.0")
    private ISysAreaProvideService sysAreaProvideService;
    @DubboReference(registry={"public_nacos"})
    private IOrganizationService organizationService;

    @Override
    public List<BCompanyAddress> getAddressListByCid(Long cid) {
        return ((BCompanyAddressMapper)this.baseMapper).getAddressListByCid(cid);
    }

    @Override
    public List<BCompanyAddress> getAddressListByCidForMtCompanyErrorInfo(Long cid) {
        return ((BCompanyAddressMapper)this.baseMapper).getAddressListByCidForMtCompanyErrorInfo(cid);
    }

    @Override
    public List<CompanyAddressVo> getAddressVoList(Long cid) {
        List<CompanyAddressVo> addressVoList = ((BCompanyAddressMapper)this.baseMapper).getAddressVoList(cid);
        for (CompanyAddressVo vo : addressVoList) {
            SysAreaVo area = this.areaService.getAreaById(vo.getAreaId());
            vo.setArea(area);
        }
        return addressVoList;
    }

    @Override
    public List<CompanyAddressVo> getAddressVoListForCompanyBaseInfoPage(Long cid) {
        List<CompanyAddressVo> addressVoList = ((BCompanyAddressMapper)this.baseMapper).getAddressVoListForCompanyBaseInfoPage(cid);
        for (CompanyAddressVo vo : addressVoList) {
            SysAreaVo area = this.areaService.getAreaById(vo.getAreaId());
            vo.setArea(area);
        }
        return addressVoList;
    }

    @Override
    @Transactional
    public boolean saveBatch(List<BCompanyAddressEditParam> paramList) {
        if (CollectionUtil.isEmpty(paramList)) {
            return true;
        }
        Map<Long, List<BCompanyAddressEditParam>> map = paramList.stream().collect(Collectors.groupingBy(BCompanyAddressEditParam::getCid));
        for (List<BCompanyAddressEditParam> list : map.values()) {
            if (this.cidSaveBatch(list)) continue;
            return false;
        }
        return true;
    }

    private boolean cidSaveBatch(List<BCompanyAddressEditParam> paramList) {
        HashSet batchNames = new HashSet();
        HashSet batchAreaIds = new HashSet();
        AtomicBoolean isFirst = new AtomicBoolean(true);
        paramList.stream().forEach(param -> {
            if (isFirst.get()) {
                param.setIsNeedMainCheck(Boolean.valueOf(true));
                isFirst.set(false);
            } else {
                param.setIsNeedMainCheck(Boolean.valueOf(false));
            }
            this.batchUniqueCheck((BCompanyAddressEditParam)param, batchNames, batchAreaIds);
            if (param.getId() == null) {
                this.add((BCompanyAddressEditParam)param);
            } else {
                this.edit((BCompanyAddressEditParam)param);
            }
        });
        return true;
    }

    private void batchUniqueCheck(BCompanyAddressEditParam param, Set<String> batchNames, Set<Long> batchAreaIds) {
        if (!batchNames.add(param.getName())) {
            throw new ServiceException("\u4fdd\u5b58\u5931\u8d25\uff0c\u6267\u4e1a\u5730\u5740\u540d\u79f0\u5b58\u5728\u91cd\u590d: " + param.getName());
        }
        if (!batchAreaIds.add(param.getAreaId())) {
            throw new ServiceException("\u4fdd\u5b58\u5931\u8d25\uff0c\u6267\u4e1a\u5730\u5740\u884c\u653f\u533a\u5212\u5b58\u5728\u91cd\u590d: " + param.getAreaId());
        }
    }

    private void dataBaseUniqueCheck(BCompanyAddressEditParam param) {
        if (((BCompanyAddressMapper)this.baseMapper).selectCountByName(param) > 0) {
            throw new ServiceException("\u4fdd\u5b58\u5931\u8d25\uff0c\u6267\u4e1a\u5730\u5740\u540d\u79f0\u5df2\u5b58\u5728: " + param.getName());
        }
        if (((BCompanyAddressMapper)this.baseMapper).selectCountByAreaId(param) > 0) {
            throw new ServiceException("\u4fdd\u5b58\u5931\u8d25\uff0c\u6267\u4e1a\u5730\u5740\u884c\u653f\u533a\u5212\u5df2\u5b58\u5728: " + param.getAreaId());
        }
    }

    @Override
    public boolean removeBatchByIds(List<Long> idList) {
        if (CollectionUtil.isEmpty(idList)) {
            return true;
        }
        ((BCompanyAddressMapper)this.baseMapper).deleteBatchIds(idList);
        return false;
    }

    @Override
    public CompanyAddressVo getOneAddressVo(Long subCid) {
        CompanyAddressVo vo = null;
        BCompanyAddress entity = (BCompanyAddress)this.getById(subCid);
        if (entity != null) {
            vo = new CompanyAddressVo();
            vo.setId(entity.getId());
            vo.setCid(entity.getCid());
            vo.setName(entity.getName());
            vo.setAreaId(entity.getAreaId());
            vo.setAddress(entity.getAddress());
            vo.setArea(this.areaService.getAreaById(entity.getAreaId()));
        }
        return vo;
    }

    @Override
    @Transactional
    public void editCompanyAddressById(BCompanyAddressEditParam param) {
        this.edit(param);
        this.companyErrorService.manualMaintenanceOne(param.getCid());
    }

    @Transactional
    public void edit(BCompanyAddressEditParam param) {
        if (param.getId() == null) {
            throw new ServiceException("\u5730\u5740id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        BCompanyAddress dbAddress = (BCompanyAddress)((BCompanyAddressMapper)this.baseMapper).selectById(param.getId());
        if (param.getIsMain() == null) {
            param.setIsMain(dbAddress.getIsMain());
        }
        this.checkParam(param);
        this.dataBaseUniqueCheck(param);
        if (dbAddress == null) {
            throw new ServiceException("id\u53c2\u6570\u6709\u8bef\uff0c\u8be5\u5730\u5740\u4e0d\u5b58\u5728");
        }
        Boolean isChangeMain = param.getIsMain() == 1 && dbAddress.getIsMain() == 0;
        BCompanyAddress address = new BCompanyAddress();
        if (param.getIsMain() != null && param.getIsMain() == 1 || dbAddress.getIsMain() == 1) {
            this.changeMainAddress(param, isChangeMain);
            address.setIsMain(param.getIsMain());
        }
        address.setId(param.getId());
        address.setAddress(param.getAddress() == null ? "" : param.getAddress());
        address.setAreaId(param.getAreaId());
        address.setName(param.getName());
        ((BCompanyAddressMapper)this.baseMapper).updateById(address);
    }

    private void maintanceCompanySupervision(BCompany company) {
        SysAreaV3OneVo area = this.sysAreaProvideService.getAreaByIdV3(company.getAreaId());
        if (Objects.isNull(area)) {
            return;
        }
        Long areaId = Objects.equals(company.getBelongType(), CompanyBelongTypeEnum.SHI.getValue()) ? area.getCityId() : (Objects.equals(company.getBelongType(), CompanyBelongTypeEnum.SHENG.getValue()) ? area.getProvinceId() : area.getAreaId());
        Organization org = this.organizationService.getOrganizationByAreaId(areaId);
        if (Objects.isNull(org)) {
            return;
        }
        company.setSupervisionUnit(org.getId());
        company.setSupervisionAreaId(org.getAreaId());
        this.companyService.updateById(company);
    }

    private void changeMainAddress(BCompanyAddressEditParam param, Boolean isChangeMain) {
        BCompany oldCompany;
        BCompanyAddress mainAddress;
        if (isChangeMain.booleanValue() && (mainAddress = ((BCompanyAddressMapper)this.baseMapper).selectMainAddress(param.getCid())) != null) {
            BCompanyAddress updateParam = new BCompanyAddress();
            updateParam.setId(mainAddress.getId());
            updateParam.setIsMain(Integer.valueOf(0));
            ((BCompanyAddressMapper)this.baseMapper).updateById(updateParam);
        }
        if (ObjectUtil.isNull((Object)(oldCompany = (BCompany)this.companyService.getById(param.getCid())))) {
            throw new ServiceException("\u9662\u533a\u4fe1\u606f\u5f02\u5e38!");
        }
        if (oldCompany.getSupervisoryJurisdictionType() != 0) {
            return;
        }
        Boolean isChangeAreaId = !Objects.equals(param.getAreaId(), oldCompany.getAreaId());
        Boolean isChangeAddress = !Objects.equals(param.getAddress(), oldCompany.getAddress());
        BCompany company = new BCompany();
        company.setId(param.getCid());
        if (isChangeAreaId.booleanValue()) {
            company.setAreaId(param.getAreaId());
        }
        if (isChangeAddress.booleanValue()) {
            company.setAddress(param.getAddress() == null ? "" : param.getAddress());
        }
        if (isChangeAddress.booleanValue() || isChangeAreaId.booleanValue()) {
            this.companyService.updateById(company);
        }
        if (isChangeAreaId.booleanValue()) {
            oldCompany.setAreaId(param.getAreaId());
            this.maintanceCompanySupervision(oldCompany);
        }
    }

    @Override
    @Transactional
    public void addCompanyAddress(BCompanyAddressEditParam param) {
        this.add(param);
        this.companyErrorService.manualMaintenanceOne(param.getCid());
    }

    @Transactional
    public void add(BCompanyAddressEditParam param) {
        this.checkParam(param);
        this.dataBaseUniqueCheck(param);
        BCompanyAddress address = new BCompanyAddress();
        address.setCid(param.getCid());
        address.setName(param.getName());
        address.setAreaId(param.getAreaId());
        address.setAddress(param.getAddress() == null ? "" : param.getAddress());
        address.setIsMain(Integer.valueOf(0));
        if (Boolean.TRUE.equals(param.getIsNeedMainCheck()) && ((BCompanyAddressMapper)this.baseMapper).selectCountByCid(param.getCid()) == 0) {
            address.setIsMain(Integer.valueOf(1));
        }
        if (param.getIsMain() != null && param.getIsMain() == 1) {
            this.changeMainAddress(param, true);
            address.setIsMain(param.getIsMain());
        }
        ((BCompanyAddressMapper)this.baseMapper).insert(address);
    }

    @Override
    @Transactional
    public void deleteCompanyAddressById(Long id) {
        if (id == null) {
            throw new ServiceException("\u5730\u5740id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        BCompanyAddress address = (BCompanyAddress)((BCompanyAddressMapper)this.baseMapper).selectById(id);
        if (address == null) {
            throw new ServiceException("\u5730\u5740\u4e0d\u5b58\u5728");
        }
        if (address.getIsMain() == 1) {
            throw new ServiceException("\u8be5\u5730\u5740\u4e3a\u4e3b\u6267\u4e1a\u5730\u5740\uff0c\u4e0d\u80fd\u76f4\u63a5\u5220\u9664");
        }
        if (!this.ifCanDeleteBasedOnStaffNum(id)) {
            throw new ServiceException("\u8be5\u5730\u5740\u4e0b\u6709\u5458\u5de5\uff0c\u4e0d\u80fd\u76f4\u63a5\u5220\u9664");
        }
        ((BCompanyAddressMapper)this.baseMapper).deleteById(id);
        this.companyErrorService.manualMaintenanceOne(address.getCid());
    }

    @Override
    public List<BCompanyAddress> getMainCompanyAddressList() {
        return ((BCompanyAddressMapper)this.baseMapper).getMainCompanyAddressList();
    }

    @Override
    public boolean ifCanDeleteBasedOnStaffNum(Long companyAddressId) {
        BCompanyAddress db = (BCompanyAddress)this.getById(companyAddressId);
        if (db == null) {
            throw new ServiceException("\u5730\u5740\u4e0d\u5b58\u5728\uff0c\u6821\u9a8c\u5931\u8d25");
        }
        Integer staffNum = ((BCompanyAddressMapper)this.baseMapper).getStaffNumForDel(companyAddressId);
        return staffNum == 0;
    }

    @Override
    public List<OrgCompanyAddressVo> getOrgCompanyAddressVo(Long cid) {
        return ((BCompanyAddressMapper)this.baseMapper).getOrgCompanyAddressVo(cid);
    }

    @Override
    public BCompanyAddress getMainAddress(Long cid) {
        if (cid == null) {
            throw new ServiceException("cid\u4e3a\u7a7a\uff0c\u67e5\u627e\u4e3b\u6267\u4e1a\u5730\u5740\u5931\u8d25");
        }
        return ((BCompanyAddressMapper)this.baseMapper).getMainAddress(cid);
    }

    private void checkParam(BCompanyAddressEditParam param) {
        if (param.getCid() == null) {
            throw new ServiceException("\u6240\u5c5e\u9662\u533aid\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StrUtil.isBlank((CharSequence)param.getName())) {
            throw new ServiceException("\u6267\u4e1a\u5730\u5740\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (param.getAreaId() == null) {
            throw new ServiceException("\u6240\u5c5e\u533a\u57dfid\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    @Generated
    public BCompanyAddressServiceImpl(ISysAreaService areaService, IBCompanyService companyService, IEMachineRoomCommonService machineRoomCommonService) {
        this.areaService = areaService;
        this.companyService = companyService;
        this.machineRoomCommonService = machineRoomCommonService;
    }
}

