/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.rho.modules.sys.service.b.impl;

import cn.smarthse.framework.mybatisPlus.service.impl.ServiceImpl;
import cn.smarthse.rho.core.framework.Constant;
import cn.smarthse.rho.core.framework.model.BaseEntity;
import cn.smarthse.rho.core.framework.model.LayuiGridData;
import cn.smarthse.rho.core.framework.model.LayuiGridParam;
import cn.smarthse.rho.modules.sys.dao.b.BChangeLicenseMapper;
import cn.smarthse.rho.modules.sys.entity.b.BChangeLicense;
import cn.smarthse.rho.modules.sys.enums.license.LicenseChangeTypeEnum;
import cn.smarthse.rho.modules.sys.enums.license.LicenseStatusEnum;
import cn.smarthse.rho.modules.sys.model.b.param.license.BChangeLicenseGenParam;
import cn.smarthse.rho.modules.sys.model.b.param.license.ChangeLicenseParam;
import cn.smarthse.rho.modules.sys.model.b.vo.license.ChangeLicenseListVo;
import cn.smarthse.rho.modules.sys.service.b.IBChangeLicenseOptLogService;
import cn.smarthse.rho.modules.sys.service.b.IBChangeLicenseService;
import cn.smarthse.rho.modules.sys.service.sys.ISysFileService;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import javax.smarthse.framework.exception.ServiceException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
@Transactional(readOnly=true)
public class BChangeLicenseServiceImpl
extends ServiceImpl<BChangeLicenseMapper, BChangeLicense>
implements IBChangeLicenseService {
    @Autowired
    private ISysFileService sysFileService;
    @Autowired
    private IBChangeLicenseOptLogService optLogService;

    @Override
    public void applyChange(BChangeLicenseGenParam param) {
        this.genChangeLicense(param);
    }

    @Override
    @Transactional
    public void genChangeLicense(BChangeLicenseGenParam param) {
        BChangeLicense db = this.getByCidAndSubType(param.getCid(), param.getSubType());
        if (db != null) {
            throw new ServiceException("\u4e0d\u53ef\u91cd\u590d\u7533\u8bf7");
        }
        LicenseChangeTypeEnum changeTypeEnum = LicenseChangeTypeEnum.getEnumBySubType((String)param.getSubType());
        BChangeLicense e = new BChangeLicense();
        e.setCid(param.getCid());
        e.setType(changeTypeEnum.getType());
        e.setSubType(changeTypeEnum.getSubType());
        e.setTitle(null);
        e.setTargetId(param.getTargetId());
        this.save(e);
    }

    @Override
    public BChangeLicense getByCidAndSubType(Long cid, String subType) {
        QueryWrapper wrapper = new QueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.lambda().eq(BChangeLicense::getCid, (Object)cid)).eq(BChangeLicense::getSubType, (Object)subType)).eq(BaseEntity::getIsValid, (Object)Constant.ACTIVE_YES)).last("limit 1");
        return (BChangeLicense)this.getOne((Wrapper)wrapper);
    }

    @Override
    public void genChangeLicense(List<BChangeLicenseGenParam> paramList) {
        for (BChangeLicenseGenParam param : paramList) {
            this.genChangeLicense(param);
        }
    }

    @Override
    public LayuiGridData<ChangeLicenseListVo> getChangeLicenseList(ChangeLicenseParam param) {
        PageHelper.startPage((int)param.getPage(), (int)param.getLimit());
        List<ChangeLicenseListVo> list = ((BChangeLicenseMapper)this.baseMapper).getChangeLicenseList(param);
        return new LayuiGridData((Page)list, (LayuiGridParam)param);
    }

    @Override
    public ChangeLicenseListVo getInfo(ChangeLicenseParam param) {
        String subType;
        BChangeLicense changeLicense = (BChangeLicense)this.getById((Serializable)((Object)param.getLicenseId()));
        if (changeLicense == null) {
            return null;
        }
        ChangeLicenseListVo vo = new ChangeLicenseListVo();
        vo.setId(changeLicense.getId());
        vo.setCid(changeLicense.getCid());
        vo.setType(changeLicense.getType());
        vo.setSubType(changeLicense.getSubType());
        vo.setTitle(changeLicense.getTitle());
        vo.setTargetId(changeLicense.getTargetId());
        vo.setAdminLicenseId(changeLicense.getAdminLicenseId());
        vo.setAdminLicenseStatus(changeLicense.getAdminLicenseStatus());
        vo.setAdminLicenseTime(changeLicense.getAdminLicenseTime());
        vo.setSdFileUrl(this.sysFileService.getUrl(changeLicense.getSdFileId()));
        vo.setOptLogList(this.optLogService.getListByLicenseId(changeLicense.getId()));
        if (changeLicense.getAdminLicenseStatus() == LicenseStatusEnum.RETURNED.getStatus()) {
            vo.setReturnReason(this.optLogService.getLastReturnReason(changeLicense.getId()));
        }
        if ((subType = vo.getSubType()) == null) {
            return vo;
        }
        if (subType.equals(LicenseChangeTypeEnum.CHANGE_THERAPY_DEVICE_ADD.getSubType()) || subType.equals(LicenseChangeTypeEnum.CHANGE_THERAPY_DEVICE_SUB.getSubType()) || subType.equals(LicenseChangeTypeEnum.CHANGE_THERAPY_DEVICE_PLACE.getSubType())) {
            // empty if block
        }
        return vo;
    }

    @Override
    public BChangeLicense getLicenseByTargetId(Long targetId) {
        QueryWrapper wrapper = new QueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.lambda().eq(BChangeLicense::getTargetId, (Object)targetId)).eq(BaseEntity::getIsValid, (Object)Constant.ACTIVE_YES)).last("limit 1");
        return (BChangeLicense)this.getOne((Wrapper)wrapper);
    }

    @Override
    public List<BChangeLicense> listLicenseByTargetIds(List<Long> targetIds) {
        if (CollectionUtils.isEmpty(targetIds)) {
            return Collections.emptyList();
        }
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().in(BChangeLicense::getTargetId, targetIds)).eq(BChangeLicense::getIsCur, (Object)1)).list();
    }
}

