/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.rho.modules.sys.provider.sys;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import cn.smarthse.modules.datacentre.enums.CompanyBelongTypeEnum;
import cn.smarthse.modules.datacentre.provider.system.ISysAreaProvideService;
import cn.smarthse.modules.health.supervise.entity.basic.Organization;
import cn.smarthse.modules.health.supervise.service.basic.IOrganizationService;
import cn.smarthse.modules.platform.model.v3.sysArea.SysAreaV3OneVo;
import cn.smarthse.rho.core.framework.model.IdParam;
import cn.smarthse.rho.core.framework.model.IdsParam;
import cn.smarthse.rho.core.framework.model.LayuiGridData;
import cn.smarthse.rho.core.framework.model.LayuiGridParam;
import cn.smarthse.rho.modules.sys.converter.sys.SysUserConverter;
import cn.smarthse.rho.modules.sys.entity.b.BCompany;
import cn.smarthse.rho.modules.sys.entity.b.BCompanyAddress;
import cn.smarthse.rho.modules.sys.entity.sys.SysUser;
import cn.smarthse.rho.modules.sys.enums.company.BusinessStatusEnum;
import cn.smarthse.rho.modules.sys.enums.company.CompanyLicenceStatusEnum;
import cn.smarthse.rho.modules.sys.enums.sys.RhoUserRolesEnum;
import cn.smarthse.rho.modules.sys.model.b.param.BCompanyAddressEditParam;
import cn.smarthse.rho.modules.sys.model.b.param.BCompanyPushParam;
import cn.smarthse.rho.modules.sys.model.b.vo.company.CompanyAddressVo;
import cn.smarthse.rho.modules.sys.model.sys.param.SysCompanyUserAddForComParam;
import cn.smarthse.rho.modules.sys.model.sys.param.SysCompanyUserCreateEditParam;
import cn.smarthse.rho.modules.sys.model.sys.param.SysCompanyUserEditForComParam;
import cn.smarthse.rho.modules.sys.model.sys.param.SysCompanyUserEditForSupParam;
import cn.smarthse.rho.modules.sys.model.sys.param.SysCompanyUserListParam;
import cn.smarthse.rho.modules.sys.model.sys.param.SysCompanyUserStatueEditByCidListForSupParam;
import cn.smarthse.rho.modules.sys.model.sys.param.SysCompanyUserStatueEditForComParam;
import cn.smarthse.rho.modules.sys.model.sys.param.SysCompanyUserStatueEditForSupParam;
import cn.smarthse.rho.modules.sys.model.sys.param.SysRoleDto;
import cn.smarthse.rho.modules.sys.model.sys.vo.SysUserCompanyListForComVo;
import cn.smarthse.rho.modules.sys.model.sys.vo.SysUserCompanyListForSupVo;
import cn.smarthse.rho.modules.sys.model.sys.vo.SysUserCompanyOneForComVo;
import cn.smarthse.rho.modules.sys.model.sys.vo.SysUserCompanyOneForSupVo;
import cn.smarthse.rho.modules.sys.provider.company.IBCompanyAddressProvider;
import cn.smarthse.rho.modules.sys.provider.sys.ISysUserServiceProvider;
import cn.smarthse.rho.modules.sys.service.b.IBCompanyErrorService;
import cn.smarthse.rho.modules.sys.service.b.IBCompanyPushService;
import cn.smarthse.rho.modules.sys.service.b.IBCompanyService;
import cn.smarthse.rho.modules.sys.service.e.IEMachineRoomCommonService;
import cn.smarthse.rho.modules.sys.service.sys.ISysAreaService;
import cn.smarthse.rho.modules.sys.service.sys.ISysUserRoleService;
import cn.smarthse.rho.modules.sys.service.sys.ISysUserService;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javax.smarthse.framework.exception.ServiceException;
import lombok.Generated;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.beans.factory.annotation.Autowired;

@DubboService
public class SysUserServiceProviderImpl
implements ISysUserServiceProvider {
    private final IBCompanyService companyService;
    private final ISysUserService sysUserService;
    private final ISysUserRoleService sysUserRoleService;
    private final ISysAreaService sysAreaService;
    private final IBCompanyPushService companyPushService;
    private final IEMachineRoomCommonService machineRoomCommonService;
    @Autowired
    private IBCompanyErrorService companyErrorService;
    @DubboReference
    private IBCompanyAddressProvider companyAddressProvider;
    @DubboReference(registry={"public_nacos"})
    private IOrganizationService organizationService;
    @DubboReference(registry={"public_nacos"}, version="1.0.0")
    private ISysAreaProvideService sysAreaProvideService;
    private final SysUserConverter converter;

    public LayuiGridData<SysUserCompanyListForSupVo> getSysCompanyUserListForSup(SysCompanyUserListParam param) {
        return new LayuiGridData(this.sysUserService.getSysCompanyUserListForSup(param), (LayuiGridParam)param);
    }

    public LayuiGridData<SysUserCompanyListForComVo> getSysCompanyUserListForCom(SysCompanyUserListParam param) {
        return new LayuiGridData(this.sysUserService.getSysCompanyUserListForCom(param), (LayuiGridParam)param);
    }

    public SysUserCompanyOneForSupVo getSysUserCompanyByCidForSup(Long cid) {
        SysUserCompanyOneForSupVo rst;
        SysUser sysUser = this.sysUserService.getManagerUserByCid(cid);
        if (sysUser == null) {
            rst = new SysUserCompanyOneForSupVo();
            rst.setCid(cid);
        } else {
            rst = this.converter.entity2SysUserCompanyOneForSupVo(sysUser);
        }
        SysUserCompanyOneForSupVo company = this.companyService.getSysUserCompanyByCidForSup(cid);
        if (Objects.nonNull(company)) {
            Organization organization;
            rst.setHospitalName(company.getHospitalName());
            rst.setBranchName(company.getBranchName());
            rst.setCreditCode(company.getCreditCode());
            rst.setMedicalNucode(company.getMedicalNucode());
            rst.setBelongType(company.getBelongType());
            rst.setSupervisionUnit(company.getSupervisionUnit());
            if (Objects.nonNull(rst.getSupervisionUnit()) && Objects.nonNull(organization = this.organizationService.getOrgById(rst.getSupervisionUnit()))) {
                rst.setSupervisionUnitStr(organization.getName());
            }
            rst.setIsTest(company.getIsTest());
            rst.setBusinessStatus(company.getBusinessStatus());
            rst.setLicenceStatus(company.getLicenceStatus());
            rst.setAddressType(company.getAddressType());
            rst.setCompanyAddressList(this.companyAddressProvider.getAddressVoList(cid));
            rst.setSupervisoryJurisdictionType(company.getSupervisoryJurisdictionType());
            List companyAddressList = rst.getCompanyAddressList();
            if (rst.getAddressType() == 0) {
                if (rst.getSupervisoryJurisdictionType() == 0) {
                    rst.setAreaId(company.getAreaId());
                    rst.setSysArea(this.sysAreaService.getAreaById(rst.getAreaId()));
                    rst.setStatisticsAreaId(rst.getAreaId());
                    rst.setStatisticsSysArea(rst.getSysArea());
                } else if (rst.getSupervisoryJurisdictionType() == 1) {
                    List<CompanyAddressVo> companyAddressList2;
                    if (CollUtil.isNotEmpty((Collection)companyAddressList) && CollUtil.isNotEmpty(companyAddressList2 = companyAddressList.stream().filter(item -> item.getIsMain() == 1).toList())) {
                        rst.setAreaId(companyAddressList2.get(0).getAreaId());
                        rst.setSysArea(this.sysAreaService.getAreaById(rst.getAreaId()));
                    }
                    rst.setStatisticsAreaId(company.getAreaId());
                    rst.setStatisticsSysArea(this.sysAreaService.getAreaById(rst.getStatisticsAreaId()));
                }
            } else if (rst.getAddressType() == 1) {
                List<CompanyAddressVo> companyAddressList2;
                if (CollUtil.isNotEmpty((Collection)companyAddressList) && CollUtil.isNotEmpty(companyAddressList2 = companyAddressList.stream().filter(item -> item.getIsMain() == 1).toList())) {
                    rst.setAreaId(companyAddressList2.get(0).getAreaId());
                    rst.setSysArea(this.sysAreaService.getAreaById(rst.getAreaId()));
                }
                rst.setStatisticsAreaId(company.getAreaId());
                rst.setStatisticsSysArea(this.sysAreaService.getAreaById(rst.getStatisticsAreaId()));
            }
        }
        return rst;
    }

    public SysUserCompanyOneForComVo getSysUserCompanyByUserIdForCom(Long userId) {
        SysUser sysUser = this.sysUserService.getUserById(userId);
        if (sysUser == null) {
            throw new ServiceException("\u7528\u6237\u4e0d\u5b58\u5728\uff01");
        }
        return this.converter.entity2SysUserCompanyOneForComVo(sysUser).setRoleList(this.converter.sysRoleVoList2SysRoleDtoList(this.sysUserRoleService.getRoleListByUserId(userId)));
    }

    public Boolean updateSysCompanyUserEditForSup(SysCompanyUserEditForSupParam param) {
        param.setCreditCode(StrUtil.nullToEmpty((CharSequence)StrUtil.toUpperCase((CharSequence)StrUtil.trim((CharSequence)param.getCreditCode()))));
        if (this.companyService.isHaveThisBranchName(param.getBranchName(), param.getCid()).booleanValue()) {
            throw new ServiceException("\u8be5\u9662\u533a\u540d\u79f0\u5df2\u5b58\u5728");
        }
        LambdaUpdateWrapper wrapper = (LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)Wrappers.lambdaUpdate(BCompany.class).set(BCompany::getName, (Object)param.getBranchName())).set(StrUtil.isNotBlank((CharSequence)param.getCreditCode()), BCompany::getCreditCode, (Object)param.getCreditCode())).set(BCompany::getBelongType, (Object)param.getBelongType())).set(Objects.nonNull(param.getIsTest()), BCompany::getIsTest, (Object)param.getIsTest())).eq(BCompany::getId, (Object)param.getCid());
        SysUserCompanyOneForSupVo company = this.companyService.getSysUserCompanyByCidForSup(param.getCid());
        if (param.getAddressType() == 0) {
            if (param.getSupervisoryJurisdictionType() == 0) {
                if (Objects.isNull(param.getAreaId())) {
                    throw new ServiceException("\u8bf7\u9009\u62e9\u6240\u5728\u884c\u653f\u533a\u5212");
                }
                area = this.sysAreaProvideService.getAreaByIdV3(param.getAreaId());
                if (Objects.isNull(area)) {
                    throw new ServiceException("\u6240\u5728\u884c\u653f\u533a\u5212\u4e0d\u5b58\u5728");
                }
                if (area.getLevel() < 4) {
                    throw new ServiceException("\u6240\u5728\u884c\u653f\u533a\u5212\u9700\u7cbe\u786e\u5230\u4e61\u9547\u8857\u9053");
                }
                dtoArea = this.sysAreaProvideService.getAreaByIdV3(Objects.isNull(company.getAreaId()) ? param.getLoginAreaId() : company.getAreaId());
                this.validateAreaPermission(param.getLoginAreaLevel(), area, dtoArea);
                addressEditParamList = new ArrayList<BCompanyAddressEditParam>();
                BCompanyAddressEditParam addressEditParam = new BCompanyAddressEditParam();
                addressEditParam.setId(company.getCompanyAddressId());
                addressEditParam.setCid(param.getCid());
                addressEditParam.setName(company.getBranchName());
                addressEditParam.setAreaId(param.getAreaId());
                addressEditParam.setAddress(company.getAddress());
                addressEditParam.setIsMain(Integer.valueOf(1));
                addressEditParamList.add(addressEditParam);
                this.companyAddressProvider.saveBatch(addressEditParamList);
                Long areaId = Objects.equals(param.getBelongType(), CompanyBelongTypeEnum.SHI.getValue()) ? area.getCityId() : (Objects.equals(param.getBelongType(), CompanyBelongTypeEnum.SHENG.getValue()) ? area.getProvinceId() : area.getAreaId());
                Organization org = this.organizationService.getOrganizationByAreaId(areaId);
                if (Objects.nonNull(org)) {
                    ((LambdaUpdateWrapper)wrapper.set(BCompany::getSupervisionUnit, (Object)org.getId())).set(BCompany::getSupervisionAreaId, (Object)org.getAreaId());
                }
                ((LambdaUpdateWrapper)((LambdaUpdateWrapper)wrapper.set(BCompany::getAreaId, (Object)param.getAreaId())).set(BCompany::getAddressType, (Object)0)).set(BCompany::getSupervisoryJurisdictionType, (Object)0);
            } else if (param.getSupervisoryJurisdictionType() == 1) {
                if (Objects.isNull(param.getAreaId())) {
                    throw new ServiceException("\u8bf7\u9009\u62e9\u6240\u5728\u884c\u653f\u533a\u5212");
                }
                area = this.sysAreaProvideService.getAreaByIdV3(param.getAreaId());
                if (Objects.isNull(area)) {
                    throw new ServiceException("\u6240\u5728\u884c\u653f\u533a\u5212\u4e0d\u5b58\u5728");
                }
                if (area.getLevel() < 4) {
                    throw new ServiceException("\u6240\u5728\u884c\u653f\u533a\u5212\u9700\u7cbe\u786e\u5230\u4e61\u9547\u8857\u9053");
                }
                dtoArea = this.sysAreaProvideService.getAreaByIdV3(Objects.isNull(company.getAreaId()) ? param.getLoginAreaId() : company.getAreaId());
                this.validateAreaPermission(param.getLoginAreaLevel(), area, dtoArea);
                addressEditParamList = new ArrayList();
                BCompanyAddressEditParam addressEditParam = new BCompanyAddressEditParam();
                addressEditParam.setId(company.getCompanyAddressId());
                addressEditParam.setCid(param.getCid());
                addressEditParam.setName(company.getBranchName());
                addressEditParam.setAreaId(param.getAreaId());
                addressEditParam.setAddress(company.getAddress());
                addressEditParam.setIsMain(Integer.valueOf(1));
                addressEditParamList.add(addressEditParam);
                this.companyAddressProvider.saveBatch(addressEditParamList);
                if (Objects.isNull(param.getStatisticsAreaId())) {
                    throw new ServiceException("\u8bf7\u9009\u62e9\u7edf\u8ba1\u5730\u5740");
                }
                SysAreaV3OneVo area2 = this.sysAreaProvideService.getAreaByIdV3(param.getStatisticsAreaId());
                if (Objects.isNull(area2)) {
                    throw new ServiceException("\u7edf\u8ba1\u5730\u5740\u4e0d\u5b58\u5728");
                }
                if (area2.getLevel() < 4) {
                    throw new ServiceException("\u7edf\u8ba1\u5730\u5740\u9700\u7cbe\u786e\u5230\u4e61\u9547\u8857\u9053");
                }
                Long areaId = Objects.equals(param.getBelongType(), CompanyBelongTypeEnum.SHI.getValue()) ? area2.getCityId() : (Objects.equals(param.getBelongType(), CompanyBelongTypeEnum.SHENG.getValue()) ? area2.getProvinceId() : area2.getAreaId());
                Organization org = this.organizationService.getOrganizationByAreaId(areaId);
                if (Objects.nonNull(org)) {
                    ((LambdaUpdateWrapper)wrapper.set(BCompany::getSupervisionUnit, (Object)org.getId())).set(BCompany::getSupervisionAreaId, (Object)org.getAreaId());
                }
                ((LambdaUpdateWrapper)((LambdaUpdateWrapper)wrapper.set(BCompany::getAreaId, (Object)param.getStatisticsAreaId())).set(BCompany::getAddressType, (Object)0)).set(BCompany::getSupervisoryJurisdictionType, (Object)1);
            }
        } else if (param.getAddressType() == 1) {
            param.setSupervisoryJurisdictionType(Integer.valueOf(1));
            if (Objects.isNull(param.getStatisticsAreaId())) {
                throw new ServiceException("\u8bf7\u9009\u62e9\u7edf\u8ba1\u5730\u5740");
            }
            SysAreaV3OneVo area2 = this.sysAreaProvideService.getAreaByIdV3(param.getStatisticsAreaId());
            if (Objects.isNull(area2)) {
                throw new ServiceException("\u7edf\u8ba1\u5730\u5740\u4e0d\u5b58\u5728");
            }
            if (area2.getLevel() < 4) {
                throw new ServiceException("\u7edf\u8ba1\u5730\u5740\u9700\u7cbe\u786e\u5230\u4e61\u9547\u8857\u9053");
            }
            Long areaId = Objects.equals(param.getBelongType(), CompanyBelongTypeEnum.SHI.getValue()) ? area2.getCityId() : (Objects.equals(param.getBelongType(), CompanyBelongTypeEnum.SHENG.getValue()) ? area2.getProvinceId() : area2.getAreaId());
            Organization org = this.organizationService.getOrganizationByAreaId(areaId);
            if (Objects.nonNull(org)) {
                ((LambdaUpdateWrapper)wrapper.set(BCompany::getSupervisionUnit, (Object)org.getId())).set(BCompany::getSupervisionAreaId, (Object)org.getAreaId());
            }
            ((LambdaUpdateWrapper)((LambdaUpdateWrapper)wrapper.set(BCompany::getAreaId, (Object)param.getStatisticsAreaId())).set(BCompany::getAddressType, (Object)1)).set(BCompany::getSupervisoryJurisdictionType, (Object)1);
            BCompanyAddress address = this.companyAddressProvider.getMainAddress(param.getCid());
            this.machineRoomCommonService.updateMachineRoomAddr(param.getCid(), address.getId());
        } else {
            throw new ServiceException("\u53c2\u6570\u975e\u6cd5");
        }
        boolean b = this.companyService.update((Wrapper)wrapper);
        if (b) {
            this.companyErrorService.manualMaintenanceOne(param.getCid());
            BCompany bCompany = (BCompany)this.companyService.getById(param.getCid());
            if (!(!Objects.nonNull(bCompany) || Objects.equals(param.getBranchName(), bCompany.getName()) && Objects.equals(param.getCreditCode(), bCompany.getCreditCode()) && Objects.equals(param.getAreaId(), bCompany.getAreaId()))) {
                BCompanyPushParam pushParam = new BCompanyPushParam();
                pushParam.setCompany(bCompany);
                pushParam.setOptType(String.valueOf(2));
                pushParam.setOptReason("\u5b57\u6bb5\u53d8\u66f4");
                this.companyPushService.addPushData(pushParam);
            }
        }
        if (StrUtil.isNotBlank((CharSequence)param.getUsername()) && Objects.nonNull(param.getId())) {
            if (!this.sysUserService.checkUsername(param.getUsername(), param.getId())) {
                throw new ServiceException("\u7528\u6237\u540d\u5df2\u5b58\u5728\uff01");
            }
            SysUser user = new SysUser();
            user.setId(param.getId());
            user.setUsername(param.getUsername());
            user.setUpdateBy(param.getLoginUserId());
            user.setUpdateDate(LocalDateTime.now());
            this.sysUserService.updateById(user);
        }
        return b;
    }

    private void validateAreaPermission(Integer loginAreaLevel, SysAreaV3OneVo area, SysAreaV3OneVo area2) {
        if (Objects.isNull(loginAreaLevel)) {
            return;
        }
        switch (loginAreaLevel) {
            case 0: {
                break;
            }
            case 1: {
                if (Objects.equals(area.getProvinceId(), area2.getProvinceId())) break;
                throw new ServiceException("\u53ea\u80fd\u4fee\u6539\u672c\u7701\u53ca\u4ee5\u4e0b\u7684\u533a\u57df");
            }
            case 2: {
                if (Objects.equals(area.getCityId(), area2.getCityId())) break;
                throw new ServiceException("\u53ea\u80fd\u4fee\u6539\u672c\u5e02\u53ca\u4ee5\u4e0b\u7684\u533a\u57df");
            }
            case 3: {
                if (Objects.equals(area.getAreaId(), area2.getAreaId())) break;
                throw new ServiceException("\u53ea\u80fd\u4fee\u6539\u672c\u533a\u53bf\u53ca\u4ee5\u4e0b\u7684\u533a\u57df");
            }
            case 4: {
                if (Objects.equals(area.getStreetId(), area2.getStreetId())) break;
                throw new ServiceException("\u53ea\u80fd\u4fee\u6539\u8857\u9053\u7ea7\u522b\u7684\u533a\u57df");
            }
        }
    }

    public Boolean updateSysCompanyUserEditForCom(SysCompanyUserEditForComParam param) {
        SysUser user = this.sysUserService.getUserById(param.getId());
        if (user == null) {
            throw new ServiceException("\u8be5\u7528\u6237\u5df2\u7ecf\u4e0d\u5b58\u5728");
        }
        long[] list = StrUtil.splitToLong((CharSequence)user.getRoleIds(), (CharSequence)",");
        if (Arrays.stream(list).anyMatch(id -> id == RhoUserRolesEnum.RHO_COMPANY_SUPER_ADMIN.getRoleId()) && !Arrays.equals(list, param.getRoleList().stream().mapToLong(SysRoleDto::getRoleId).toArray())) {
            throw new ServiceException("\u62e5\u6709\u7ba1\u7406\u5458\u89d2\u8272\u7528\u6237\u4e0d\u53ef\u4fee\u6539\u89d2\u8272");
        }
        return this.sysUserService.updateSysCompanyUserEditForCom(param);
    }

    public Boolean updateSysCompanyUserStatueForSup(SysCompanyUserStatueEditForSupParam param) {
        return this.sysUserService.updateSysCompanyUserStatueForSup(param);
    }

    public Boolean updateSysCompanyUserExcludeSingleUserStatueByCidListForSup(SysCompanyUserStatueEditByCidListForSupParam param) {
        if (param.getIsForbidden() == 0) {
            List companyList = this.companyService.list((Wrapper)new LambdaQueryWrapper().in(BCompany::getId, (Collection)param.getIdList()));
            for (BCompany company : companyList) {
                if (BusinessStatusEnum.CLOSE.getValue().equals(company.getBusinessStatus())) {
                    throw new ServiceException("\u8425\u4e1a\u72b6\u6001\u5df2\u5173\u95ed\uff0c\u8d26\u53f7\u65e0\u6cd5\u542f\u7528");
                }
                if (!CompanyLicenceStatusEnum.CLOSE.getValue().equals(company.getLicenceStatus())) continue;
                throw new ServiceException("\u8bb8\u53ef\u8bc1\u5df2\u6ce8\u9500\uff0c\u8d26\u53f7\u65e0\u6cd5\u542f\u7528");
            }
        }
        for (Long id : param.getIdList()) {
            SysCompanyUserStatueEditForSupParam dto = new SysCompanyUserStatueEditForSupParam();
            dto.setId(id);
            dto.setIsForbidden(param.getIsForbidden());
            dto.setLoginUserId(param.getLoginUserId());
            dto.setLoginUsername(param.getLoginUsername());
            this.sysUserService.updateSysCompanyUserStatueForSup(dto);
        }
        return true;
    }

    public Boolean updateSysCompanyUserStatueForCom(SysCompanyUserStatueEditForComParam param) {
        SysUser user = this.sysUserService.getUserById(param.getUserId());
        if (user == null) {
            throw new ServiceException("\u8be5\u7528\u6237\u5df2\u7ecf\u4e0d\u5b58\u5728");
        }
        long[] list = StrUtil.splitToLong((CharSequence)user.getRoleIds(), (CharSequence)",");
        if (Arrays.stream(list).anyMatch(id -> id == RhoUserRolesEnum.RHO_COMPANY_SUPER_ADMIN.getRoleId())) {
            throw new ServiceException("\u62e5\u6709\u7ba1\u7406\u5458\u89d2\u8272\u7528\u6237\u4e0d\u53ef\u7981\u7528\u6216\u542f\u7528");
        }
        return this.sysUserService.updateSysCompanyUserStatueForCom(param);
    }

    public Boolean resetPasswordForSup(IdParam param) {
        return this.sysUserService.resetPassword(param);
    }

    public Boolean resetPasswordForCom(IdParam param) {
        SysUser user = this.sysUserService.getUserById(param.getId());
        if (user == null) {
            throw new ServiceException("\u8be5\u7528\u6237\u5df2\u7ecf\u4e0d\u5b58\u5728");
        }
        long[] list = StrUtil.splitToLong((CharSequence)user.getRoleIds(), (CharSequence)",");
        if (Arrays.stream(list).anyMatch(id -> id == RhoUserRolesEnum.RHO_COMPANY_SUPER_ADMIN.getRoleId())) {
            throw new ServiceException("\u62e5\u6709\u7ba1\u7406\u5458\u89d2\u8272\u7528\u6237\u4e0d\u53ef\u91cd\u7f6e\u5bc6\u7801");
        }
        return this.sysUserService.resetPassword(param);
    }

    public SysUser getUserById(Long userId) {
        return this.sysUserService.getUserById(userId);
    }

    public List<SysUser> getUserListByCid(Long cid) {
        return this.sysUserService.getUserListByCid(cid);
    }

    public SysUser getManagerUserByCid(Long cid) {
        return this.sysUserService.getManagerUserByCid(cid);
    }

    public SysUser getUserByUsername(String username) {
        return this.sysUserService.getUserByUsername(username);
    }

    public void changePassword(Long userId, String oldPassword, String newPassword) {
        this.sysUserService.changePassword(userId, oldPassword, newPassword);
    }

    public SysUser addUserForSuperCas(Long cid, String username, String nickname, Long roleId) {
        return this.sysUserService.addUserForSuperCas(cid, username, nickname, roleId);
    }

    public Boolean addUserForSup(SysCompanyUserCreateEditParam param) {
        return this.sysUserService.addUserForSup(param);
    }

    public Boolean addUserByCidListForSup(IdsParam param) {
        return this.sysUserService.addUserByCidListForSup(param);
    }

    public Boolean addUserForCom(SysCompanyUserAddForComParam param) {
        return this.sysUserService.addUserForCom(param);
    }

    public Boolean deleteSysCompanyUserByCidListForSup(IdsParam param) {
        return this.sysUserService.delUserExcludeSingleUserByCidList(param);
    }

    public Boolean deleteSysCompanyUserAndCompanyByCidListForSup(IdsParam param) {
        this.sysUserService.delUserByCidList(param.getIdList(), param.getLoginUserId());
        this.companyService.delByCidList(param.getIdList(), param.getLoginUserId());
        this.companyErrorService.manualMaintenanceList(param.getIdList());
        return Boolean.TRUE;
    }

    public Boolean deleteSysCompanyUserByUserIdForCom(IdParam param) {
        return this.sysUserService.delUserByUserId(param.getId(), param.getLoginUserId());
    }

    public void updatePassStateThreeMonth() {
        this.sysUserService.updatePassStateThreeMonth();
    }

    public void modifyPasswordByPhone(Long userId, String newPassword) {
        this.sysUserService.modifyPasswordByPhone(userId, newPassword);
    }

    @Generated
    public SysUserServiceProviderImpl(IBCompanyService companyService, ISysUserService sysUserService, ISysUserRoleService sysUserRoleService, ISysAreaService sysAreaService, IBCompanyPushService companyPushService, IEMachineRoomCommonService machineRoomCommonService, SysUserConverter converter) {
        this.companyService = companyService;
        this.sysUserService = sysUserService;
        this.sysUserRoleService = sysUserRoleService;
        this.sysAreaService = sysAreaService;
        this.companyPushService = companyPushService;
        this.machineRoomCommonService = machineRoomCommonService;
        this.converter = converter;
    }
}

