/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.rho.modules.sys.provider.sys;

import cn.smarthse.framework.oss.bean.OssClientBean;
import cn.smarthse.rho.core.framework.utils.StringUtils;
import cn.smarthse.rho.modules.sys.converter.sys.SysConverter;
import cn.smarthse.rho.modules.sys.entity.sys.SysFile;
import cn.smarthse.rho.modules.sys.model.sys.vo.SysFileVo;
import cn.smarthse.rho.modules.sys.provider.sys.ISysFileProvider;
import cn.smarthse.rho.modules.sys.service.sys.ISysFileService;
import java.util.List;
import lombok.Generated;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.transaction.annotation.Transactional;

@DubboService
public class SysFileProvideImpl
implements ISysFileProvider {
    private final ISysFileService sysFileService;
    private final OssClientBean ossClientBean;
    private final SysConverter converter;

    public SysFileVo getFileById(Long fileId) {
        if (fileId == null) {
            return null;
        }
        SysFile sysFile = (SysFile)this.sysFileService.getById(fileId);
        if (sysFile == null) {
            return null;
        }
        sysFile.setFullOssUrl(this.ossClientBean.getUrl(sysFile.getOssUrl()));
        return this.converter.sysFile2SysFileVo(sysFile);
    }

    public List<SysFileVo> getFileVoByIds(String ids) {
        return this.sysFileService.getFileVoByIds(ids);
    }

    public SysFileVo getFileByHash(String fileHash) {
        if (StringUtils.isEmpty((CharSequence)fileHash)) {
            return null;
        }
        SysFile sysFile = this.sysFileService.getByHash(fileHash);
        if (sysFile == null) {
            return null;
        }
        sysFile.setFullOssUrl(this.ossClientBean.getUrl(sysFile.getOssUrl()));
        return this.converter.sysFile2SysFileVo(sysFile);
    }

    public String getFileUrl(Long fileId) {
        if (fileId == null) {
            return null;
        }
        SysFileVo sysFileVo = this.getFileById(fileId);
        return sysFileVo == null ? null : sysFileVo.getFullOssUrl();
    }

    @Transactional
    public SysFileVo addSysFile(SysFile sysFile, Long adminId) {
        sysFile.setCreateBy(adminId);
        this.sysFileService.save(sysFile);
        sysFile.setFullOssUrl(this.ossClientBean.getUrl(sysFile.getOssUrl()));
        return this.converter.sysFile2SysFileVo(sysFile);
    }

    @Generated
    public SysFileProvideImpl(ISysFileService sysFileService, OssClientBean ossClientBean, SysConverter converter) {
        this.sysFileService = sysFileService;
        this.ossClientBean = ossClientBean;
        this.converter = converter;
    }
}

