/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.rho.modules.sys.provider.sys;

import cn.smarthse.rho.modules.sys.converter.sys.SysConverter;
import cn.smarthse.rho.modules.sys.model.sys.vo.SysAreaTreeVo;
import cn.smarthse.rho.modules.sys.model.sys.vo.SysAreaVo;
import cn.smarthse.rho.modules.sys.model.sys.vo.SysAreaVo2;
import cn.smarthse.rho.modules.sys.provider.sys.ISysAreaProvider;
import cn.smarthse.rho.modules.sys.service.sys.ISysAreaService;
import cn.smarthse.rho.modules.sys.utils.AreaUtils;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.dubbo.config.annotation.DubboService;

@DubboService
public class SysAreaProviderImpl
implements ISysAreaProvider {
    private final ISysAreaService sysAreaService;
    private final SysConverter sysConverter;

    public SysAreaVo getAreaById(Long areaId) {
        return this.sysAreaService.getAreaById(areaId);
    }

    public SysAreaVo2 getAreaByIdV2(Long areaId) {
        SysAreaVo area = this.sysAreaService.getAreaById(areaId);
        SysAreaVo2 result = this.sysConverter.sysAreaVo2SysAreaVo2(area);
        if (result != null) {
            result.setProvinceList(this.sysAreaService.getAreaList(0L));
            if (area.getLevel() >= 2) {
                result.setCityList(this.sysAreaService.getAreaList(area.getProvinceId()));
            }
            if (area.getLevel() >= 3) {
                result.setAreaList(this.sysAreaService.getAreaList(area.getCityId()));
            }
            if (area.getLevel() >= 4) {
                result.setStreetList(this.sysAreaService.getAreaList(area.getAreaId()));
            }
        }
        return result;
    }

    public String getAreaNameById(Long areaId) {
        return this.sysAreaService.getAreaNameById(areaId);
    }

    public List<SysAreaVo> getAreaList(Long pid) {
        return this.sysAreaService.getAreaList(pid);
    }

    public List<SysAreaTreeVo> getAreaTreeList(Long pid) {
        return this.sysAreaService.getAreaTreeList(pid);
    }

    public String getAreaAddress(Long areaId, String linkCode) {
        return this.sysAreaService.getAreaAddress(areaId, linkCode);
    }

    public String getAreaAddress(Long areaId) {
        return this.sysAreaService.getAreaAddress(areaId);
    }

    public Map<String, Long> getByAreaAddress(List<String> areaAddressList) {
        return this.sysAreaService.getByAreaAddress(areaAddressList);
    }

    public Long getByAreaAddress(String areaAddress) {
        return this.sysAreaService.getByAreaAddress(areaAddress);
    }

    public Integer getLevel(Long areaId) {
        return this.sysAreaService.getLevel(areaId);
    }

    public boolean hasPermission(Long childAreaId, Long parentId) {
        return this.sysAreaService.hasPermission(childAreaId, parentId);
    }

    public SysAreaVo analysisAreaPermissions(Long loginUserAreaId, Long paramAreaId) {
        SysAreaVo loginUserArea = this.getAreaById(loginUserAreaId);
        SysAreaVo paramArea = this.getAreaById(paramAreaId);
        return AreaUtils.analysisAreaPermissions((SysAreaVo)loginUserArea, (SysAreaVo)paramArea);
    }

    public List<SysAreaVo> getSubAreaByIdAndLevel(Long areaId) {
        return this.sysAreaService.getSubAreaByIdAndLevel(areaId, this.getLevel(areaId));
    }

    @Generated
    public SysAreaProviderImpl(ISysAreaService sysAreaService, SysConverter sysConverter) {
        this.sysAreaService = sysAreaService;
        this.sysConverter = sysConverter;
    }
}

