/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.rho.modules.sys.provider.sys;

import cn.smarthse.rho.core.framework.mybatis.SysChangeLog;
import cn.smarthse.rho.modules.sys.enums.sys.SysChangeLogEnum;
import cn.smarthse.rho.modules.sys.model.g.param.GEquipmentSelfCheckLogListParam;
import cn.smarthse.rho.modules.sys.model.g.param.GSafetyDeviceSelfCheckLogListParam;
import cn.smarthse.rho.modules.sys.model.g.vo.GEquipmentSelfCheckLogListVo;
import cn.smarthse.rho.modules.sys.model.g.vo.GSafetyDeviceSelfCheckLogListVo;
import cn.smarthse.rho.modules.sys.provider.sys.ISysChangeLogProvider;
import cn.smarthse.rho.modules.sys.service.sys.ISysChangeLogService;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.dubbo.config.annotation.DubboService;

@DubboService
public class ISysChangeLogProviderImpl
implements ISysChangeLogProvider {
    private final ISysChangeLogService sysChangeLogService;

    public List<GEquipmentSelfCheckLogListVo> getEquipmentSelfCheckLog(GEquipmentSelfCheckLogListParam param) {
        List<SysChangeLog> list = this.sysChangeLogService.getChangeLogList(param.getId(), "g_equipment_self_check");
        if (list == null) {
            return null;
        }
        Map<Long, List<SysChangeLog>> map = list.stream().collect(Collectors.groupingBy(SysChangeLog::getBatchCode));
        List<Object> voList = new ArrayList<GEquipmentSelfCheckLogListVo>();
        for (Map.Entry<Long, List<SysChangeLog>> entry : map.entrySet()) {
            List<SysChangeLog> logs = entry.getValue();
            SysChangeLog first = logs.get(0);
            GEquipmentSelfCheckLogListVo vo = new GEquipmentSelfCheckLogListVo();
            vo.setOprator(first.getUsername());
            vo.setOperationTime(first.getEditTime());
            if ("insert".equals(first.getOperation())) {
                vo.setOperationTypeStr("\u65b0\u589e");
                voList.add(vo);
                continue;
            }
            ArrayList<String> strList = new ArrayList<String>();
            for (SysChangeLog log : logs) {
                String str = SysChangeLogEnum.getValueByTableAndField((String)log.getTableName(), (String)log.getFieldValue());
                if (!StringUtils.isNotBlank((CharSequence)str)) continue;
                strList.add(str);
            }
            vo.setOperationTypeStr(String.join((CharSequence)"\u3001", strList));
            voList.add(vo);
        }
        if (voList != null) {
            voList = voList.stream().sorted(Comparator.comparing(GEquipmentSelfCheckLogListVo::getOperationTime).reversed()).collect(Collectors.toList());
        }
        return voList;
    }

    public List<GSafetyDeviceSelfCheckLogListVo> getSafetyDeviceSelfCheckLog(GSafetyDeviceSelfCheckLogListParam param) {
        List<SysChangeLog> list = this.sysChangeLogService.getChangeLogList(param.getId(), "g_safety_device_self_check");
        if (list == null) {
            return null;
        }
        Map<Long, List<SysChangeLog>> map = list.stream().collect(Collectors.groupingBy(SysChangeLog::getBatchCode));
        List<Object> voList = new ArrayList<GSafetyDeviceSelfCheckLogListVo>();
        for (Map.Entry<Long, List<SysChangeLog>> entry : map.entrySet()) {
            List<SysChangeLog> logs = entry.getValue();
            SysChangeLog first = logs.get(0);
            GSafetyDeviceSelfCheckLogListVo vo = new GSafetyDeviceSelfCheckLogListVo();
            vo.setOprator(first.getUsername());
            vo.setOperationTime(first.getEditTime());
            if ("insert".equals(first.getOperation())) {
                vo.setOperationTypeStr("\u65b0\u589e");
                voList.add(vo);
                continue;
            }
            ArrayList<String> strList = new ArrayList<String>();
            for (SysChangeLog log : logs) {
                String str = SysChangeLogEnum.getValueByTableAndField((String)log.getTableName(), (String)log.getFieldValue());
                if (!StringUtils.isNotBlank((CharSequence)str)) continue;
                strList.add(str);
            }
            vo.setOperationTypeStr(String.join((CharSequence)"\u3001", strList));
            voList.add(vo);
        }
        if (voList != null) {
            voList = voList.stream().sorted(Comparator.comparing(GSafetyDeviceSelfCheckLogListVo::getOperationTime).reversed()).collect(Collectors.toList());
        }
        return voList;
    }

    public void addOneSelfCheckInsertLog(SysChangeLog log) {
        this.sysChangeLogService.addOneSelfCheckInsertLog(log);
    }

    @Generated
    public ISysChangeLogProviderImpl(ISysChangeLogService sysChangeLogService) {
        this.sysChangeLogService = sysChangeLogService;
    }
}

