/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.rho.modules.sys.provider.risk;

import cn.hutool.core.lang.Pair;
import cn.smarthse.rho.core.framework.model.LayuiGridData;
import cn.smarthse.rho.modules.sys.converter.RRiskBasicConverter;
import cn.smarthse.rho.modules.sys.converter.r.RiskAcceptanceRecordHistoryConverter;
import cn.smarthse.rho.modules.sys.dao.risk.RiskBasicCommonMapper;
import cn.smarthse.rho.modules.sys.entity.b.BCompany;
import cn.smarthse.rho.modules.sys.entity.r.RRiskAcceptanceRecord;
import cn.smarthse.rho.modules.sys.entity.r.RRiskBasic;
import cn.smarthse.rho.modules.sys.entity.r.RRiskBasicSource;
import cn.smarthse.rho.modules.sys.enums.risk.BasicRiskStatusEnum;
import cn.smarthse.rho.modules.sys.enums.risk.RiskAcceptanceWayEnum;
import cn.smarthse.rho.modules.sys.enums.risk.RiskTypeEnum;
import cn.smarthse.rho.modules.sys.enums.risk.RiskUnresolvedTypeEnum;
import cn.smarthse.rho.modules.sys.enums.risk.RiskWarningStatusEnum;
import cn.smarthse.rho.modules.sys.enums.risk.SourceRiskStatusEnum;
import cn.smarthse.rho.modules.sys.model.c.param.CheckOrgChooseQueryParam;
import cn.smarthse.rho.modules.sys.model.c.vo.ThirdOrgVo;
import cn.smarthse.rho.modules.sys.model.r.param.AddRiskForCommonParam;
import cn.smarthse.rho.modules.sys.model.r.param.ResolveRiskForCommonParam;
import cn.smarthse.rho.modules.sys.model.r.param.RiskMangerGenParam;
import cn.smarthse.rho.modules.sys.model.r.param.RiskQueryCommonParam;
import cn.smarthse.rho.modules.sys.model.r.param.SearchRiskParam;
import cn.smarthse.rho.modules.sys.model.r.vo.RiskAcceptanceCommonVo;
import cn.smarthse.rho.modules.sys.model.r.vo.RiskAcceptanceHistoryVo;
import cn.smarthse.rho.modules.sys.provider.risk.IRiskProvider;
import cn.smarthse.rho.modules.sys.service.b.IBCompanyService;
import cn.smarthse.rho.modules.sys.service.c.ICTrainingCertService;
import cn.smarthse.rho.modules.sys.service.risk.IRiskAcceptanceRecordCommonService;
import cn.smarthse.rho.modules.sys.service.risk.IRiskAcceptanceRecordHistoryCommonService;
import cn.smarthse.rho.modules.sys.service.risk.IRiskBasicCommonService;
import cn.smarthse.rho.modules.sys.service.risk.IRiskBasicSourceCommonService;
import cn.smarthse.rho.modules.sys.service.risk.IRiskBasicSourceHistoryCommonService;
import cn.smarthse.rho.modules.sys.utils.risk.RiskDateUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
@DubboService
@Transactional(readOnly=true)
public class RiskProviderImpl
implements IRiskProvider {
    private final RRiskBasicConverter rRiskBasicConverter;
    private final RiskAcceptanceRecordHistoryConverter riskAcceptanceRecordHistoryConverter;
    private final IRiskBasicCommonService riskBasicService;
    private final IRiskBasicSourceCommonService riskSourceService;
    private final IRiskAcceptanceRecordCommonService acceptanceRecordCommonService;
    private final IRiskAcceptanceRecordHistoryCommonService acceptanceRecordHistoryCommonService;
    private final RiskBasicCommonMapper riskBasicCommonMapper;
    private final IRiskBasicSourceHistoryCommonService sourceHistoryCommonService;
    private final IBCompanyService companyService;
    private final ICTrainingCertService trainingCertService;
    private static final List<Integer> EIGHT_RISK_TYPE = Arrays.asList(101, 102, 103, 104, 105, 106, 108, 109);
    private static final List<Integer> SIX_EXCEPTION_TYPE = Arrays.asList(102001, 103001, 104004, 104005, 104006, 105002);
    private static final List<Integer> NO_NEED_ACCEPT_TYPE = Arrays.asList(106, 108, 109);

    @Transactional
    public void genRiskOfCommon(List<AddRiskForCommonParam> paramList) {
        if (!CollectionUtils.isEmpty(paramList)) {
            Map<Integer, List<AddRiskForCommonParam>> typeMap = paramList.stream().collect(Collectors.groupingBy(AddRiskForCommonParam::getType));
            typeMap.forEach((type, list) -> {
                this.determineBasicRisk((List<AddRiskForCommonParam>)list, (Integer)type);
                this.determineSourceRisk((List<AddRiskForCommonParam>)list, (Integer)type);
            });
        }
    }

    @Transactional
    public void determineBasicRisk(List<AddRiskForCommonParam> paramRiskBasicList, Integer riskType) {
        RRiskBasic riskBasic = new RRiskBasic();
        ArrayList<RRiskBasic> addBasicList = new ArrayList<RRiskBasic>();
        HashSet<Pair> addedBasicSet = new HashSet<Pair>();
        List<Long> paramCidList = paramRiskBasicList.stream().map(AddRiskForCommonParam::getCid).distinct().collect(Collectors.toList());
        List<RRiskBasic> dbBasicList = this.riskBasicCommonMapper.listRiskBasicByCid(paramCidList, riskType, LocalDate.now().getYear());
        if (CollectionUtils.isEmpty(dbBasicList)) {
            for (AddRiskForCommonParam riskParam : paramRiskBasicList) {
                boolean anyMatch = addedBasicSet.contains(Pair.of((Object)riskParam.getCid(), (Object)riskParam.getType()));
                if (anyMatch) continue;
                riskBasic = new RRiskBasic();
                riskBasic.setId(Long.valueOf(IdWorker.getId()));
                riskBasic.setCid(riskParam.getCid());
                riskBasic.setYear(Integer.valueOf(LocalDate.now().getYear()));
                riskBasic.setName(this.handleBasicRiskName(riskParam));
                riskBasic.setType(riskParam.getType());
                riskBasic.setCategory(Integer.valueOf(EIGHT_RISK_TYPE.contains(riskType) ? 1 : 2));
                riskBasic.setStatus(BasicRiskStatusEnum.UNRESOLVED.getValue());
                riskBasic.setUnresolvedType(RiskUnresolvedTypeEnum.UN_RECTIFY.getValue());
                riskBasic.setWarningStatus(RiskWarningStatusEnum.NONE.getValue());
                if (Objects.equals(riskParam.getType(), RiskTypeEnum.TRAINING.getValue())) {
                    if (riskParam.getCetStatus() != null && riskParam.getCetStatus() == 3) {
                        riskBasic.setUnresolvedType(RiskUnresolvedTypeEnum.UN_ACCEPT.getValue());
                    } else {
                        riskBasic.setUnresolvedType(RiskUnresolvedTypeEnum.UN_RECTIFY.getValue());
                    }
                }
                addedBasicSet.add(Pair.of((Object)riskParam.getCid(), (Object)riskParam.getType()));
                addBasicList.add(riskBasic);
            }
            this.riskBasicService.saveBatch(addBasicList);
            return;
        }
        Set dbRiskSet = dbBasicList.stream().map(risk -> Pair.of((Object)risk.getCid(), (Object)risk.getType())).collect(Collectors.toSet());
        for (AddRiskForCommonParam riskBasicParam : paramRiskBasicList) {
            boolean isExistInDb = dbRiskSet.contains(Pair.of((Object)riskBasicParam.getCid(), (Object)riskBasicParam.getType()));
            boolean isExistInAddedSet = addedBasicSet.contains(Pair.of((Object)riskBasicParam.getCid(), (Object)riskBasicParam.getType()));
            if (isExistInDb) {
                this.riskBasicCommonMapper.updateRiskBasicForGenBasic(riskBasicParam.getCid(), riskType, LocalDate.now().getYear());
            }
            if (isExistInDb || isExistInAddedSet) continue;
            riskBasic = new RRiskBasic();
            riskBasic.setId(Long.valueOf(IdWorker.getId()));
            riskBasic.setCid(riskBasicParam.getCid());
            riskBasic.setYear(Integer.valueOf(LocalDate.now().getYear()));
            riskBasic.setName(this.handleBasicRiskName(riskBasicParam));
            riskBasic.setType(riskBasicParam.getType());
            riskBasic.setCategory(Integer.valueOf(EIGHT_RISK_TYPE.contains(riskType) ? 1 : 2));
            riskBasic.setStatus(BasicRiskStatusEnum.UNRESOLVED.getValue());
            riskBasic.setUnresolvedType(RiskUnresolvedTypeEnum.UN_RECTIFY.getValue());
            riskBasic.setWarningStatus(RiskWarningStatusEnum.NONE.getValue());
            if (Objects.equals(riskBasicParam.getType(), RiskTypeEnum.TRAINING.getValue())) {
                if (riskBasicParam.getCetStatus() != null && riskBasicParam.getCetStatus() == 3) {
                    riskBasic.setUnresolvedType(RiskUnresolvedTypeEnum.UN_ACCEPT.getValue());
                } else {
                    riskBasic.setUnresolvedType(RiskUnresolvedTypeEnum.UN_RECTIFY.getValue());
                }
            }
            addedBasicSet.add(Pair.of((Object)riskBasicParam.getCid(), (Object)riskBasicParam.getType()));
            addBasicList.add(riskBasic);
        }
        this.riskBasicService.saveBatch(addBasicList);
    }

    @Transactional
    public void determineSourceRisk(List<AddRiskForCommonParam> paramRiskBasicList, Integer riskType) {
        ArrayList<RRiskBasicSource> addSourceList = new ArrayList<RRiskBasicSource>();
        RRiskBasicSource addSource = new RRiskBasicSource();
        ArrayList<RRiskAcceptanceRecord> addAcceptanceRecordList = new ArrayList<RRiskAcceptanceRecord>();
        ArrayList<RRiskBasicSource> updateSourceList = new ArrayList<RRiskBasicSource>();
        ArrayList<RRiskBasicSource> sourceHistoryList = new ArrayList<RRiskBasicSource>();
        for (AddRiskForCommonParam riskBasicParam : paramRiskBasicList) {
            RRiskBasicSource updateSource;
            RRiskBasicSource dbSource = this.searchSourceWithRiskType(riskType, riskBasicParam);
            LocalDate calStartTime = riskBasicParam.getStartTime();
            if (Objects.equals(riskType, RiskTypeEnum.PHYSICAL_EXAMINATION.getValue()) && riskBasicParam.getIsGenerateByData() == 0 && riskBasicParam.getHealthSpecialWarning() == 1) {
                calStartTime = riskBasicParam.getPostStartTime();
            }
            if (dbSource == null) {
                RRiskBasic basic = this.riskBasicCommonMapper.searchBasicForSource(riskBasicParam.getCid(), riskBasicParam.getType(), LocalDate.now().getYear());
                addSource = this.rRiskBasicConverter.commonAddParam2SourceEntity(riskBasicParam);
                addSource.setId(Long.valueOf(IdWorker.getId()));
                addSource.setRiskId(basic.getId());
                addSource.setCategory(Integer.valueOf(EIGHT_RISK_TYPE.contains(riskType) ? 1 : 2));
                addSource.setYear(Integer.valueOf(LocalDate.now().getYear()));
                addSource.setFindTime(LocalDateTime.now());
                addSource.setName(this.handleSourceRiskName(riskBasicParam));
                addSource.setRequireFinishTime(RiskDateUtil.calRequireFinishTime((LocalDate)calStartTime, (Integer)riskType, (Integer)riskBasicParam.getIsGenerateByData(), (Integer)riskBasicParam.getHealthSpecialWarning()));
                addSource.setStatus(SourceRiskStatusEnum.UN_RESOLVED.getValue());
                addSource.setUnresolvedType(RiskUnresolvedTypeEnum.UN_RECTIFY.getValue());
                addSource.setBusinessStartDate(riskBasicParam.getStartTime());
                if (riskBasicParam.getIsGenerateByData() == 1) {
                    addSource.setWarningStatus(RiskWarningStatusEnum.NONE.getValue());
                }
                if (riskBasicParam.getIsGenerateByData() == 0 || Objects.equals(riskBasicParam.getType(), RiskTypeEnum.DOSE_MONITORING.getValue()) || Objects.equals(riskBasicParam.getType(), RiskTypeEnum.PHYSICAL_EXCEPTION_OCC.getValue()) || Objects.equals(riskBasicParam.getType(), RiskTypeEnum.PHYSICAL_EXCEPTION_CONTRAINDICATION.getValue()) || Objects.equals(riskBasicParam.getType(), RiskTypeEnum.PHYSICAL_EXCEPTION_REVIEW.getValue()) || Objects.equals(riskBasicParam.getType(), RiskTypeEnum.DOSE_EXCEPTION_OVERDOSE.getValue())) {
                    addSource.setWarningStatus(RiskWarningStatusEnum.RED.getValue());
                }
                if (riskBasicParam.getIsGenerateByData() == 0 && Objects.equals(riskBasicParam.getType(), RiskTypeEnum.PHYSICAL_EXAMINATION.getValue()) && riskBasicParam.getHealthSpecialWarning() == 1) {
                    addSource.setWarningStatus(RiskWarningStatusEnum.FIRST.getValue());
                }
                if (Objects.equals(riskBasicParam.getType(), RiskTypeEnum.EXCEPTION_PERFORMANCE_TEST.getValue()) || Objects.equals(riskBasicParam.getType(), RiskTypeEnum.EXCEPTION_PLACE_TEST.getValue())) {
                    addSource.setWarningStatus(RiskWarningStatusEnum.YELLOW.getValue());
                }
                if (Objects.equals(riskBasicParam.getType(), RiskTypeEnum.TRAINING.getValue())) {
                    if (riskBasicParam.getCetStatus() != null && riskBasicParam.getCetStatus() == 3) {
                        addSource.setUnresolvedType(RiskUnresolvedTypeEnum.UN_ACCEPT.getValue());
                    } else {
                        addSource.setUnresolvedType(RiskUnresolvedTypeEnum.UN_RECTIFY.getValue());
                    }
                }
                addSourceList.add(addSource);
                continue;
            }
            if (dbSource.getStatus() == SourceRiskStatusEnum.RESOLVED.getValue()) {
                sourceHistoryList.add(dbSource);
                updateSource = this.rRiskBasicConverter.commonAddParam2SourceEntity(riskBasicParam);
                updateSource.setId(dbSource.getId());
                updateSource.setName(this.handleSourceRiskName(riskBasicParam));
                updateSource.setYear(Integer.valueOf(LocalDate.now().getYear()));
                updateSource.setFindTime(LocalDateTime.now());
                updateSource.setRequireFinishTime(RiskDateUtil.calRequireFinishTime((LocalDate)calStartTime, (Integer)riskType, (Integer)riskBasicParam.getIsGenerateByData(), (Integer)riskBasicParam.getHealthSpecialWarning()));
                updateSource.setStatus(SourceRiskStatusEnum.UN_RESOLVED.getValue());
                updateSource.setUnresolvedType(RiskUnresolvedTypeEnum.UN_RECTIFY.getValue());
                updateSource.setWarningStatus(RiskWarningStatusEnum.NONE.getValue());
                updateSource.setBusinessStartDate(riskBasicParam.getStartTime());
                if (riskBasicParam.getIsGenerateByData() == 0 && Objects.equals(riskBasicParam.getType(), RiskTypeEnum.PHYSICAL_EXAMINATION.getValue()) && riskBasicParam.getHealthSpecialWarning() == 1) {
                    updateSource.setWarningStatus(RiskWarningStatusEnum.FIRST.getValue());
                }
                updateSourceList.add(updateSource);
                continue;
            }
            if (dbSource.getStatus() != SourceRiskStatusEnum.UN_RESOLVED.getValue() || dbSource.getIsGenerateByData() != 0 || riskBasicParam.getIsGenerateByData() != 1) continue;
            sourceHistoryList.add(dbSource);
            updateSource = this.rRiskBasicConverter.commonAddParam2SourceEntity(riskBasicParam);
            updateSource.setId(dbSource.getId());
            updateSource.setName(this.handleSourceRiskName(riskBasicParam));
            updateSource.setYear(Integer.valueOf(LocalDate.now().getYear()));
            updateSource.setFindTime(LocalDateTime.now());
            updateSource.setRequireFinishTime(RiskDateUtil.calRequireFinishTime((LocalDate)calStartTime, (Integer)riskType, (Integer)riskBasicParam.getIsGenerateByData(), (Integer)riskBasicParam.getHealthSpecialWarning()));
            updateSource.setStatus(SourceRiskStatusEnum.UN_RESOLVED.getValue());
            updateSource.setUnresolvedType(RiskUnresolvedTypeEnum.UN_RECTIFY.getValue());
            updateSource.setWarningStatus(RiskWarningStatusEnum.NONE.getValue());
            updateSource.setBusinessStartDate(riskBasicParam.getStartTime());
            updateSourceList.add(updateSource);
        }
        if (!CollectionUtils.isEmpty(addSourceList)) {
            this.riskSourceService.saveBatch(addSourceList);
            for (RRiskBasicSource source2 : addSourceList) {
                RRiskAcceptanceRecord acceptanceRecord = new RRiskAcceptanceRecord();
                acceptanceRecord.setId(Long.valueOf(IdWorker.getId()));
                acceptanceRecord.setRiskId(source2.getRiskId());
                acceptanceRecord.setSourceId(source2.getId());
                acceptanceRecord.setCid(source2.getCid());
                acceptanceRecord.setRiskType(riskType);
                acceptanceRecord.setFindTime(source2.getFindTime());
                acceptanceRecord.setRequireFinishTime(source2.getRequireFinishTime());
                acceptanceRecord.setStatus(Integer.valueOf(0));
                acceptanceRecord.setAcceptanceResult(null);
                addAcceptanceRecordList.add(acceptanceRecord);
            }
            this.acceptanceRecordCommonService.saveBatch(addAcceptanceRecordList);
        }
        if (!CollectionUtils.isEmpty(updateSourceList)) {
            this.sourceHistoryCommonService.saveSourceAsHistory(sourceHistoryList, "\u7cfb\u7edf\u81ea\u52a8\u751f\u6210\u98ce\u9669");
            updateSourceList.forEach(source -> {
                LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
                ((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)updateWrapper.set(source.getBusinessStartDate() == null, RRiskBasicSource::getBusinessStartDate, null)).set(RRiskBasicSource::getActualFinishTime, null)).set(RRiskBasicSource::getAcceptanceDirectorName, null)).set(RRiskBasicSource::getReformDirectorName, null)).set(RRiskBasicSource::getAcceptanceDate, null)).set(RRiskBasicSource::getAcceptanceWay, null)).eq(RRiskBasicSource::getId, (Object)source.getId());
                this.riskSourceService.update(source, (Wrapper)updateWrapper);
                this.acceptanceRecordCommonService.saveHistoryAndResetStatus((RRiskBasicSource)source);
            });
        }
    }

    private RRiskBasicSource searchSourceWithRiskType(Integer riskType, AddRiskForCommonParam param) {
        RRiskBasicSource dbSource = null;
        if (Objects.equals(riskType, RiskTypeEnum.DOSE_MONITORING.getValue())) {
            return null;
        }
        dbSource = Objects.equals(riskType, RiskTypeEnum.PHYSICAL_EXAMINATION.getValue()) ? this.riskBasicCommonMapper.searchSourceByBusinessId(riskType, param.getCid(), param.getSubBusinessId(), LocalDate.now().getYear(), param.getPostType()) : this.riskBasicCommonMapper.searchSourceByBusinessId(riskType, param.getCid(), param.getSubBusinessId(), LocalDate.now().getYear(), null);
        return dbSource;
    }

    @Transactional
    public void resolveRiskOfCommon(List<Long> sourceIdList) {
        this.resolveRiskOfCommon(new ResolveRiskForCommonParam(sourceIdList));
    }

    @Transactional
    public void resolveRiskOfCommon(ResolveRiskForCommonParam param) {
        List sourceIdList = param.getSourceIdList();
        if (CollectionUtils.isEmpty((Collection)sourceIdList)) {
            return;
        }
        Integer acceptanceWay = param.getAcceptanceWay() == null ? RiskAcceptanceWayEnum.DATA.getValue() : param.getAcceptanceWay();
        String reformMeasure = param.getReformMeasure();
        List sourceList = this.riskSourceService.listByIds(sourceIdList);
        this.sourceHistoryCommonService.saveSourceAsHistory(sourceList, "\u7cfb\u7edf\u81ea\u52a8\u5316\u89e3\u98ce\u9669");
        for (RRiskBasicSource source : sourceList) {
            source.setStatus(BasicRiskStatusEnum.RESOLVED.getValue());
            source.setUnresolvedType(RiskUnresolvedTypeEnum.NONE.getValue());
            source.setActualFinishTime(LocalDate.now());
            source.setAcceptanceWay(acceptanceWay);
            source.setReformDirectorName("\u7cfb\u7edf\u81ea\u52a8\u6574\u6539\u9a8c\u6536");
            source.setAcceptanceDirectorName("\u7cfb\u7edf\u81ea\u52a8\u6574\u6539\u9a8c\u6536");
            source.setAcceptanceDate(LocalDate.now());
        }
        this.riskSourceService.updateBatchById(sourceList);
        this.acceptanceRecordCommonService.updateAcceptanceForResolveOfCommon(sourceIdList, acceptanceWay, reformMeasure);
        ArrayList<RRiskBasic> basicList = new ArrayList<RRiskBasic>();
        List basicIdList = sourceList.stream().map(RRiskBasicSource::getRiskId).distinct().collect(Collectors.toList());
        for (Long basicId : basicIdList) {
            List<RRiskBasicSource> curSourceRelatedData = this.riskSourceService.listSourceByBasicId(basicId);
            if (!curSourceRelatedData.stream().allMatch(curSource -> curSource.getStatus().equals(BasicRiskStatusEnum.RESOLVED.getValue()))) continue;
            RRiskBasic basic = (RRiskBasic)this.riskBasicService.getById(basicId);
            basic.setStatus(BasicRiskStatusEnum.RESOLVED.getValue());
            basic.setUnresolvedType(RiskUnresolvedTypeEnum.NONE.getValue());
            basicList.add(basic);
        }
        this.riskBasicService.updateBatchById(basicList);
    }

    @Transactional
    public void searchAndChangeSourceRiskWarningStatus(RiskMangerGenParam param) {
        Integer healthSpecialType = 104825;
        ArrayList<RRiskBasicSource> firstWarningList = new ArrayList<RRiskBasicSource>();
        List<RRiskBasicSource> performanceFirstWarningList = this.riskSourceService.listWarningSource(RiskTypeEnum.PERFORMANCE_TEST.getValue(), RiskWarningStatusEnum.FIRST.getValue());
        List<RRiskBasicSource> placeFirstWarningList = this.riskSourceService.listWarningSource(RiskTypeEnum.PLACE_TEST.getValue(), RiskWarningStatusEnum.FIRST.getValue());
        List<RRiskBasicSource> phyExamWarningList = this.riskSourceService.listWarningSource(RiskTypeEnum.PHYSICAL_EXAMINATION.getValue(), RiskWarningStatusEnum.FIRST.getValue());
        List<RRiskBasicSource> trainWarningList = this.riskSourceService.listWarningSource(RiskTypeEnum.TRAINING.getValue(), RiskWarningStatusEnum.FIRST.getValue());
        List<RRiskBasicSource> personalWarningList = this.riskSourceService.listWarningSource(RiskTypeEnum.PERSONAL_PROTECTIVE_EQUIPMENT.getValue(), RiskWarningStatusEnum.FIRST.getValue());
        List<RRiskBasicSource> safetyWarningList = this.riskSourceService.listWarningSource(RiskTypeEnum.SAFETY_DEVICES_AND_ALERTS.getValue(), RiskWarningStatusEnum.FIRST.getValue());
        List<RRiskBasicSource> healthSpecialWarningList = this.riskSourceService.listWarningSource(healthSpecialType, RiskWarningStatusEnum.FIRST.getValue());
        firstWarningList.addAll(performanceFirstWarningList);
        firstWarningList.addAll(placeFirstWarningList);
        firstWarningList.addAll(phyExamWarningList);
        firstWarningList.addAll(trainWarningList);
        firstWarningList.addAll(personalWarningList);
        firstWarningList.addAll(safetyWarningList);
        firstWarningList.addAll(healthSpecialWarningList);
        if (!CollectionUtils.isEmpty(firstWarningList)) {
            this.sourceHistoryCommonService.saveSourceAsHistory(firstWarningList, "\u9996\u6b21\u9884\u8b66\u53d8\u66f4\u4e3a\u9ec4\u8272\u9884\u8b66\u3002");
            firstWarningList.stream().forEach(source -> source.setWarningStatus(RiskWarningStatusEnum.YELLOW.getValue()));
            this.riskSourceService.updateBatchById(firstWarningList);
            firstWarningList = null;
        }
        ArrayList<RRiskBasicSource> yellowWarningList = new ArrayList<RRiskBasicSource>();
        List<RRiskBasicSource> performanceYellowWarningList = this.riskSourceService.listWarningSource(RiskTypeEnum.PERFORMANCE_TEST.getValue(), RiskWarningStatusEnum.YELLOW.getValue());
        List<RRiskBasicSource> placeYellowWarningList = this.riskSourceService.listWarningSource(RiskTypeEnum.PLACE_TEST.getValue(), RiskWarningStatusEnum.YELLOW.getValue());
        List<RRiskBasicSource> phyExamYellowWarningList = this.riskSourceService.listWarningSource(RiskTypeEnum.PHYSICAL_EXAMINATION.getValue(), RiskWarningStatusEnum.YELLOW.getValue());
        List<RRiskBasicSource> trainYellowWarningList = this.riskSourceService.listWarningSource(RiskTypeEnum.TRAINING.getValue(), RiskWarningStatusEnum.YELLOW.getValue());
        List<RRiskBasicSource> personalYellowWarningList = this.riskSourceService.listWarningSource(RiskTypeEnum.PERSONAL_PROTECTIVE_EQUIPMENT.getValue(), RiskWarningStatusEnum.YELLOW.getValue());
        List<RRiskBasicSource> safetyYellowWarningList = this.riskSourceService.listWarningSource(RiskTypeEnum.SAFETY_DEVICES_AND_ALERTS.getValue(), RiskWarningStatusEnum.YELLOW.getValue());
        List<RRiskBasicSource> healthSpecialYellowWarningList = this.riskSourceService.listWarningSource(healthSpecialType, RiskWarningStatusEnum.YELLOW.getValue());
        yellowWarningList.addAll(performanceYellowWarningList);
        yellowWarningList.addAll(placeYellowWarningList);
        yellowWarningList.addAll(phyExamYellowWarningList);
        yellowWarningList.addAll(trainYellowWarningList);
        yellowWarningList.addAll(personalYellowWarningList);
        yellowWarningList.addAll(safetyYellowWarningList);
        yellowWarningList.addAll(healthSpecialYellowWarningList);
        if (!CollectionUtils.isEmpty(yellowWarningList)) {
            this.sourceHistoryCommonService.saveSourceAsHistory(yellowWarningList, "\u9ec4\u6b21\u9884\u8b66\u53d8\u66f4\u4e3a\u7ea2\u8272\u9884\u8b66\u3002");
            yellowWarningList.stream().forEach(source -> source.setWarningStatus(RiskWarningStatusEnum.RED.getValue()));
            this.riskSourceService.updateBatchById(yellowWarningList);
            yellowWarningList = null;
        }
        ArrayList<RRiskBasicSource> redWarningList = new ArrayList<RRiskBasicSource>();
        List<RRiskBasicSource> performanceRedWarningList = this.riskSourceService.listWarningSource(RiskTypeEnum.PERFORMANCE_TEST.getValue(), RiskWarningStatusEnum.RED.getValue());
        List<RRiskBasicSource> placeRedWarningList = this.riskSourceService.listWarningSource(RiskTypeEnum.PLACE_TEST.getValue(), RiskWarningStatusEnum.RED.getValue());
        List<RRiskBasicSource> phyExamRedWarningList = this.riskSourceService.listWarningSource(RiskTypeEnum.PHYSICAL_EXAMINATION.getValue(), RiskWarningStatusEnum.RED.getValue());
        List<RRiskBasicSource> trainRedWarningList = this.riskSourceService.listWarningSource(RiskTypeEnum.TRAINING.getValue(), RiskWarningStatusEnum.RED.getValue());
        List<RRiskBasicSource> personalRedWarningList = this.riskSourceService.listWarningSource(RiskTypeEnum.PERSONAL_PROTECTIVE_EQUIPMENT.getValue(), RiskWarningStatusEnum.RED.getValue());
        List<RRiskBasicSource> safetyRedWarningList = this.riskSourceService.listWarningSource(RiskTypeEnum.SAFETY_DEVICES_AND_ALERTS.getValue(), RiskWarningStatusEnum.RED.getValue());
        List<RRiskBasicSource> healthSpecialRedWarningList = this.riskSourceService.listWarningSource(healthSpecialType, RiskWarningStatusEnum.RED.getValue());
        List<RRiskBasicSource> Ex201ActivateLawWarningList = this.riskSourceService.listWarningSource(RiskTypeEnum.EXCEPTION_PERFORMANCE_TEST.getValue(), RiskWarningStatusEnum.ACTIVATE_LAW.getValue());
        List<RRiskBasicSource> Ex301ActivateLawWarningList = this.riskSourceService.listWarningSource(RiskTypeEnum.EXCEPTION_PLACE_TEST.getValue(), RiskWarningStatusEnum.ACTIVATE_LAW.getValue());
        List<RRiskBasicSource> Ex404ActivateLawWarningList = this.riskSourceService.listWarningSource(RiskTypeEnum.PHYSICAL_EXCEPTION_OCC.getValue(), RiskWarningStatusEnum.ACTIVATE_LAW.getValue());
        List<RRiskBasicSource> Ex405ActivateLawWarningList = this.riskSourceService.listWarningSource(RiskTypeEnum.PHYSICAL_EXCEPTION_CONTRAINDICATION.getValue(), RiskWarningStatusEnum.ACTIVATE_LAW.getValue());
        List<RRiskBasicSource> Ex406ActivateLawWarningList = this.riskSourceService.listWarningSource(RiskTypeEnum.PHYSICAL_EXCEPTION_REVIEW.getValue(), RiskWarningStatusEnum.ACTIVATE_LAW.getValue());
        List<RRiskBasicSource> Ex502ActivateLawWarningList = this.riskSourceService.listWarningSource(RiskTypeEnum.DOSE_EXCEPTION_OVERDOSE.getValue(), RiskWarningStatusEnum.ACTIVATE_LAW.getValue());
        redWarningList.addAll(performanceRedWarningList);
        redWarningList.addAll(placeRedWarningList);
        redWarningList.addAll(phyExamRedWarningList);
        redWarningList.addAll(trainRedWarningList);
        redWarningList.addAll(personalRedWarningList);
        redWarningList.addAll(safetyRedWarningList);
        redWarningList.addAll(healthSpecialRedWarningList);
        redWarningList.addAll(Ex201ActivateLawWarningList);
        redWarningList.addAll(Ex301ActivateLawWarningList);
        redWarningList.addAll(Ex404ActivateLawWarningList);
        redWarningList.addAll(Ex405ActivateLawWarningList);
        redWarningList.addAll(Ex406ActivateLawWarningList);
        redWarningList.addAll(Ex502ActivateLawWarningList);
        if (!CollectionUtils.isEmpty(redWarningList)) {
            this.sourceHistoryCommonService.saveSourceAsHistory(redWarningList, "\u53d8\u66f4\u7ea2\u8272\u9884\u8b66\u3002");
            redWarningList.stream().forEach(source -> source.setWarningStatus(RiskWarningStatusEnum.RED.getValue()));
            this.riskSourceService.updateBatchById(redWarningList);
            redWarningList = null;
        }
        ArrayList<RRiskBasicSource> changeToFirstWarningList = new ArrayList<RRiskBasicSource>();
        List<RRiskBasicSource> performanceFirstWarningListForNone = this.riskSourceService.listWarningSourceForNoneWarningStatus(RiskTypeEnum.PERFORMANCE_TEST.getValue(), RiskWarningStatusEnum.FIRST.getValue());
        List<RRiskBasicSource> placeFirstWarningListForNone = this.riskSourceService.listWarningSourceForNoneWarningStatus(RiskTypeEnum.PLACE_TEST.getValue(), RiskWarningStatusEnum.FIRST.getValue());
        List<RRiskBasicSource> phyExamWarningListForNone = this.riskSourceService.listWarningSourceForNoneWarningStatus(RiskTypeEnum.PHYSICAL_EXAMINATION.getValue(), RiskWarningStatusEnum.FIRST.getValue());
        List<RRiskBasicSource> trainWarningListForNone = this.riskSourceService.listWarningSourceForNoneWarningStatus(RiskTypeEnum.TRAINING.getValue(), RiskWarningStatusEnum.FIRST.getValue());
        List<RRiskBasicSource> personalWarningListForNone = this.riskSourceService.listWarningSourceForNoneWarningStatus(RiskTypeEnum.PERSONAL_PROTECTIVE_EQUIPMENT.getValue(), RiskWarningStatusEnum.FIRST.getValue());
        List<RRiskBasicSource> safetyWarningListForNone = this.riskSourceService.listWarningSourceForNoneWarningStatus(RiskTypeEnum.SAFETY_DEVICES_AND_ALERTS.getValue(), RiskWarningStatusEnum.FIRST.getValue());
        changeToFirstWarningList.addAll(performanceFirstWarningListForNone);
        changeToFirstWarningList.addAll(placeFirstWarningListForNone);
        changeToFirstWarningList.addAll(phyExamWarningListForNone);
        changeToFirstWarningList.addAll(trainWarningListForNone);
        changeToFirstWarningList.addAll(personalWarningListForNone);
        changeToFirstWarningList.addAll(safetyWarningListForNone);
        if (!CollectionUtils.isEmpty(changeToFirstWarningList)) {
            changeToFirstWarningList.stream().forEach(source -> source.setWarningStatus(RiskWarningStatusEnum.FIRST.getValue()));
            this.riskSourceService.updateBatchById(changeToFirstWarningList);
            changeToFirstWarningList = null;
        }
        ArrayList<RRiskBasicSource> changeToYellowWarningList = new ArrayList<RRiskBasicSource>();
        List<RRiskBasicSource> performanceYellowWarningListForNone = this.riskSourceService.listWarningSourceForNoneWarningStatus(RiskTypeEnum.PERFORMANCE_TEST.getValue(), RiskWarningStatusEnum.YELLOW.getValue());
        List<RRiskBasicSource> placeYellowWarningListForNone = this.riskSourceService.listWarningSourceForNoneWarningStatus(RiskTypeEnum.PLACE_TEST.getValue(), RiskWarningStatusEnum.YELLOW.getValue());
        List<RRiskBasicSource> phyExamYellowWarningListForNone = this.riskSourceService.listWarningSourceForNoneWarningStatus(RiskTypeEnum.PHYSICAL_EXAMINATION.getValue(), RiskWarningStatusEnum.YELLOW.getValue());
        List<RRiskBasicSource> trainYellowWarningListForNone = this.riskSourceService.listWarningSourceForNoneWarningStatus(RiskTypeEnum.TRAINING.getValue(), RiskWarningStatusEnum.YELLOW.getValue());
        List<RRiskBasicSource> personalYellowWarningListForNone = this.riskSourceService.listWarningSourceForNoneWarningStatus(RiskTypeEnum.PERSONAL_PROTECTIVE_EQUIPMENT.getValue(), RiskWarningStatusEnum.YELLOW.getValue());
        List<RRiskBasicSource> safetyYellowWarningListForNone = this.riskSourceService.listWarningSourceForNoneWarningStatus(RiskTypeEnum.SAFETY_DEVICES_AND_ALERTS.getValue(), RiskWarningStatusEnum.YELLOW.getValue());
        changeToYellowWarningList.addAll(performanceYellowWarningListForNone);
        changeToYellowWarningList.addAll(placeYellowWarningListForNone);
        changeToYellowWarningList.addAll(phyExamYellowWarningListForNone);
        changeToYellowWarningList.addAll(trainYellowWarningListForNone);
        changeToYellowWarningList.addAll(personalYellowWarningListForNone);
        changeToYellowWarningList.addAll(safetyYellowWarningListForNone);
        if (!CollectionUtils.isEmpty(changeToYellowWarningList)) {
            changeToYellowWarningList.stream().forEach(source -> source.setWarningStatus(RiskWarningStatusEnum.YELLOW.getValue()));
            this.riskSourceService.updateBatchById(changeToYellowWarningList);
            changeToYellowWarningList = null;
        }
        ArrayList<RRiskBasicSource> changeToRedWarningList = new ArrayList<RRiskBasicSource>();
        List<RRiskBasicSource> performanceRedWarningListForNone = this.riskSourceService.listWarningSourceForNoneWarningStatus(RiskTypeEnum.PERFORMANCE_TEST.getValue(), RiskWarningStatusEnum.RED.getValue());
        List<RRiskBasicSource> placeRedWarningListForNone = this.riskSourceService.listWarningSourceForNoneWarningStatus(RiskTypeEnum.PLACE_TEST.getValue(), RiskWarningStatusEnum.RED.getValue());
        List<RRiskBasicSource> phyExamRedWarningListForNone = this.riskSourceService.listWarningSourceForNoneWarningStatus(RiskTypeEnum.PHYSICAL_EXAMINATION.getValue(), RiskWarningStatusEnum.RED.getValue());
        List<RRiskBasicSource> trainRedWarningListForNone = this.riskSourceService.listWarningSourceForNoneWarningStatus(RiskTypeEnum.TRAINING.getValue(), RiskWarningStatusEnum.RED.getValue());
        List<RRiskBasicSource> personalRedWarningListForNone = this.riskSourceService.listWarningSourceForNoneWarningStatus(RiskTypeEnum.PERSONAL_PROTECTIVE_EQUIPMENT.getValue(), RiskWarningStatusEnum.RED.getValue());
        List<RRiskBasicSource> safetyRedWarningListForNone = this.riskSourceService.listWarningSourceForNoneWarningStatus(RiskTypeEnum.SAFETY_DEVICES_AND_ALERTS.getValue(), RiskWarningStatusEnum.RED.getValue());
        changeToRedWarningList.addAll(performanceRedWarningListForNone);
        changeToRedWarningList.addAll(placeRedWarningListForNone);
        changeToRedWarningList.addAll(phyExamRedWarningListForNone);
        changeToRedWarningList.addAll(trainRedWarningListForNone);
        changeToRedWarningList.addAll(personalRedWarningListForNone);
        changeToRedWarningList.addAll(safetyRedWarningListForNone);
        if (!CollectionUtils.isEmpty(changeToRedWarningList)) {
            changeToRedWarningList.stream().forEach(source -> source.setWarningStatus(RiskWarningStatusEnum.RED.getValue()));
            this.riskSourceService.updateBatchById(changeToRedWarningList);
            changeToRedWarningList = null;
        }
        ArrayList<RRiskBasicSource> changeToActivateLawList = new ArrayList<RRiskBasicSource>();
        List<RRiskBasicSource> performanceActivateLawListForNone = this.riskSourceService.listWarningSourceForNoneWarningStatus(RiskTypeEnum.PERFORMANCE_TEST.getValue(), RiskWarningStatusEnum.ACTIVATE_LAW.getValue());
        List<RRiskBasicSource> placeActivateLawListForNone = this.riskSourceService.listWarningSourceForNoneWarningStatus(RiskTypeEnum.PLACE_TEST.getValue(), RiskWarningStatusEnum.ACTIVATE_LAW.getValue());
        List<RRiskBasicSource> phyExamActivateLawListForNone = this.riskSourceService.listWarningSourceForNoneWarningStatus(RiskTypeEnum.PHYSICAL_EXAMINATION.getValue(), RiskWarningStatusEnum.ACTIVATE_LAW.getValue());
        List<RRiskBasicSource> trainActivateLawListForNone = this.riskSourceService.listWarningSourceForNoneWarningStatus(RiskTypeEnum.TRAINING.getValue(), RiskWarningStatusEnum.ACTIVATE_LAW.getValue());
        List<RRiskBasicSource> personalActivateLawWarningListForNone = this.riskSourceService.listWarningSourceForNoneWarningStatus(RiskTypeEnum.PERSONAL_PROTECTIVE_EQUIPMENT.getValue(), RiskWarningStatusEnum.ACTIVATE_LAW.getValue());
        List<RRiskBasicSource> safetyActivateLawWarningListForNone = this.riskSourceService.listWarningSourceForNoneWarningStatus(RiskTypeEnum.SAFETY_DEVICES_AND_ALERTS.getValue(), RiskWarningStatusEnum.ACTIVATE_LAW.getValue());
        List<RRiskBasicSource> Ex201ActivateLawWarningListForNone = this.riskSourceService.listWarningSourceForNoneWarningStatus(RiskTypeEnum.EXCEPTION_PERFORMANCE_TEST.getValue(), RiskWarningStatusEnum.ACTIVATE_LAW.getValue());
        List<RRiskBasicSource> Ex301ActivateLawWarningListForNone = this.riskSourceService.listWarningSourceForNoneWarningStatus(RiskTypeEnum.EXCEPTION_PLACE_TEST.getValue(), RiskWarningStatusEnum.ACTIVATE_LAW.getValue());
        List<RRiskBasicSource> Ex404ActivateLawWarningListForNone = this.riskSourceService.listWarningSourceForNoneWarningStatus(RiskTypeEnum.PHYSICAL_EXCEPTION_OCC.getValue(), RiskWarningStatusEnum.ACTIVATE_LAW.getValue());
        List<RRiskBasicSource> Ex405ActivateLawWarningListForNone = this.riskSourceService.listWarningSourceForNoneWarningStatus(RiskTypeEnum.PHYSICAL_EXCEPTION_CONTRAINDICATION.getValue(), RiskWarningStatusEnum.ACTIVATE_LAW.getValue());
        List<RRiskBasicSource> Ex406ActivateLawWarningListForNone = this.riskSourceService.listWarningSourceForNoneWarningStatus(RiskTypeEnum.PHYSICAL_EXCEPTION_REVIEW.getValue(), RiskWarningStatusEnum.ACTIVATE_LAW.getValue());
        List<RRiskBasicSource> Ex502ActivateLawWarningListForNone = this.riskSourceService.listWarningSourceForNoneWarningStatus(RiskTypeEnum.DOSE_EXCEPTION_OVERDOSE.getValue(), RiskWarningStatusEnum.ACTIVATE_LAW.getValue());
        changeToActivateLawList.addAll(performanceActivateLawListForNone);
        changeToActivateLawList.addAll(placeActivateLawListForNone);
        changeToActivateLawList.addAll(phyExamActivateLawListForNone);
        changeToActivateLawList.addAll(trainActivateLawListForNone);
        changeToActivateLawList.addAll(personalActivateLawWarningListForNone);
        changeToActivateLawList.addAll(safetyActivateLawWarningListForNone);
        changeToActivateLawList.addAll(Ex201ActivateLawWarningListForNone);
        changeToActivateLawList.addAll(Ex301ActivateLawWarningListForNone);
        changeToActivateLawList.addAll(Ex404ActivateLawWarningListForNone);
        changeToActivateLawList.addAll(Ex405ActivateLawWarningListForNone);
        changeToActivateLawList.addAll(Ex406ActivateLawWarningListForNone);
        changeToActivateLawList.addAll(Ex502ActivateLawWarningListForNone);
        if (!CollectionUtils.isEmpty(changeToActivateLawList)) {
            changeToActivateLawList.stream().forEach(source -> source.setWarningStatus(RiskWarningStatusEnum.RED.getValue()));
            this.riskSourceService.updateBatchById(changeToActivateLawList);
            changeToActivateLawList = null;
        }
        this.riskSourceService.maintenanceWarningSourceForNone();
    }

    @Transactional
    public void searchAndChangeBasicRiskWarningStatus(RiskMangerGenParam param) {
        this.riskBasicService.changeBasicWarningStatus(param);
    }

    public List<RRiskBasicSource> listRiskSourceAboutPhysical(SearchRiskParam param) {
        return this.riskSourceService.listRiskSourceAboutPhysical(param);
    }

    public String handleBasicRiskName(AddRiskForCommonParam riskParam) {
        String secName;
        if (riskParam.getCompanyName() == null) {
            BCompany company = (BCompany)this.companyService.getById(riskParam.getCid());
            riskParam.setCompanyName(company.getName());
        }
        if (Objects.equals(riskParam.getType(), RiskTypeEnum.LICENSE_MANAGEMENT.getValue())) {
            secName = riskParam.getIsGenerateByData() == 0 ? "\u672a\u53ca\u65f6\u5f00\u5c55\u8bb8\u53ef\u6821\u9a8c" : "\u8bb8\u53ef\u5373\u5c06\u5230\u671f";
            return String.format("%s\u5e74\u4efd-%s", LocalDate.now().getYear(), secName);
        }
        if (Objects.equals(riskParam.getType(), RiskTypeEnum.PERSONAL_PROTECTIVE_EQUIPMENT.getValue())) {
            secName = riskParam.getIsGenerateByData() == 0 ? "\u672a\u53ca\u65f6\u5f00\u5c55\u4e2a\u4eba\u9632\u62a4\u7528\u54c1\u81ea\u68c0" : "\u4e2a\u4eba\u9632\u62a4\u7528\u54c1\u81ea\u68c0\u5373\u5c06\u5931\u6548";
            return String.format("%s\u5e74\u4efd-%s", LocalDate.now().getYear(), secName);
        }
        if (Objects.equals(riskParam.getType(), RiskTypeEnum.SAFETY_DEVICES_AND_ALERTS.getValue())) {
            secName = riskParam.getIsGenerateByData() == 0 ? "\u672a\u53ca\u65f6\u5f00\u5c55\u5b89\u5168\u88c5\u7f6e\u548c\u8b66\u793a\u6807\u8bc6\u81ea\u67e5" : "\u5b89\u5168\u88c5\u7f6e\u548c\u8b66\u793a\u6807\u8bc6\u81ea\u67e5\u5373\u5c06\u5931\u6548";
            return String.format("%s\u5e74\u4efd-%s", LocalDate.now().getYear(), secName);
        }
        if (Objects.equals(riskParam.getType(), RiskTypeEnum.EXCEPTION_PERFORMANCE_TEST.getValue())) {
            return String.format("%s\u5e74\u4efd-\u6027\u80fd\u68c0\u6d4b\u7ed3\u679c\u5f02\u5e38", LocalDate.now().getYear());
        }
        if (Objects.equals(riskParam.getType(), RiskTypeEnum.EXCEPTION_PLACE_TEST.getValue())) {
            return String.format("%s\u5e74\u4efd-\u573a\u6240\u68c0\u6d4b\u7ed3\u679c\u5f02\u5e38", LocalDate.now().getYear());
        }
        if (Objects.equals(riskParam.getType(), RiskTypeEnum.PHYSICAL_EXCEPTION_OCC.getValue()) || Objects.equals(riskParam.getType(), RiskTypeEnum.PHYSICAL_EXCEPTION_CONTRAINDICATION.getValue()) || Objects.equals(riskParam.getType(), RiskTypeEnum.PHYSICAL_EXCEPTION_REVIEW.getValue())) {
            return String.format("%s\u5e74\u4efd-\u4f53\u68c0\u7ed3\u679c\u5f02\u5e38-%s", LocalDate.now().getYear(), RiskTypeEnum.getName((Integer)riskParam.getType()));
        }
        if (Objects.equals(riskParam.getType(), RiskTypeEnum.DOSE_EXCEPTION_OVERDOSE.getValue())) {
            return String.format("%s\u5e74\u4efd-\u4e2a\u4eba\u5242\u91cf\u76d1\u6d4b\u5f02\u5e38-\u8d85\u5242\u91cf\u7167\u5c04", LocalDate.now().getYear());
        }
        String riskTypeName = RiskTypeEnum.getName((Integer)riskParam.getType());
        return String.format("%s\u5e74\u4efd-%s\u5b58\u5728\u98ce\u9669", LocalDate.now().getYear(), riskTypeName);
    }

    public String handleSourceRiskName(AddRiskForCommonParam riskParam) {
        String secName;
        if (riskParam.getCompanyName() == null) {
            BCompany company = (BCompany)this.companyService.getById(riskParam.getCid());
            riskParam.setCompanyName(company.getName());
        }
        if (riskParam.getTimeSpecialType() == 1) {
            return String.format("%s-\u57fa\u7840\u4fe1\u606f\u7f3a\u5931\u5bfc\u81f4\u98ce\u9669\u4e0d\u53ef\u8bc4\u4f30", riskParam.getSubBusinessName());
        }
        if (Objects.equals(riskParam.getType(), RiskTypeEnum.LICENSE_MANAGEMENT.getValue())) {
            secName = riskParam.getIsGenerateByData() == 0 ? "\u672a\u53ca\u65f6\u5f00\u5c55\u8bb8\u53ef\u6821\u9a8c" : "\u8bb8\u53ef\u5373\u5c06\u5230\u671f";
            return String.format("%s\u5e74\u4efd-%s", LocalDate.now().getYear(), secName);
        }
        if (Objects.equals(riskParam.getType(), RiskTypeEnum.PERSONAL_PROTECTIVE_EQUIPMENT.getValue())) {
            secName = riskParam.getIsGenerateByData() == 0 ? "\u672a\u53ca\u65f6\u5f00\u5c55\u4e2a\u4eba\u9632\u62a4\u7528\u54c1\u81ea\u68c0" : "\u4e2a\u4eba\u9632\u62a4\u7528\u54c1\u81ea\u68c0\u5373\u5c06\u5931\u6548";
            return String.format("%s\u5e74\u4efd-%s", LocalDate.now().getYear(), secName);
        }
        if (Objects.equals(riskParam.getType(), RiskTypeEnum.SAFETY_DEVICES_AND_ALERTS.getValue())) {
            secName = riskParam.getIsGenerateByData() == 0 ? "\u672a\u53ca\u65f6\u5f00\u5c55\u5b89\u5168\u88c5\u7f6e\u548c\u8b66\u793a\u6807\u8bc6\u81ea\u67e5" : "\u5b89\u5168\u88c5\u7f6e\u548c\u8b66\u793a\u6807\u8bc6\u81ea\u67e5\u5373\u5c06\u5931\u6548";
            return String.format("%s\u5e74\u4efd-%s", LocalDate.now().getYear(), secName);
        }
        if (Objects.equals(riskParam.getType(), RiskTypeEnum.PHYSICAL_EXAMINATION.getValue())) {
            Object postName = "\u804c\u4e1a\u5065\u5eb7\u4f53\u68c0";
            if (riskParam.getPostType() == 1) {
                postName = "\u5c97\u524d" + (String)postName;
            } else if (riskParam.getPostType() == 2) {
                postName = "\u5728\u5c97" + (String)postName;
            } else if (riskParam.getPostType() == 3) {
                postName = "\u79bb\u5c97" + (String)postName;
            }
            String secName2 = riskParam.getIsGenerateByData() == 0 ? "\u672a\u53ca\u65f6\u5f00\u5c55" + (String)postName : (String)postName + "\u5373\u5c06\u5931\u6548";
            return String.format("%s-%s", riskParam.getSubBusinessName(), secName2);
        }
        if (Objects.equals(riskParam.getType(), RiskTypeEnum.EXCEPTION_PERFORMANCE_TEST.getValue())) {
            return String.format("%s-\u6027\u80fd\u68c0\u6d4b\u7ed3\u679c\u5f02\u5e38", riskParam.getSubBusinessName());
        }
        if (Objects.equals(riskParam.getType(), RiskTypeEnum.EXCEPTION_PLACE_TEST.getValue())) {
            return String.format("%s-\u573a\u6240\u68c0\u6d4b\u7ed3\u679c\u5f02\u5e38", riskParam.getSubBusinessName());
        }
        if (Objects.equals(riskParam.getType(), RiskTypeEnum.PHYSICAL_EXCEPTION_OCC.getValue()) || Objects.equals(riskParam.getType(), RiskTypeEnum.PHYSICAL_EXCEPTION_CONTRAINDICATION.getValue()) || Objects.equals(riskParam.getType(), RiskTypeEnum.PHYSICAL_EXCEPTION_REVIEW.getValue())) {
            return String.format("%s-\u4f53\u68c0\u7ed3\u679c\u5f02\u5e38-%s", riskParam.getSubBusinessName(), RiskTypeEnum.getName((Integer)riskParam.getType()));
        }
        if (Objects.equals(riskParam.getType(), RiskTypeEnum.DOSE_EXCEPTION_OVERDOSE.getValue())) {
            return String.format("%s-\u4e2a\u4eba\u5242\u91cf\u76d1\u6d4b\u5f02\u5e38-\u8d85\u5242\u91cf\u7167\u5c04", riskParam.getSubBusinessName());
        }
        String riskTypeName = RiskTypeEnum.getName((Integer)riskParam.getType());
        String secName3 = riskParam.getIsGenerateByData() == 0 ? "\u672a\u53ca\u65f6\u5f00\u5c55" + riskTypeName : riskTypeName + "\u5373\u5c06\u5931\u6548";
        return String.format("%s-%s", riskParam.getSubBusinessName(), secName3);
    }

    @Transactional
    public void saveRiskAcceptanceRecordHistory(RRiskAcceptanceRecord riskAcceptanceRecord) {
        this.acceptanceRecordHistoryCommonService.save(this.riskAcceptanceRecordHistoryConverter.record2recordHistory(riskAcceptanceRecord));
    }

    @Transactional
    public void saveBatchRiskAcceptanceRecordHistory(List<RRiskAcceptanceRecord> riskAcceptanceRecordList) {
        this.acceptanceRecordHistoryCommonService.saveBatch(this.riskAcceptanceRecordHistoryConverter.recordList2recordHistoryList(riskAcceptanceRecordList));
    }

    public LayuiGridData<RiskAcceptanceHistoryVo> listAcceptanceHistory(RiskQueryCommonParam param) {
        return this.acceptanceRecordHistoryCommonService.listAcceptanceHistory(param);
    }

    public List<RiskAcceptanceCommonVo> listAcceptanceRecordBySourceId(Long sourceId) {
        return this.acceptanceRecordCommonService.listAcceptanceRecordBySourceId(sourceId);
    }

    public LayuiGridData<ThirdOrgVo> getCheckOrgChooseList(CheckOrgChooseQueryParam param) {
        return this.companyService.getCheckOrgChooseList(param);
    }

    public RiskAcceptanceHistoryVo getHistoryAcceptRecord(Long sourceId) {
        return this.acceptanceRecordHistoryCommonService.getHistoryAcceptRecord(sourceId);
    }

    @Generated
    public RiskProviderImpl(RRiskBasicConverter rRiskBasicConverter, RiskAcceptanceRecordHistoryConverter riskAcceptanceRecordHistoryConverter, IRiskBasicCommonService riskBasicService, IRiskBasicSourceCommonService riskSourceService, IRiskAcceptanceRecordCommonService acceptanceRecordCommonService, IRiskAcceptanceRecordHistoryCommonService acceptanceRecordHistoryCommonService, RiskBasicCommonMapper riskBasicCommonMapper, IRiskBasicSourceHistoryCommonService sourceHistoryCommonService, IBCompanyService companyService, ICTrainingCertService trainingCertService) {
        this.rRiskBasicConverter = rRiskBasicConverter;
        this.riskAcceptanceRecordHistoryConverter = riskAcceptanceRecordHistoryConverter;
        this.riskBasicService = riskBasicService;
        this.riskSourceService = riskSourceService;
        this.acceptanceRecordCommonService = acceptanceRecordCommonService;
        this.acceptanceRecordHistoryCommonService = acceptanceRecordHistoryCommonService;
        this.riskBasicCommonMapper = riskBasicCommonMapper;
        this.sourceHistoryCommonService = sourceHistoryCommonService;
        this.companyService = companyService;
        this.trainingCertService = trainingCertService;
    }
}

