/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.rho.modules.sys.manger.staff.staffSync;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import cn.smarthse.framework.sensitive.enumd.DesensitizationType;
import cn.smarthse.framework.sensitive.utils.DesensitizationUtils;
import cn.smarthse.rho.modules.sys.entity.b.BCompany;
import cn.smarthse.rho.modules.sys.entity.c.CStaff;
import cn.smarthse.rho.modules.sys.entity.c.CStaffBaseInfo;
import cn.smarthse.rho.modules.sys.enums.staff.PostStatusEnum;
import cn.smarthse.rho.modules.sys.enums.staff.StaffSourceEnum;
import cn.smarthse.rho.modules.sys.model.b.vo.CStaffInfoSyncVo;
import cn.smarthse.rho.modules.sys.model.wanda.sync.param.WandaSyncParam;
import cn.smarthse.rho.modules.sys.service.b.IBCompanyService;
import cn.smarthse.rho.modules.sys.service.c.ICDoseDataService;
import cn.smarthse.rho.modules.sys.service.c.ICStaffBaseInfoService;
import cn.smarthse.rho.modules.sys.service.c.ICStaffErrorService;
import cn.smarthse.rho.modules.sys.service.c.ICStaffService;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import lombok.Generated;
import org.redisson.api.RLock;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;

@Component
public class WandaStaffCMInfoSyncDoseManager {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WandaStaffCMInfoSyncDoseManager.class);
    private final IBCompanyService companyService;
    private final ICDoseDataService doseDataService;
    private final ICStaffBaseInfoService staffBaseInfoService;
    private final ICStaffService staffService;
    private final RedissonClient redissonClient;
    private final ICStaffErrorService staffErrorService;
    @Autowired
    private ApplicationContext applicationContext;
    private static final String LOCK_KEY = "WandaStaffCMInfoSyncManager";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void syncStaffInfoFromDose(WandaSyncParam param) {
        log.debug("wanda\u4eba\u5458\u533b\u9662\u5173\u8054\u540c\u6b65\uff1a syncWandaStaffData() start");
        StringBuilder sb = new StringBuilder(LOCK_KEY);
        RLock lock = this.redissonClient.getLock(sb.toString());
        boolean resLock = false;
        try {
            resLock = lock.tryLock(1L, 3600L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        if (resLock) {
            try {
                WandaStaffCMInfoSyncDoseManager self = (WandaStaffCMInfoSyncDoseManager)this.applicationContext.getBean(WandaStaffCMInfoSyncDoseManager.class);
                self.syncStaffInfoFromDoseLock(param);
                log.debug("wanda\u4eba\u5458\u533b\u9662\u5173\u8054\u540c\u6b65\uff1a syncWandaStaffData() end");
            }
            catch (Exception e) {
                log.error("\u3010\u4eba\u5458\u5173\u8054\u516c\u53f8\u3011\u3010\u4f53\u68c0\u3011\u3010\u4e2a\u4eba\u5242\u91cf\u3011\u5931\u8d25\uff1ae{}", (Throwable)e);
            }
            finally {
                lock.unlock();
            }
        } else {
            log.error("{}\uff1a\u3010\u4eba\u5458\u5173\u8054\u516c\u53f8\u3011\u3010\u4e2a\u4eba\u5242\u91cf\u3011\u9501\u8d85\u65f6", (Object)LOCK_KEY);
        }
    }

    public void syncStaffInfoFromDoseLock(WandaSyncParam param) {
        List<CStaffInfoSyncVo> list = this.staffBaseInfoService.getWandaSyncStaffInfoFromDoseData(param);
        List<CStaffInfoSyncVo> canSyncList = list.stream().filter(v -> this.canSync((CStaffInfoSyncVo)v)).collect(Collectors.toList());
        if (CollUtil.isNotEmpty(canSyncList)) {
            this.saveStaffInfo(canSyncList);
        }
    }

    public void saveStaffInfo(List<CStaffInfoSyncVo> canSyncList) {
        for (CStaffInfoSyncVo vo : canSyncList) {
            try {
                this.genOne(vo);
            }
            catch (Exception e) {
                log.error("\u3010\u4eba\u5458\u5173\u8054\u516c\u53f8\u3011\u3010\u4f53\u68c0\u3011\u3010\u5355\u4e2a\u3011\u5931\u8d25\uff1asbId{},name{},idCard{},e{}", new Object[]{vo.getStaffBaseInfoId(), DesensitizationUtils.desensitized((CharSequence)vo.getName(), (DesensitizationType)DesensitizationType.NAME), DesensitizationUtils.desensitized((CharSequence)vo.getIdcard(), (DesensitizationType)DesensitizationType.ID_CARD), e});
            }
        }
    }

    private void genOne(CStaffInfoSyncVo vo) {
        if (StrUtil.isBlank((CharSequence)vo.getDoseCheckIdListStr())) {
            return;
        }
        List doseCheckIdList = StrUtil.split((CharSequence)vo.getDoseCheckIdListStr(), (CharSequence)",");
        List doseData = this.doseDataService.listByIds(doseCheckIdList);
        vo.setDoseCheckList(doseData);
        if (CollUtil.isEmpty((Collection)vo.getDoseCheckList())) {
            return;
        }
        CStaffBaseInfo staffBaseInfo = (CStaffBaseInfo)this.staffBaseInfoService.getById(vo.getStaffBaseInfoId());
        if (staffBaseInfo == null) {
            return;
        }
        List<Long> cidList = doseData.stream().map(v -> v.getCid()).distinct().collect(Collectors.toList());
        this.saveStaffInfoList(cidList, staffBaseInfo, vo);
    }

    public void saveStaffInfoList(List<Long> cidList, CStaffBaseInfo staffBaseInfo, CStaffInfoSyncVo vo) {
        if (CollUtil.isEmpty(cidList)) {
            return;
        }
        Long staffBaseInfoId = staffBaseInfo.getId();
        for (Long cid : cidList) {
            CStaff staffEntity = this.staffService.getByBaseIdAndCid(staffBaseInfoId, cid);
            if (staffEntity != null || (staffEntity = this.wandaSyncInfo2StaffInfoEntity(cid, staffBaseInfo, vo)) == null) continue;
            this.staffService.save(staffEntity);
            this.staffErrorService.manualMaintenanceOne(staffEntity.getBaseId());
        }
    }

    private List<Long> extractCid(CStaffInfoSyncVo vo, CStaffBaseInfo entity) {
        List doseDataList = vo.getDoseCheckList();
        if (CollUtil.isEmpty((Collection)doseDataList)) {
            return null;
        }
        List cidList = doseDataList.stream().map(v -> v.getCid()).distinct().collect(Collectors.toList());
        List companyList = this.companyService.listByIds(cidList);
        if (CollUtil.isEmpty((Collection)companyList)) {
            return null;
        }
        companyList = CollUtil.distinct((Collection)companyList, e -> e.getCreditCode(), (boolean)true);
        return companyList.stream().map(v -> v.getId()).collect(Collectors.toList());
    }

    private CStaff wandaSyncInfo2StaffInfoEntity(Long cid, CStaffBaseInfo staffBaseInfo, CStaffInfoSyncVo vo) {
        BCompany company = (BCompany)this.companyService.getById(cid);
        if (company == null) {
            return null;
        }
        CStaff entity = new CStaff();
        entity.setBaseId(staffBaseInfo.getId());
        entity.setCid(cid);
        entity.setEditTime(LocalDateTime.now());
        entity.setStaffType(Integer.valueOf(1));
        entity.setPostStatus(PostStatusEnum.ON_POST.getValue());
        entity.setSource(StaffSourceEnum.WAND_DOSE.getValue());
        return entity;
    }

    private boolean canSync(CStaffInfoSyncVo vo) {
        boolean flag = true;
        if (vo.getStaffBaseInfoId() == null) {
            flag = false;
        }
        if (StrUtil.isBlank((CharSequence)vo.getName())) {
            flag = false;
        } else if (StrUtil.contains((CharSequence)vo.getName(), (CharSequence)"*")) {
            flag = false;
        }
        if (StrUtil.isBlank((CharSequence)vo.getIdcard())) {
            flag = false;
        } else if (StrUtil.contains((CharSequence)vo.getIdcard(), (CharSequence)"*")) {
            flag = false;
        }
        if (StrUtil.isBlank((CharSequence)vo.getDoseCheckIdListStr())) {
            flag = false;
        }
        return flag;
    }

    @Generated
    public WandaStaffCMInfoSyncDoseManager(IBCompanyService companyService, ICDoseDataService doseDataService, ICStaffBaseInfoService staffBaseInfoService, ICStaffService staffService, RedissonClient redissonClient, ICStaffErrorService staffErrorService) {
        this.companyService = companyService;
        this.doseDataService = doseDataService;
        this.staffBaseInfoService = staffBaseInfoService;
        this.staffService = staffService;
        this.redissonClient = redissonClient;
        this.staffErrorService = staffErrorService;
    }
}

