/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.rho.modules.sys.manger.staff.relocation;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollUtil;
import cn.smarthse.rho.modules.sys.converter.c.CStaffBaseInfoConverter;
import cn.smarthse.rho.modules.sys.converter.c.CStaffConverter;
import cn.smarthse.rho.modules.sys.entity.b.BCompany;
import cn.smarthse.rho.modules.sys.entity.c.CDoseData;
import cn.smarthse.rho.modules.sys.entity.c.CHealthCheckData;
import cn.smarthse.rho.modules.sys.entity.c.CStaff;
import cn.smarthse.rho.modules.sys.entity.c.CStaffBaseInfo;
import cn.smarthse.rho.modules.sys.entity.c.CTrainingCert;
import cn.smarthse.rho.modules.sys.enums.staff.PostStatusEnum;
import cn.smarthse.rho.modules.sys.enums.staff.StaffSourceEnum;
import cn.smarthse.rho.modules.sys.manger.staff.relocation.StaffRelocateLogManager;
import cn.smarthse.rho.modules.sys.model.c.param.staff.relocation.StaffRelocateBatchParam;
import cn.smarthse.rho.modules.sys.model.c.param.staff.relocation.StaffRelocateParam;
import cn.smarthse.rho.modules.sys.service.b.IBCompanyErrorService;
import cn.smarthse.rho.modules.sys.service.b.IBCompanyService;
import cn.smarthse.rho.modules.sys.service.b.IBOrgService;
import cn.smarthse.rho.modules.sys.service.b.IBPostService;
import cn.smarthse.rho.modules.sys.service.c.ICDoseDataService;
import cn.smarthse.rho.modules.sys.service.c.ICHealthCheckDataService;
import cn.smarthse.rho.modules.sys.service.c.ICStaffBaseInfoService;
import cn.smarthse.rho.modules.sys.service.c.ICStaffErrorService;
import cn.smarthse.rho.modules.sys.service.c.ICStaffService;
import cn.smarthse.rho.modules.sys.service.c.ICStaffWorkExperienceService;
import cn.smarthse.rho.modules.sys.service.c.ICStatisticService;
import cn.smarthse.rho.modules.sys.service.c.ICTrainingCertService;
import cn.smarthse.rho.modules.sys.service.risk.IRiskBasicSourceCommonService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.smarthse.framework.exception.ServiceException;
import lombok.Generated;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@Transactional(readOnly=true)
public class StaffRelocateManager {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(StaffRelocateManager.class);
    @Autowired
    private ICStaffBaseInfoService staffBaseInfoService;
    @Autowired
    private ICStatisticService statisticService;
    @Autowired
    private IRiskBasicSourceCommonService riskBasicSourceService;
    @Autowired
    private ICStaffWorkExperienceService staffWorkExperienceService;
    @Autowired
    private IBCompanyService companyService;
    @Autowired
    private ICStaffService staffService;
    @Autowired
    private IBOrgService orgService;
    @Autowired
    private IBPostService postService;
    @Autowired
    @Lazy
    private StaffRelocateManager self;
    @Autowired
    private CStaffConverter converter;
    @Autowired
    private RedissonClient redissonClient;
    @Autowired
    private ICStaffErrorService staffErrorService;
    @Autowired
    private IBCompanyErrorService companyErrorService;
    @Autowired
    private ICHealthCheckDataService healthCheckDataService;
    @Autowired
    private ICDoseDataService doseDataService;
    @Autowired
    private ICTrainingCertService trainingCertService;
    @Autowired
    private StaffRelocateLogManager staffRelocateLogManager;
    @Autowired
    private CStaffBaseInfoConverter cStaffBaseInfoConverter;

    @Transactional
    public void relocate(StaffRelocateBatchParam batchParam) {
        List paramList = batchParam.getList();
        if (CollUtil.isEmpty((Collection)paramList)) {
            return;
        }
        this.checkData(paramList);
        for (StaffRelocateParam param : paramList) {
            this.relocateOne(param);
        }
    }

    @Transactional
    public void relocateOne(StaffRelocateParam param) {
        this.relocateStaff(param);
        this.staffErrorService.manualMaintenanceOne(param.getStaffBaseInfoId());
        this.companyErrorService.manualMaintenanceOne(param.getBeCid());
    }

    @Transactional
    public void relocateStaff(StaffRelocateParam param) {
        Long beCid = param.getBeCid();
        Long toCid = param.getToCid();
        Long sbId = param.getStaffBaseInfoId();
        CStaff toStaffDB = this.staffService.getByBaseIdAndCidForStaffRelocation(sbId, toCid);
        CStaff beStaffDB = this.staffService.getByBaseIdAndCidForStaffRelocation(sbId, beCid);
        if (toStaffDB == null) {
            CStaff toStaff = new CStaff();
            toStaff.setBaseId(sbId);
            toStaff.setCid(toCid);
            toStaff.setStaffType(Integer.valueOf(1));
            toStaff.setPostStatus(PostStatusEnum.ON_POST.getValue());
            toStaff.setIfRaManager(Integer.valueOf(0));
            toStaff.setSource(StaffSourceEnum.UNIT_RELOCATION.getValue());
            toStaff.setIfRaManager(Integer.valueOf(0));
            toStaff.setRelocateType(Integer.valueOf(1));
            toStaff.setRelocatePrimitiveId(beStaffDB.getRelocateType() == 0 ? beStaffDB.getId() : beStaffDB.getRelocatePrimitiveId());
            toStaff.setRelocateSourceId(beStaffDB.getId());
            this.staffService.save(toStaff);
        }
        this.staffService.removeById(beStaffDB.getId());
        this.riskBasicSourceService.deleteByBaseIdAndCid(sbId, beCid);
        this.staffWorkExperienceService.deleteByBaseIdAndCid(sbId, beCid);
        this.staffRelocateLogManager.addLog(sbId, beCid, toCid);
    }

    @Transactional
    public void relocateHc(StaffRelocateParam param) {
        Long sbId = param.getStaffBaseInfoId();
        Long beCid = param.getBeCid();
        Long toCid = param.getToCid();
        List<CHealthCheckData> sourceList = this.healthCheckDataService.getListForRelocating(param);
        ArrayList<Long> needDelRelocateIdList = new ArrayList<Long>();
        ArrayList<CHealthCheckData> relocateList = new ArrayList<CHealthCheckData>();
        for (CHealthCheckData data : sourceList) {
            CHealthCheckData relocateData = new CHealthCheckData();
            BeanUtil.copyProperties((Object)data, (Object)relocateData, (String[])new String[]{"id", "createDate", "updateDate", "createBy", "updateBy", "isValid"});
            relocateData.setRelocateType(Integer.valueOf(1));
            relocateData.setRelocatePrimitiveId(data.getRelocateType() == 0 ? data.getId() : data.getRelocatePrimitiveId());
            relocateData.setRelocateSourceId(data.getId());
            relocateData.setCid(toCid);
            relocateData.setRelocateTargetCid(toCid);
            relocateList.add(relocateData);
            needDelRelocateIdList.add(data.getId());
        }
        this.healthCheckDataService.saveBatch(relocateList);
        this.healthCheckDataService.removeByIds(needDelRelocateIdList);
    }

    @Transactional
    public void relocateDose(StaffRelocateParam param) {
        Long sbId = param.getStaffBaseInfoId();
        Long beCid = param.getBeCid();
        Long toCid = param.getToCid();
        List<CDoseData> sourceList = this.doseDataService.getListForRelocating(param);
        ArrayList<Long> needDelRelocateIdList = new ArrayList<Long>();
        ArrayList<CDoseData> relocateList = new ArrayList<CDoseData>();
        for (CDoseData data : sourceList) {
            CDoseData relocateData = new CDoseData();
            BeanUtil.copyProperties((Object)data, (Object)relocateData, (String[])new String[]{"id", "createDate", "updateDate", "createBy", "updateBy", "isValid"});
            relocateData.setRelocateType(Integer.valueOf(1));
            relocateData.setRelocatePrimitiveId(data.getRelocateType() == 0 ? data.getId() : data.getRelocatePrimitiveId());
            relocateData.setRelocateSourceId(data.getId());
            relocateData.setCid(toCid);
            relocateData.setRelocateTargetCid(toCid);
            relocateList.add(relocateData);
            needDelRelocateIdList.add(data.getId());
        }
        this.doseDataService.saveBatch(relocateList);
        this.doseDataService.removeByIds(needDelRelocateIdList);
    }

    @Transactional
    public void relocateTraining(StaffRelocateParam param) {
        Long sbId = param.getStaffBaseInfoId();
        Long beCid = param.getBeCid();
        Long toCid = param.getToCid();
        List<CTrainingCert> sourceList = this.trainingCertService.getListForRelocating(param);
        ArrayList<Long> needDelRelocateIdList = new ArrayList<Long>();
        ArrayList<CTrainingCert> relocateList = new ArrayList<CTrainingCert>();
        for (CTrainingCert data : sourceList) {
            CTrainingCert relocateData = new CTrainingCert();
            BeanUtil.copyProperties((Object)data, (Object)relocateData, (String[])new String[]{"id", "createDate", "updateDate", "createBy", "updateBy", "isValid"});
            relocateData.setRelocateType(Integer.valueOf(1));
            relocateData.setRelocatePrimitiveId(data.getRelocateType() == 0 ? data.getId() : data.getRelocatePrimitiveId());
            relocateData.setRelocateSourceId(data.getId());
            relocateData.setCid(toCid);
            relocateData.setRelocateTargetCid(toCid);
            relocateList.add(relocateData);
            needDelRelocateIdList.add(data.getId());
        }
        this.trainingCertService.saveBatch(relocateList);
        this.trainingCertService.removeByIds(needDelRelocateIdList);
    }

    public void checkData(List<StaffRelocateParam> paramList) {
        Map<Long, Long> duplicateSbIdMap = paramList.stream().filter(param -> param.getStaffBaseInfoId() != null).collect(Collectors.groupingBy(v -> v.getStaffBaseInfoId(), Collectors.counting())).entrySet().stream().filter(entry -> (Long)entry.getValue() >= 2L).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < paramList.size(); ++i) {
            StringBuilder subSb = new StringBuilder();
            StaffRelocateParam param2 = paramList.get(i);
            Long sbId = param2.getStaffBaseInfoId();
            Long beCid = param2.getBeCid();
            Long toCid = param2.getToCid();
            CStaffBaseInfo staffBaseInfo = (CStaffBaseInfo)this.staffBaseInfoService.getById(sbId);
            BCompany beCompany = (BCompany)this.companyService.getById(beCid);
            BCompany toCompany = (BCompany)this.companyService.getById(toCid);
            CStaff beStaff = this.staffService.getByBaseIdAndCidForStaffRelocation(sbId, beCid);
            if (duplicateSbIdMap.containsKey(sbId)) {
                subSb.append("\u4e00\u4e2a\u4eba\u5458\u4e0d\u80fd\u540c\u65f6\u8fc1\u79fb\u4e0d\u540c\u9662\u533a;");
            }
            if (beStaff == null) {
                subSb.append("\u4eba\u5458\u4e0d\u5b58\u5728;");
            } else if (staffBaseInfo == null) {
                subSb.append("\u57fa\u7840\u4fe1\u606f\u4e0d\u5b58\u5728\u3002");
            }
            if (beCompany == null) {
                subSb.append("\u5f53\u524d\u4e0d\u9662\u533a\u5b58\u5728\u3002");
            }
            if (toCompany == null) {
                subSb.append("\u76ee\u6807\u9662\u533a\u4e0d\u5b58\u5728\u3002");
            }
            if (beCid != null && toCid != null && beCid.equals(toCid)) {
                subSb.append("\u5f53\u524d\u9662\u533a\u4e0e\u76ee\u6807\u9662\u533a\u4e0d\u80fd\u76f8\u540c\u3002");
            }
            if (beCompany != null && toCompany != null && !beCompany.getCreditCode().equals(toCompany.getCreditCode())) {
                subSb.append("\u8fc1\u79fb\u76ee\u6807\u9662\u533a\u4fe1\u7528\u4ee3\u7801\u9700\u548c\u5f53\u524d\u9662\u533a\u65b0\u540c\u3002");
            }
            if (subSb.length() <= 0) continue;
            sb.append("\u7b2c").append(i + 1).append("\u884c\u4eba\u6570\u636e\uff1a").append((CharSequence)subSb).append("\\n");
        }
        if (sb.length() > 0) {
            throw new ServiceException(sb.toString());
        }
    }
}

