/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.rho.modules.sys.manger.staff.relocation;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.IdcardUtil;
import cn.hutool.core.util.StrUtil;
import cn.smarthse.framework.core.domain.ResponseStateEnum;
import cn.smarthse.rho.modules.sys.converter.c.CStaffBaseInfoConverter;
import cn.smarthse.rho.modules.sys.converter.c.CStaffConverter;
import cn.smarthse.rho.modules.sys.entity.b.BCompany;
import cn.smarthse.rho.modules.sys.entity.b.BOrg;
import cn.smarthse.rho.modules.sys.entity.b.BPost;
import cn.smarthse.rho.modules.sys.entity.c.CStaff;
import cn.smarthse.rho.modules.sys.entity.c.CStaffBaseInfo;
import cn.smarthse.rho.modules.sys.model.c.vo.staff.StaffRelocationImportResultVo;
import cn.smarthse.rho.modules.sys.model.easyexcel.staff.StaffRelocationImportDto;
import cn.smarthse.rho.modules.sys.service.b.IBCompanyService;
import cn.smarthse.rho.modules.sys.service.b.IBOrgService;
import cn.smarthse.rho.modules.sys.service.b.IBPostService;
import cn.smarthse.rho.modules.sys.service.c.ICDoseDataService;
import cn.smarthse.rho.modules.sys.service.c.ICHealthCheckDataService;
import cn.smarthse.rho.modules.sys.service.c.ICStaffBaseInfoService;
import cn.smarthse.rho.modules.sys.service.c.ICStaffErrorService;
import cn.smarthse.rho.modules.sys.service.c.ICStaffService;
import cn.smarthse.rho.modules.sys.service.c.ICStaffWorkExperienceService;
import cn.smarthse.rho.modules.sys.service.c.ICStatisticService;
import cn.smarthse.rho.modules.sys.service.c.ICTrainingCertService;
import cn.smarthse.rho.modules.sys.service.risk.IRiskBasicSourceCommonService;
import com.alibaba.fastjson2.JSON;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.smarthse.framework.exception.ServiceException;
import lombok.Generated;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@Transactional(readOnly=true)
public class StaffRelocateImportManager {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(StaffRelocateImportManager.class);
    @Autowired
    private ICStaffBaseInfoService staffBaseInfoService;
    @Autowired
    private ICStatisticService statisticService;
    @Autowired
    private IRiskBasicSourceCommonService riskBasicSourceService;
    @Autowired
    private ICStaffWorkExperienceService staffWorkExperienceService;
    @Autowired
    private IBCompanyService companyService;
    @Autowired
    private ICStaffService staffService;
    @Autowired
    private IBOrgService orgService;
    @Autowired
    private IBPostService postService;
    @Autowired
    @Lazy
    private StaffRelocateImportManager self;
    @Autowired
    private CStaffConverter converter;
    @Autowired
    private RedissonClient redissonClient;
    @Autowired
    private ICStaffErrorService staffErrorService;
    @Autowired
    private ICHealthCheckDataService healthCheckDataService;
    @Autowired
    private ICDoseDataService doseDataService;
    @Autowired
    private ICTrainingCertService trainingCertService;
    @Autowired
    private CStaffBaseInfoConverter cStaffBaseInfoConverter;

    public List<StaffRelocationImportResultVo> importRelation(List<StaffRelocationImportDto> dtoList, Long currCid) {
        this.checkData(dtoList, currCid);
        return this.genResult(dtoList, currCid);
    }

    private List<StaffRelocationImportResultVo> genResult(List<StaffRelocationImportDto> dtoList, Long currCid) {
        dtoList = dtoList.stream().filter(v -> StrUtil.equals((CharSequence)v.getNeedRelocation(), (CharSequence)"\u662f")).collect(Collectors.toList());
        ArrayList<StaffRelocationImportResultVo> resultList = new ArrayList<StaffRelocationImportResultVo>();
        for (StaffRelocationImportDto staffRelocationImportDto : dtoList) {
            String idcard = staffRelocationImportDto.getIdcard();
            String beCompanyName = staffRelocationImportDto.getBeCompanyName();
            String toCompanyName = staffRelocationImportDto.getToCompanyName();
            CStaffBaseInfo oneByIdCard = this.staffBaseInfoService.getOneByIdCard(idcard);
            BCompany beCompany = this.companyService.getByName(beCompanyName);
            BCompany toCompany = this.companyService.getByName(toCompanyName);
            CStaff staff = this.staffService.getByBaseIdAndCidForStaffRelocation(oneByIdCard.getId(), currCid);
            BOrg org = (BOrg)this.orgService.getById(staff.getOrgId());
            boolean validCard = IdcardUtil.isValidCard15((String)oneByIdCard.getIdcard()) || IdcardUtil.isValidCard18((String)idcard);
            Integer sex = validCard ? Integer.valueOf(IdcardUtil.getGenderByIdCard((String)idcard)) : oneByIdCard.getSex();
            Integer age = validCard ? Integer.valueOf(IdcardUtil.getAgeByIdCard((String)idcard)) : oneByIdCard.getAge();
            StaffRelocationImportResultVo result = new StaffRelocationImportResultVo();
            result.setId(oneByIdCard.getId());
            result.setStaffBaseInfoId(oneByIdCard.getId());
            result.setName(oneByIdCard.getName());
            result.setIdcard(oneByIdCard.getIdcard());
            result.setSex(sex);
            result.setAge(age);
            result.setBeCid(beCompany.getId());
            result.setBeCompanyName(beCompany.getName());
            result.setToCid(toCompany.getId());
            result.setToCompanyName(beCompany.getName());
            result.setPost(staff.getPost());
            result.setPostStatus(staff.getPostStatus());
            BPost postDB = (BPost)this.postService.getById(staff.getPost());
            result.setPostName(postDB == null ? null : postDB.getName());
            if (org != null) {
                result.setOrgId(org.getId());
                result.setOrgName(org.getName());
            }
            resultList.add(result);
        }
        return resultList;
    }

    private void checkData(List<StaffRelocationImportDto> dtoList, Long currCid) {
        if (currCid == null) {
            throw new ServiceException("\u65e0\u6cd5\u8bc6\u522b\u767b\u5f55\u9662\u533a\uff0c\u5bfc\u5165\u5931\u8d25");
        }
        if (CollUtil.isEmpty(dtoList)) {
            throw new ServiceException("\u672a\u53d1\u73b0\u53ef\u5bfc\u5165\u7684\u6570\u636e\uff0c\u8bf7\u68c0\u67e5\u6587\u4ef6\u5185\u5bb9\u3002");
        }
        List tempList = dtoList.stream().filter(v -> StrUtil.equals((CharSequence)v.getNeedRelocation(), (CharSequence)"\u662f")).collect(Collectors.toList());
        if (CollUtil.isEmpty(tempList)) {
            throw new ServiceException("\u672a\u53d1\u73b0\u9700\u8981\u8fc1\u79fb\u7684\u8bb0\u5f55\uff0c\u8bf7\u68c0\u67e5\u6587\u4ef6\u5185\u5bb9\u3002");
        }
        ArrayList<StaffRelocationImportDto> errorInfoList = new ArrayList<StaffRelocationImportDto>();
        for (StaffRelocationImportDto dto : dtoList) {
            StringBuilder sb = new StringBuilder();
            String name = dto.getName();
            String idcard = dto.getIdcard();
            String beCompanyName = dto.getBeCompanyName();
            String toCompanyName = dto.getToCompanyName();
            String needRelocation = dto.getNeedRelocation();
            if (!StrUtil.equals((CharSequence)needRelocation, (CharSequence)"\u662f")) {
                if (StrUtil.isNotBlank((CharSequence)toCompanyName)) {
                    sb.append("\u76ee\u6807\u9662\u533a\u5df2\u586b\u5199\uff0c\u4f46\u201c\u662f\u5426\u8fc1\u79fb\u201d\u4e3a\u201c\u5426\u201d\u6216\u4e3a\u7a7a\u3002");
                }
            } else {
                if (StrUtil.isBlank((CharSequence)name)) {
                    sb.append("\u59d3\u540d\u4e0d\u80fd\u4e3a\u7a7a\u3002");
                }
                CStaffBaseInfo oneByIdCard = null;
                if (StrUtil.isBlank((CharSequence)idcard)) {
                    sb.append("\u8eab\u4efd\u8bc1\u53f7\u4e0d\u80fd\u4e3a\u7a7a\u3002");
                } else {
                    oneByIdCard = this.staffBaseInfoService.getOneByIdCard(idcard);
                    if (oneByIdCard == null) {
                        sb.append("\u4eba\u5458\u4e0d\u5b58\u5728\u3002");
                    }
                }
                if (oneByIdCard != null) {
                    CStaff staff = this.staffService.getByBaseIdAndCidForStaffRelocation(oneByIdCard.getId(), currCid);
                    if (staff == null) {
                        sb.append("\u4eba\u5458\u4e0d\u5b58\u5728!");
                    } else if (StrUtil.isNotBlank((CharSequence)name) && !name.equals(oneByIdCard.getName())) {
                        sb.append("\u59d3\u540d\u586b\u5199\u9519\u8bef\u3002");
                    }
                }
                BCompany beCompany = null;
                if (StrUtil.isBlank((CharSequence)beCompanyName)) {
                    sb.append("\u5f53\u524d\u9662\u533a\u4e0d\u80fd\u4e3a\u7a7a\u3002");
                } else {
                    beCompany = this.companyService.getByName(beCompanyName);
                    if (beCompany == null) {
                        sb.append("\u5f53\u524d\u9662\u533a\u4e0d\u5b58\u5728\u3002");
                    } else if (!beCompany.getId().equals(currCid)) {
                        sb.append("\u5f53\u524d\u9662\u533a\u4e0e\u767b\u5f55\u9662\u533a\u4e0d\u4e00\u81f4\u3002");
                    }
                }
                BCompany toCompany = null;
                if (StrUtil.isBlank((CharSequence)toCompanyName)) {
                    sb.append("\u76ee\u6807\u9662\u533a\u4e0d\u80fd\u4e3a\u7a7a\u3002");
                } else {
                    toCompany = this.companyService.getByName(toCompanyName);
                    if (toCompany == null) {
                        sb.append("\u76ee\u6807\u9662\u533a\u4e0d\u5b58\u5728\u3002");
                    }
                }
                if (StrUtil.isAllNotBlank((CharSequence[])new CharSequence[]{beCompanyName, toCompanyName}) && StrUtil.equals((CharSequence)beCompanyName, (CharSequence)toCompanyName)) {
                    sb.append("\u5f53\u524d\u9662\u533a\u548c\u76ee\u6807\u9662\u533a\u4e0d\u80fd\u76f8\u540c\u3002");
                }
                if (beCompany != null && toCompany != null) {
                    if (StrUtil.isBlank((CharSequence)beCompany.getCreditCode()) || StrUtil.isBlank((CharSequence)toCompany.getCreditCode())) {
                        sb.append("\u9662\u533a\u7f3a\u5931\u793e\u4f1a\u4fe1\u7528\u4ee3\u7801\uff0c\u65e0\u6cd5\u8fc1\u79fb\u3002");
                    } else if (!beCompany.getCreditCode().equals(toCompany.getCreditCode())) {
                        sb.append("\u5f53\u524d\u9662\u533a\u4e0e\u76ee\u6807\u9662\u533a\u4fe1\u7528\u4ee3\u7801\u4e0d\u76f8\u540c\uff0c\u65e0\u6cd5\u8fc1\u79fb\u3002");
                    }
                }
            }
            if (sb.length() <= 0) continue;
            dto.setName(null);
            dto.setIdcard(null);
            dto.setHaveError(Boolean.valueOf(true));
            dto.setErrorReason(sb.toString());
            errorInfoList.add(dto);
        }
        if (errorInfoList.size() > 0) {
            throw new ServiceException(ResponseStateEnum.fail_deal.getValue(), "\u5bfc\u5165\u5931\u8d25\u00b7\uff0c\u8bf7\u6839\u636e\u9519\u8bef\u4fe1\u606f\u4fee\u6539\u540e\u91cd\u65b0\u5bfc\u5165", (Object)JSON.toJSONString(errorInfoList));
        }
    }
}

