/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.rho.modules.sys.manger.staff.baseInfoSync;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.IdcardUtil;
import cn.hutool.core.util.StrUtil;
import cn.smarthse.framework.sensitive.enumd.DesensitizationType;
import cn.smarthse.framework.sensitive.utils.DesensitizationUtils;
import cn.smarthse.rho.modules.sys.entity.c.CStaffBaseInfo;
import cn.smarthse.rho.modules.sys.enums.staff.StaffSourceEnum;
import cn.smarthse.rho.modules.sys.manger.staff.baseInfoSync.WandaStaffBaseInfoSyncHCManager;
import cn.smarthse.rho.modules.sys.model.b.vo.CStaffInfoSyncVo;
import cn.smarthse.rho.modules.sys.model.wanda.sync.param.WandaSyncParam;
import cn.smarthse.rho.modules.sys.service.c.ICStaffBaseInfoService;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import lombok.Generated;
import org.redisson.api.RLock;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Component
public class WandaStaffBaseInfoSyncTrainingManager {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WandaStaffBaseInfoSyncTrainingManager.class);
    private final ICStaffBaseInfoService staffBaseInfoService;
    private final RedissonClient redissonClient;
    @Autowired
    private ApplicationContext applicationContext;
    @Autowired
    @Lazy
    private WandaStaffBaseInfoSyncTrainingManager self;
    private static final String LOCK_KEY = "WandaStaffBaseInfoSyncManager";
    public static final Integer saveBatchNum = WandaStaffBaseInfoSyncHCManager.saveBatchNum;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void syncStaffBaseInfoFromTraining(WandaSyncParam param) {
        log.debug("wanda\u4eba\u5458\u540c\u6b65\uff1a syncWandaStaffData() start");
        StringBuilder sb = new StringBuilder(LOCK_KEY);
        RLock lock = this.redissonClient.getLock(sb.toString());
        boolean resLock = false;
        try {
            resLock = lock.tryLock(1L, 3600L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        if (resLock) {
            try {
                this.self.syncWandaStaffDataLock(param);
                log.debug("wanda\u4eba\u5458\u540c\u6b65\uff1a syncWandaStaffData() end");
            }
            catch (Exception e) {
                log.error("\u3010\u4eba\u5458\u57fa\u7840\u4fe1\u606f\u540c\u6b65\u3011\u3010\u57f9\u8bad\u3011\u3010\u6574\u4f53\u3011\u5931\u8d25,e:{}", (Throwable)e);
            }
            finally {
                lock.unlock();
            }
        } else {
            log.error("{}\uff1aPending lock timeout\uff0c\u3010\u4eba\u5458\u540c\u6b65\u9501\u3011\u3010\u57f9\u8bad\u3011\u7b49\u5f85\u8d85\u65f6", (Object)LOCK_KEY);
        }
    }

    public void syncWandaStaffDataLock(WandaSyncParam param) {
        List<CStaffInfoSyncVo> list = this.staffBaseInfoService.getWandaSyncInfoFromTrainingData(param);
        List<CStaffInfoSyncVo> canSyncList = list.stream().filter(v -> this.canSync((CStaffInfoSyncVo)v)).collect(Collectors.toList());
        if (CollUtil.isNotEmpty(canSyncList)) {
            for (CStaffInfoSyncVo vo : canSyncList) {
                vo.setIdcard(StrUtil.toUpperCase((CharSequence)vo.getIdcard()));
            }
            try {
                this.self.saveStaffBaseInfo(canSyncList);
            }
            catch (Exception e) {
                log.error("\u3010\u4eba\u5458\u57fa\u7840\u4fe1\u606f\u540c\u6b65\u3011\u3010\u57f9\u8bad\u3011\u5931\u8d25\uff1a{}", (Throwable)e);
            }
        }
    }

    public void saveStaffBaseInfo(List<CStaffInfoSyncVo> canSyncList) {
        ArrayList<CStaffBaseInfo> resultList = new ArrayList<CStaffBaseInfo>();
        for (CStaffInfoSyncVo vo : canSyncList) {
            try {
                this.self.genOne(vo, resultList);
            }
            catch (Exception e) {
                log.error("\u3010\u4eba\u5458\u57fa\u7840\u4fe1\u606f\u540c\u6b65\u3011\u3010\u4e2a\u4eba\u5242\u91cf\u3011\u3010\u5355\u4e2a\u3011\u5931\u8d25name:{},idCard:{}\uff0ce\uff1a{}", new Object[]{DesensitizationUtils.desensitized((CharSequence)vo.getName(), (DesensitizationType)DesensitizationType.NAME), DesensitizationUtils.desensitized((CharSequence)vo.getIdcard(), (DesensitizationType)DesensitizationType.ID_CARD), e});
            }
            if (resultList.size() < saveBatchNum) continue;
            this.staffBaseInfoService.saveBatch(resultList);
            resultList.clear();
        }
        if (CollUtil.isNotEmpty(resultList)) {
            this.staffBaseInfoService.saveBatch(resultList);
        }
    }

    public void genOne(CStaffInfoSyncVo vo, List<CStaffBaseInfo> resultList) {
        CStaffBaseInfo entity = this.staffBaseInfoService.getOneByIdCard(vo.getIdcard());
        if (entity == null) {
            entity = this.wandaSyncInfo2BaseInfoEntity(vo);
            resultList.add(entity);
        }
    }

    public CStaffBaseInfo wandaSyncInfo2BaseInfoEntity(CStaffInfoSyncVo vo) {
        CStaffBaseInfo entity = new CStaffBaseInfo();
        String idcard = vo.getIdcard();
        boolean validCard = IdcardUtil.isValidCard((String)idcard);
        Integer sex = validCard ? Integer.valueOf(IdcardUtil.getGenderByIdCard((String)idcard)) : vo.getSex();
        Integer age = validCard ? Integer.valueOf(IdcardUtil.getAgeByIdCard((String)idcard)) : vo.getAge();
        LocalDate birthday = validCard ? LocalDate.from(DateUtil.toLocalDateTime((Date)IdcardUtil.getBirthDate((String)idcard))) : vo.getBirthday();
        entity.setSourceId(vo.getSourceId());
        entity.setName(vo.getName());
        entity.setPhone(vo.getPhone());
        entity.setIdcardType(vo.getIdcardType());
        entity.setIdcard(idcard);
        entity.setSex(sex);
        entity.setAge(age);
        entity.setBirthday(birthday);
        entity.setSource(StaffSourceEnum.HSE_TRAIN.getValue());
        entity.setRaType(vo.getRaType());
        return entity;
    }

    private boolean canSync(CStaffInfoSyncVo vo) {
        boolean flag = true;
        if (StrUtil.isBlank((CharSequence)vo.getName())) {
            flag = false;
        } else if (StrUtil.contains((CharSequence)vo.getName(), (CharSequence)"*")) {
            flag = false;
        }
        if (StrUtil.isBlank((CharSequence)vo.getIdcard())) {
            flag = false;
        } else if (StrUtil.contains((CharSequence)vo.getIdcard(), (CharSequence)"*")) {
            flag = false;
        }
        return flag;
    }

    @Generated
    public WandaStaffBaseInfoSyncTrainingManager(ICStaffBaseInfoService staffBaseInfoService, RedissonClient redissonClient) {
        this.staffBaseInfoService = staffBaseInfoService;
        this.redissonClient = redissonClient;
    }
}

