/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.rho.modules.sys.manger.staff;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.date.LocalDateTimeUtil;
import cn.hutool.core.util.IdcardUtil;
import cn.hutool.core.util.NumberUtil;
import cn.hutool.core.util.StrUtil;
import cn.smarthse.framework.core.domain.ResponseStateEnum;
import cn.smarthse.framework.sensitive.enumd.DesensitizationType;
import cn.smarthse.framework.sensitive.utils.DesensitizationUtils;
import cn.smarthse.rho.core.framework.ShiroCommonUtil;
import cn.smarthse.rho.modules.sys.entity.b.BCompany;
import cn.smarthse.rho.modules.sys.entity.b.BOrg;
import cn.smarthse.rho.modules.sys.entity.b.BPost;
import cn.smarthse.rho.modules.sys.entity.c.CStaff;
import cn.smarthse.rho.modules.sys.entity.c.CStaffBaseInfo;
import cn.smarthse.rho.modules.sys.enums.lock.DistributedLockEnum;
import cn.smarthse.rho.modules.sys.enums.staff.PostStatusEnum;
import cn.smarthse.rho.modules.sys.enums.staff.RayCodeEnum;
import cn.smarthse.rho.modules.sys.enums.staff.StaffSourceEnum;
import cn.smarthse.rho.modules.sys.enums.staff.StaffTypeEnum;
import cn.smarthse.rho.modules.sys.manger.staff.StaffEditManager;
import cn.smarthse.rho.modules.sys.model.c.param.CStaffEditParam;
import cn.smarthse.rho.modules.sys.model.easyexcel.StaffImportDtoV2;
import cn.smarthse.rho.modules.sys.provider.company.IPostProvider;
import cn.smarthse.rho.modules.sys.service.b.IBCompanyService;
import cn.smarthse.rho.modules.sys.service.b.IBOrgService;
import cn.smarthse.rho.modules.sys.service.c.ICStaffBaseInfoService;
import cn.smarthse.rho.modules.sys.service.c.ICStaffErrorService;
import cn.smarthse.rho.modules.sys.service.c.ICStaffService;
import cn.smarthse.rho.modules.sys.utils.staff.StaffNameStorageUtil;
import com.alibaba.fastjson2.JSON;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.smarthse.framework.exception.ServiceException;
import lombok.Generated;
import org.redisson.api.RLock;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@Transactional(readOnly=true)
public class StaffImportManagerV2 {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(StaffImportManagerV2.class);
    private final RedissonClient redissonClient;
    private final ICStaffBaseInfoService staffBaseInfoService;
    private final ICStaffService staffService;
    private final IBCompanyService companyService;
    private final IBOrgService orgService;
    private final IPostProvider postProvider;
    private final StaffEditManager staffEditManager;
    private final ICStaffErrorService staffErrorService;
    public static final String IMPORT_ONE_STAFF_SUCCESS = "\u6210\u529f";
    public static final String ORG_NAME_SEPARATOR = ">";
    public static final String TIME_FORMATTER = "yyyy/MM/dd";

    @Transactional
    public String importStaff(List<StaffImportDtoV2> importInfoList, Long afterSwitchCid) {
        Long cid = ShiroCommonUtil.getJWTOidOrCid();
        if (cid == null) {
            throw new ServiceException("\u65e0\u6cd5\u6821\u9a8c\u5f53\u524d\u767b\u5f55\u4fe1\u606f\uff0c\u5bfc\u5165\u5931\u8d25!");
        }
        if (afterSwitchCid == null) {
            throw new ServiceException("\u65e0\u6cd5\u6821\u9a8c\u5f53\u524d\u9662\u533a\uff0c\u5bfc\u5165\u5931\u8d25!");
        }
        StringBuilder sb = new StringBuilder(DistributedLockEnum.IMPORT_STAFF_BATCH.getKey()).append(cid);
        RLock lock = this.redissonClient.getLock(sb.toString());
        boolean resLock = false;
        try {
            resLock = lock.tryLock(60L, 60L, TimeUnit.MINUTES);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        if (resLock) {
            try {
                String e = this.importStaffLock(importInfoList, afterSwitchCid);
                return e;
            }
            catch (ServiceException e) {
                throw e;
            }
            catch (Exception e) {
                log.error(e.getMessage());
                throw e;
            }
            finally {
                if (lock != null && lock.isHeldByCurrentThread()) {
                    lock.unlock();
                }
            }
        }
        log.error("{}\uff1aPending lock timeout\uff0cmethod:importStaff()", (Object)sb);
        throw new ServiceException("\u6574\u4f53\u8d85\u65f6");
    }

    @Transactional
    public String importStaffLock(List<StaffImportDtoV2> importInfoList, Long afterSwitchCid) {
        for (StaffImportDtoV2 staffImportDtoV2 : importInfoList) {
            staffImportDtoV2.setIdcard(StrUtil.toUpperCase((CharSequence)staffImportDtoV2.getIdcard()));
            staffImportDtoV2.setName(StaffNameStorageUtil.dealName((String)staffImportDtoV2.getName()));
        }
        this.checkImportInfoList(importInfoList, afterSwitchCid);
        ArrayList<StaffImportDtoV2> errorInfoList = new ArrayList<StaffImportDtoV2>();
        for (StaffImportDtoV2 staffImportDto : importInfoList) {
            staffImportDto.setAfterSelectCid(afterSwitchCid);
            String result = this.importOneStaff(staffImportDto);
            if (result.equals(IMPORT_ONE_STAFF_SUCCESS)) continue;
            staffImportDto.setHaveError(Boolean.valueOf(true));
            staffImportDto.setErrorReason(result);
            errorInfoList.add(staffImportDto);
        }
        return errorInfoList.size() > 0 ? JSON.toJSONString(errorInfoList) : null;
    }

    private void checkImportInfoList(List<StaffImportDtoV2> importInfoList, Long afterSwitchCid) {
        BCompany afterSelectCompany = (BCompany)this.companyService.getById(afterSwitchCid);
        if (afterSelectCompany == null) {
            throw new ServiceException("\u65e0\u6cd5\u83b7\u53d6\u5f53\u524d\u9662\u533a\u4fe1\u606f\uff0c\u5bfc\u5165\u5931\u8d25");
        }
        StringBuilder stringBuilder = new StringBuilder();
        Map<String, List<StaffImportDtoV2>> idcardMap = importInfoList.stream().filter(v -> StrUtil.isNotBlank((CharSequence)v.getIdcard())).collect(Collectors.groupingBy(v -> v.getIdcard()));
        idcardMap.forEach((idCard, list) -> {
            if (list.size() >= 2) {
                stringBuilder.append("\u8eab\u4efd\u8bc1").append(DesensitizationUtils.desensitized((CharSequence)idCard, (DesensitizationType)DesensitizationType.ID_CARD)).append("\u5728excel\u4e2d\u91cd\u590d\u5b58\u5728\u3002");
            }
        });
        if (stringBuilder.length() > 0) {
            throw new ServiceException(stringBuilder.toString());
        }
        BCompany company = afterSelectCompany;
        ArrayList<StaffImportDtoV2> errorInfoList = new ArrayList<StaffImportDtoV2>();
        for (StaffImportDtoV2 dto : importInfoList) {
            BPost post;
            StringBuilder sb = new StringBuilder();
            if (StrUtil.isBlank((CharSequence)dto.getName())) {
                sb.append("\u59d3\u540d\u4e0d\u80fd\u4e3a\u7a7a\u3002");
            }
            if (StrUtil.isBlank((CharSequence)dto.getPhone())) {
                sb.append("\u624b\u673a\u53f7\u4e0d\u80fd\u4e3a\u7a7a\u3002");
            }
            if (StrUtil.isBlank((CharSequence)dto.getIdcard())) {
                sb.append("\u8eab\u4efd\u8bc1\u4e0d\u80fd\u4e3a\u7a7a\u3002");
            } else if (!IdcardUtil.isValidCard((String)dto.getIdcard())) {
                sb.append("\u8eab\u4efd\u8bc1\u683c\u5f0f\u9519\u8bef\u3002");
            }
            if (StrUtil.isBlank((CharSequence)dto.getRaType())) {
                sb.append("\u804c\u4e1a\u7167\u5c04\u79cd\u7c7b\u53ca\u4ee3\u7801\u4e0d\u80fd\u4e3a\u7a7a\u3002");
            } else {
                String rayType;
                List split = StrUtil.split((CharSequence)dto.getRaType(), (CharSequence)"\uff1a");
                String string = CollUtil.isEmpty((Collection)split) ? null : (rayType = split.size() >= 2 ? (String)split.get(1) : (String)split.get(0));
                if (StrUtil.isBlank(rayType) || StrUtil.isBlank((CharSequence)RayCodeEnum.getCode(rayType))) {
                    sb.append("\u804c\u4e1a\u7167\u5c04\u79cd\u7c7b\u53ca\u4ee3\u7801\u9519\u8bef\u3002");
                }
            }
            String orgName = dto.getOrgName();
            if (StrUtil.isBlank((CharSequence)orgName)) {
                sb.append("\u90e8\u95e8\u4e0d\u80fd\u4e3a\u7a7a\u3002");
            } else if (company != null) {
                BOrg org;
                Integer addressType = company.getAddressType();
                if (addressType == 0 && (org = this.orgService.getCompanyOrgByCascadeName(company.getId(), orgName, ORG_NAME_SEPARATOR)) == null) {
                    sb.append("\u90e8\u95e8\u4e0d\u5b58\u5728\u3002");
                }
                if (addressType == 1 && (org = this.orgService.getMultipleAddressCompanyOrgByCascadeName(company.getId(), orgName, ORG_NAME_SEPARATOR)) == null) {
                    sb.append("\u90e8\u95e8\u4e0d\u5b58\u5728\u3002");
                }
            }
            String postName = dto.getPostName();
            if (StrUtil.isBlank((CharSequence)postName)) {
                sb.append("\u5c97\u4f4d\u4e0d\u80fd\u4e3a\u7a7a\u3002");
            } else if (company != null && (post = this.postProvider.getPostInfoForImporting(company.getId(), postName)) == null) {
                sb.append("\u5c97\u4f4d\u4e0d\u5b58\u5728\u3002");
            }
            String postStartTime = dto.getPostStartTime();
            if (StrUtil.isBlank((CharSequence)postStartTime)) {
                sb.append("\u672c\u5c97\u4f4d\u4e0a\u5c97\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a\u3002");
            } else {
                try {
                    LocalDateTime localDateTime = LocalDateTimeUtil.parse((CharSequence)postStartTime, (DateTimeFormatter)DateTimeFormatter.ofPattern(TIME_FORMATTER));
                }
                catch (Exception e) {
                    sb.append("\u672c\u5c97\u4f4d\u4e0a\u5c97\u65f6\u95f4\u683c\u5f0f\u9519\u8bef\u3002");
                }
            }
            if (sb.length() <= 0) continue;
            dto.setHaveError(Boolean.valueOf(true));
            dto.setErrorReason(sb.toString());
            errorInfoList.add(dto);
        }
        if (errorInfoList.size() > 0) {
            throw new ServiceException(ResponseStateEnum.fail_deal.getValue(), "\u5bfc\u5165\u5931\u8d25\u00b7\uff0c\u8bf7\u6839\u636e\u9519\u8bef\u4fe1\u606f\u4fee\u6539\u540e\u91cd\u65b0\u5bfc\u5165", (Object)JSON.toJSONString(errorInfoList));
        }
    }

    @Transactional
    public String importOneStaff(StaffImportDtoV2 staffImportDto) {
        StringBuilder sb = new StringBuilder(DistributedLockEnum.EDIT_STAFF_INFO.getKey()).append(staffImportDto.getIdcard());
        RLock lock = this.redissonClient.getLock(sb.toString());
        boolean resLock = false;
        try {
            resLock = lock.tryLock(5L, 5L, TimeUnit.MINUTES);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        if (resLock) {
            try {
                String e = this.importOneStaffLock(staffImportDto);
                return e;
            }
            catch (Exception e) {
                log.error(e.getMessage());
                throw e;
            }
            finally {
                lock.unlock();
            }
        }
        StringBuilder errInfo = new StringBuilder();
        errInfo.append("\u5bfc\u5165\u8d85\u65f6");
        log.error("{}\uff1aPending lock timeout\uff0cmethod:importStaff()", (Object)sb);
        return errInfo.toString();
    }

    @Transactional
    public String importOneStaffLock(StaffImportDtoV2 dto) {
        CStaffBaseInfo db = this.staffBaseInfoService.getOneByIdCard(dto.getIdcard());
        if (db == null) {
            String idcard = dto.getIdcard();
            boolean validCard = IdcardUtil.isValidCard((String)idcard);
            Integer sex = StrUtil.isBlank((CharSequence)dto.getSex()) ? null : Integer.valueOf("\u7537".equals(dto.getSex()) ? 1 : 0);
            Integer n = sex = validCard ? Integer.valueOf(IdcardUtil.getGenderByIdCard((String)idcard)) : sex;
            Integer age = validCard ? Integer.valueOf(IdcardUtil.getAgeByIdCard((String)idcard)) : (NumberUtil.isInteger((String)dto.getAge()) ? Integer.valueOf(dto.getAge()) : null);
            LocalDate birthday = validCard ? LocalDate.from(DateUtil.toLocalDateTime((Date)IdcardUtil.getBirthDate((String)idcard))) : null;
            List split = StrUtil.split((CharSequence)dto.getRaType(), (CharSequence)"\uff1a");
            String rayType = CollUtil.isEmpty((Collection)split) ? null : (split.size() >= 2 ? (String)split.get(1) : (String)split.get(0));
            String rayTypeCode = RayCodeEnum.getCode(rayType);
            CStaffBaseInfo staffBaseInfo = new CStaffBaseInfo();
            staffBaseInfo.setName(dto.getName());
            staffBaseInfo.setPhone(dto.getPhone());
            staffBaseInfo.setIdcard(dto.getIdcard());
            staffBaseInfo.setAge(age);
            staffBaseInfo.setSex(sex);
            staffBaseInfo.setBirthday(birthday);
            staffBaseInfo.setRaType(rayTypeCode);
            staffBaseInfo.setEditTime(LocalDateTime.now());
            staffBaseInfo.setRayStaffTime(LocalDateTimeUtil.parse((CharSequence)dto.getPostStartTime(), (DateTimeFormatter)DateTimeFormatter.ofPattern(TIME_FORMATTER)));
            staffBaseInfo.setSource(StaffSourceEnum.UNIT_IMPORT.getValue());
            this.staffBaseInfoService.save(staffBaseInfo);
            db = staffBaseInfo;
        }
        this.staffErrorService.manualMaintenanceOne(db.getId());
        BCompany company = (BCompany)this.companyService.getById(dto.getAfterSelectCid());
        BOrg org = null;
        if (company.getAddressType() == 0) {
            org = this.orgService.getCompanyOrgByCascadeName(company.getId(), dto.getOrgName(), ORG_NAME_SEPARATOR);
        } else if (company.getAddressType() == 1) {
            org = this.orgService.getMultipleAddressCompanyOrgByCascadeName(company.getId(), dto.getOrgName(), ORG_NAME_SEPARATOR);
        }
        BPost post = this.postProvider.getPostInfoForImporting(company.getId(), dto.getPostName());
        CStaff staffDB = this.staffService.getByBaseIdAndCid(db.getId(), company.getId());
        if (staffDB != null) {
            return "\u8be5\u5458\u5de5\u5df2\u5728\u9662\u533a\u4e2d\uff0c\u65e0\u9700\u91cd\u590d\u5bfc\u5165";
        }
        CStaffEditParam subParam = new CStaffEditParam();
        subParam.setBaseId(db.getId());
        subParam.setCid(company.getId());
        subParam.setOrgId(org.getId());
        subParam.setStaffType(StaffTypeEnum.RAY.getValue());
        subParam.setPost(post.getId());
        subParam.setPostStatus(PostStatusEnum.ON_POST.getValue());
        subParam.setType(Integer.valueOf(1));
        subParam.setPostStartTime(LocalDateTimeUtil.parse((CharSequence)dto.getPostStartTime(), (DateTimeFormatter)DateTimeFormatter.ofPattern(TIME_FORMATTER)));
        subParam.setSource(StaffSourceEnum.UNIT_IMPORT.getValue());
        this.staffEditManager.addStaffInfo(subParam);
        return IMPORT_ONE_STAFF_SUCCESS;
    }

    @Generated
    public StaffImportManagerV2(RedissonClient redissonClient, ICStaffBaseInfoService staffBaseInfoService, ICStaffService staffService, IBCompanyService companyService, IBOrgService orgService, IPostProvider postProvider, StaffEditManager staffEditManager, ICStaffErrorService staffErrorService) {
        this.redissonClient = redissonClient;
        this.staffBaseInfoService = staffBaseInfoService;
        this.staffService = staffService;
        this.companyService = companyService;
        this.orgService = orgService;
        this.postProvider = postProvider;
        this.staffEditManager = staffEditManager;
        this.staffErrorService = staffErrorService;
    }
}

