/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.rho.modules.sys.manger.staff;

import cn.hutool.core.util.IdcardUtil;
import cn.hutool.core.util.StrUtil;
import cn.smarthse.framework.sensitive.utils.DesensitizationUtils;
import cn.smarthse.rho.modules.sys.converter.c.CStaffBaseInfoConverter;
import cn.smarthse.rho.modules.sys.converter.c.CStaffConverter;
import cn.smarthse.rho.modules.sys.entity.b.BCompany;
import cn.smarthse.rho.modules.sys.entity.b.BOrg;
import cn.smarthse.rho.modules.sys.entity.b.BPost;
import cn.smarthse.rho.modules.sys.entity.c.CStaff;
import cn.smarthse.rho.modules.sys.entity.c.CStaffBaseInfo;
import cn.smarthse.rho.modules.sys.entity.c.CStaffWorkExperience;
import cn.smarthse.rho.modules.sys.enums.lock.DistributedLockEnum;
import cn.smarthse.rho.modules.sys.enums.staff.PostStatusEnum;
import cn.smarthse.rho.modules.sys.enums.staff.StaffSourceEnum;
import cn.smarthse.rho.modules.sys.model.c.param.CStaffBaseInfoEditParam;
import cn.smarthse.rho.modules.sys.model.c.param.CStaffDeleteParam;
import cn.smarthse.rho.modules.sys.model.c.param.CStaffEditParam;
import cn.smarthse.rho.modules.sys.model.c.param.StaffStatisticsParam;
import cn.smarthse.rho.modules.sys.model.c.param.staff.CheckStaffRelationParam;
import cn.smarthse.rho.modules.sys.model.c.param.staff.RayManagerEditMainParam;
import cn.smarthse.rho.modules.sys.model.c.param.staff.StaffPostEditParam;
import cn.smarthse.rho.modules.sys.model.c.vo.StaffArchiveListVo;
import cn.smarthse.rho.modules.sys.service.b.IBCompanyService;
import cn.smarthse.rho.modules.sys.service.b.IBOrgService;
import cn.smarthse.rho.modules.sys.service.b.IBPostService;
import cn.smarthse.rho.modules.sys.service.c.ICStaffBaseInfoService;
import cn.smarthse.rho.modules.sys.service.c.ICStaffErrorService;
import cn.smarthse.rho.modules.sys.service.c.ICStaffService;
import cn.smarthse.rho.modules.sys.service.c.ICStaffWorkExperienceService;
import cn.smarthse.rho.modules.sys.service.c.ICStatisticService;
import cn.smarthse.rho.modules.sys.service.risk.IRiskBasicSourceCommonService;
import cn.smarthse.rho.modules.sys.utils.staff.StaffNameStorageUtil;
import java.time.LocalDateTime;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.smarthse.framework.exception.ServiceException;
import lombok.Generated;
import org.redisson.api.RLock;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@Transactional(readOnly=true)
public class StaffEditManager {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(StaffEditManager.class);
    @Autowired
    private ICStaffBaseInfoService staffBaseInfoService;
    @Autowired
    private ICStatisticService statisticService;
    @Autowired
    private IRiskBasicSourceCommonService riskBasicSourceService;
    @Autowired
    private ICStaffWorkExperienceService staffWorkExperienceService;
    @Autowired
    private IBCompanyService companyService;
    @Autowired
    private ICStaffService staffService;
    @Autowired
    private IBOrgService orgService;
    @Autowired
    private IBPostService postService;
    @Autowired
    @Lazy
    private StaffEditManager self;
    @Autowired
    private CStaffConverter converter;
    @Autowired
    private RedissonClient redissonClient;
    @Autowired
    private ICStaffErrorService staffErrorService;
    @Autowired
    private CStaffBaseInfoConverter cStaffBaseInfoConverter;

    @Transactional
    public void addManager(CStaffBaseInfoEditParam param) {
        param.setName(StaffNameStorageUtil.dealName((String)param.getName()));
        if (param.getId() != null) {
            throw new ServiceException("\u53c2\u6570\u9519\u8bef");
        }
        if (param.getSource() == null) {
            throw new ServiceException("\u7f3a\u5c11\u6570\u636e\u6765\u6e90");
        }
        if (StrUtil.isNotBlank((CharSequence)param.getIdcard())) {
            throw new ServiceException("\u65e0\u9700\u8eab\u4efd\u8bc1");
        }
        if (param.getName() == null) {
            throw new ServiceException("\u7f3a\u5c11\u59d3\u540d");
        }
        if (param.getPhone() == null) {
            throw new ServiceException("\u7f3a\u5c11\u624b\u673a\u53f7");
        }
        CStaffBaseInfo db = this.staffBaseInfoService.getOneByNamePhoneForEd(param.getName(), param.getPhone());
        if (db == null) {
            CStaffBaseInfo addEntity = new CStaffBaseInfo();
            addEntity.setName(param.getName());
            addEntity.setPhone(param.getPhone());
            addEntity.setSource(param.getSource());
            addEntity.setIdcard(null);
            addEntity.setCreateBy(param.getLoginUserId());
            addEntity.setUpdateBy(param.getLoginUserId());
            this.staffBaseInfoService.save(addEntity);
            db = addEntity;
        }
        param.getStaffEditParam().setBaseId(db.getId());
        param.getStaffEditParam().setIfRaManager(Integer.valueOf(1));
        param.getStaffEditParam().setType(null);
        this.self.addStaffInfoForManager(param.getStaffEditParam());
        this.staffErrorService.manualMaintenanceOne(db.getId());
    }

    @Transactional
    public StaffArchiveListVo add(CStaffBaseInfoEditParam param) {
        this.checkForAdd(param);
        String subKey = param.getId() != null ? ((CStaffBaseInfo)this.staffBaseInfoService.getById(param.getId())).getIdcard() : param.getIdcard();
        StringBuilder sb = new StringBuilder(DistributedLockEnum.EDIT_STAFF_INFO.getKey()).append(subKey);
        RLock lock = this.redissonClient.getLock(sb.toString());
        boolean resLock = false;
        try {
            resLock = lock.tryLock(10L, 10L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        if (resLock) {
            try {
                StaffArchiveListVo e = this.addLock(param);
                return e;
            }
            catch (ServiceException e) {
                throw e;
            }
            catch (Exception e) {
                log.error(e.getMessage());
                throw new ServiceException("\u5931\u8d25");
            }
            finally {
                lock.unlock();
            }
        }
        log.error("{}\uff1aPending lock timeout\uff0cmethod:\u65b0\u589e\u4eba\u5458\u65b9\u6cd5", (Object)sb.toString());
        throw new ServiceException("\u5931\u8d25");
    }

    @Transactional
    public StaffArchiveListVo addLock(CStaffBaseInfoEditParam param) {
        param.setIdcard(DesensitizationUtils.ignoreSetDesensitizationField((String)param.getIdcard()));
        param.setPhone(DesensitizationUtils.ignoreSetDesensitizationField((String)param.getPhone()));
        param.setName(DesensitizationUtils.ignoreSetDesensitizationField((String)param.getName()));
        param.setName(StaffNameStorageUtil.dealName((String)param.getName()));
        param.setIdcard(StrUtil.toUpperCase((CharSequence)param.getIdcard()));
        this.checkForAdd(param);
        CStaffBaseInfo db = null;
        if (param.getId() == null) {
            db = this.staffBaseInfoService.getOneByIdCard(param.getIdcard());
            if (db == null) {
                CStaffBaseInfo addEntity = this.cStaffBaseInfoConverter.param2Entity(param);
                addEntity.setEditTime(LocalDateTime.now());
                addEntity.setCreateBy(param.getLoginUserId());
                addEntity.setUpdateBy(param.getLoginUserId());
                this.staffBaseInfoService.save(addEntity);
                db = addEntity;
            }
        } else {
            CStaffBaseInfo upEntity;
            db = (CStaffBaseInfo)this.staffBaseInfoService.getById(param.getId());
            if (StrUtil.isNotBlank((CharSequence)param.getPhone()) && StrUtil.isBlank((CharSequence)db.getPhone())) {
                db.setPhone(param.getPhone());
                upEntity = new CStaffBaseInfo();
                upEntity.setId(db.getId());
                upEntity.setPhone(param.getPhone());
                this.staffBaseInfoService.updateById(upEntity);
            }
            if (param.getAddApiSource() == 1) {
                upEntity = new CStaffBaseInfo();
                upEntity.setId(db.getId());
                upEntity.setHeadId(param.getHeadId());
                upEntity.setName(param.getName());
                upEntity.setPhone(param.getPhone());
                upEntity.setRayStaffTime(param.getRayStaffTime());
                upEntity.setRaType(param.getRaType());
                this.staffBaseInfoService.updateById(upEntity);
            }
        }
        param.getStaffEditParam().setBaseId(db.getId());
        this.self.addStaffInfo(param.getStaffEditParam());
        return null;
    }

    public void checkForAdd(CStaffBaseInfoEditParam param) {
        if (param.getId() == null) {
            if (StrUtil.isBlank((CharSequence)param.getIdcard())) {
                throw new ServiceException("\u7f3a\u5c11\u8eab\u4efd\u8bc1\u4fe1\u606f");
            }
            if (StrUtil.contains((CharSequence)param.getIdcard(), (CharSequence)"*")) {
                throw new ServiceException("\u8eab\u4efd\u8bc1\u4fe1\u606f\u683c\u5f0f\u9519\u8bef");
            }
            if (StrUtil.contains((CharSequence)param.getPhone(), (CharSequence)"*")) {
                throw new ServiceException("\u624b\u673a\u53f7\u4fe1\u606f\u683c\u5f0f\u9519\u8bef");
            }
            if (param.getSource() == null) {
                throw new ServiceException("\u7f3a\u5c11\u6570\u636e\u6765\u6e90");
            }
        } else {
            CStaffBaseInfo db = (CStaffBaseInfo)this.staffBaseInfoService.getById(param.getId());
            if (db == null) {
                throw new ServiceException("\u4fe1\u606f\u4e0d\u5b58\u5728");
            }
        }
    }

    @Transactional
    public void editBaseInfo(CStaffBaseInfoEditParam param) {
        if (param.getId() == null) {
            throw new ServiceException("\u53c2\u6570\u9519\u8bef");
        }
        if (StrUtil.isBlank((CharSequence)param.getIdcard())) {
            throw new ServiceException("\u7f3a\u5c11\u8eab\u4efd\u8bc1\u4fe1\u606f");
        }
        param.setIdcard(DesensitizationUtils.ignoreSetDesensitizationField((String)param.getIdcard()));
        param.setPhone(DesensitizationUtils.ignoreSetDesensitizationField((String)param.getPhone()));
        param.setName(DesensitizationUtils.ignoreSetDesensitizationField((String)param.getName()));
        param.setName(StaffNameStorageUtil.dealName((String)param.getName()));
        param.setIdcard(StrUtil.toUpperCase((CharSequence)param.getIdcard()));
        CStaffBaseInfo upEntity = this.cStaffBaseInfoConverter.param2Entity(param);
        upEntity.setEditTime(LocalDateTime.now());
        upEntity.setUpdateBy(param.getLoginUserId());
        upEntity.setSourceId(null);
        if (this.staffBaseInfoService.hasIdCardConflict(param.getId(), param.getIdcard())) {
            throw new ServiceException("\u8eab\u4efd\u8bc1\u5df2\u88ab\u4f7f\u7528");
        }
        if (StrUtil.isNotBlank((CharSequence)upEntity.getIdcard()) && IdcardUtil.isValidCard((String)upEntity.getIdcard())) {
            upEntity.setSex(Integer.valueOf(IdcardUtil.getGenderByIdCard((String)upEntity.getIdcard())));
            upEntity.setAge(Integer.valueOf(IdcardUtil.getAgeByIdCard((String)upEntity.getIdcard())));
        }
        this.staffBaseInfoService.updateById(upEntity);
        this.staffErrorService.manualMaintenanceOne(upEntity.getId());
        this.self.editStaffInfo(param.getStaffEditParam());
    }

    @Transactional
    public void addStaffInfo(CStaffEditParam param) {
        param.setType(Integer.valueOf(1));
        CStaff cStaff = this.converter.param2Entity(param);
        cStaff.setEditTime(LocalDateTime.now());
        cStaff.setSource(cStaff.getSource() == null ? StaffSourceEnum.UNIT.getValue() : cStaff.getSource());
        if (cStaff == null) {
            return;
        }
        if (cStaff.getId() != null) {
            throw new ServiceException("\u53c2\u6570\u9519\u8bef\uff0c\u53ef\u5c1d\u8bd5\u5237\u65b0\u9875\u9762\u540e\u91cd\u8bd5");
        }
        if (cStaff.getBaseId() == null) {
            throw new ServiceException("\u57fa\u7840\u4fe1\u606f\u53c2\u6570\u9519\u8bef\uff0c\u53ef\u5c1d\u8bd5\u5237\u65b0\u9875\u9762\u540e\u91cd\u8bd5");
        }
        if (cStaff.getCid() == null) {
            throw new ServiceException("\u7f3a\u5931\u533b\u9662\u4fe1\u606f");
        }
        BCompany company = (BCompany)this.companyService.getById(cStaff.getCid());
        if (company == null) {
            throw new ServiceException("\u533b\u9662\u4fe1\u606f\u4e0d\u660e\u786e");
        }
        CStaff db = this.staffService.getByBaseIdAndCid(cStaff.getBaseId(), cStaff.getCid());
        if (db != null) {
            throw new ServiceException("\u4e0d\u53ef\u91cd\u590d\u6dfb\u52a0");
        }
        this.staffService.save(cStaff);
        CStaffBaseInfo staffBaseInfo = (CStaffBaseInfo)this.staffBaseInfoService.getById(param.getBaseId());
        this.self.recordOnPostWorkExperience(cStaff, staffBaseInfo, param);
        StaffStatisticsParam statisticsParam = new StaffStatisticsParam();
        statisticsParam.setId(cStaff.getBaseId());
        this.statisticService.initData(statisticsParam);
        this.staffErrorService.manualMaintenanceOne(cStaff.getBaseId());
    }

    @Transactional
    public void addStaffInfoForManager(CStaffEditParam param) {
        param.setType(Integer.valueOf(1));
        CStaff cStaff = this.converter.param2Entity(param);
        cStaff.setEditTime(LocalDateTime.now());
        cStaff.setSource(cStaff.getSource() == null ? StaffSourceEnum.UNIT.getValue() : cStaff.getSource());
        if (cStaff == null) {
            return;
        }
        if (cStaff.getId() != null) {
            throw new ServiceException("\u53c2\u6570\u9519\u8bef\uff0c\u53ef\u5c1d\u8bd5\u5237\u65b0\u9875\u9762\u540e\u91cd\u8bd5");
        }
        if (cStaff.getBaseId() == null) {
            throw new ServiceException("\u57fa\u7840\u4fe1\u606f\u53c2\u6570\u9519\u8bef\uff0c\u53ef\u5c1d\u8bd5\u5237\u65b0\u9875\u9762\u540e\u91cd\u8bd5");
        }
        if (cStaff.getCid() == null) {
            throw new ServiceException("\u7f3a\u5931\u533b\u9662\u4fe1\u606f");
        }
        BCompany company = (BCompany)this.companyService.getById(cStaff.getCid());
        if (company == null) {
            throw new ServiceException("\u533b\u9662\u4fe1\u606f\u4e0d\u660e\u786e");
        }
        CStaff db = this.staffService.getByBaseIdAndCid(cStaff.getBaseId(), cStaff.getCid());
        if (db == null) {
            this.staffService.save(cStaff);
        } else {
            if (db.getIfRaManager() == 1) {
                throw new ServiceException("\u4e0d\u53ef\u91cd\u590d\u6dfb\u52a0");
            }
            db.setIfRaManager(Integer.valueOf(1));
            CStaff upEntity = new CStaff();
            upEntity.setId(db.getId());
            upEntity.setIfRaManager(Integer.valueOf(1));
            this.staffService.updateById(upEntity);
        }
        StaffStatisticsParam statisticsParam = new StaffStatisticsParam();
        statisticsParam.setId(cStaff.getBaseId());
        this.statisticService.initData(statisticsParam);
        this.staffErrorService.manualMaintenanceOne(cStaff.getBaseId());
    }

    @Transactional
    public void editStaffInfo(CStaffEditParam param) {
        if (param == null) {
            return;
        }
        Integer type = param.getType();
        CStaff oldStaff = (CStaff)this.staffService.getById(param.getId());
        CStaff updateEntity = this.converter.param2Entity(param);
        updateEntity.setSource(null);
        if (updateEntity == null) {
            return;
        }
        if (updateEntity.getId() == null) {
            throw new ServiceException("\u53c2\u6570\u9519\u8bef\uff0c\u53ef\u5c1d\u8bd5\u5237\u65b0\u9875\u9762\u540e\u91cd\u8bd5");
        }
        if (updateEntity.getCid() != null && !updateEntity.getCid().equals(oldStaff.getCid())) {
            throw new ServiceException("\u4e0d\u53ef\u53d8\u66f4\u9662\u533a");
        }
        if (param.getOrgId() != null) {
            BOrg org = (BOrg)this.orgService.getById(param.getOrgId());
            if (org == null) {
                throw new ServiceException("\u90e8\u95e8\u4e0d\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u90e8\u95e8");
            }
            if (!org.getCid().equals(oldStaff.getCid())) {
                throw new ServiceException("\u6240\u5728\u90e8\u95e8\u4e0d\u5c5e\u4e8e\u5f53\u524d\u6240\u5728\u9662\u533a\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u90e8\u95e8\u6216\u8005\u9662\u533a");
            }
        }
        updateEntity.setEditTime(LocalDateTime.now());
        this.staffService.updateById(updateEntity);
        this.staffErrorService.manualMaintenanceOne(oldStaff.getBaseId());
    }

    @Transactional
    public void recordOnPostWorkExperience(CStaff newestData, CStaffBaseInfo baseInfo, CStaffEditParam param) {
        BPost postInfo = (BPost)this.postService.getById(newestData.getPost());
        CStaffWorkExperience staffWorkExperience = new CStaffWorkExperience();
        staffWorkExperience.setCid(newestData.getCid());
        staffWorkExperience.setOrgId(newestData.getOrgId());
        staffWorkExperience.setStaffBaseInfoId(baseInfo.getId());
        staffWorkExperience.setPost(newestData.getPost());
        if (postInfo != null) {
            staffWorkExperience.setPostName(postInfo.getName());
        }
        staffWorkExperience.setPostStatus(PostStatusEnum.ON_POST.getValue());
        staffWorkExperience.setType(param.getType());
        staffWorkExperience.setRaType(baseInfo.getRaType());
        staffWorkExperience.setPostStartTime(param.getPostStartTime());
        this.staffWorkExperienceService.save(staffWorkExperience);
    }

    @Transactional
    public void recordWorkExperience(CStaff oldData, CStaff newestData, CStaffBaseInfo baseInfo, CStaffEditParam param) {
        BPost postInfo = (BPost)this.postService.getById(newestData.getPost());
        BPost bPost = postInfo = postInfo == null ? new BPost() : postInfo;
        if (param.getType() == null) {
            return;
        }
        if (param.getType() == 0) {
            CStaffWorkExperience newestWorkExperienceInfo = this.staffWorkExperienceService.getNewestInfo(baseInfo.getId(), oldData.getCid());
            if (newestWorkExperienceInfo != null && (PostStatusEnum.ON_POST.getValue().equals(newestWorkExperienceInfo.getPostStatus()) || PostStatusEnum.TP_NON_POST.getValue().equals(newestWorkExperienceInfo.getPostStatus()))) {
                newestWorkExperienceInfo.setPostDepartureTime(param.getPostDepartureTime());
                newestWorkExperienceInfo.setPostStatus(PostStatusEnum.NON_POST.getValue());
                this.staffWorkExperienceService.updateById(newestWorkExperienceInfo);
            } else {
                CStaffWorkExperience staffWorkExperience = new CStaffWorkExperience();
                staffWorkExperience.setCid(newestData.getCid());
                staffWorkExperience.setOrgId(newestData.getOrgId());
                staffWorkExperience.setStaffBaseInfoId(baseInfo.getId());
                staffWorkExperience.setPost(newestData.getPost());
                staffWorkExperience.setPostName(postInfo.getName());
                staffWorkExperience.setPostStatus(PostStatusEnum.NON_POST.getValue());
                staffWorkExperience.setType(param.getType());
                staffWorkExperience.setRaType(baseInfo.getRaType());
                staffWorkExperience.setPostStartTime(param.getPostStartTime());
                staffWorkExperience.setPostDepartureTime(param.getPostDepartureTime());
                this.staffWorkExperienceService.save(staffWorkExperience);
            }
        } else if (param.getType() == 1) {
            CStaffWorkExperience staffWorkExperience = new CStaffWorkExperience();
            staffWorkExperience.setCid(newestData.getCid());
            staffWorkExperience.setOrgId(newestData.getOrgId());
            staffWorkExperience.setStaffBaseInfoId(baseInfo.getId());
            staffWorkExperience.setPost(newestData.getPost());
            staffWorkExperience.setPostName(postInfo.getName());
            staffWorkExperience.setPostStatus(PostStatusEnum.ON_POST.getValue());
            staffWorkExperience.setType(param.getType());
            staffWorkExperience.setRaType(baseInfo.getRaType());
            staffWorkExperience.setPostStartTime(param.getPostStartTime());
            this.staffWorkExperienceService.save(staffWorkExperience);
        } else if (param.getType() == 2) {
            CStaffWorkExperience staffWorkExperience;
            CStaffWorkExperience newestWorkExperienceInfo = this.staffWorkExperienceService.getNewestInfo(baseInfo.getId(), oldData.getCid());
            if (newestWorkExperienceInfo != null && PostStatusEnum.ON_POST.getValue().equals(newestWorkExperienceInfo.getPostStatus())) {
                staffWorkExperience = new CStaffWorkExperience();
                staffWorkExperience.setId(newestWorkExperienceInfo.getId());
                staffWorkExperience.setPostStatus(PostStatusEnum.NON_POST.getValue());
                staffWorkExperience.setType(param.getType());
                staffWorkExperience.setPostDepartureTime(param.getPostDepartureTime());
                staffWorkExperience.setIsPostJobTransfer(Integer.valueOf(1));
                this.staffWorkExperienceService.updateById(staffWorkExperience);
            }
            staffWorkExperience = new CStaffWorkExperience();
            staffWorkExperience.setCid(newestData.getCid());
            staffWorkExperience.setOrgId(newestData.getOrgId());
            staffWorkExperience.setStaffBaseInfoId(baseInfo.getId());
            staffWorkExperience.setPost(newestData.getPost());
            staffWorkExperience.setPostName(postInfo.getName());
            staffWorkExperience.setPostStatus(PostStatusEnum.ON_POST.getValue());
            staffWorkExperience.setType(param.getType());
            staffWorkExperience.setRaType(baseInfo.getRaType());
            staffWorkExperience.setPostStartTime(param.getPostStartTime());
            staffWorkExperience.setIsOnJobTransfer(Integer.valueOf(1));
            this.staffWorkExperienceService.save(staffWorkExperience);
        } else if (param.getType() == 3) {
            CStaffWorkExperience newestWorkExperienceInfo = this.staffWorkExperienceService.getNewestInfo(baseInfo.getId(), oldData.getCid());
            if (newestWorkExperienceInfo != null && PostStatusEnum.ON_POST.getValue().equals(newestWorkExperienceInfo.getPostStatus())) {
                newestWorkExperienceInfo.setTpPostDepartureTime(param.getTpPostDepartureTime());
                newestWorkExperienceInfo.setPrePostStartTime(param.getPrePostStartTime());
                newestWorkExperienceInfo.setPostStatus(PostStatusEnum.TP_NON_POST.getValue());
                this.staffWorkExperienceService.updateById(newestWorkExperienceInfo);
            } else {
                CStaffWorkExperience staffWorkExperience = new CStaffWorkExperience();
                staffWorkExperience.setCid(newestData.getCid());
                staffWorkExperience.setOrgId(newestData.getOrgId());
                staffWorkExperience.setStaffBaseInfoId(baseInfo.getId());
                staffWorkExperience.setPost(newestData.getPost());
                staffWorkExperience.setPostName(postInfo.getName());
                staffWorkExperience.setPostStatus(PostStatusEnum.TP_NON_POST.getValue());
                staffWorkExperience.setType(param.getType());
                staffWorkExperience.setRaType(baseInfo.getRaType());
                staffWorkExperience.setTpPostDepartureTime(param.getTpPostDepartureTime());
                staffWorkExperience.setPrePostStartTime(param.getPrePostStartTime());
                this.staffWorkExperienceService.save(staffWorkExperience);
            }
        } else {
            return;
        }
    }

    @Transactional
    public void deleteStaff(CStaffDeleteParam param) {
        Long staffId = param.getStaffId();
        if (staffId == null) {
            return;
        }
        CStaff staff = (CStaff)this.staffService.getById(staffId);
        if (staff == null) {
            return;
        }
        if (this.staffService.hasRelatedData(new CheckStaffRelationParam(staff.getCid(), staff.getBaseId())).booleanValue()) {
            throw new ServiceException("\u4eba\u5458\u65e0\u6cd5\u5220\u9664");
        }
        this.riskBasicSourceService.deleteByBaseIdAndCid(staff.getBaseId(), staff.getCid());
        this.staffService.removeById(staff.getId());
        this.staffErrorService.manualMaintenanceOne(staff.getBaseId(), staff.getCid());
    }

    @Transactional
    public void editManagerMainType(RayManagerEditMainParam param) {
        CStaff staff = (CStaff)this.staffService.getById(param.getStaffId());
        Long cid = staff.getCid();
        Long sbId = staff.getBaseId();
        Long staffId = staff.getId();
        if (staff == null) {
            return;
        }
        if (cid == null || sbId == null) {
            return;
        }
        if (param.getManagerMainType() == 0) {
            CStaff upEntity = new CStaff();
            upEntity.setId(staffId);
            upEntity.setManagerMainType(param.getManagerMainType());
            this.staffService.updateById(upEntity);
        } else if (param.getManagerMainType() == 1) {
            List<CStaff> list = this.staffService.getListForEditManagerMainType(cid);
            for (CStaff entity : list) {
                if (entity.getId().equals(staffId)) {
                    entity.setManagerMainType(Integer.valueOf(1));
                    continue;
                }
                entity.setManagerMainType(Integer.valueOf(0));
            }
            this.staffService.updateBatchById(list);
        }
    }

    @Transactional
    public void editRayPostType(StaffPostEditParam param) {
        Long cid = param.getCid();
        Long staffId = param.getStaffId();
        CStaff staff = (CStaff)this.staffService.getById(staffId);
        if (staff == null) {
            return;
        }
        if (!cid.equals(staff.getCid())) {
            throw new ServiceException("\u4eba\u5458\u65e0\u6cd5\u4fee\u6539");
        }
        if (StrUtil.isBlank((CharSequence)PostStatusEnum.getName((Integer)param.getPostStatus()))) {
            throw new ServiceException("\u5c97\u4f4d\u72b6\u6001\u5f02\u5e38\uff0c\u65e0\u6cd5\u4fee\u6539");
        }
        CStaff upEntity = new CStaff();
        upEntity.setId(staff.getId());
        upEntity.setPostStatus(param.getPostStatus());
        upEntity.setIfRaManager(param.getIfRaManager());
        this.staffService.updateById(upEntity);
    }
}

