/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.rho.modules.sys.manger.risk.hc.v4.gen;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.date.LocalDateTimeUtil;
import cn.hutool.core.util.StrUtil;
import cn.smarthse.encrypt.spring.utils.SpringEncryptUtils;
import cn.smarthse.rho.modules.sys.dao.risk.gen.v4.RiskGenHcInfoV4Mapper;
import cn.smarthse.rho.modules.sys.dao.risk.gen.v4.RiskGenSbInfoV4Mapper;
import cn.smarthse.rho.modules.sys.dao.risk.gen.v4.RiskGenWeInfoV4Mapper;
import cn.smarthse.rho.modules.sys.entity.c.CHealthCheckData;
import cn.smarthse.rho.modules.sys.entity.c.CStaffWorkExperience;
import cn.smarthse.rho.modules.sys.enums.risk.RiskCategoryEnum;
import cn.smarthse.rho.modules.sys.enums.risk.RiskPostStatusEnum;
import cn.smarthse.rho.modules.sys.enums.risk.RiskPostSubStatusEnum;
import cn.smarthse.rho.modules.sys.enums.risk.RiskSourceEnum;
import cn.smarthse.rho.modules.sys.enums.risk.RiskTypeEnum;
import cn.smarthse.rho.modules.sys.manger.risk.hc.v4.gen.RiskGenHCManagerV4;
import cn.smarthse.rho.modules.sys.model.c.vo.staff.RiskStaffBaseInfo;
import cn.smarthse.rho.modules.sys.model.r.param.AddRiskForCommonParam;
import cn.smarthse.rho.modules.sys.model.r.param.RiskMangerGenParam;
import cn.smarthse.rho.modules.sys.provider.risk.IRiskProvider;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalUnit;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.apache.dubbo.config.annotation.DubboReference;
import org.redisson.api.RLock;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class RiskGenHCOnManagerV4 {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RiskGenHCOnManagerV4.class);
    private final RiskGenHCManagerV4 riskGenHCManagerV4;
    private final RiskGenHcInfoV4Mapper riskGenHcInfoV4Mapper;
    private final RiskGenSbInfoV4Mapper riskGenSbInfoV4Mapper;
    private final RiskGenWeInfoV4Mapper riskGenWeInfoV4Mapper;
    private final RedissonClient redissonClient;
    @DubboReference
    private IRiskProvider riskProvider;
    private static final String LOCK_KEY = "RiskGenManager_on";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void genHCRisk(RiskMangerGenParam param) {
        String title = "\u98ce\u9669\u7ef4\u62a4\uff1a\u4f53\u68c0\u98ce\u9669-\u751f\u6210";
        String methodName = "genHCRisk()";
        log.debug(title + methodName + "start");
        StringBuilder sb = new StringBuilder(LOCK_KEY).append("_").append(methodName).append("_").append(param.getYear()).append(param.getThirdLevelAreaId());
        RLock lock = this.redissonClient.getLock(sb.toString());
        boolean resLock = false;
        try {
            resLock = lock.tryLock(1L, 3600L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        if (resLock) {
            try {
                this.genHCRiskLock(param);
                log.debug(title + methodName + "end");
            }
            catch (Exception e) {
                log.error("\u3010\u4f53\u68c0\u98ce\u9669\u751f\u6210V4\u3011\u3010\u5c97\u4e2d\u3011\u3010\u6574\u4f53\u3011\u5931\u8d25,e:{}", (Throwable)e);
            }
            finally {
                lock.unlock();
            }
        } else {
            log.error(":{}\uff1a\u3010\u4f53\u68c0\u98ce\u9669\u751f\u6210V4\u3011\u3010\u5c97\u4e2d\u3011\u3010\u9501\u8d85\u65f6\u3011", (Object)LOCK_KEY);
        }
    }

    private void genHCRiskLock(RiskMangerGenParam param) {
        param.setSpecificTime(RiskGenHCManagerV4.SPECIFIC_TIME);
        this.riskGenHCManagerV4.initAssistance(param);
        List<RiskStaffBaseInfo> entityList = this.riskGenSbInfoV4Mapper.getListForGenHcOnRiskV4(param);
        ArrayList<AddRiskForCommonParam> genInfoListParam = new ArrayList<AddRiskForCommonParam>();
        for (RiskStaffBaseInfo staffBaseInfo : entityList) {
            try {
                this.genOne(staffBaseInfo, genInfoListParam);
            }
            catch (Exception e) {
                log.error("\u3010\u4f53\u68c0\u98ce\u9669\u751f\u6210V4\u3011\u3010\u5c97\u4e2d\u3011\u3010\u5355\u4e2a\u3011\u4f53\u68c0\u751f\u6210\u5931\u8d25:sbId:{},e:{}", (Object)staffBaseInfo.getId(), (Object)e);
            }
            if (genInfoListParam.size() < 500) continue;
            this.genBatch(genInfoListParam);
        }
        if (CollUtil.isNotEmpty(genInfoListParam)) {
            this.genBatch(genInfoListParam);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void genBatch(List<AddRiskForCommonParam> genInfoListParam) {
        try {
            for (AddRiskForCommonParam param : genInfoListParam) {
                try {
                    String subBusinessNameDe = SpringEncryptUtils.decrypt((String)param.getSubBusinessName());
                    param.setSubBusinessName(StrUtil.isBlank((CharSequence)subBusinessNameDe) ? "\u672a\u77e5\u59d3\u540d" : subBusinessNameDe);
                }
                catch (Exception e) {
                    log.error("\u3010\u4f53\u68c0\u98ce\u9669\u751f\u6210V4\u3011\u3010\u5c97\u4e2d\u3011\u3010\u59d3\u540d\u89e3\u5bc6\u5931\u8d25\u3011sbId:{},sbName:{}, riskType:{}", new Object[]{param.getSubBusinessId(), param.getName(), param.getType(), e});
                }
            }
            this.riskProvider.genRiskOfCommon(genInfoListParam);
        }
        catch (Exception e) {
            log.error("\u3010\u4f53\u68c0\u98ce\u9669\u751f\u6210V4\u3011\u3010\u5c97\u4e2d\u3011\u4f53\u68c0\u98ce\u9669\u751f\u6210\u5931\u8d25:{}", (Throwable)e);
        }
        finally {
            genInfoListParam.clear();
        }
    }

    private void genOne(RiskStaffBaseInfo staffBaseInfo, List<AddRiskForCommonParam> genInfoListParam) {
        try {
            this.genOnJob(staffBaseInfo, genInfoListParam);
        }
        catch (Exception e) {
            log.error("\u3010\u4f53\u68c0\u98ce\u9669\u751f\u6210V4\u3011\u3010\u5c97\u4e2d\u3011\u98ce\u9669\u751f\u6210\u5931\u8d25\u5f02\u5e38baseId:{}\uff0c\u5f02\u5e38\u5982\u4e0b\uff1a:{}", (Object)staffBaseInfo.getId(), (Object)e);
        }
    }

    private void genOnJob(RiskStaffBaseInfo staffBaseInfo, List<AddRiskForCommonParam> genInfoListParam) {
        Long cid = staffBaseInfo.getCid();
        Long sbId = staffBaseInfo.getId();
        Integer riskType = RiskTypeEnum.PHYSICAL_EXAMINATION.getValue();
        Integer riskPostType = RiskPostStatusEnum.ON_POST.getValue();
        CStaffWorkExperience we = this.riskGenWeInfoV4Mapper.getLastWorkExperienceForOnRiskV4(cid, sbId);
        Long weId = null;
        LocalDateTime postStartTime = null;
        if (we == null) {
            log.error("\u3010\u4f53\u68c0\u98ce\u9669\u751f\u6210V4\u3011\u3010\u5c97\u4e2d\u3011\u6ca1\u6709\u5de5\u4f5c\u7ecf\u5386\uff0c\u98ce\u9669\u751f\u6210\u5931\u8d25:sbId:{},cid:{}", (Object)sbId, (Object)cid);
            return;
        }
        weId = we.getId();
        postStartTime = we.getPostStartTime();
        if (postStartTime == null) {
            log.error("\u3010\u4f53\u68c0\u98ce\u9669\u751f\u6210V4\u3011\u3010\u5c97\u4e2d\u3011\u5de5\u4f5c\u7ecf\u5386\u4e0a\u5c97\u59cb\u65f6\u95f4\u4e3a\u7a7a\uff0c\u98ce\u9669\u751f\u6210\u5931\u8d25:sbId:{},cid:{},weId:{}", new Object[]{sbId, cid, weId});
            return;
        }
        if (this.riskGenHCManagerV4.hasSDFileForCommonOnRisk(cid, sbId)) {
            return;
        }
        if (this.riskGenHCManagerV4.hasCommonRisk(cid, sbId, riskType, riskPostType)) {
            return;
        }
        CHealthCheckData lastData = this.getLastData(sbId);
        if (lastData != null) {
            this.genHasDataRisk(staffBaseInfo, lastData, we, genInfoListParam);
        } else {
            this.genNonDataRisk(staffBaseInfo, we, genInfoListParam);
        }
    }

    private void genHasDataRisk(RiskStaffBaseInfo staffBaseInfo, CHealthCheckData lastData, CStaffWorkExperience we, List<AddRiskForCommonParam> genInfoListParam) {
        Long cid = staffBaseInfo.getCid();
        Long sbId = staffBaseInfo.getId();
        Integer riskType = RiskTypeEnum.PHYSICAL_EXAMINATION.getValue();
        String sbName = staffBaseInfo.getName();
        Integer riskPostType = RiskPostStatusEnum.ON_POST.getValue();
        Long weId = we.getId();
        LocalDateTime postStartTime = we.getPostStartTime();
        LocalDateTime postDepartureTime = we.getPostDepartureTime();
        LocalDateTime currentTime = LocalDateTime.now();
        Integer riskSubPostType = RiskPostSubStatusEnum.ON_POST.getValue();
        LocalDate checkDate = lastData.getCheckDate();
        boolean timeCheckPass = RiskGenHCManagerV4.timeCheck(LocalDateTimeUtil.of((TemporalAccessor)lastData.getCheckDate()), currentTime);
        if (timeCheckPass) {
            return;
        }
        if (!timeCheckPass) {
            AddRiskForCommonParam genParam = new AddRiskForCommonParam();
            Long businessId = lastData.getId();
            Long subBusinessId = sbId;
            String subBusinessName = sbName;
            Integer category = RiskCategoryEnum.COMMON_EIGHT.getValue();
            LocalDate startTime = lastData.getCheckDate();
            LocalDate staffRayTime = RiskGenHCManagerV4.time2Date(staffBaseInfo.getRayStaffTime());
            Integer isGenerateByData = 1;
            genParam.setCid(cid);
            genParam.setThirdOrgId(null);
            genParam.setBusinessId(businessId);
            genParam.setSubBusinessId(subBusinessId);
            genParam.setSubBusinessName(subBusinessName);
            genParam.setName(null);
            genParam.setSource(RiskSourceEnum.PORTRAIT.getValue());
            genParam.setCategory(category);
            genParam.setType(riskType);
            genParam.setPostType(riskPostType);
            genParam.setPostSubType(riskSubPostType);
            genParam.setPostStartTime(postStartTime == null ? null : LocalDate.from(postStartTime));
            genParam.setPostDepartureTime(postDepartureTime == null ? null : LocalDate.from(postDepartureTime));
            genParam.setWorkExperienceId(weId);
            genParam.setFinderName("\u5b9a\u65f6\u4efb\u52a1");
            genParam.setDescription(null);
            genParam.setFiles(null);
            genParam.setStartTime(startTime);
            genParam.setExpireTime(null);
            genParam.setRequireFinishTime(null);
            genParam.setCheckData(checkDate);
            genParam.setRayStaffTime(staffRayTime);
            genParam.setIsGenerateByData(isGenerateByData);
            genInfoListParam.add(genParam);
        }
    }

    private void genNonDataRisk(RiskStaffBaseInfo staffBaseInfo, CStaffWorkExperience we, List<AddRiskForCommonParam> genInfoListParam) {
        Long cid = staffBaseInfo.getCid();
        Long sbId = staffBaseInfo.getId();
        Integer riskType = RiskTypeEnum.PHYSICAL_EXAMINATION.getValue();
        String sbName = staffBaseInfo.getName();
        Integer riskPostType = RiskPostStatusEnum.ON_POST.getValue();
        Long weId = we.getId();
        LocalDateTime postStartTime = we.getPostStartTime();
        LocalDateTime postDepartureTime = we.getPostDepartureTime();
        LocalDateTime currentTime = LocalDateTime.now();
        Integer riskSubPostType = RiskPostSubStatusEnum.ON_POST.getValue();
        LocalDateTime after2YearTime = LocalDateTimeUtil.offset((LocalDateTime)postStartTime, (long)2L, (TemporalUnit)ChronoUnit.YEARS);
        if (currentTime.isBefore(after2YearTime)) {
            return;
        }
        AddRiskForCommonParam genParam = new AddRiskForCommonParam();
        Long businessId = null;
        Long subBusinessId = sbId;
        Integer category = RiskCategoryEnum.COMMON_EIGHT.getValue();
        String subBusinessName = sbName;
        LocalDate startTime = LocalDate.from(currentTime);
        LocalDate staffRayTime = RiskGenHCManagerV4.time2Date(staffBaseInfo.getRayStaffTime());
        Integer isGenerateByData = 0;
        genParam.setCid(cid);
        genParam.setThirdOrgId(null);
        genParam.setBusinessId(businessId);
        genParam.setSubBusinessId(subBusinessId);
        genParam.setSubBusinessName(subBusinessName);
        genParam.setName(null);
        genParam.setSource(RiskSourceEnum.PORTRAIT.getValue());
        genParam.setCategory(category);
        genParam.setType(riskType);
        genParam.setPostType(riskPostType);
        genParam.setPostSubType(riskSubPostType);
        genParam.setPostStartTime(postStartTime == null ? null : LocalDate.from(postStartTime));
        genParam.setPostDepartureTime(postDepartureTime == null ? null : LocalDate.from(postDepartureTime));
        genParam.setWorkExperienceId(weId);
        genParam.setFinderName("\u5b9a\u65f6\u4efb\u52a1");
        genParam.setDescription(null);
        genParam.setFiles(null);
        genParam.setStartTime(startTime);
        genParam.setExpireTime(null);
        genParam.setRequireFinishTime(null);
        genParam.setRayStaffTime(staffRayTime);
        genParam.setIsGenerateByData(isGenerateByData);
        genInfoListParam.add(genParam);
    }

    public CHealthCheckData getLastData(Long sbId) {
        return this.riskGenHcInfoV4Mapper.getLastHealthCheckDataForGenRiskOnJobV4(sbId);
    }

    @Generated
    public RiskGenHCOnManagerV4(RiskGenHCManagerV4 riskGenHCManagerV4, RiskGenHcInfoV4Mapper riskGenHcInfoV4Mapper, RiskGenSbInfoV4Mapper riskGenSbInfoV4Mapper, RiskGenWeInfoV4Mapper riskGenWeInfoV4Mapper, RedissonClient redissonClient) {
        this.riskGenHCManagerV4 = riskGenHCManagerV4;
        this.riskGenHcInfoV4Mapper = riskGenHcInfoV4Mapper;
        this.riskGenSbInfoV4Mapper = riskGenSbInfoV4Mapper;
        this.riskGenWeInfoV4Mapper = riskGenWeInfoV4Mapper;
        this.redissonClient = redissonClient;
    }
}

