/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.rho.modules.sys.manger.risk.hc.v4.gen;

import cn.hutool.core.date.LocalDateTimeUtil;
import cn.smarthse.rho.modules.sys.dao.risk.gen.v4.RiskGenRiskInfoV4Mapper;
import cn.smarthse.rho.modules.sys.dao.risk.gen.v4.RiskGenSbInfoV4Mapper;
import cn.smarthse.rho.modules.sys.enums.RhoTimeEnum;
import cn.smarthse.rho.modules.sys.enums.risk.RiskWarningStatusEnum;
import cn.smarthse.rho.modules.sys.model.r.param.RiskMangerGenParam;
import cn.smarthse.rho.modules.sys.provider.risk.IRiskProvider;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalUnit;
import lombok.Generated;
import org.apache.dubbo.config.annotation.DubboReference;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class RiskGenHCManagerV4 {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RiskGenHCManagerV4.class);
    private final RiskGenRiskInfoV4Mapper riskGenRiskInfoV4Mapper;
    private final RiskGenSbInfoV4Mapper riskGenSbInfoV4Mapper;
    private final RedissonClient redissonClient;
    @DubboReference
    private IRiskProvider riskProvider;
    public static final String LOCK_KEY_PRE = "RiskGenManager_pre";
    public static final String LOCK_KEY_ON = "RiskGenManager_on";
    public static final String LOCK_KEY_DT = "RiskGenManager_dt";
    public static final String LOCK_KEY_FC = "RiskGenManager_fc";
    public static final String LOCK_KEY_ZYJJZ = "RiskGenManager_zyjjz";
    private static final LocalDateTime LIMIT_TIME = LocalDateTimeUtil.offset((LocalDateTime)LocalDateTime.now(), (long)-2L, (TemporalUnit)ChronoUnit.YEARS);
    private static final String WX = "WX";
    private static final String WJS = "WJS";
    private static final String YC = "YC";
    private static final String FY = "FY";
    public static final Integer CURR_YEAR = 2025;
    public static final LocalDateTime TRIAL_RUN_TIME = LocalDateTime.of(2025, 8, 14, 0, 0, 0);
    public static final LocalDateTime SPECIFIC_TIME = LocalDateTime.of(2025, 8, 14, 0, 0, 0);

    public boolean hasSDFileForCommonPreRisk(Long cid, Long sbId) {
        Integer num = this.riskGenRiskInfoV4Mapper.countSDFileForGenHcCommonPreRisk(cid, sbId);
        return num > 0;
    }

    public boolean hasSDFileForCommonOnRisk(Long cid, Long sbId) {
        Integer num = this.riskGenRiskInfoV4Mapper.countSDFileForGenHcCommonOnRisk(cid, sbId);
        return num > 0;
    }

    public boolean hasSDFileForCommonDtRisk(Long cid, Long sbId, LocalDateTime newestPostDepartureTime) {
        Integer num = this.riskGenRiskInfoV4Mapper.countSDFileForGenHcCommonDtRisk(cid, sbId, newestPostDepartureTime);
        return num > 0;
    }

    public boolean countRetiredSDFile(Long cid, Long sbId, LocalDateTime newestPostDepartureTime) {
        Integer num = this.riskGenRiskInfoV4Mapper.countRetiredSDFile(cid, sbId, newestPostDepartureTime);
        return num > 0;
    }

    public boolean hasSDFileForFcRisk(Long cid, Long sbId, Long newestFcHcId) {
        Integer num = this.riskGenRiskInfoV4Mapper.countSDFileForGenHcFcRisk(cid, sbId, newestFcHcId);
        return num > 0;
    }

    public boolean hasSDFileForZyjjzRisk(Long cid, Long sbId) {
        Integer num = this.riskGenRiskInfoV4Mapper.countSDFileForGenHcZyjjzRisk(cid, sbId);
        return num > 0;
    }

    public boolean hasCommonRisk(Long cid, Long sbId, Integer riskType, Integer riskPostType) {
        Integer num = this.riskGenRiskInfoV4Mapper.countRiskForGenHcCommon(cid, sbId, riskType, riskPostType);
        return num > 0;
    }

    public boolean hasRisk(Long cid, Long sbId, Integer riskType) {
        Integer num = this.riskGenRiskInfoV4Mapper.countRisk(cid, sbId, riskType);
        return num > 0;
    }

    public boolean hasRiskError(Long cid, Long sbId, Integer riskType) {
        Integer num = this.riskGenRiskInfoV4Mapper.countRiskForGenHcError(cid, sbId, riskType);
        return num > 0;
    }

    public boolean hasOnJobInSameCreditCode(Long cid, Long sbId) {
        Integer num = this.riskGenRiskInfoV4Mapper.countOnJobInSameCreditCode(cid, sbId);
        return num > 0;
    }

    public static LocalDateTime add30Days(LocalDateTime time) {
        return LocalDateTimeUtil.offset((LocalDateTime)time, (long)RhoTimeEnum.SECOND_OF_30_DAY.getTime(), (TemporalUnit)ChronoUnit.SECONDS);
    }

    public static LocalDateTime sub30Days(LocalDateTime time) {
        return LocalDateTimeUtil.offset((LocalDateTime)time, (long)(-RhoTimeEnum.SECOND_OF_30_DAY.getTime().longValue()), (TemporalUnit)ChronoUnit.SECONDS);
    }

    public static LocalDateTime add90Days(LocalDateTime time) {
        return LocalDateTimeUtil.offset((LocalDateTime)time, (long)RhoTimeEnum.SECOND_OF_90_DAY.getTime(), (TemporalUnit)ChronoUnit.SECONDS);
    }

    public static LocalDateTime sub90Days(LocalDateTime time) {
        return LocalDateTimeUtil.offset((LocalDateTime)time, (long)(-RhoTimeEnum.SECOND_OF_90_DAY.getTime().longValue()), (TemporalUnit)ChronoUnit.SECONDS);
    }

    public static LocalDateTime add2Year(LocalDateTime time) {
        return LocalDateTimeUtil.offset((LocalDateTime)time, (long)2L, (TemporalUnit)ChronoUnit.YEARS);
    }

    public static LocalDateTime sub2Year(LocalDateTime time) {
        return LocalDateTimeUtil.offset((LocalDateTime)time, (long)-2L, (TemporalUnit)ChronoUnit.YEARS);
    }

    public static LocalDateTime add240Days(LocalDateTime time) {
        return LocalDateTimeUtil.offset((LocalDateTime)time, (long)RhoTimeEnum.SECOND_OF_240_DAY.getTime(), (TemporalUnit)ChronoUnit.SECONDS);
    }

    public static boolean timeCheck(LocalDateTime checkData, LocalDateTime referenceTime) {
        Integer warnType = RiskGenHCManagerV4.calculateWarnType(checkData, referenceTime);
        return warnType == RiskWarningStatusEnum.NONE.getValue();
    }

    public static Integer calculateWarnType(LocalDateTime checkData, LocalDateTime referenceTime) {
        LocalDateTime expireDate = LocalDateTimeUtil.offset((LocalDateTime)checkData, (long)2L, (TemporalUnit)ChronoUnit.YEARS);
        Duration diffTime = LocalDateTimeUtil.between((LocalDateTime)referenceTime, (LocalDateTime)expireDate);
        return RiskGenHCManagerV4.calculateHasDataWarningType(diffTime.getSeconds());
    }

    public static Integer calculateHasDataWarningType(long diffTimes) {
        Integer warnType = RiskWarningStatusEnum.NONE.getValue();
        long abs = Math.abs(diffTimes);
        warnType = diffTimes > 0L ? (RhoTimeEnum.SECOND_OF_90_DAY.getTime() < abs ? RiskWarningStatusEnum.NONE.getValue() : (RhoTimeEnum.SECOND_OF_30_DAY.getTime() < abs && abs <= RhoTimeEnum.SECOND_OF_90_DAY.getTime() ? RiskWarningStatusEnum.FIRST.getValue() : (abs <= RhoTimeEnum.SECOND_OF_30_DAY.getTime() ? RiskWarningStatusEnum.YELLOW.getValue() : RiskWarningStatusEnum.NONE.getValue()))) : (abs < RhoTimeEnum.SECOND_OF_30_DAY.getTime() ? RiskWarningStatusEnum.RED.getValue() : RiskWarningStatusEnum.ACTIVATE_LAW.getValue());
        return warnType;
    }

    public void initAssistance(RiskMangerGenParam param) {
        if (param.getNeedInitAssistance() == 1) {
            this.riskGenSbInfoV4Mapper.initAssistance(param);
            this.riskGenSbInfoV4Mapper.initAssistancePostTime(param);
            this.riskGenSbInfoV4Mapper.initAssistanceHc(param);
        }
    }

    public static LocalDate time2Date(LocalDateTime dateTime) {
        return dateTime == null ? null : LocalDate.from(dateTime);
    }

    @Generated
    public RiskGenHCManagerV4(RiskGenRiskInfoV4Mapper riskGenRiskInfoV4Mapper, RiskGenSbInfoV4Mapper riskGenSbInfoV4Mapper, RedissonClient redissonClient) {
        this.riskGenRiskInfoV4Mapper = riskGenRiskInfoV4Mapper;
        this.riskGenSbInfoV4Mapper = riskGenSbInfoV4Mapper;
        this.redissonClient = redissonClient;
    }
}

