/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.rho.modules.sys.manger.risk.hc.v4.defuse;

import cn.hutool.core.date.LocalDateTimeUtil;
import cn.smarthse.rho.modules.sys.dao.risk.gen.v4.RiskGenHcInfoV4Mapper;
import cn.smarthse.rho.modules.sys.dao.risk.gen.v4.RiskGenSbInfoV4Mapper;
import cn.smarthse.rho.modules.sys.dao.risk.gen.v4.RiskGenWeInfoV4Mapper;
import cn.smarthse.rho.modules.sys.entity.r.RRiskBasicSource;
import cn.smarthse.rho.modules.sys.enums.RhoTimeEnum;
import cn.smarthse.rho.modules.sys.enums.risk.RiskPostStatusEnum;
import cn.smarthse.rho.modules.sys.enums.risk.RiskPostSubStatusEnum;
import cn.smarthse.rho.modules.sys.enums.risk.RiskTypeEnum;
import cn.smarthse.rho.modules.sys.model.r.param.ResolveRiskForCommonParam;
import cn.smarthse.rho.modules.sys.model.r.vo.RiskDefuseDto;
import cn.smarthse.rho.modules.sys.provider.risk.IRiskProvider;
import cn.smarthse.rho.modules.sys.service.c.ICHealthCheckDataService;
import cn.smarthse.rho.modules.sys.service.c.ICStaffBaseInfoService;
import cn.smarthse.rho.modules.sys.service.c.ICStaffService;
import cn.smarthse.rho.modules.sys.service.c.ICStaffWorkExperienceService;
import cn.smarthse.rho.modules.sys.service.risk.IRiskAcceptanceRecordCommonService;
import cn.smarthse.rho.modules.sys.service.risk.IRiskBasicSourceCommonService;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalUnit;
import java.util.List;
import lombok.Generated;
import org.apache.dubbo.config.annotation.DubboReference;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class RiskDefuseHCManagerV4 {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RiskDefuseHCManagerV4.class);
    private final RedissonClient redissonClient;
    private final ICStaffBaseInfoService staffBaseInfoService;
    private final ICStaffService staffService;
    private final IRiskBasicSourceCommonService riskSourceService;
    private final ICHealthCheckDataService healthCheckDataService;
    private final ICStaffWorkExperienceService staffWorkExperienceService;
    private final IRiskAcceptanceRecordCommonService riskAcceptanceRecordService;
    private final RiskGenHcInfoV4Mapper riskGenHcInfoV4Mapper;
    private final RiskGenSbInfoV4Mapper riskGenSbInfoV4Mapper;
    private final RiskGenWeInfoV4Mapper riskGenWeInfoV4Mapper;
    @DubboReference
    private IRiskProvider riskProvider;
    private static final String LOCK_KEY = "RiskGenManager";
    private static final String WORK_TIME_DIFF_DEFUSE_MEASURE = "\u4eba\u5458\u4e0a\u5c97/\u79bb\u5c97\u65f6\u95f4\u5df2\u4fee\u6539\uff0c\u9700\u91cd\u65b0\u8bc4\u4f30\u98ce\u9669";
    private static final String POST_STATUS_DEFUSE_MEASURE = "\u5c97\u4f4d\u72b6\u6001\u53d8\u66f4\uff0c\u9700\u91cd\u65b0\u8bc4\u4f30\u98ce\u9669";
    private static final int RISK_POST_TYPE_PRE = RiskPostStatusEnum.PRE_POST.getValue();
    private static final int RISK_POST_TYPE_ON = RiskPostStatusEnum.ON_POST.getValue();
    private static final int RISK_POST_TYPE_DT = RiskPostStatusEnum.DT_POST.getValue();
    private static final int RISK_POST_SUB_TYPE_ON = RiskPostSubStatusEnum.ON_POST.getValue();
    private static final int RISK_POST_SUB_TYPE_DT = RiskPostSubStatusEnum.DT_POST.getValue();

    public static boolean timeDiff(LocalDateTime wePostStartTime, LocalDateTime wePostDepartureTime, LocalDateTime riskPostStartTime, LocalDateTime riskPostDepartureTime) {
        LocalDate wePostStartTimeTemp = wePostStartTime == null ? null : LocalDate.from(wePostStartTime);
        LocalDate wePostDepartureTimeTemp = wePostDepartureTime == null ? null : LocalDate.from(wePostDepartureTime);
        LocalDate riskPostStartTimeTemp = riskPostStartTime == null ? null : LocalDate.from(riskPostStartTime);
        LocalDate riskPostDepartureTimeTemp = riskPostDepartureTime == null ? null : LocalDate.from(riskPostDepartureTime);
        long riskPostStartSecond = LocalDateTimeUtil.of((TemporalAccessor)((Object)(riskPostStartTimeTemp == null ? LocalDateTimeUtil.of((long)0L) : riskPostStartTimeTemp))).atZone(ZoneId.systemDefault()).toEpochSecond();
        long riskPostDepartureSecond = LocalDateTimeUtil.of((TemporalAccessor)((Object)(riskPostDepartureTimeTemp == null ? LocalDateTimeUtil.of((long)0L) : riskPostDepartureTimeTemp))).atZone(ZoneId.systemDefault()).toEpochSecond();
        long workExperiencePostStartSecond = LocalDateTimeUtil.of((TemporalAccessor)((Object)(wePostStartTimeTemp == null ? LocalDateTimeUtil.of((long)0L) : wePostStartTimeTemp))).atZone(ZoneId.systemDefault()).toEpochSecond();
        long workExperiencePostDepartureSecond = LocalDateTimeUtil.of((TemporalAccessor)((Object)(wePostDepartureTimeTemp == null ? LocalDateTimeUtil.of((long)0L) : wePostDepartureTimeTemp))).atZone(ZoneId.systemDefault()).toEpochSecond();
        return riskPostStartSecond != workExperiencePostStartSecond || riskPostDepartureSecond != workExperiencePostDepartureSecond;
    }

    public static boolean isPassRiskType(RRiskBasicSource risk) {
        return risk.getType().equals(RiskTypeEnum.PHYSICAL_EXCEPTION_OCC.getValue()) || risk.getType().equals(RiskTypeEnum.PHYSICAL_EXCEPTION_CONTRAINDICATION.getValue());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void defuseList(List<RiskDefuseDto> riskDefuseDtoList) {
        try {
            for (RiskDefuseDto dto : riskDefuseDtoList) {
                try {
                    ResolveRiskForCommonParam defuseParam = new ResolveRiskForCommonParam();
                    defuseParam.setSourceIdList(List.of(dto.getRiskId()));
                    defuseParam.setReformMeasure(dto.getReformMeasure());
                    defuseParam.setAcceptanceWay(dto.getAcceptanceWay());
                    this.riskProvider.resolveRiskOfCommon(defuseParam);
                }
                catch (Exception e) {
                    log.error("\u3010\u4f53\u68c0\u98ce\u9669\u5316\u89e3\u3011\u3010\u5355\u4e2a\u3011\u3010\u8c03\u7528\u5316\u89e3\u65b9\u6cd5\u3011\u5931\u8d25,risk:{}", (Object)dto.getRiskId(), (Object)e);
                }
            }
        }
        catch (Exception e) {
            log.error("\u3010\u4f53\u68c0\u98ce\u9669\u5316\u89e3\u3011\u4f53\u68c0\u98ce\u9669\u5316\u89e3\u5931\u8d25,e:{}", (Throwable)e);
        }
        finally {
            riskDefuseDtoList.clear();
        }
    }

    public static LocalDateTime add240Days(LocalDateTime time) {
        return LocalDateTimeUtil.offset((LocalDateTime)time, (long)RhoTimeEnum.SECOND_OF_240_DAY.getTime(), (TemporalUnit)ChronoUnit.SECONDS);
    }

    @Generated
    public RiskDefuseHCManagerV4(RedissonClient redissonClient, ICStaffBaseInfoService staffBaseInfoService, ICStaffService staffService, IRiskBasicSourceCommonService riskSourceService, ICHealthCheckDataService healthCheckDataService, ICStaffWorkExperienceService staffWorkExperienceService, IRiskAcceptanceRecordCommonService riskAcceptanceRecordService, RiskGenHcInfoV4Mapper riskGenHcInfoV4Mapper, RiskGenSbInfoV4Mapper riskGenSbInfoV4Mapper, RiskGenWeInfoV4Mapper riskGenWeInfoV4Mapper) {
        this.redissonClient = redissonClient;
        this.staffBaseInfoService = staffBaseInfoService;
        this.staffService = staffService;
        this.riskSourceService = riskSourceService;
        this.healthCheckDataService = healthCheckDataService;
        this.staffWorkExperienceService = staffWorkExperienceService;
        this.riskAcceptanceRecordService = riskAcceptanceRecordService;
        this.riskGenHcInfoV4Mapper = riskGenHcInfoV4Mapper;
        this.riskGenSbInfoV4Mapper = riskGenSbInfoV4Mapper;
        this.riskGenWeInfoV4Mapper = riskGenWeInfoV4Mapper;
    }
}

