/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.rho.modules.sys.manger.risk.hc.v4.defuse;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.date.LocalDateTimeUtil;
import cn.smarthse.rho.modules.sys.dao.risk.gen.v4.RiskGenHcInfoV4Mapper;
import cn.smarthse.rho.modules.sys.dao.risk.gen.v4.RiskGenRiskInfoV4Mapper;
import cn.smarthse.rho.modules.sys.dao.risk.gen.v4.RiskGenSbInfoV4Mapper;
import cn.smarthse.rho.modules.sys.dao.risk.gen.v4.RiskGenWeInfoV4Mapper;
import cn.smarthse.rho.modules.sys.entity.c.CHealthCheckData;
import cn.smarthse.rho.modules.sys.entity.c.CStaffWorkExperience;
import cn.smarthse.rho.modules.sys.entity.r.RRiskBasicSource;
import cn.smarthse.rho.modules.sys.enums.risk.RiskPostStatusEnum;
import cn.smarthse.rho.modules.sys.enums.risk.RiskTypeEnum;
import cn.smarthse.rho.modules.sys.enums.risk.defuse.HcDefsuseMeasureEnum;
import cn.smarthse.rho.modules.sys.enums.staff.PostStatusEnum;
import cn.smarthse.rho.modules.sys.manger.risk.hc.v4.defuse.RiskDefuseHCManagerV4;
import cn.smarthse.rho.modules.sys.manger.risk.hc.v4.gen.RiskGenHCDtManagerV4;
import cn.smarthse.rho.modules.sys.manger.risk.hc.v4.gen.RiskGenHCManagerV4;
import cn.smarthse.rho.modules.sys.model.c.vo.staff.RiskStaff;
import cn.smarthse.rho.modules.sys.model.c.vo.staff.RiskStaffBaseInfo;
import cn.smarthse.rho.modules.sys.model.r.param.RiskManagerDefuseParam;
import cn.smarthse.rho.modules.sys.model.r.vo.RiskDefuseDto;
import cn.smarthse.rho.modules.sys.provider.risk.IRiskProvider;
import java.time.LocalDateTime;
import java.time.temporal.TemporalAccessor;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.apache.dubbo.config.annotation.DubboReference;
import org.redisson.api.RLock;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class RiskDefuseHCDtManagerV4 {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RiskDefuseHCDtManagerV4.class);
    private final RedissonClient redissonClient;
    private final RiskDefuseHCManagerV4 riskDefuseHCManagerV4;
    private final RiskGenHCManagerV4 riskGenHCManagerV4;
    private final RiskGenHCDtManagerV4 riskGenHCDtManagerV4;
    private final RiskGenHcInfoV4Mapper riskGenHcInfoV4Mapper;
    private final RiskGenSbInfoV4Mapper riskGenSbInfoV4Mapper;
    private final RiskGenWeInfoV4Mapper riskGenWeInfoV4Mapper;
    private final RiskGenRiskInfoV4Mapper riskGenRiskInfoV4Mapper;
    @DubboReference
    private IRiskProvider riskProvider;
    private static final String LOCK_KEY = "RiskGenManager_dt";
    private static final String WORK_TIME_DIFF_DEFUSE_MEASURE = "\u4eba\u5458\u4e0a\u5c97/\u79bb\u5c97\u65f6\u95f4\u5df2\u4fee\u6539\uff0c\u9700\u91cd\u65b0\u8bc4\u4f30\u98ce\u9669";
    private static final String POST_STATUS_DEFUSE_MEASURE = "\u5c97\u4f4d\u72b6\u6001\u53d8\u66f4\uff0c\u9700\u91cd\u65b0\u8bc4\u4f30\u98ce\u9669";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void defuseHCRisk(RiskManagerDefuseParam param) {
        String title = "\u98ce\u9669\u7ef4\u62a4\uff1a\u4f53\u68c0-\u5316\u89e3";
        String methodName = "defuseHCRisk()";
        log.debug(title + methodName + "start");
        StringBuilder sb = new StringBuilder(LOCK_KEY).append("_").append(methodName).append("_").append(param.getYear());
        RLock lock = this.redissonClient.getLock(sb.toString());
        boolean resLock = false;
        try {
            resLock = lock.tryLock(1L, 3600L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        if (resLock) {
            try {
                this.defuseHCRiskLock(param);
                log.debug(title + methodName + "end");
            }
            catch (Exception e) {
                log.error(title + "\u5931\u8d25{}", (Throwable)e);
            }
            finally {
                lock.unlock();
            }
        } else {
            log.error("{}\uff1aPending lock timeout\uff0cmethod:" + methodName, (Object)LOCK_KEY);
        }
    }

    private void defuseHCRiskLock(RiskManagerDefuseParam param) {
        try {
            this.defuseDtJob(param);
        }
        catch (Exception e) {
            log.error("\u3010\u4f53\u68c0\u98ce\u9669\u5316\u89e3V4\u3011\u3010\u79bb\u5c97\u3011\u3010\u6574\u4f53\u3011\u98ce\u9669\u751f\u6210\u5931\u8d25\u5f02\u5e38\u5f02\u5e38\u5982\u4e0b\uff1a:{}", (Throwable)e);
        }
    }

    private void defuseDtJob(RiskManagerDefuseParam param) {
        List<Long> riskList = this.riskGenRiskInfoV4Mapper.getHealthCheckDtJobRiskIdList2Defuse(param.getCidList());
        ArrayList<RiskDefuseDto> riskDefuseDtoList = new ArrayList<RiskDefuseDto>();
        for (Long rid : riskList) {
            try {
                RRiskBasicSource risk = this.riskGenRiskInfoV4Mapper.getExEnFieldForRisk(rid);
                this.defuseOneDtJob(risk, riskDefuseDtoList);
            }
            catch (Exception e) {
                log.error("\u3010\u4f53\u68c0\u98ce\u9669\u5316\u89e3V4\u3011\u3010\u79bb\u5c97\u3011\u5931\u8d25\uff1arId{}", (Object)rid, (Object)e);
            }
            if (riskDefuseDtoList.size() < 500) continue;
            this.riskDefuseHCManagerV4.defuseList(riskDefuseDtoList);
        }
        if (CollUtil.isNotEmpty(riskDefuseDtoList)) {
            this.riskDefuseHCManagerV4.defuseList(riskDefuseDtoList);
        }
    }

    private void defuseOneDtJob(RRiskBasicSource risk, List<RiskDefuseDto> riskDefuseDtoList) {
        Long sbId = risk.getSubBusinessId();
        Long cid = risk.getCid();
        Long rId = risk.getId();
        RiskStaffBaseInfo staffBaseInfo = null;
        Integer riskType = risk.getType();
        Integer riskSpecialType = risk.getTimeSpecialType();
        Integer riskPostType = risk.getPostType();
        if (!riskType.equals(RiskTypeEnum.PHYSICAL_EXAMINATION.getValue())) {
            log.error("\u3010\u4f53\u68c0\u98ce\u9669\u5316\u89e3V4\u3011\u3010\u79bb\u5c97\u3011\u65e0\u6cd5\u5316\u89e3\u975e\u666e\u901a\u98ce\u9669,\u5316\u89e3\u5931\u8d25\u3002riskId:{}", (Object)rId);
            return;
        }
        if (!riskPostType.equals(RiskPostStatusEnum.DT_POST.getValue())) {
            log.error("\u3010\u4f53\u68c0\u98ce\u9669\u5316\u89e3V4\u3011\u3010\u79bb\u5c97\u3011\u65e0\u6cd5\u5316\u89e3\u975e\u79bb\u5c97\u98ce\u9669,\u5316\u89e3\u5931\u8d25\u3002riskId:{}", (Object)rId);
            return;
        }
        if (sbId == null) {
            log.error("\u3010\u4f53\u68c0\u98ce\u9669\u5316\u89e3V4\u3011\u3010\u79bb\u5c97\u3011\u4f53\u68c0\u98ce\u9669\u7f3a\u5c11\u7528\u6237id,\u5316\u89e3\u5931\u8d25\u3002riskId:{}", (Object)rId);
            return;
        }
        staffBaseInfo = this.riskGenSbInfoV4Mapper.getInfoUnDeFieldForRisk(sbId);
        if (staffBaseInfo == null) {
            riskDefuseDtoList.add(RiskDefuseDto.createSpecialMeasuresDefuse((Long)rId, (String)HcDefsuseMeasureEnum.STAFF_REMOVED.getMeasure()));
            return;
        }
        if (staffBaseInfo != null) {
            RiskStaff staff = this.riskGenSbInfoV4Mapper.getByBaseIdAndCidForRisk(sbId, cid);
            if (staff == null) {
                riskDefuseDtoList.add(RiskDefuseDto.createSpecialMeasuresDefuse((Long)rId, (String)HcDefsuseMeasureEnum.STAFF_REMOVED.getMeasure()));
                return;
            }
            if (staff != null && staff.getPostStatus() != null && !staff.getPostStatus().equals(PostStatusEnum.NON_POST.getValue())) {
                riskDefuseDtoList.add(RiskDefuseDto.createSpecialMeasuresDefuse((Long)rId, (String)HcDefsuseMeasureEnum.JOB_ON_TO_DT.getMeasure()));
                return;
            }
            if (staff != null && staff.getStaffType() != null && staff.getStaffType() != 1) {
                riskDefuseDtoList.add(RiskDefuseDto.createSpecialMeasuresDefuse((Long)rId, (String)HcDefsuseMeasureEnum.RAY_TRUE_TO_FALSE.getMeasure()));
                return;
            }
        }
        if (riskType.equals(RiskTypeEnum.PHYSICAL_EXAMINATION.getValue())) {
            if (riskSpecialType == 1) {
                this.defuseOnePreJobForSpecial(risk, riskDefuseDtoList);
                return;
            }
            if (riskSpecialType == 0) {
                this.defuseOneDtJobForCommon(risk, riskDefuseDtoList);
                return;
            }
        }
    }

    private void defuseOnePreJobForSpecial(RRiskBasicSource risk, List<RiskDefuseDto> riskDefuseDtoList) {
        boolean needDefuse;
        Long sbId = risk.getSubBusinessId();
        Long cid = risk.getCid();
        Long rId = risk.getId();
        CStaffWorkExperience we = null;
        we = this.riskGenWeInfoV4Mapper.getLastWorkExperienceForOnRiskV4(cid, sbId);
        boolean bl = needDefuse = we != null && we.getPostDepartureTime() != null;
        if (needDefuse) {
            riskDefuseDtoList.add(RiskDefuseDto.createCommonMeasuresDefuse((Long)rId, (String)HcDefsuseMeasureEnum.TIME_FULL.getMeasure()));
        }
    }

    private void defuseOneDtJobForCommon(RRiskBasicSource risk, List<RiskDefuseDto> riskDefuseDtoList) {
        Long hcId = risk.getBusinessId();
        Long sbId = risk.getSubBusinessId();
        Long cid = risk.getCid();
        Long weId = risk.getWorkExperienceId();
        Long rId = risk.getId();
        Integer isGenerateByData = risk.getIsGenerateByData();
        LocalDateTime wePostStartTime = null;
        LocalDateTime wePostDepartureTime = null;
        LocalDateTime riskPostStartTime = null;
        LocalDateTime riskPostDepartureTime = null;
        CStaffWorkExperience workExperience = null;
        Object healthCheckData = null;
        if (weId == null) {
            log.error("\u3010\u4f53\u68c0\u98ce\u9669\u5316\u89e3V4\u3011\u3010\u79bb\u5c97\u3011\u4f53\u68c0\u98ce\u9669\u7f3a\u5c11wordExperienceId,\u5316\u89e3\u5931\u8d25\u3002sbId{},riskId:{}", (Object)sbId, (Object)rId);
            return;
        }
        workExperience = this.riskGenWeInfoV4Mapper.getForRiskById(weId);
        if (workExperience == null) {
            riskDefuseDtoList.add(RiskDefuseDto.createSpecialMeasuresDefuse((Long)rId, (String)HcDefsuseMeasureEnum.WE_EDIT.getMeasure()));
            return;
        }
        wePostStartTime = workExperience.getPostStartTime();
        wePostDepartureTime = workExperience.getPostDepartureTime();
        riskPostStartTime = risk.getPostStartTime() == null ? null : LocalDateTimeUtil.of((TemporalAccessor)risk.getPostStartTime());
        LocalDateTime localDateTime = riskPostDepartureTime = risk.getPostDepartureTime() == null ? null : LocalDateTimeUtil.of((TemporalAccessor)risk.getPostDepartureTime());
        if (wePostDepartureTime == null) {
            log.error("\u3010\u4f53\u68c0\u98ce\u9669\u5316\u89e3V4\u3011\u3010\u79bb\u5c97\u3011\u4f53\u68c0\u98ce\u9669\u5bf9\u5e94\u5de5\u4f5c\u7ecf\u5386\u7f3a\u5c11\u79bb\u5c97\u65f6\u95f4,\u5316\u89e3\u5931\u8d25\u3002sbId{},riskId:{}", (Object)sbId, (Object)rId);
            return;
        }
        if (RiskDefuseHCManagerV4.timeDiff(wePostStartTime, wePostDepartureTime, riskPostStartTime, riskPostDepartureTime)) {
            riskDefuseDtoList.add(RiskDefuseDto.createSpecialMeasuresDefuse((Long)rId, (String)HcDefsuseMeasureEnum.WE_EDIT.getMeasure()));
            return;
        }
        if (wePostDepartureTime.isBefore(RiskGenHCManagerV4.SPECIFIC_TIME)) {
            riskDefuseDtoList.add(RiskDefuseDto.createSpecialMeasuresDefuse((Long)rId, (String)HcDefsuseMeasureEnum.WE_EDIT.getMeasure()));
            return;
        }
        if (this.riskGenHCManagerV4.hasOnJobInSameCreditCode(cid, sbId)) {
            riskDefuseDtoList.add(RiskDefuseDto.createSpecialMeasuresDefuse((Long)rId, (String)HcDefsuseMeasureEnum.SAME_CREDIT_HAS_ON_JOB.getMeasure()));
            return;
        }
        CHealthCheckData validData = this.riskGenHCDtManagerV4.getValidForDtJob(sbId, wePostDepartureTime);
        if (validData != null) {
            riskDefuseDtoList.add(RiskDefuseDto.createCommonMeasuresDefuse((Long)rId, (String)HcDefsuseMeasureEnum.COMMON.getMeasure()));
            return;
        }
    }

    @Generated
    public RiskDefuseHCDtManagerV4(RedissonClient redissonClient, RiskDefuseHCManagerV4 riskDefuseHCManagerV4, RiskGenHCManagerV4 riskGenHCManagerV4, RiskGenHCDtManagerV4 riskGenHCDtManagerV4, RiskGenHcInfoV4Mapper riskGenHcInfoV4Mapper, RiskGenSbInfoV4Mapper riskGenSbInfoV4Mapper, RiskGenWeInfoV4Mapper riskGenWeInfoV4Mapper, RiskGenRiskInfoV4Mapper riskGenRiskInfoV4Mapper) {
        this.redissonClient = redissonClient;
        this.riskDefuseHCManagerV4 = riskDefuseHCManagerV4;
        this.riskGenHCManagerV4 = riskGenHCManagerV4;
        this.riskGenHCDtManagerV4 = riskGenHCDtManagerV4;
        this.riskGenHcInfoV4Mapper = riskGenHcInfoV4Mapper;
        this.riskGenSbInfoV4Mapper = riskGenSbInfoV4Mapper;
        this.riskGenWeInfoV4Mapper = riskGenWeInfoV4Mapper;
        this.riskGenRiskInfoV4Mapper = riskGenRiskInfoV4Mapper;
    }
}

