/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.rho.modules.sys.manger.risk.dose.v2.gen;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.date.LocalDateTimeUtil;
import cn.hutool.core.util.StrUtil;
import cn.smarthse.encrypt.spring.utils.SpringEncryptUtils;
import cn.smarthse.rho.modules.sys.dao.risk.gen.dose.v2.RiskGenDoseTotalMapper;
import cn.smarthse.rho.modules.sys.entity.c.CDoseData;
import cn.smarthse.rho.modules.sys.enums.risk.RiskSourceEnum;
import cn.smarthse.rho.modules.sys.enums.risk.RiskTimePointEnum;
import cn.smarthse.rho.modules.sys.enums.risk.RiskTypeEnum;
import cn.smarthse.rho.modules.sys.manger.risk.dose.v2.RiskDoseManagerV2;
import cn.smarthse.rho.modules.sys.model.c.vo.staff.RiskStaffBaseInfo;
import cn.smarthse.rho.modules.sys.model.r.param.AddRiskForCommonParam;
import cn.smarthse.rho.modules.sys.model.r.param.RiskMangerGenParam;
import cn.smarthse.rho.modules.sys.provider.risk.IRiskProvider;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.temporal.TemporalAccessor;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.redisson.api.RLock;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class RiskGenDoseCommonManagerV2 {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RiskGenDoseCommonManagerV2.class);
    private final RedissonClient redissonClient;
    private final IRiskProvider riskProvider;
    private final RiskGenDoseTotalMapper riskGenDoseTotalMapper;
    private final RiskDoseManagerV2 riskDoseManager;
    private static final String LOCK_KEY = "RiskGenManager_dose";
    private static final Integer riskType = RiskTypeEnum.DOSE_MONITORING.getValue();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void genDoseRisk(RiskMangerGenParam param) {
        String title = "\u98ce\u9669\u7ef4\u62a4\uff1a\u4e2a\u4eba\u5242\u91cf\u98ce\u9669-\u751f\u6210";
        String methodName = "genDoseRisk()";
        log.debug(title + methodName + "start");
        StringBuilder sb = new StringBuilder(LOCK_KEY).append("_").append(methodName).append("_").append(param.getYear()).append(param.getThirdLevelAreaId());
        RLock lock = this.redissonClient.getLock(sb.toString());
        boolean resLock = false;
        try {
            resLock = lock.tryLock(30L, 30L, TimeUnit.MINUTES);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        if (resLock) {
            try {
                param.setSpecificTime(RiskTimePointEnum.SPECIAL_TIME.getTime());
                this.genDoseRiskLock(param);
                log.debug(title + methodName + "end");
            }
            catch (Exception e) {
                log.error(title + "\u5931\u8d25{}", (Throwable)e);
            }
            finally {
                lock.unlock();
            }
        } else {
            log.error("{}\uff1aPending lock timeout\uff0cmethod:" + methodName, (Object)LOCK_KEY);
        }
    }

    public void genDoseRiskLock(RiskMangerGenParam param) {
        ArrayList<AddRiskForCommonParam> genListParam = new ArrayList<AddRiskForCommonParam>();
        List<RiskStaffBaseInfo> entityList = this.riskGenDoseTotalMapper.getListForGenDoseCommonRisk(param);
        LocalDateTime current = LocalDateTime.now();
        for (RiskStaffBaseInfo entity : entityList) {
            try {
                this.genCommonRisk(entity, current, genListParam);
            }
            catch (Exception e) {
                log.error("\u3010\u4e2a\u4eba\u5242\u91cf\u98ce\u9669\u751f\u6210\u3011\u3010\u666e\u901a\u3011\u5355\u4e2a\u98ce\u9669\u751f\u6210\u5931\u8d25\uff0csbId{}\uff0ce{}", (Object)entity.getId(), (Object)e);
            }
            if (genListParam.size() < 500) continue;
            this.genBatch(genListParam);
        }
        if (CollUtil.isNotEmpty(genListParam)) {
            this.genBatch(genListParam);
        }
    }

    private void genCommonRisk(RiskStaffBaseInfo staffBaseInfo, LocalDateTime current, List<AddRiskForCommonParam> genListParam) {
        Long sbId;
        Long cid = staffBaseInfo.getCid();
        if (this.riskDoseManager.countValidSdFileForGenCommonDoseRisk(cid, sbId = staffBaseInfo.getId())) {
            return;
        }
        if (this.riskDoseManager.hasUnresolvedCommonDoseRisk(cid, sbId)) {
            return;
        }
        CDoseData lastData = this.riskGenDoseTotalMapper.getLastDataForGenCommonDoseRisk(sbId);
        if (lastData != null) {
            LocalDate endDate = lastData.getEndDate();
            if (RiskDoseManagerV2.hasExpired(LocalDateTimeUtil.of((TemporalAccessor)endDate))) {
                return;
            }
            Integer isGenerateByData = 1;
            LocalDate startTime = endDate;
            Long businessId = lastData.getId();
            Long subBusinessId = sbId;
            String staffName = staffBaseInfo.getName();
            AddRiskForCommonParam genParam = new AddRiskForCommonParam();
            genParam.setCid(cid);
            genParam.setThirdOrgId(null);
            genParam.setBusinessId(businessId);
            genParam.setSubBusinessId(subBusinessId);
            genParam.setSubBusinessName(staffName);
            genParam.setName(null);
            genParam.setSource(RiskSourceEnum.PORTRAIT.getValue());
            genParam.setType(riskType);
            genParam.setFinderName("\u5b9a\u65f6\u4efb\u52a1");
            genParam.setDescription(null);
            genParam.setFiles(null);
            genParam.setStartTime(startTime);
            genParam.setExpireTime(null);
            genParam.setRequireFinishTime(null);
            genParam.setIsGenerateByData(isGenerateByData);
            genListParam.add(genParam);
        } else {
            Integer isGenerateByData = 0;
            LocalDate startTime = null;
            Long businessId = null;
            Long subBusinessId = sbId;
            String staffName = staffBaseInfo.getName();
            AddRiskForCommonParam genParam = new AddRiskForCommonParam();
            genParam.setCid(cid);
            genParam.setThirdOrgId(null);
            genParam.setBusinessId(businessId);
            genParam.setSubBusinessId(subBusinessId);
            genParam.setSubBusinessName(staffName);
            genParam.setName(null);
            genParam.setSource(RiskSourceEnum.PORTRAIT.getValue());
            genParam.setType(riskType);
            genParam.setFinderName("\u5b9a\u65f6\u4efb\u52a1");
            genParam.setDescription(null);
            genParam.setFiles(null);
            genParam.setStartTime(startTime);
            genParam.setExpireTime(null);
            genParam.setRequireFinishTime(null);
            genParam.setIsGenerateByData(isGenerateByData);
            genListParam.add(genParam);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void genBatch(List<AddRiskForCommonParam> genInfoListParam) {
        try {
            for (AddRiskForCommonParam param : genInfoListParam) {
                try {
                    String subBusinessNameDe = SpringEncryptUtils.decrypt((String)param.getSubBusinessName());
                    param.setSubBusinessName(StrUtil.isBlank((CharSequence)subBusinessNameDe) ? "\u672a\u77e5\u59d3\u540d" : subBusinessNameDe);
                }
                catch (Exception e) {
                    log.error("\u3010\u4e2a\u4eba\u5242\u91cf\u98ce\u9669\u751f\u6210\u3011\u3010\u8d85\u5242\u91cf\u3011\u3010\u59d3\u540d\u89e3\u5bc6\u5931\u8d25\u3011sbId:{},sbName:{}, riskType:{}", new Object[]{param.getSubBusinessId(), param.getName(), param.getType(), e});
                }
            }
            this.riskProvider.genRiskOfCommon(genInfoListParam);
        }
        catch (Exception e) {
            log.error("\u3010\u4e2a\u4eba\u5242\u91cf\u98ce\u9669\u751f\u6210\u3011\u3010\u8d85\u5242\u91cf\u3011\u4f53\u68c0\u98ce\u9669\u751f\u6210\u5931\u8d25:{}", (Throwable)e);
        }
        finally {
            genInfoListParam.clear();
        }
    }

    @Generated
    public RiskGenDoseCommonManagerV2(RedissonClient redissonClient, IRiskProvider riskProvider, RiskGenDoseTotalMapper riskGenDoseTotalMapper, RiskDoseManagerV2 riskDoseManager) {
        this.redissonClient = redissonClient;
        this.riskProvider = riskProvider;
        this.riskGenDoseTotalMapper = riskGenDoseTotalMapper;
        this.riskDoseManager = riskDoseManager;
    }
}

