/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.rho.modules.sys.manger.risk.dose.v2.defuse;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.date.LocalDateTimeUtil;
import cn.smarthse.rho.modules.sys.dao.risk.gen.common.RiskGenPBSbInfoMapper;
import cn.smarthse.rho.modules.sys.dao.risk.gen.dose.v2.RiskGenDoseTotalMapper;
import cn.smarthse.rho.modules.sys.entity.c.CDoseData;
import cn.smarthse.rho.modules.sys.entity.c.CStaffBaseInfo;
import cn.smarthse.rho.modules.sys.entity.r.RRiskBasicSource;
import cn.smarthse.rho.modules.sys.enums.risk.RiskTypeEnum;
import cn.smarthse.rho.modules.sys.enums.risk.defuse.DoseDefsuseMeasureEnum;
import cn.smarthse.rho.modules.sys.enums.staff.PostStatusEnum;
import cn.smarthse.rho.modules.sys.manger.risk.dose.v2.RiskDoseManagerV2;
import cn.smarthse.rho.modules.sys.manger.risk.dose.v2.RiskGenDoseManagerV2;
import cn.smarthse.rho.modules.sys.model.c.vo.staff.RiskStaff;
import cn.smarthse.rho.modules.sys.model.r.param.RiskManagerDefuseParam;
import cn.smarthse.rho.modules.sys.model.r.vo.RiskDefuseDto;
import cn.smarthse.rho.modules.sys.provider.risk.IRiskProvider;
import cn.smarthse.rho.modules.sys.service.c.ICDoseDataService;
import cn.smarthse.rho.modules.sys.service.c.ICStaffBaseInfoService;
import cn.smarthse.rho.modules.sys.service.risk.IRiskBasicSourceCommonService;
import java.time.LocalDate;
import java.time.temporal.TemporalAccessor;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.redisson.api.RLock;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class RiskDefuseDoseCommonManagerV2 {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RiskDefuseDoseCommonManagerV2.class);
    private final RedissonClient redissonClient;
    private final IRiskBasicSourceCommonService riskSourceService;
    private final ICDoseDataService doseDataService;
    private final ICStaffBaseInfoService baseInfoService;
    private final RiskGenDoseManagerV2 riskGenDoseManagerV2;
    private final RiskGenDoseTotalMapper riskGenDoseTotalMapper;
    private final RiskGenPBSbInfoMapper pbSbInfoMapper;
    private final RiskDoseManagerV2 riskDoseManager;
    private final IRiskProvider riskProvider;
    private static final String LOCK_KEY = "RiskGenManager";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void defuseDoseRisk(RiskManagerDefuseParam param) {
        String title = "\u98ce\u9669\u7ef4\u62a4\uff1a\u4e2a\u4eba\u5242\u91cf-\u5316\u89e3";
        String methodName = "defuseDoseRisk()";
        log.debug(title + methodName + "start");
        StringBuilder sb = new StringBuilder(LOCK_KEY).append("_").append(methodName).append("_").append(param.getYear());
        RLock lock = this.redissonClient.getLock(sb.toString());
        boolean resLock = false;
        try {
            resLock = lock.tryLock(30L, 30L, TimeUnit.MINUTES);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        if (resLock) {
            try {
                this.defuseDoseHCRiskLock(param);
                log.debug(title + methodName + "end");
            }
            catch (Exception e) {
                log.error("\u3010\u4e2a\u4eba\u5242\u91cf\u98ce\u9669\u5316\u89e3\u3011\u3010\u666e\u901a\u3011\u3010\u6574\u4f53\u3011\u5931\u8d25,e:{}", (Throwable)e);
            }
            finally {
                lock.unlock();
            }
        } else {
            log.error("{}\uff1a\u3010\u4e2a\u4eba\u5242\u91cf\u98ce\u9669\u5316\u89e3\u3011\u3010\u666e\u901a\u3011\u9501\u8d85\u65f6:" + methodName, (Object)LOCK_KEY);
        }
    }

    public void defuseDoseHCRiskLock(RiskManagerDefuseParam param) {
        List<RRiskBasicSource> list = this.riskGenDoseTotalMapper.getDoseCommonRiskForDefuse(param);
        ArrayList<RiskDefuseDto> riskDefuseDtoList = new ArrayList<RiskDefuseDto>();
        for (RRiskBasicSource vo : list) {
            try {
                this.defuseOne(vo, riskDefuseDtoList);
            }
            catch (Exception e) {
                log.error("\u3010\u4e2a\u4eba\u5242\u91cf\u98ce\u9669\u5316\u89e3\u3011\u3010\u666e\u901a\u3011\u3010\u5355\u4e2a\u3011\u5931\u8d25,riskId{},e:{}", (Object)vo.getId(), (Object)e);
            }
            if (riskDefuseDtoList.size() < 500) continue;
            this.riskDoseManager.defuseList(riskDefuseDtoList);
        }
        if (CollUtil.isNotEmpty(riskDefuseDtoList)) {
            this.riskDoseManager.defuseList(riskDefuseDtoList);
        }
    }

    public void defuseOne(RRiskBasicSource vo, List<RiskDefuseDto> riskDefuseDtoList) {
        Integer type;
        Long sbId = vo.getSubBusinessId();
        Long cid = vo.getCid();
        Long rId = vo.getId();
        if (sbId == null) {
            riskDefuseDtoList.add(RiskDefuseDto.createSpecialDefuse((Long)vo.getId()));
            return;
        }
        CStaffBaseInfo staffBaseInfo = (CStaffBaseInfo)this.baseInfoService.getById(vo.getSubBusinessId());
        if (staffBaseInfo == null) {
            riskDefuseDtoList.add(RiskDefuseDto.createSpecialDefuse((Long)vo.getId()));
            return;
        }
        if (staffBaseInfo != null) {
            RiskStaff staff = this.pbSbInfoMapper.getStaffInfoBySbIdAndCid(sbId, cid);
            if (staff == null) {
                riskDefuseDtoList.add(RiskDefuseDto.createSpecialMeasuresDefuse((Long)rId, (String)DoseDefsuseMeasureEnum.STAFF_REMOVED.getMeasure()));
                return;
            }
            if (staff != null && staff.getPostStatus() != null && !staff.getPostStatus().equals(PostStatusEnum.ON_POST.getValue())) {
                riskDefuseDtoList.add(RiskDefuseDto.createSpecialMeasuresDefuse((Long)rId, (String)DoseDefsuseMeasureEnum.JOB_ON_TO_DT.getMeasure()));
                return;
            }
            if (staff != null && staff.getStaffType() != null && staff.getStaffType() != 1) {
                riskDefuseDtoList.add(RiskDefuseDto.createSpecialMeasuresDefuse((Long)rId, (String)DoseDefsuseMeasureEnum.RAY_TRUE_TO_FALSE.getMeasure()));
                return;
            }
        }
        if ((type = vo.getType()) == RiskTypeEnum.DOSE_MONITORING.getValue()) {
            this.defuseOneCommon(vo, riskDefuseDtoList);
        }
    }

    private void defuseOneCommon(RRiskBasicSource vo, List<RiskDefuseDto> riskDefuseDtoList) {
        CDoseData lastData = this.riskGenDoseTotalMapper.getLastDataForGenCommonDoseRisk(vo.getSubBusinessId());
        if (lastData != null) {
            LocalDate endDate = lastData.getEndDate();
            if (RiskDoseManagerV2.hasExpired(LocalDateTimeUtil.of((TemporalAccessor)endDate))) {
                riskDefuseDtoList.add(RiskDefuseDto.createCommonDefuse((Long)vo.getId()));
                return;
            }
        }
    }

    @Generated
    public RiskDefuseDoseCommonManagerV2(RedissonClient redissonClient, IRiskBasicSourceCommonService riskSourceService, ICDoseDataService doseDataService, ICStaffBaseInfoService baseInfoService, RiskGenDoseManagerV2 riskGenDoseManagerV2, RiskGenDoseTotalMapper riskGenDoseTotalMapper, RiskGenPBSbInfoMapper pbSbInfoMapper, RiskDoseManagerV2 riskDoseManager, IRiskProvider riskProvider) {
        this.redissonClient = redissonClient;
        this.riskSourceService = riskSourceService;
        this.doseDataService = doseDataService;
        this.baseInfoService = baseInfoService;
        this.riskGenDoseManagerV2 = riskGenDoseManagerV2;
        this.riskGenDoseTotalMapper = riskGenDoseTotalMapper;
        this.pbSbInfoMapper = pbSbInfoMapper;
        this.riskDoseManager = riskDoseManager;
        this.riskProvider = riskProvider;
    }
}

