/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.rho.modules.sys.manger.risk.dose.v2;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.date.LocalDateTimeUtil;
import cn.hutool.core.util.StrUtil;
import cn.smarthse.rho.modules.sys.entity.c.CDoseData;
import cn.smarthse.rho.modules.sys.entity.c.CStaffBaseInfo;
import cn.smarthse.rho.modules.sys.entity.r.RRiskBasicSource;
import cn.smarthse.rho.modules.sys.enums.RhoTimeEnum;
import cn.smarthse.rho.modules.sys.enums.risk.RiskSourceEnum;
import cn.smarthse.rho.modules.sys.enums.risk.RiskTypeEnum;
import cn.smarthse.rho.modules.sys.enums.staff.PostStatusEnum;
import cn.smarthse.rho.modules.sys.enums.staff.StaffTypeEnum;
import cn.smarthse.rho.modules.sys.manger.risk.RiskGenHCManagerV3;
import cn.smarthse.rho.modules.sys.model.r.param.AddRiskForCommonParam;
import cn.smarthse.rho.modules.sys.model.r.param.RiskMangerGenParam;
import cn.smarthse.rho.modules.sys.provider.risk.IRiskProvider;
import cn.smarthse.rho.modules.sys.service.c.ICDoseDataService;
import cn.smarthse.rho.modules.sys.service.c.ICStaffBaseInfoService;
import cn.smarthse.rho.modules.sys.service.risk.IRiskBasicSourceCommonService;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalUnit;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.redisson.api.RLock;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class RiskGenDoseManagerV2 {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RiskGenDoseManagerV2.class);
    private final ICStaffBaseInfoService staffBaseInfoService;
    private final ICDoseDataService doseDataService;
    private final IRiskBasicSourceCommonService riskBasicSourceService;
    private final RedissonClient redissonClient;
    private final IRiskProvider riskProvider;
    private static final String LOCK_KEY = "RiskGenManager";
    private static final Integer CURR_YEAR = RiskGenHCManagerV3.CURR_YEAR;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void genDoseRisk(RiskMangerGenParam param) {
        String title = "\u98ce\u9669\u7ef4\u62a4\uff1a\u4e2a\u4eba\u5242\u91cf\u98ce\u9669-\u751f\u6210";
        String methodName = "genDoseRisk()";
        log.debug(title + methodName + "start");
        StringBuilder sb = new StringBuilder(LOCK_KEY).append("_").append(methodName).append("_").append(param.getYear()).append(param.getThirdLevelAreaId());
        RLock lock = this.redissonClient.getLock(sb.toString());
        boolean resLock = false;
        try {
            resLock = lock.tryLock(30L, 30L, TimeUnit.MINUTES);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        if (resLock) {
            try {
                this.genDoseRiskLock(param);
                log.debug(title + methodName + "end");
            }
            catch (Exception e) {
                log.error(title + "\u5931\u8d25{}", (Throwable)e);
            }
            finally {
                lock.unlock();
            }
        } else {
            log.error("{}\uff1aPending lock timeout\uff0cmethod:" + methodName, (Object)LOCK_KEY);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void genDoseRiskLock(RiskMangerGenParam param) {
        ArrayList<AddRiskForCommonParam> genListParam = new ArrayList<AddRiskForCommonParam>();
        List<CStaffBaseInfo> entityList = this.staffBaseInfoService.getListForGenDoseRisk(param);
        LocalDateTime current = LocalDateTime.now();
        for (CStaffBaseInfo entity : entityList) {
            try {
                this.genCommonRisk(entity, current, genListParam);
            }
            catch (Exception e) {
                log.error("\u3010\u4e2a\u4eba\u5242\u91cf\u5206\u6790\u751f\u6210\u3011\u3010\u666e\u901a\u3011\u5355\u4e2a\u98ce\u9669\u751f\u6210\u5931\u8d25\uff0csbId{}\uff0ce{}", (Object)entity.getId(), (Object)e);
            }
            try {
                this.genErrorRisk(entity, current, genListParam);
            }
            catch (Exception e) {
                log.error("\u3010\u4e2a\u4eba\u5242\u91cf\u5206\u6790\u751f\u6210\u3011\u3010\u5f02\u5e38\u3011\u5355\u4e2a\u98ce\u9669\u751f\u6210\u5931\u8d25\uff0csbId{}\uff0ce{}", (Object)entity.getId(), (Object)e);
            }
            if (genListParam.size() < 500) continue;
            try {
                this.riskProvider.genRiskOfCommon(genListParam);
            }
            catch (Exception e) {
                log.error("\u4e2a\u4eba\u5242\u91cf\u98ce\u9669\u751f\u6210\u5931\u8d25:{}", (Throwable)e);
            }
            finally {
                genListParam.clear();
            }
        }
        try {
            if (CollUtil.isNotEmpty(genListParam)) {
                this.riskProvider.genRiskOfCommon(genListParam);
            }
        }
        catch (Exception e) {
            log.error("\u8bb8\u53ef\u8bc1\u98ce\u9669\u751f\u6210\u5931\u8d25:{}", (Throwable)e);
        }
        finally {
            genListParam.clear();
        }
    }

    public CDoseData getValidData(LocalDateTime time, Long sbId) {
        LocalDateTime s = RiskGenDoseManagerV2.sub90Days(time);
        CDoseData validData = this.doseDataService.getLastDataForGenDoseRisk(sbId, s);
        return validData;
    }

    private void genErrorRisk(CStaffBaseInfo staffBaseInfo, LocalDateTime current, List<AddRiskForCommonParam> genListParam) {
        Long sbId = staffBaseInfo.getId();
        Integer riskType = RiskTypeEnum.DOSE_EXCEPTION_OVERDOSE.getValue();
        CDoseData validData = this.getLastDataForGenErrorDoseRisk(staffBaseInfo.getId());
        if (validData == null) {
            return;
        }
        Boolean isBigDose = validData.getIsBigDose();
        if (!isBigDose.booleanValue() || isBigDose.booleanValue() && StrUtil.isNotBlank((CharSequence)validData.getBigDoseReport())) {
            return;
        }
        LocalDate startTime = validData.getCheckDate();
        LocalDate expireTime = RiskGenDoseManagerV2.add90Days(LocalDateTimeUtil.of((TemporalAccessor)startTime)).toLocalDate();
        Integer isGenerateByData = 1;
        LocalDateTime s2 = RiskGenDoseManagerV2.sub90Days(current);
        List<Long> cidList = this.staffBaseInfoService.getCidList(sbId, PostStatusEnum.ON_POST.getValue(), StaffTypeEnum.RAY.getValue());
        for (Long cid : cidList) {
            RRiskBasicSource risk = this.riskBasicSourceService.getLastRiskForErrorGenDoseRisk(sbId, cid, s2);
            if (risk != null) continue;
            Long businessId = validData.getId();
            Long subBusinessId = sbId;
            AddRiskForCommonParam genParam = new AddRiskForCommonParam();
            genParam.setCid(cid);
            genParam.setThirdOrgId(null);
            genParam.setBusinessId(businessId);
            genParam.setSubBusinessId(subBusinessId);
            genParam.setSubBusinessName(staffBaseInfo.getName());
            genParam.setName(null);
            genParam.setSource(RiskSourceEnum.PORTRAIT.getValue());
            genParam.setType(riskType);
            genParam.setFinderName("\u5b9a\u65f6\u4efb\u52a1");
            genParam.setDescription(null);
            genParam.setFiles(null);
            genParam.setStartTime(startTime);
            genParam.setExpireTime(expireTime);
            genParam.setRequireFinishTime(null);
            genParam.setIsGenerateByData(isGenerateByData);
            genListParam.add(genParam);
        }
    }

    private void genCommonRisk(CStaffBaseInfo staffBaseInfo, LocalDateTime current, List<AddRiskForCommonParam> genListParam) {
        LocalDate endDate;
        LocalDateTime expireDate;
        Integer riskType = RiskTypeEnum.DOSE_MONITORING.getValue();
        CDoseData validData = this.getLastDataForGenCommonDoseRisk(staffBaseInfo.getId());
        if (validData != null && ((expireDate = LocalDateTimeUtil.offset((LocalDateTime)LocalDateTimeUtil.of((TemporalAccessor)(endDate = validData.getEndDate())), (long)90L, (TemporalUnit)ChronoUnit.DAYS)).isAfter(current) || expireDate.isEqual(current))) {
            return;
        }
        List<Long> cidList = this.staffBaseInfoService.getCidList(staffBaseInfo.getId(), PostStatusEnum.ON_POST.getValue(), StaffTypeEnum.RAY.getValue());
        for (Long cid : cidList) {
            RRiskBasicSource risk = this.riskBasicSourceService.getLastRiskForCommonGenDoseRisk(staffBaseInfo.getId(), cid);
            if (risk != null) continue;
            Long subBusinessId = staffBaseInfo.getId();
            Integer isGenerateByData = validData == null ? 0 : 1;
            LocalDate startTime = isGenerateByData == null ? LocalDate.from(current) : LocalDate.from(validData.getCheckDate());
            AddRiskForCommonParam genParam = new AddRiskForCommonParam();
            genParam.setCid(cid);
            genParam.setThirdOrgId(null);
            genParam.setBusinessId(null);
            genParam.setSubBusinessId(subBusinessId);
            genParam.setSubBusinessName(staffBaseInfo.getName());
            genParam.setName(null);
            genParam.setSource(RiskSourceEnum.PORTRAIT.getValue());
            genParam.setType(riskType);
            genParam.setFinderName("\u5b9a\u65f6\u4efb\u52a1");
            genParam.setDescription(null);
            genParam.setFiles(null);
            genParam.setStartTime(startTime);
            genParam.setExpireTime(null);
            genParam.setRequireFinishTime(null);
            genParam.setIsGenerateByData(isGenerateByData);
            genListParam.add(genParam);
        }
    }

    public CDoseData getLastDataForGenCommonDoseRisk(Long staffBaseInfoId) {
        return this.doseDataService.getLastDataForGenCommonDoseRisk(staffBaseInfoId);
    }

    public CDoseData getLastDataForGenErrorDoseRisk(Long staffBaseInfoId) {
        return this.doseDataService.getLastDataForGenErrorDoseRisk(staffBaseInfoId);
    }

    public static LocalDateTime sub90Days(LocalDateTime time) {
        LocalDateTime onlyDate = LocalDateTimeUtil.of((TemporalAccessor)time.toLocalTime());
        return LocalDateTimeUtil.offset((LocalDateTime)onlyDate, (long)(-RhoTimeEnum.SECOND_OF_90_DAY.getTime().longValue()), (TemporalUnit)ChronoUnit.SECONDS);
    }

    public static LocalDateTime add90Days(LocalDateTime time) {
        LocalDateTime onlyDate = LocalDateTimeUtil.of((TemporalAccessor)time.toLocalTime());
        return LocalDateTimeUtil.offset((LocalDateTime)onlyDate, (long)RhoTimeEnum.SECOND_OF_90_DAY.getTime(), (TemporalUnit)ChronoUnit.SECONDS);
    }

    @Generated
    public RiskGenDoseManagerV2(ICStaffBaseInfoService staffBaseInfoService, ICDoseDataService doseDataService, IRiskBasicSourceCommonService riskBasicSourceService, RedissonClient redissonClient, IRiskProvider riskProvider) {
        this.staffBaseInfoService = staffBaseInfoService;
        this.doseDataService = doseDataService;
        this.riskBasicSourceService = riskBasicSourceService;
        this.redissonClient = redissonClient;
        this.riskProvider = riskProvider;
    }
}

