/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.rho.modules.sys.manger.risk.dose.v2;

import cn.hutool.core.date.LocalDateTimeUtil;
import cn.smarthse.rho.modules.sys.dao.risk.gen.common.RiskGenPBAssistanceMapper;
import cn.smarthse.rho.modules.sys.dao.risk.gen.dose.v2.RiskGenDoseTotalMapper;
import cn.smarthse.rho.modules.sys.entity.c.CDoseData;
import cn.smarthse.rho.modules.sys.enums.RhoTimeEnum;
import cn.smarthse.rho.modules.sys.manger.risk.RiskGenHCManagerV3;
import cn.smarthse.rho.modules.sys.model.r.param.ResolveRiskForCommonParam;
import cn.smarthse.rho.modules.sys.model.r.param.RiskMangerGenParam;
import cn.smarthse.rho.modules.sys.model.r.vo.RiskDefuseDto;
import cn.smarthse.rho.modules.sys.provider.risk.IRiskProvider;
import cn.smarthse.rho.modules.sys.service.c.ICDoseDataService;
import cn.smarthse.rho.modules.sys.service.c.ICStaffBaseInfoService;
import cn.smarthse.rho.modules.sys.service.risk.IRiskBasicSourceCommonService;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalUnit;
import java.util.List;
import lombok.Generated;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class RiskDoseManagerV2 {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RiskDoseManagerV2.class);
    private final ICStaffBaseInfoService staffBaseInfoService;
    private final ICDoseDataService doseDataService;
    private final IRiskBasicSourceCommonService riskBasicSourceService;
    private final RiskGenPBAssistanceMapper pbAssistanceMapper;
    private final RiskGenDoseTotalMapper riskGenDoseTotalMapper;
    private final RedissonClient redissonClient;
    private final IRiskProvider riskProvider;
    private static final String LOCK_KEY = "RiskGenManager";
    private static final Integer CURR_YEAR = RiskGenHCManagerV3.CURR_YEAR;

    public void initAssistance(RiskMangerGenParam param) {
        if (param.getNeedInitAssistance() == 1) {
            this.pbAssistanceMapper.initAssistance(param);
            this.pbAssistanceMapper.initAssistancePostTime(param);
            this.pbAssistanceMapper.initAssistanceDose(param);
        }
    }

    public CDoseData getLastDataForGenCommonDoseRisk(Long staffBaseInfoId) {
        return this.doseDataService.getLastDataForGenCommonDoseRisk(staffBaseInfoId);
    }

    public CDoseData getLastDataForGenErrorDoseRisk(Long staffBaseInfoId) {
        return this.doseDataService.getLastDataForGenErrorDoseRisk(staffBaseInfoId);
    }

    public static LocalDateTime sub90Days(LocalDateTime time) {
        LocalDateTime onlyDate = LocalDateTimeUtil.of((TemporalAccessor)time.toLocalTime());
        return LocalDateTimeUtil.offset((LocalDateTime)onlyDate, (long)(-RhoTimeEnum.SECOND_OF_90_DAY.getTime().longValue()), (TemporalUnit)ChronoUnit.SECONDS);
    }

    public static LocalDateTime add90Days(LocalDateTime time) {
        LocalDateTime onlyDate = LocalDateTimeUtil.of((TemporalAccessor)time.toLocalTime());
        return LocalDateTimeUtil.offset((LocalDateTime)onlyDate, (long)RhoTimeEnum.SECOND_OF_90_DAY.getTime(), (TemporalUnit)ChronoUnit.SECONDS);
    }

    public static boolean hasExpired(LocalDateTime endDate) {
        LocalDateTime current;
        LocalDateTime expireDate = RiskDoseManagerV2.add90Days(LocalDateTimeUtil.of((TemporalAccessor)endDate));
        return !expireDate.isAfter(current = LocalDateTime.now());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void defuseList(List<RiskDefuseDto> riskDefuseDtoList) {
        try {
            for (RiskDefuseDto dto : riskDefuseDtoList) {
                try {
                    ResolveRiskForCommonParam defuseParam = new ResolveRiskForCommonParam();
                    defuseParam.setSourceIdList(List.of(dto.getRiskId()));
                    defuseParam.setReformMeasure(dto.getReformMeasure());
                    defuseParam.setAcceptanceWay(dto.getAcceptanceWay());
                    this.riskProvider.resolveRiskOfCommon(defuseParam);
                }
                catch (Exception e) {
                    log.error("\u3010\u4e2a\u4eba\u5242\u91cf\u98ce\u9669\u5316\u89e3\u3011\u3010\u666e\u901a\u3011\u3010\u5355\u4e2a\u3011\u3010\u8c03\u7528\u5316\u89e3\u65b9\u6cd5\u3011\u5931\u8d25,risk:{}", (Object)dto.getRiskId(), (Object)e);
                }
            }
        }
        catch (Exception e) {
            log.error("\u3010\u4e2a\u4eba\u5242\u91cf\u98ce\u9669\u5316\u89e3\u3011\u3010\u666e\u901a\u3011\u4f53\u68c0\u98ce\u9669\u5316\u89e3\u5931\u8d25,e:{}", (Throwable)e);
        }
        finally {
            riskDefuseDtoList.clear();
        }
    }

    public boolean hasUnresolvedCommonDoseRisk(Long cid, Long sbId) {
        int num = this.riskGenDoseTotalMapper.countUnresolvedCommonDoseRisk(cid, sbId);
        return num > 0;
    }

    public boolean hasUnresolvedBigDoseRisk(Long cid, Long sbId) {
        int num = this.riskGenDoseTotalMapper.hasUnresolvedBigDoseRisk(cid, sbId);
        return num > 0;
    }

    public boolean countValidSdFileForGenCommonDoseRisk(Long cid, Long sbId) {
        int num = this.riskGenDoseTotalMapper.countValidSdFileForGenCommonDoseRisk(cid, sbId);
        return num > 0;
    }

    public boolean countValidSdFileForGenBigDoseRisk(Long cid, Long sbId) {
        int num = this.riskGenDoseTotalMapper.countValidSdFileForGenBigDoseRisk(cid, sbId);
        return num > 0;
    }

    @Generated
    public RiskDoseManagerV2(ICStaffBaseInfoService staffBaseInfoService, ICDoseDataService doseDataService, IRiskBasicSourceCommonService riskBasicSourceService, RiskGenPBAssistanceMapper pbAssistanceMapper, RiskGenDoseTotalMapper riskGenDoseTotalMapper, RedissonClient redissonClient, IRiskProvider riskProvider) {
        this.staffBaseInfoService = staffBaseInfoService;
        this.doseDataService = doseDataService;
        this.riskBasicSourceService = riskBasicSourceService;
        this.pbAssistanceMapper = pbAssistanceMapper;
        this.riskGenDoseTotalMapper = riskGenDoseTotalMapper;
        this.redissonClient = redissonClient;
        this.riskProvider = riskProvider;
    }
}

