/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.rho.modules.sys.manger.risk.dose.v2;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.date.LocalDateTimeUtil;
import cn.hutool.core.util.StrUtil;
import cn.smarthse.rho.modules.sys.entity.c.CDoseData;
import cn.smarthse.rho.modules.sys.entity.c.CStaffBaseInfo;
import cn.smarthse.rho.modules.sys.entity.r.RRiskBasicSource;
import cn.smarthse.rho.modules.sys.enums.risk.RiskAcceptanceWayEnum;
import cn.smarthse.rho.modules.sys.manger.risk.dose.v2.RiskGenDoseManagerV2;
import cn.smarthse.rho.modules.sys.model.r.param.ResolveRiskForCommonParam;
import cn.smarthse.rho.modules.sys.model.r.param.RiskManagerDefuseParam;
import cn.smarthse.rho.modules.sys.model.r.vo.RiskDefuseDto;
import cn.smarthse.rho.modules.sys.provider.risk.IRiskProvider;
import cn.smarthse.rho.modules.sys.service.c.ICDoseDataService;
import cn.smarthse.rho.modules.sys.service.c.ICStaffBaseInfoService;
import cn.smarthse.rho.modules.sys.service.risk.IRiskBasicSourceCommonService;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalUnit;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import lombok.Generated;
import org.redisson.api.RLock;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class RiskDefuseDoseManagerV2 {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RiskDefuseDoseManagerV2.class);
    private final RedissonClient redissonClient;
    private final IRiskBasicSourceCommonService riskSourceService;
    private final ICDoseDataService doseDataService;
    private final ICStaffBaseInfoService baseInfoService;
    private final RiskGenDoseManagerV2 riskGenDoseManagerV2;
    private final IRiskProvider riskProvider;
    private static final String LOCK_KEY = "RiskGenManager";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void defuseDoseRisk(RiskManagerDefuseParam param) {
        String title = "\u98ce\u9669\u7ef4\u62a4\uff1a\u4e2a\u4eba\u5242\u91cf-\u5316\u89e3";
        String methodName = "defuseDoseRisk()";
        log.debug(title + methodName + "start");
        StringBuilder sb = new StringBuilder(LOCK_KEY).append("_").append(methodName).append("_").append(param.getYear());
        RLock lock = this.redissonClient.getLock(sb.toString());
        boolean resLock = false;
        try {
            resLock = lock.tryLock(30L, 30L, TimeUnit.MINUTES);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        if (resLock) {
            try {
                this.defuseDoseHCRiskLock(param);
                log.debug(title + methodName + "end");
            }
            catch (Exception e) {
                log.error("\u3010\u4e2a\u4eba\u5242\u91cf\u98ce\u9669\u5316\u89e3\u3011\u3010\u6574\u4f53\u3011\u5931\u8d25,e:{}", (Throwable)e);
            }
            finally {
                lock.unlock();
            }
        } else {
            log.error("{}\uff1a\u3010\u4e2a\u4eba\u5242\u91cf\u98ce\u9669\u5316\u89e3\u3011\u9501\u8d85\u65f6:" + methodName, (Object)LOCK_KEY);
        }
    }

    public void defuseDoseHCRiskLock(RiskManagerDefuseParam param) {
        List<RRiskBasicSource> list = this.riskSourceService.getDoseRiskForManager(param);
        ArrayList<RiskDefuseDto> riskDefuseDtoList = new ArrayList<RiskDefuseDto>();
        for (RRiskBasicSource vo : list) {
            try {
                this.defuseOne(vo, riskDefuseDtoList);
            }
            catch (Exception e) {
                log.error("\u3010\u4e2a\u4eba\u5242\u91cf\u98ce\u9669\u5316\u89e3\u3011\u3010\u5355\u4e2a\u3011\u5931\u8d25,riskId{},e:{}", (Object)vo.getId(), (Object)e);
            }
            if (riskDefuseDtoList.size() < 500) continue;
            this.defuseList(riskDefuseDtoList);
        }
        if (CollUtil.isNotEmpty(riskDefuseDtoList)) {
            this.defuseList(riskDefuseDtoList);
        }
    }

    public void defuseOne(RRiskBasicSource vo, List<RiskDefuseDto> riskDefuseDtoList) {
        if (vo.getSubBusinessId() == null) {
            riskDefuseDtoList.add(RiskDefuseDto.createSpecialDefuse((Long)vo.getId()));
            return;
        }
        CStaffBaseInfo staffBaseInfo = (CStaffBaseInfo)this.baseInfoService.getById(vo.getSubBusinessId());
        if (staffBaseInfo == null) {
            riskDefuseDtoList.add(RiskDefuseDto.createSpecialDefuse((Long)vo.getId()));
            return;
        }
        Integer type = vo.getType();
        if (type == 105) {
            this.defuseOneCommon(vo, riskDefuseDtoList);
        } else if (type == 105002) {
            this.defuseOneError(vo, riskDefuseDtoList);
        }
    }

    private void defuseOneError(RRiskBasicSource vo, List<RiskDefuseDto> riskDefuseDtoList) {
        CDoseData validData = this.riskGenDoseManagerV2.getLastDataForGenErrorDoseRisk(vo.getSubBusinessId());
        Boolean isBigDose = validData.getIsBigDose();
        if (!isBigDose.booleanValue() || isBigDose.booleanValue() && StrUtil.isNotBlank((CharSequence)validData.getBigDoseReport())) {
            riskDefuseDtoList.add(RiskDefuseDto.createCommonDefuse((Long)vo.getId()));
            return;
        }
    }

    private void defuseOneCommon(RRiskBasicSource vo, List<RiskDefuseDto> riskDefuseDtoList) {
        LocalDateTime current;
        LocalDate endDate;
        LocalDateTime expireDate;
        CDoseData validData = this.riskGenDoseManagerV2.getLastDataForGenCommonDoseRisk(vo.getSubBusinessId());
        if (validData != null && ((expireDate = LocalDateTimeUtil.offset((LocalDateTime)LocalDateTimeUtil.of((TemporalAccessor)(endDate = validData.getEndDate())), (long)90L, (TemporalUnit)ChronoUnit.DAYS)).isAfter(current = LocalDateTime.now()) || expireDate.isEqual(current))) {
            riskDefuseDtoList.add(RiskDefuseDto.createCommonDefuse((Long)vo.getId()));
            return;
        }
    }

    private void defuseList(List<RiskDefuseDto> riskDefuseDtoList) {
        try {
            Map<Integer, List<RiskDefuseDto>> riskDefuseDtoListMap = riskDefuseDtoList.stream().collect(Collectors.groupingBy(RiskDefuseDto::getAcceptanceWay));
            riskDefuseDtoListMap.forEach((acceptanceWay, list) -> {
                if (acceptanceWay.equals(RiskAcceptanceWayEnum.DATA.getValue())) {
                    ResolveRiskForCommonParam defuseParam = new ResolveRiskForCommonParam();
                    defuseParam.setSourceIdList(list.stream().map(v -> v.getRiskId()).collect(Collectors.toList()));
                    defuseParam.setAcceptanceWay(acceptanceWay);
                    this.riskProvider.resolveRiskOfCommon(defuseParam);
                }
                if (acceptanceWay.equals(RiskAcceptanceWayEnum.SPECIAL_FOREVER.getValue())) {
                    Map<String, List<RiskDefuseDto>> measureWayMap = list.stream().collect(Collectors.groupingBy(v -> v.getReformMeasure()));
                    measureWayMap.forEach((measure, specialList) -> {
                        ResolveRiskForCommonParam defuseParam = new ResolveRiskForCommonParam();
                        defuseParam.setSourceIdList(specialList.stream().map(v -> v.getRiskId()).collect(Collectors.toList()));
                        defuseParam.setAcceptanceWay(acceptanceWay);
                        defuseParam.setReformMeasure(measure.equals("NULL") ? null : measure);
                        this.riskProvider.resolveRiskOfCommon(defuseParam);
                    });
                }
            });
        }
        catch (Exception e) {
            log.error("\u3010\u4e2a\u4eba\u5242\u91cf\u98ce\u9669\u5316\u89e3\u3011\u4f53\u68c0\u98ce\u9669\u5316\u89e3\u5931\u8d25,e:{}", (Throwable)e);
        }
        finally {
            riskDefuseDtoList.clear();
        }
    }

    @Generated
    public RiskDefuseDoseManagerV2(RedissonClient redissonClient, IRiskBasicSourceCommonService riskSourceService, ICDoseDataService doseDataService, ICStaffBaseInfoService baseInfoService, RiskGenDoseManagerV2 riskGenDoseManagerV2, IRiskProvider riskProvider) {
        this.redissonClient = redissonClient;
        this.riskSourceService = riskSourceService;
        this.doseDataService = doseDataService;
        this.baseInfoService = baseInfoService;
        this.riskGenDoseManagerV2 = riskGenDoseManagerV2;
        this.riskProvider = riskProvider;
    }
}

