/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.rho.modules.sys.manger.risk;

import cn.hutool.core.date.LocalDateTimeUtil;
import cn.hutool.core.util.StrUtil;
import cn.smarthse.encrypt.spring.utils.SpringEncryptUtils;
import cn.smarthse.rho.modules.sys.entity.c.CTrainingCert;
import cn.smarthse.rho.modules.sys.entity.r.RRiskBasicSource;
import cn.smarthse.rho.modules.sys.enums.RhoTimeEnum;
import cn.smarthse.rho.modules.sys.enums.risk.RiskCategoryEnum;
import cn.smarthse.rho.modules.sys.enums.risk.RiskSourceEnum;
import cn.smarthse.rho.modules.sys.enums.risk.RiskTypeEnum;
import cn.smarthse.rho.modules.sys.enums.risk.RiskWarningStatusEnum;
import cn.smarthse.rho.modules.sys.enums.staff.PostStatusEnum;
import cn.smarthse.rho.modules.sys.enums.staff.StaffTypeEnum;
import cn.smarthse.rho.modules.sys.manger.risk.RiskGenHCManagerV3;
import cn.smarthse.rho.modules.sys.model.c.vo.staff.RiskStaffBaseInfo;
import cn.smarthse.rho.modules.sys.model.r.param.AddRiskForCommonParam;
import cn.smarthse.rho.modules.sys.model.r.param.RiskMangerGenParam;
import cn.smarthse.rho.modules.sys.model.r.vo.CalculateVo;
import cn.smarthse.rho.modules.sys.provider.risk.IRiskProvider;
import cn.smarthse.rho.modules.sys.service.c.ICStaffBaseInfoService;
import cn.smarthse.rho.modules.sys.service.c.ICTrainingCertService;
import cn.smarthse.rho.modules.sys.service.risk.IRiskBasicSourceCommonService;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalUnit;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.redisson.api.RLock;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class RiskGenTrainingManager {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RiskGenTrainingManager.class);
    private final ICTrainingCertService trainingCertService;
    private final ICStaffBaseInfoService staffBaseInfoService;
    private final IRiskBasicSourceCommonService riskBasicSourceService;
    private final RedissonClient redissonClient;
    private final IRiskProvider riskProvider;
    private static final String LOCK_KEY = "RiskGenManager";
    public static final Integer CURR_YEAR = RiskGenHCManagerV3.CURR_YEAR;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void genTrainingRisk(RiskMangerGenParam param) {
        String title = "\u3010\u57f9\u8bad\u98ce\u9669\u751f\u6210\u3011\u3010\u6574\u4f53\u3011";
        String methodName = "genTrainingRisk()";
        log.debug(title + methodName + "start");
        StringBuilder sb = new StringBuilder(LOCK_KEY).append("_").append(methodName).append("_").append(param.getYear()).append(param.getThirdLevelAreaId());
        RLock lock = this.redissonClient.getLock(sb.toString());
        boolean resLock = false;
        try {
            resLock = lock.tryLock(1L, 3600L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        if (resLock) {
            try {
                this.genTrainingRiskLock(param);
                log.debug(title + methodName + "end");
            }
            catch (Exception e) {
                log.error(title + "\u5931\u8d25{}", (Throwable)e);
            }
            finally {
                lock.unlock();
            }
        } else {
            log.error("{}\uff1aPending lock timeout\uff0cmethod:" + methodName, (Object)LOCK_KEY);
        }
    }

    public void genTrainingRiskLock(RiskMangerGenParam param) {
        LocalDateTime current = LocalDateTime.now();
        List<RiskStaffBaseInfo> entityList = this.staffBaseInfoService.getListForGenTrainingRisk(param);
        ArrayList<AddRiskForCommonParam> genListParam = new ArrayList<AddRiskForCommonParam>();
        for (RiskStaffBaseInfo entity : entityList) {
            LocalDateTime s = current;
            CTrainingCert lastData = this.trainingCertService.getLastTrainingCheckDataTimeLimitForGenRisk(entity.getId(), s);
            if (lastData != null) {
                this.genHasDataInfo(entity, lastData, genListParam);
            } else {
                this.genNonDataInfo(entity, genListParam);
            }
            if (genListParam.size() < 500) continue;
            this.genRiskBatch(genListParam);
        }
        this.genRiskBatch(genListParam);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void genRiskBatch(List<AddRiskForCommonParam> genListParam) {
        try {
            for (AddRiskForCommonParam param : genListParam) {
                try {
                    String subBusinessNameDe = SpringEncryptUtils.decrypt((String)param.getSubBusinessName());
                    param.setSubBusinessName(StrUtil.isBlank((CharSequence)subBusinessNameDe) ? "\u672a\u77e5\u59d3\u540d" : subBusinessNameDe);
                }
                catch (Exception e) {
                    log.error("\u3010\u57f9\u8bad\u98ce\u9669\u751f\u6210V3\u3011\u3010\u59d3\u540d\u89e3\u5bc6\u5931\u8d25\u3011sbId:{},sbName:{}, riskType:{}", new Object[]{param.getSubBusinessId(), param.getName(), param.getType(), e});
                }
            }
            this.riskProvider.genRiskOfCommon(genListParam);
        }
        catch (Exception e) {
            log.error("\u8bb8\u53ef\u8bc1\u98ce\u9669\u751f\u6210\u5931\u8d25:{}", (Throwable)e);
        }
        finally {
            genListParam.clear();
        }
    }

    private void genHasDataInfo(RiskStaffBaseInfo entity, CTrainingCert lastData, List<AddRiskForCommonParam> genListParam) {
        LocalDate issuanceDate = lastData.getIssuanceDate();
        LocalDate certValidDate = lastData.getCertValidDate();
        Long certId = lastData.getId();
        Long sbId = entity.getId();
        if (issuanceDate == null) {
            log.error("\u3010\u57f9\u8bad\u98ce\u9669\u751f\u6210\u3011\u3010\u6709\u6570\u636e\u3011\u3010\u7f3a\u5c11\u53d1\u8bc1\u65f6\u95f4\u3011\u751f\u6210\u5931\u8d25:sbId{},trainingCert{}", (Object)sbId, (Object)certId);
            return;
        }
        if (certValidDate == null) {
            log.error("\u3010\u57f9\u8bad\u98ce\u9669\u751f\u6210\u3011\u3010\u6709\u6570\u636e\u3011\u3010\u7f3a\u5c11\u6709\u6548\u671f\u3011\u751f\u6210\u5931\u8d25:sbId{},trainingCert{}", (Object)sbId, (Object)certId);
            return;
        }
        LocalDateTime expireTime = LocalDateTimeUtil.of((TemporalAccessor)certValidDate);
        Integer warnType = RiskGenTrainingManager.calculateHasDataWarningType(LocalDateTime.now(), expireTime);
        if (warnType.equals(RiskWarningStatusEnum.NONE.getValue())) {
            return;
        }
        List<Long> cidList = this.staffBaseInfoService.getCidListForRiskTask(entity.getId(), PostStatusEnum.ON_POST.getValue(), StaffTypeEnum.RAY.getValue());
        CTrainingCert lastDataAll = this.trainingCertService.getOneLastTobeAuditTrainingCheckData(entity.getId());
        for (Long cid : cidList) {
            RRiskBasicSource risk = this.riskBasicSourceService.getTrainingRiskForDuplicateCheck(entity.getId(), CURR_YEAR);
            if (risk != null) {
                return;
            }
            AddRiskForCommonParam genParam = new AddRiskForCommonParam();
            genParam.setCid(cid);
            genParam.setThirdOrgId(null);
            genParam.setCetStatus(lastDataAll == null ? null : Integer.valueOf(3));
            genParam.setBusinessId(certId);
            genParam.setSubBusinessId(sbId);
            genParam.setSubBusinessName(entity.getName());
            genParam.setName(null);
            genParam.setSource(RiskSourceEnum.PORTRAIT.getValue());
            genParam.setType(RiskTypeEnum.TRAINING.getValue());
            genParam.setCategory(RiskCategoryEnum.COMMON_EIGHT.getValue());
            genParam.setFinderName("\u5b9a\u65f6\u4efb\u52a1");
            genParam.setDescription(null);
            genParam.setFiles(null);
            genParam.setStartTime(issuanceDate);
            genParam.setExpireTime(certValidDate);
            genParam.setRequireFinishTime(null);
            genParam.setIsGenerateByData(Integer.valueOf(1));
            genListParam.add(genParam);
        }
    }

    private void genNonDataInfo(RiskStaffBaseInfo entity, List<AddRiskForCommonParam> genListParam) {
        if (entity.getCreateDate() == null) {
            log.error("\u3010\u57f9\u8bad\u98ce\u9669\u751f\u6210\u3011\u3010\u65e0\u6570\u636e\u3011\u3010\u521b\u5efa\u65f6\u95f4\u3011\u8ba1\u7b97\u5931\u8d25:{}", (Object)entity.getId());
            return;
        }
        CalculateVo calculate = RiskGenTrainingManager.calculate2(entity);
        List<Long> cidList = this.staffBaseInfoService.getCidListForRiskTask(entity.getId(), PostStatusEnum.ON_POST.getValue(), StaffTypeEnum.RAY.getValue());
        CTrainingCert lastDataAll = this.trainingCertService.getOneLastTobeAuditTrainingCheckData(entity.getId());
        for (Long cid : cidList) {
            RRiskBasicSource risk = this.riskBasicSourceService.getTrainingRiskForDuplicateCheck(entity.getId(), CURR_YEAR);
            if (risk != null) {
                return;
            }
            AddRiskForCommonParam genParam = new AddRiskForCommonParam();
            genParam.setCid(cid);
            genParam.setThirdOrgId(null);
            genParam.setBusinessId(null);
            genParam.setSubBusinessId(entity.getId());
            genParam.setSubBusinessName(entity.getName());
            genParam.setName(null);
            genParam.setCetStatus(lastDataAll == null ? null : Integer.valueOf(3));
            genParam.setSource(RiskSourceEnum.PORTRAIT.getValue());
            genParam.setType(RiskTypeEnum.TRAINING.getValue());
            genParam.setCategory(RiskCategoryEnum.COMMON_EIGHT.getValue());
            genParam.setFinderName("\u5b9a\u65f6\u4efb\u52a1");
            genParam.setDescription(null);
            genParam.setFiles(null);
            genParam.setStartTime(LocalDate.from(calculate.getStartTime()));
            genParam.setExpireTime(null);
            genParam.setRequireFinishTime(null);
            genParam.setIsGenerateByData(Integer.valueOf(0));
            genListParam.add(genParam);
        }
    }

    public static CalculateVo calculate(CTrainingCert entity) {
        CalculateVo calculate = new CalculateVo();
        calculate.setStartTime(LocalDateTimeUtil.of((TemporalAccessor)entity.getIssuanceDate()));
        calculate.setExpireTime(LocalDateTimeUtil.of((TemporalAccessor)entity.getCertValidDate()));
        calculate.setWarningType(RiskGenTrainingManager.calculateWarnType(entity));
        return calculate;
    }

    public static Integer calculateWarnType(CTrainingCert entity) {
        if (entity.getCertValidDate() == null) {
            return null;
        }
        LocalDateTime now = LocalDateTime.now();
        LocalDateTime expireDate = LocalDateTimeUtil.of((TemporalAccessor)entity.getCertValidDate());
        return RiskGenTrainingManager.calculateHasDataWarningType(now, expireDate);
    }

    public static Integer calculateHasDataWarningType(LocalDateTime now, LocalDateTime expireDate) {
        Duration diffTime = LocalDateTimeUtil.between((LocalDateTime)now, (LocalDateTime)expireDate);
        return RiskGenTrainingManager.calculateHasDataWarningType(diffTime.getSeconds());
    }

    private static Integer calculateHasDataWarningType(long diffTimes) {
        Integer warnType = RiskWarningStatusEnum.NONE.getValue();
        long abs = Math.abs(diffTimes);
        warnType = diffTimes > 0L ? (RhoTimeEnum.SECOND_OF_90_DAY.getTime() < abs ? RiskWarningStatusEnum.NONE.getValue() : (RhoTimeEnum.SECOND_OF_30_DAY.getTime() < abs && abs <= RhoTimeEnum.SECOND_OF_90_DAY.getTime() ? RiskWarningStatusEnum.FIRST.getValue() : (abs <= RhoTimeEnum.SECOND_OF_30_DAY.getTime() ? RiskWarningStatusEnum.YELLOW.getValue() : RiskWarningStatusEnum.NONE.getValue()))) : (abs < RhoTimeEnum.SECOND_OF_30_DAY.getTime() ? RiskWarningStatusEnum.RED.getValue() : RiskWarningStatusEnum.ACTIVATE_LAW.getValue());
        return warnType;
    }

    public static CalculateVo calculate2(RiskStaffBaseInfo entity) {
        CalculateVo calculate = new CalculateVo();
        calculate.setStartTime(entity.getCreateDate());
        calculate.setWarningType(RiskGenTrainingManager.calculateNonDataWarningType(entity.getCreateDate()));
        return calculate;
    }

    public static Integer calculateNonDataWarningType(LocalDateTime time) {
        LocalDateTime now = LocalDateTime.now();
        Duration diffTime = LocalDateTimeUtil.between((LocalDateTime)now, (LocalDateTime)time);
        long diffSeconds = diffTime.getSeconds();
        long abs = Math.abs(diffSeconds);
        int warnType = RiskWarningStatusEnum.NONE.getValue();
        warnType = diffSeconds > 0L ? RiskWarningStatusEnum.NONE.getValue() : (abs < RhoTimeEnum.SECOND_OF_30_DAY.getTime() ? RiskWarningStatusEnum.RED.getValue().intValue() : RiskWarningStatusEnum.ACTIVATE_LAW.getValue().intValue());
        return warnType;
    }

    public static LocalDateTime sub2Year(LocalDateTime time) {
        return LocalDateTimeUtil.offset((LocalDateTime)time, (long)-2L, (TemporalUnit)ChronoUnit.YEARS);
    }

    @Generated
    public RiskGenTrainingManager(ICTrainingCertService trainingCertService, ICStaffBaseInfoService staffBaseInfoService, IRiskBasicSourceCommonService riskBasicSourceService, RedissonClient redissonClient, IRiskProvider riskProvider) {
        this.trainingCertService = trainingCertService;
        this.staffBaseInfoService = staffBaseInfoService;
        this.riskBasicSourceService = riskBasicSourceService;
        this.redissonClient = redissonClient;
        this.riskProvider = riskProvider;
    }
}

