/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.rho.modules.sys.manger.risk;

import cn.smarthse.rho.modules.sys.enums.risk.RiskSourceEnum;
import cn.smarthse.rho.modules.sys.enums.risk.RiskTypeEnum;
import cn.smarthse.rho.modules.sys.model.g.vo.GSelfCheckNeedRenRiskVo;
import cn.smarthse.rho.modules.sys.model.r.param.AddRiskForCommonParam;
import cn.smarthse.rho.modules.sys.provider.risk.IRiskProvider;
import cn.smarthse.rho.modules.sys.service.g.IGProtectiveEquipmentService;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.apache.dubbo.config.annotation.DubboReference;
import org.redisson.api.RLock;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Component;

@Component
public class RiskGenProtectiveEquipmentManager {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RiskGenProtectiveEquipmentManager.class);
    private final RedissonClient redissonClient;
    @DubboReference
    private IRiskProvider riskProvider;
    private final IGProtectiveEquipmentService gProtectiveEquipmentService;
    private static final String LOCK_KEY = "RiskGenProtectiveEquipmentManager";
    private final ThreadPoolTaskExecutor taskExecutor;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void genProtectiveEquipmentRisk() {
        String title = "\u98ce\u9669\u7ef4\u62a4\uff1a\u4e2a\u4eba\u9632\u62a4\u7528\u54c1\u81ea\u68c0\u9884\u8b66";
        String methodName = "genProtectiveEquipmentRisk()";
        log.debug(title + methodName + "start");
        StringBuilder sb = new StringBuilder(LOCK_KEY).append("_genProtectiveEquipmentRisk");
        RLock lock = this.redissonClient.getLock(sb.toString());
        boolean resLock = false;
        try {
            resLock = lock.tryLock(30L, 30L, TimeUnit.MINUTES);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        if (resLock) {
            try {
                this.genProtectiveEquipmentRiskLock();
                log.debug(title + methodName + "end");
            }
            catch (Exception e) {
                log.error(title + "\u5931\u8d25{}", (Throwable)e);
            }
            finally {
                lock.unlock();
            }
        } else {
            log.error("{}\uff1aPending lock timeout\uff0cmethod:" + methodName, (Object)LOCK_KEY);
        }
    }

    private void genProtectiveEquipmentRiskLock() {
        List<GSelfCheckNeedRenRiskVo> voList = this.gProtectiveEquipmentService.selectNeedToGenRiskId();
        this.genRisk(voList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void genRisk(List<GSelfCheckNeedRenRiskVo> voList) {
        ArrayList<AddRiskForCommonParam> parmList = new ArrayList<AddRiskForCommonParam>();
        for (GSelfCheckNeedRenRiskVo vo : voList) {
            AddRiskForCommonParam genParam = new AddRiskForCommonParam();
            Boolean existData = vo.getCheckTime() != null;
            genParam.setCid(vo.getCid());
            genParam.setThirdOrgId(null);
            genParam.setBusinessId(vo.getId());
            genParam.setSubBusinessId(null);
            genParam.setName(existData != false ? "\u4e2a\u4eba\u9632\u62a4\u7528\u54c1\u81ea\u68c0\u5373\u5c06\u5931\u6548" : "\u672a\u53ca\u65f6\u5f00\u5c55\u4e2a\u4eba\u9632\u62a4\u7528\u54c1\u81ea\u68c0");
            genParam.setSource(RiskSourceEnum.PORTRAIT.getValue());
            genParam.setType(RiskTypeEnum.PERSONAL_PROTECTIVE_EQUIPMENT.getValue());
            genParam.setFinderName("\u7cfb\u7edf");
            genParam.setDescription(null);
            genParam.setFiles(null);
            genParam.setStartTime(existData != false ? vo.getCheckTime() : null);
            genParam.setIsGenerateByData(Integer.valueOf(existData != false ? 1 : 0));
            parmList.add(genParam);
            if (parmList.size() <= 500) continue;
            try {
                this.riskProvider.genRiskOfCommon(parmList);
            }
            catch (Exception e) {
                log.error("\u5b89\u5168\u88c5\u7f6e\u548c\u8b66\u793a\u6807\u8bc6\u81ea\u68c0\u98ce\u9669\u751f\u6210\u5931\u8d25:{}", (Throwable)e);
            }
            finally {
                parmList.clear();
            }
        }
        this.riskProvider.genRiskOfCommon(parmList);
    }

    @Generated
    public RiskGenProtectiveEquipmentManager(RedissonClient redissonClient, IGProtectiveEquipmentService gProtectiveEquipmentService, ThreadPoolTaskExecutor taskExecutor) {
        this.redissonClient = redissonClient;
        this.gProtectiveEquipmentService = gProtectiveEquipmentService;
        this.taskExecutor = taskExecutor;
    }
}

