/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.rho.modules.sys.manger.risk;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.date.LocalDateTimeUtil;
import cn.hutool.core.util.StrUtil;
import cn.smarthse.encrypt.spring.utils.SpringEncryptUtils;
import cn.smarthse.rho.modules.sys.entity.c.CHealthCheckData;
import cn.smarthse.rho.modules.sys.entity.c.CStaff;
import cn.smarthse.rho.modules.sys.entity.c.CStaffWorkExperience;
import cn.smarthse.rho.modules.sys.entity.r.RRiskAcceptanceRecord;
import cn.smarthse.rho.modules.sys.enums.RhoTimeEnum;
import cn.smarthse.rho.modules.sys.enums.health.HealthCheckResultEnum;
import cn.smarthse.rho.modules.sys.enums.risk.RiskCategoryEnum;
import cn.smarthse.rho.modules.sys.enums.risk.RiskPostStatusEnum;
import cn.smarthse.rho.modules.sys.enums.risk.RiskPostSubStatusEnum;
import cn.smarthse.rho.modules.sys.enums.risk.RiskSourceEnum;
import cn.smarthse.rho.modules.sys.enums.risk.RiskTypeEnum;
import cn.smarthse.rho.modules.sys.enums.risk.RiskWarningStatusEnum;
import cn.smarthse.rho.modules.sys.enums.staff.PostStatusEnum;
import cn.smarthse.rho.modules.sys.model.c.vo.staff.RiskStaffBaseInfo;
import cn.smarthse.rho.modules.sys.model.r.param.AddRiskForCommonParam;
import cn.smarthse.rho.modules.sys.model.r.param.RiskMangerGenParam;
import cn.smarthse.rho.modules.sys.provider.risk.IRiskProvider;
import cn.smarthse.rho.modules.sys.service.b.IBCertService;
import cn.smarthse.rho.modules.sys.service.b.IBCompanyService;
import cn.smarthse.rho.modules.sys.service.c.ICDoseDataService;
import cn.smarthse.rho.modules.sys.service.c.ICHealthCheckDataService;
import cn.smarthse.rho.modules.sys.service.c.ICStaffBaseInfoService;
import cn.smarthse.rho.modules.sys.service.c.ICStaffService;
import cn.smarthse.rho.modules.sys.service.c.ICStaffWorkExperienceService;
import cn.smarthse.rho.modules.sys.service.c.ICTrainingCertService;
import cn.smarthse.rho.modules.sys.service.e.IEDeviceCommonService;
import cn.smarthse.rho.modules.sys.service.e.IEMachineRoomCommonService;
import cn.smarthse.rho.modules.sys.service.risk.IRiskAcceptanceRecordCommonService;
import cn.smarthse.rho.modules.sys.service.risk.IRiskBasicSourceCommonService;
import cn.smarthse.rho.modules.sys.service.sys.ISysAreaService;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalUnit;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.dubbo.config.annotation.DubboReference;
import org.redisson.api.RLock;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;

@Component
public class RiskGenHCManagerV3 {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RiskGenHCManagerV3.class);
    private final ICHealthCheckDataService healthCheckDataService;
    private final ICTrainingCertService trainingCertService;
    private final ICStaffBaseInfoService staffBaseInfoService;
    private final ICStaffService staffService;
    private final ICDoseDataService doseDataService;
    private final IBCompanyService companyService;
    private final ISysAreaService areaService;
    private final IBCertService cmCertService;
    private final IEDeviceCommonService deviceService;
    private final IEMachineRoomCommonService machineRoomService;
    private final ICStaffWorkExperienceService staffWorkExperienceService;
    private final IRiskBasicSourceCommonService riskBasicSourceService;
    private final ApplicationContext applicationContext;
    private final IRiskAcceptanceRecordCommonService riskAcceptanceRecordService;
    private final RedissonClient redissonClient;
    @DubboReference
    private IRiskProvider riskProvider;
    private static final String LOCK_KEY = "RiskGenManager";
    private static final LocalDateTime LIMIT_TIME = LocalDateTimeUtil.offset((LocalDateTime)LocalDateTime.now(), (long)-2L, (TemporalUnit)ChronoUnit.YEARS);
    private static final String WX = "WX";
    private static final String WJS = "WJS";
    private static final String YC = "YC";
    private static final String FY = "FY";
    public static final Integer CURR_YEAR = 2025;
    public static final LocalDateTime TRIAL_RUN_TIME = LocalDateTime.of(2025, 8, 14, 0, 0, 0);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void genHCRisk(RiskMangerGenParam param) {
        String title = "\u98ce\u9669\u7ef4\u62a4\uff1a\u4f53\u68c0\u98ce\u9669-\u751f\u6210";
        String methodName = "genHCRisk()";
        log.debug(title + methodName + "start");
        StringBuilder sb = new StringBuilder(LOCK_KEY).append("_").append(methodName).append("_").append(param.getYear()).append(param.getThirdLevelAreaId());
        RLock lock = this.redissonClient.getLock(sb.toString());
        boolean resLock = false;
        try {
            resLock = lock.tryLock(1L, 3600L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        if (resLock) {
            try {
                this.genHCRiskLock(param);
                log.debug(title + methodName + "end");
            }
            catch (Exception e) {
                log.error("\u3010\u4f53\u68c0\u98ce\u9669\u751f\u6210V3\u3011\u3010\u6574\u4f53\u3011\u5931\u8d25,e:{}", (Throwable)e);
            }
            finally {
                lock.unlock();
            }
        } else {
            log.error(":{}\uff1a\u3010\u4f53\u68c0\u98ce\u9669\u751f\u6210V3\u3011\u3010\u9501\u8d85\u65f6\u3011", (Object)LOCK_KEY);
        }
    }

    public void genHCRiskLock(RiskMangerGenParam param) {
        Object limitTime = null;
        List<RiskStaffBaseInfo> entityList = this.staffBaseInfoService.getListForGenHcRisk(param);
        ArrayList<AddRiskForCommonParam> genInfoListParam = new ArrayList<AddRiskForCommonParam>();
        ArrayList<Long> defuseInfoListParam = new ArrayList<Long>();
        ParamCollect paramCollect = new ParamCollect(genInfoListParam, defuseInfoListParam);
        for (RiskStaffBaseInfo staffBaseInfo : entityList) {
            try {
                this.genOne(staffBaseInfo, paramCollect);
            }
            catch (Exception e) {
                log.error("\u3010\u4f53\u68c0\u98ce\u9669\u751f\u6210V3\u3011\u3010\u5355\u4e2a\u3011\u4f53\u68c0\u751f\u6210\u5931\u8d25:sbId:{},e:{}", (Object)staffBaseInfo.getId(), (Object)e);
            }
            if (paramCollect.getGenInfoListParam().size() < 500) continue;
            this.genBatch(paramCollect);
        }
        if (CollUtil.isNotEmpty(paramCollect.getGenInfoListParam())) {
            this.genBatch(paramCollect);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void genBatch(ParamCollect paramCollect) {
        try {
            for (AddRiskForCommonParam param : paramCollect.getGenInfoListParam()) {
                try {
                    String subBusinessNameDe = SpringEncryptUtils.decrypt((String)param.getSubBusinessName());
                    param.setSubBusinessName(StrUtil.isBlank((CharSequence)subBusinessNameDe) ? "\u672a\u77e5\u59d3\u540d" : subBusinessNameDe);
                }
                catch (Exception e) {
                    log.error("\u3010\u4f53\u68c0\u98ce\u9669\u751f\u6210V3\u3011\u3010\u59d3\u540d\u89e3\u5bc6\u5931\u8d25\u3011sbId:{},sbName:{}, riskType:{}", new Object[]{param.getSubBusinessId(), param.getName(), param.getType(), e});
                }
            }
            this.riskProvider.genRiskOfCommon(paramCollect.getGenInfoListParam());
        }
        catch (Exception e) {
            log.error("\u3010\u4f53\u68c0\u98ce\u9669\u751f\u6210V3\u3011\u4f53\u68c0\u98ce\u9669\u751f\u6210\u5931\u8d25:{}", (Throwable)e);
        }
        finally {
            paramCollect.getGenInfoListParam().clear();
        }
    }

    private void genOne(RiskStaffBaseInfo staffBaseInfo, ParamCollect paramCollect) {
        try {
            this.genPreJob(staffBaseInfo, paramCollect);
        }
        catch (Exception e) {
            log.error("\u3010\u4f53\u68c0\u98ce\u9669\u751f\u6210V3\u3011\u3010\u5c97\u524d\u3011\u98ce\u9669\u751f\u6210\u5931\u8d25\u5f02\u5e38baseId:{}\uff0c\u5f02\u5e38\u5982\u4e0b\uff1a:{}", (Object)staffBaseInfo.getId(), (Object)e);
        }
        try {
            this.genOnJob(staffBaseInfo, paramCollect);
        }
        catch (Exception e) {
            log.error("\u3010\u4f53\u68c0\u98ce\u9669\u751f\u6210V3\u3011\u3010\u5c97\u4e2d\u3011\u98ce\u9669\u751f\u6210\u5931\u8d25\u5f02\u5e38baseId:{}\uff0c\u5f02\u5e38\u5982\u4e0b\uff1a:{}", (Object)staffBaseInfo.getId(), (Object)e);
        }
        try {
            this.genDtJob(staffBaseInfo, paramCollect);
        }
        catch (Exception e) {
            log.error("\u3010\u4f53\u68c0\u98ce\u9669\u751f\u6210V3\u3011\u3010\u79bb\u5c97\u3011\u98ce\u9669\u751f\u6210\u5931\u8d25\u5f02\u5e38baseId:{}\uff0c\u5f02\u5e38\u5982\u4e0b\uff1a:{}", (Object)staffBaseInfo.getId(), (Object)e);
        }
    }

    private void genPreJob(RiskStaffBaseInfo staffBaseInfo, ParamCollect paramCollect) {
        List<AddRiskForCommonParam> genInfoListParam = paramCollect.getGenInfoListParam();
        List<CStaffWorkExperience> workExperienceList = this.staffWorkExperienceService.getWorkExperienceListForPreJobRisk(staffBaseInfo.getId());
        Map<Long, List<CStaffWorkExperience>> weListMap = workExperienceList.stream().collect(Collectors.groupingBy(CStaffWorkExperience::getCid));
        Long sbId = staffBaseInfo.getId();
        String sbName = staffBaseInfo.getName();
        Integer riskPostType = RiskPostStatusEnum.PRE_POST.getValue();
        for (Map.Entry<Long, List<CStaffWorkExperience>> longListEntry : weListMap.entrySet()) {
            List<Long> oldNormalRiskList;
            String subBusinessName;
            Long cid = longListEntry.getKey();
            List<CStaffWorkExperience> weList = longListEntry.getValue();
            Collections.sort(weList, (e1, e2) -> e2.getPostStartTime().compareTo(e1.getPostStartTime()));
            CStaffWorkExperience we = weList.get(0);
            Long weId = we.getId();
            LocalDateTime postStartTime = we.getPostStartTime();
            LocalDateTime postDepartureTime = we.getPostDepartureTime();
            if (postStartTime == null) {
                log.error("\u3010\u4f53\u68c0\u98ce\u9669\u751f\u6210V3\u3011\u3010\u5c97\u524d\u3011\u5de5\u4f5c\u7ecf\u5386\u4e0a\u5c97\u59cb\u65f6\u95f4\u4e3a\u7a7a\uff0c\u98ce\u9669\u751f\u6210\u5931\u8d25:sbId:{},cid:{},weId:{}", new Object[]{sbId, cid, we.getId()});
                continue;
            }
            if (postStartTime.isBefore(TRIAL_RUN_TIME)) continue;
            CHealthCheckData validData = this.getValidDataForPreJob(sbId, postStartTime);
            if (validData != null) {
                List<Long> oldExceptionRiskList;
                boolean isError = HealthCheckResultEnum.isError((String)validData.getResultCode());
                Integer riskType = HealthCheckResultEnum.getRiskTypeCode((String)validData.getResultCode());
                if (!isError || !isError || this.checkSupportingDocuments(sbId, riskType, riskPostType)) continue;
                if (validData.getResultCode().equals(HealthCheckResultEnum.FC.getValue())) {
                    LocalDate s = validData.getCheckDate();
                    LocalDate e = LocalDate.from(RiskGenHCManagerV3.add240Days(LocalDateTimeUtil.of((TemporalAccessor)s)));
                    CHealthCheckData lastData = this.healthCheckDataService.getLastDataForFcRisk(staffBaseInfo.getId(), s, e);
                    if (lastData != null && lastData.getResultCode() != null && !lastData.getResultCode().equals(HealthCheckResultEnum.FC.getValue())) continue;
                }
                if (CollUtil.isNotEmpty(oldExceptionRiskList = this.riskBasicSourceService.getHCExceptionRiskForGenPreJobRiskTask(sbId, cid, riskType, CURR_YEAR))) continue;
                AddRiskForCommonParam genParam = new AddRiskForCommonParam();
                Long businessId = validData.getId();
                Long subBusinessId = sbId;
                subBusinessName = sbName;
                Integer category = isError ? RiskCategoryEnum.ERROR_SIX.getValue() : RiskCategoryEnum.COMMON_EIGHT.getValue();
                LocalDate startTime = validData.getCheckDate();
                Integer isGenerateByData = 1;
                genParam.setCid(cid);
                genParam.setThirdOrgId(null);
                genParam.setBusinessId(businessId);
                genParam.setSubBusinessId(subBusinessId);
                genParam.setSubBusinessName(subBusinessName);
                genParam.setName(null);
                genParam.setSource(RiskSourceEnum.PORTRAIT.getValue());
                genParam.setCategory(category);
                genParam.setType(riskType);
                genParam.setPostType(riskPostType);
                genParam.setPostSubType(null);
                genParam.setPostStartTime(postStartTime == null ? null : LocalDate.from(postStartTime));
                genParam.setPostDepartureTime(postDepartureTime == null ? null : LocalDate.from(postDepartureTime));
                genParam.setWorkExperienceId(weId);
                genParam.setFinderName("\u5b9a\u65f6\u4efb\u52a1");
                genParam.setDescription(null);
                genParam.setFiles(null);
                genParam.setStartTime(startTime);
                genParam.setExpireTime(null);
                genParam.setRequireFinishTime(null);
                genParam.setIsGenerateByData(isGenerateByData);
                genInfoListParam.add(genParam);
                continue;
            }
            Integer riskType = RiskTypeEnum.PHYSICAL_EXAMINATION.getValue();
            if (this.checkSupportingDocuments(sbId, riskType, riskPostType) || CollUtil.isNotEmpty(oldNormalRiskList = this.riskBasicSourceService.getAllHCNormalRiskForGenPreJobRiskTask(sbId, cid, CURR_YEAR))) continue;
            AddRiskForCommonParam genParam = new AddRiskForCommonParam();
            Long businessId = null;
            Long subBusinessId = sbId;
            Integer category = RiskCategoryEnum.COMMON_EIGHT.getValue();
            subBusinessName = sbName;
            LocalDate startTime = LocalDate.from(postStartTime);
            Integer isGenerateByData = 0;
            genParam.setCid(cid);
            genParam.setThirdOrgId(null);
            genParam.setBusinessId(businessId);
            genParam.setSubBusinessId(subBusinessId);
            genParam.setSubBusinessName(subBusinessName);
            genParam.setName(null);
            genParam.setSource(RiskSourceEnum.PORTRAIT.getValue());
            genParam.setCategory(category);
            genParam.setType(riskType);
            genParam.setPostType(riskPostType);
            genParam.setPostSubType(null);
            genParam.setPostStartTime(postStartTime == null ? null : LocalDate.from(postStartTime));
            genParam.setPostDepartureTime(postDepartureTime == null ? null : LocalDate.from(postDepartureTime));
            genParam.setWorkExperienceId(weId);
            genParam.setFinderName("\u5b9a\u65f6\u4efb\u52a1");
            genParam.setDescription(null);
            genParam.setFiles(null);
            genParam.setStartTime(startTime);
            genParam.setExpireTime(null);
            genParam.setRequireFinishTime(null);
            genParam.setIsGenerateByData(isGenerateByData);
            genInfoListParam.add(genParam);
        }
    }

    public CHealthCheckData getValidDataForPreJob(Long sbId, LocalDateTime wePostStartTime) {
        LocalDateTime start = RiskGenHCManagerV3.sub90Days(wePostStartTime);
        LocalDateTime end = wePostStartTime;
        CHealthCheckData lastPostHealthCheckData = this.healthCheckDataService.getLastDtHealthCheckDataForRiskPreJob(sbId, start, end);
        LocalDateTime start1 = RiskGenHCManagerV3.sub90Days(wePostStartTime);
        LocalDateTime end1 = RiskGenHCManagerV3.add90Days(wePostStartTime);
        CHealthCheckData lastPreHealthCheckData = this.healthCheckDataService.getLastPreHealthCheckDataForRiskPreJob(sbId, start1, end1);
        CHealthCheckData validData = null;
        if (lastPreHealthCheckData != null && lastPostHealthCheckData != null) {
            validData = lastPreHealthCheckData.getCheckDate().isBefore(lastPostHealthCheckData.getCheckDate()) ? lastPostHealthCheckData : lastPreHealthCheckData;
        } else if (lastPreHealthCheckData != null) {
            validData = lastPreHealthCheckData;
        } else if (lastPostHealthCheckData != null) {
            validData = lastPostHealthCheckData;
        }
        return validData;
    }

    private void genDtJob(RiskStaffBaseInfo staffBaseInfo, ParamCollect paramCollect) {
        List<AddRiskForCommonParam> genInfoListParam = paramCollect.getGenInfoListParam();
        List<CStaffWorkExperience> workExperienceList = this.staffWorkExperienceService.getWorkExperienceListForDtJobRisk(staffBaseInfo.getId());
        Map<Long, List<CStaffWorkExperience>> weListMap = workExperienceList.stream().collect(Collectors.groupingBy(CStaffWorkExperience::getCid));
        Long sbId = staffBaseInfo.getId();
        String sbName = staffBaseInfo.getName();
        Integer riskPostType = RiskPostStatusEnum.DT_POST.getValue();
        for (Map.Entry<Long, List<CStaffWorkExperience>> longListEntry : weListMap.entrySet()) {
            List<Long> oldNormalRiskList;
            String subBusinessName;
            Long cid = longListEntry.getKey();
            List<CStaffWorkExperience> weList = longListEntry.getValue();
            Collections.sort(weList, (e1, e2) -> e2.getPostDepartureTime().compareTo(e1.getPostDepartureTime()));
            CStaffWorkExperience we = weList.get(0);
            Long weId = we.getId();
            LocalDateTime postStartTime = we.getPostStartTime();
            LocalDateTime postDepartureTime = we.getPostDepartureTime();
            if (postDepartureTime == null) {
                log.error("\u3010\u4f53\u68c0\u98ce\u9669\u751f\u6210V3\u3011\u3010\u79bb\u5c97\u3011\u5de5\u4f5c\u7ecf\u5386\u79bb\u5c97\u59cb\u65f6\u95f4\u4e3a\u7a7a\uff0c\u98ce\u9669\u751f\u6210\u5931\u8d25:sbId:{},cid:{},weId:{}", new Object[]{sbId, cid, we.getId()});
                continue;
            }
            if (postDepartureTime.isBefore(TRIAL_RUN_TIME)) continue;
            CHealthCheckData validData = this.getValidForDtJob(sbId, postDepartureTime);
            if (validData != null) {
                List<Long> oldExceptionRiskList;
                Integer riskType;
                boolean isError = HealthCheckResultEnum.isError((String)validData.getResultCode());
                if (!isError || !isError || this.checkSupportingDocuments(sbId, riskType = HealthCheckResultEnum.getRiskTypeCode((String)validData.getResultCode()), riskPostType)) continue;
                if (validData.getResultCode().equals(HealthCheckResultEnum.FC.getValue())) {
                    LocalDate s = validData.getCheckDate();
                    LocalDate e = LocalDate.from(RiskGenHCManagerV3.add240Days(LocalDateTimeUtil.of((TemporalAccessor)s)));
                    CHealthCheckData lastData = this.healthCheckDataService.getLastDataForFcRisk(staffBaseInfo.getId(), s, e);
                    if (lastData != null && lastData.getResultCode() != null && !lastData.getResultCode().equals(HealthCheckResultEnum.FC.getValue())) continue;
                }
                if (CollUtil.isNotEmpty(oldExceptionRiskList = this.riskBasicSourceService.getHCExceptionRiskForGenDtJobRiskTask(sbId, cid, riskType, CURR_YEAR))) continue;
                AddRiskForCommonParam genParam = new AddRiskForCommonParam();
                Long businessId = validData.getId();
                Long subBusinessId = sbId;
                subBusinessName = sbName;
                Integer category = isError ? RiskCategoryEnum.ERROR_SIX.getValue() : RiskCategoryEnum.COMMON_EIGHT.getValue();
                LocalDate startTime = validData.getCheckDate();
                Integer isGenerateByData = 1;
                genParam.setCid(cid);
                genParam.setThirdOrgId(null);
                genParam.setBusinessId(businessId);
                genParam.setSubBusinessId(subBusinessId);
                genParam.setSubBusinessName(subBusinessName);
                genParam.setName(null);
                genParam.setSource(RiskSourceEnum.PORTRAIT.getValue());
                genParam.setCategory(category);
                genParam.setType(riskType);
                genParam.setPostType(riskPostType);
                genParam.setPostSubType(null);
                genParam.setPostStartTime(postStartTime == null ? null : LocalDate.from(postStartTime));
                genParam.setPostDepartureTime(postDepartureTime == null ? null : LocalDate.from(postDepartureTime));
                genParam.setWorkExperienceId(weId);
                genParam.setFinderName("\u5b9a\u65f6\u4efb\u52a1");
                genParam.setDescription(null);
                genParam.setFiles(null);
                genParam.setStartTime(startTime);
                genParam.setExpireTime(null);
                genParam.setRequireFinishTime(null);
                genParam.setIsGenerateByData(isGenerateByData);
                genInfoListParam.add(genParam);
                continue;
            }
            Integer riskType = RiskTypeEnum.PHYSICAL_EXAMINATION.getValue();
            if (this.checkSupportingDocuments(sbId, riskType, riskPostType) || CollUtil.isNotEmpty(oldNormalRiskList = this.riskBasicSourceService.getAllHCNormalRiskForGenDtJobRiskTask(sbId, cid, CURR_YEAR))) continue;
            AddRiskForCommonParam genParam = new AddRiskForCommonParam();
            Long businessId = null;
            Long subBusinessId = sbId;
            Integer category = RiskCategoryEnum.COMMON_EIGHT.getValue();
            subBusinessName = sbName;
            LocalDate startTime = LocalDate.from(postDepartureTime);
            Integer isGenerateByData = 0;
            genParam.setCid(cid);
            genParam.setThirdOrgId(null);
            genParam.setBusinessId(businessId);
            genParam.setSubBusinessId(subBusinessId);
            genParam.setSubBusinessName(subBusinessName);
            genParam.setName(null);
            genParam.setSource(RiskSourceEnum.PORTRAIT.getValue());
            genParam.setCategory(category);
            genParam.setType(riskType);
            genParam.setPostType(riskPostType);
            genParam.setPostSubType(null);
            genParam.setPostStartTime(postStartTime == null ? null : LocalDate.from(postStartTime));
            genParam.setPostDepartureTime(postDepartureTime == null ? null : LocalDate.from(postDepartureTime));
            genParam.setWorkExperienceId(weId);
            genParam.setFinderName("\u5b9a\u65f6\u4efb\u52a1");
            genParam.setDescription(null);
            genParam.setFiles(null);
            genParam.setStartTime(startTime);
            genParam.setExpireTime(null);
            genParam.setRequireFinishTime(null);
            genParam.setIsGenerateByData(isGenerateByData);
            genInfoListParam.add(genParam);
        }
    }

    public CHealthCheckData getValidForDtJob(Long sbId, LocalDateTime wePostDepartureTime) {
        LocalDateTime start = RiskGenHCManagerV3.sub90Days(wePostDepartureTime);
        LocalDateTime end = RiskGenHCManagerV3.add90Days(wePostDepartureTime);
        CHealthCheckData validData = this.healthCheckDataService.getLastDtHealthCheckDataForRiskDtJob(sbId, start, end);
        return validData;
    }

    private void genOnJob(RiskStaffBaseInfo staffBaseInfo, ParamCollect paramCollect) {
        List<AddRiskForCommonParam> genInfoListParam = paramCollect.getGenInfoListParam();
        List<CStaffWorkExperience> workExperienceList = this.staffWorkExperienceService.getWorkExperienceListForOnJobRisk(staffBaseInfo.getId());
        Map<Long, List<CStaffWorkExperience>> weListMap = workExperienceList.stream().collect(Collectors.groupingBy(CStaffWorkExperience::getCid));
        Long sbId = staffBaseInfo.getId();
        String sbName = staffBaseInfo.getName();
        Integer riskPostType = RiskPostStatusEnum.ON_POST.getValue();
        for (Map.Entry<Long, List<CStaffWorkExperience>> longListEntry : weListMap.entrySet()) {
            List<Long> oldNormalRiskList;
            Long cid = longListEntry.getKey();
            List<CStaffWorkExperience> weList = longListEntry.getValue();
            Collections.sort(weList, (e1, e2) -> e2.getPostStartTime().compareTo(e1.getPostStartTime()));
            CStaffWorkExperience we = weList.get(0);
            Long weId = we.getId();
            LocalDateTime postStartTime = we.getPostStartTime();
            LocalDateTime postDepartureTime = we.getPostDepartureTime();
            LocalDateTime currentTime = LocalDateTime.now();
            Integer postStatus = null;
            LocalDate checkData = null;
            Integer riskSubPostType = null;
            CStaff staff = this.staffService.getByBaseIdAndCidForRisk(sbId, cid);
            if (staff == null) {
                log.error("\u3010\u4f53\u68c0\u98ce\u9669\u751f\u6210V3\u3011\u3010\u5c97\u4e2d\u3011\u65e0\u6cd5\u83b7\u53d6\u7528\u6237\u4e0e\u533b\u9662\u5173\u8054\uff0c\u98ce\u9669\u751f\u6210\u5931\u8d25:sbId:{},cid:{}", (Object)sbId, (Object)cid);
                continue;
            }
            postStatus = staff.getPostStatus();
            if (StrUtil.isBlank((CharSequence)PostStatusEnum.getName((Integer)postStatus))) {
                log.error("\u3010\u4f53\u68c0\u98ce\u9669\u751f\u6210V3\u3011\u3010\u5c97\u4e2d\u3011\u5c97\u4f4d\u72b6\u6001\u7801\u4e0d\u5b58\u5728\uff0c\u98ce\u9669\u751f\u6210\u5931\u8d25:sbId:{},cid:{},postStatus:{}", new Object[]{sbId, cid, postStatus});
                continue;
            }
            Integer n = riskSubPostType = postStatus.equals(PostStatusEnum.NON_POST.getValue()) ? RiskPostSubStatusEnum.DT_POST.getValue() : RiskPostSubStatusEnum.ON_POST.getValue();
            if (postStartTime == null) {
                log.error("\u3010\u4f53\u68c0\u98ce\u9669\u751f\u6210V3\u3011\u3010\u5c97\u4e2d\u3011\u5de5\u4f5c\u7ecf\u5386\u4e0a\u5c97\u59cb\u65f6\u95f4\u4e3a\u7a7a\uff0c\u98ce\u9669\u751f\u6210\u5931\u8d25:sbId:{},cid:{},weId:{}", new Object[]{sbId, cid, weId});
                continue;
            }
            if (postDepartureTime == null && postStatus.equals(PostStatusEnum.NON_POST.getValue())) {
                log.error("\u3010\u4f53\u68c0\u98ce\u9669\u751f\u6210V3\u3011\u3010\u5c97\u4e2d\u3011\u79bb\u5c97\u72b6\u6001\u751f\u6210\u5c97\u4e2d\u98ce\u9669\u65f6\uff0c\u9700\u8981\u79bb\u5c97\u65f6\u95f4\uff0c\u79bb\u5c97\u65f6\u95f4\u83b7\u53d6\u5931\u8d25\uff0c\u98ce\u9669\u751f\u6210\u5931\u8d25:sbId:{},cid:{},weId:{}", new Object[]{sbId, cid, weId});
                continue;
            }
            LocalDateTime offset1 = LocalDateTimeUtil.offset((LocalDateTime)postStartTime, (long)2L, (TemporalUnit)ChronoUnit.YEARS);
            LocalDateTime offset2 = LocalDateTimeUtil.offset((LocalDateTime)offset1, (long)(-RhoTimeEnum.SECOND_OF_90_DAY.getTime().longValue()), (TemporalUnit)ChronoUnit.SECONDS);
            if (currentTime.isBefore(offset2) || postStatus.equals(PostStatusEnum.NON_POST.getValue()) && (postDepartureTime.isBefore(TRIAL_RUN_TIME) || postStartTime.isAfter(LocalDateTimeUtil.offset((LocalDateTime)postDepartureTime, (long)-2L, (TemporalUnit)ChronoUnit.YEARS)))) continue;
            LocalDateTime referenceTime = postStatus.equals(PostStatusEnum.NON_POST.getValue()) ? postDepartureTime : currentTime;
            CHealthCheckData validData = this.getValidForOnJob(sbId, referenceTime);
            if (validData != null) {
                List<Long> oldExceptionRiskList;
                Integer isGenerateByData;
                LocalDate startTime;
                Integer category;
                String subBusinessName;
                Long subBusinessId;
                Long businessId;
                AddRiskForCommonParam genParam;
                Integer riskType;
                String checkResultCode = null;
                checkResultCode = validData.getResultCode();
                checkData = validData.getCheckDate();
                boolean isError = HealthCheckResultEnum.isError((String)validData.getResultCode());
                boolean timeCheckPass = RiskGenHCManagerV3.timeCheck(LocalDateTimeUtil.of((TemporalAccessor)validData.getCheckDate()), referenceTime);
                if (!isError && timeCheckPass) continue;
                if (!isError && !timeCheckPass) {
                    riskType = RiskTypeEnum.PHYSICAL_EXAMINATION.getValue();
                    List<Long> oldNormalRiskList2 = this.riskBasicSourceService.getAllHCNormalRiskForGenOnJobRiskTask(sbId, cid, CURR_YEAR);
                    if (CollUtil.isNotEmpty(oldNormalRiskList2) || this.checkSupportingDocuments(sbId, riskType, riskPostType)) continue;
                    genParam = new AddRiskForCommonParam();
                    businessId = validData.getId();
                    subBusinessId = sbId;
                    subBusinessName = sbName;
                    category = isError ? RiskCategoryEnum.ERROR_SIX.getValue() : RiskCategoryEnum.COMMON_EIGHT.getValue();
                    startTime = validData.getCheckDate();
                    isGenerateByData = 1;
                    genParam.setCid(cid);
                    genParam.setThirdOrgId(null);
                    genParam.setBusinessId(businessId);
                    genParam.setSubBusinessId(subBusinessId);
                    genParam.setSubBusinessName(subBusinessName);
                    genParam.setName(null);
                    genParam.setSource(RiskSourceEnum.PORTRAIT.getValue());
                    genParam.setCategory(category);
                    genParam.setType(riskType);
                    genParam.setPostType(riskPostType);
                    genParam.setPostSubType(riskSubPostType);
                    genParam.setPostStartTime(postStartTime == null ? null : LocalDate.from(postStartTime));
                    genParam.setPostDepartureTime(postDepartureTime == null ? null : LocalDate.from(postDepartureTime));
                    genParam.setWorkExperienceId(weId);
                    genParam.setFinderName("\u5b9a\u65f6\u4efb\u52a1");
                    genParam.setDescription(null);
                    genParam.setFiles(null);
                    genParam.setStartTime(startTime);
                    genParam.setExpireTime(null);
                    genParam.setRequireFinishTime(null);
                    genParam.setIsGenerateByData(isGenerateByData);
                    genInfoListParam.add(genParam);
                    continue;
                }
                if (!isError || this.checkSupportingDocuments(sbId, riskType = HealthCheckResultEnum.getRiskTypeCode((String)checkResultCode), riskPostType)) continue;
                if (checkResultCode.equals(HealthCheckResultEnum.FC.getValue())) {
                    LocalDate start = checkData;
                    LocalDate end = LocalDate.from(RiskGenHCManagerV3.add240Days(LocalDateTimeUtil.of((TemporalAccessor)start)));
                    CHealthCheckData lastData = this.healthCheckDataService.getLastDataForFcRisk(staffBaseInfo.getId(), start, end);
                    if (lastData != null && lastData.getResultCode() != null && !lastData.getResultCode().equals(HealthCheckResultEnum.FC.getValue())) continue;
                }
                if (CollUtil.isNotEmpty(oldExceptionRiskList = this.riskBasicSourceService.getHCExceptionRiskForGenOnJobRiskTask(sbId, cid, riskType, CURR_YEAR))) continue;
                genParam = new AddRiskForCommonParam();
                businessId = validData.getId();
                subBusinessId = sbId;
                subBusinessName = sbName;
                category = isError ? RiskCategoryEnum.ERROR_SIX.getValue() : RiskCategoryEnum.COMMON_EIGHT.getValue();
                startTime = validData.getCheckDate();
                isGenerateByData = 1;
                genParam.setCid(cid);
                genParam.setThirdOrgId(null);
                genParam.setBusinessId(businessId);
                genParam.setSubBusinessId(subBusinessId);
                genParam.setSubBusinessName(subBusinessName);
                genParam.setName(null);
                genParam.setSource(RiskSourceEnum.PORTRAIT.getValue());
                genParam.setCategory(category);
                genParam.setType(riskType);
                genParam.setPostType(riskPostType);
                genParam.setPostSubType(riskSubPostType);
                genParam.setPostStartTime(postStartTime == null ? null : LocalDate.from(postStartTime));
                genParam.setPostDepartureTime(postDepartureTime == null ? null : LocalDate.from(postDepartureTime));
                genParam.setWorkExperienceId(weId);
                genParam.setFinderName("\u5b9a\u65f6\u4efb\u52a1");
                genParam.setDescription(null);
                genParam.setFiles(null);
                genParam.setStartTime(startTime);
                genParam.setExpireTime(null);
                genParam.setRequireFinishTime(null);
                genParam.setIsGenerateByData(isGenerateByData);
                genInfoListParam.add(genParam);
                continue;
            }
            Integer riskType = RiskTypeEnum.PHYSICAL_EXAMINATION.getValue();
            if (this.checkSupportingDocuments(sbId, riskType, riskPostType) || CollUtil.isNotEmpty(oldNormalRiskList = this.riskBasicSourceService.getAllHCNormalRiskForGenOnJobRiskTask(sbId, cid, CURR_YEAR))) continue;
            AddRiskForCommonParam genParam = new AddRiskForCommonParam();
            Long businessId = null;
            Long subBusinessId = sbId;
            Integer category = RiskCategoryEnum.COMMON_EIGHT.getValue();
            String subBusinessName = sbName;
            LocalDate startTime = LocalDate.from(referenceTime);
            Integer isGenerateByData = 0;
            Integer healthSpecialWarning = 0;
            if (!currentTime.isBefore(offset2) && currentTime.isBefore(offset1)) {
                healthSpecialWarning = 1;
            }
            genParam.setCid(cid);
            genParam.setThirdOrgId(null);
            genParam.setBusinessId(businessId);
            genParam.setSubBusinessId(subBusinessId);
            genParam.setSubBusinessName(subBusinessName);
            genParam.setName(null);
            genParam.setSource(RiskSourceEnum.PORTRAIT.getValue());
            genParam.setCategory(category);
            genParam.setType(riskType);
            genParam.setPostType(riskPostType);
            genParam.setPostSubType(riskSubPostType);
            genParam.setPostStartTime(postStartTime == null ? null : LocalDate.from(postStartTime));
            genParam.setPostDepartureTime(postDepartureTime == null ? null : LocalDate.from(postDepartureTime));
            genParam.setWorkExperienceId(weId);
            genParam.setFinderName("\u5b9a\u65f6\u4efb\u52a1");
            genParam.setDescription(null);
            genParam.setFiles(null);
            genParam.setStartTime(startTime);
            genParam.setExpireTime(null);
            genParam.setRequireFinishTime(null);
            genParam.setIsGenerateByData(isGenerateByData);
            genParam.setHealthSpecialWarning(healthSpecialWarning);
            genInfoListParam.add(genParam);
        }
    }

    private boolean checkSupportingDocuments(Long sbId, Integer riskType, Integer riskPostType) {
        Integer acceptanceWay;
        RRiskAcceptanceRecord validSupportingDocumentsHcRisk = this.riskAcceptanceRecordService.getValidSupportingDocumentsHcRisk(sbId, riskType, riskPostType);
        return validSupportingDocumentsHcRisk != null && validSupportingDocumentsHcRisk.getAcceptanceWay() != null && ((acceptanceWay = validSupportingDocumentsHcRisk.getAcceptanceWay()) == 2 || acceptanceWay == 3);
    }

    public CHealthCheckData getValidForOnJob(Long sbId, LocalDateTime referenceTime) {
        LocalDateTime queryStartTime = RiskGenHCManagerV3.sub2Year(referenceTime);
        CHealthCheckData validData = this.healthCheckDataService.getLastOnHealthCheckDataForRiskOnJob(sbId, queryStartTime);
        return validData;
    }

    public static LocalDateTime add30Days(LocalDateTime time) {
        return LocalDateTimeUtil.offset((LocalDateTime)time, (long)RhoTimeEnum.SECOND_OF_30_DAY.getTime(), (TemporalUnit)ChronoUnit.SECONDS);
    }

    public static LocalDateTime sub30Days(LocalDateTime time) {
        return LocalDateTimeUtil.offset((LocalDateTime)time, (long)(-RhoTimeEnum.SECOND_OF_30_DAY.getTime().longValue()), (TemporalUnit)ChronoUnit.SECONDS);
    }

    public static LocalDateTime add90Days(LocalDateTime time) {
        return LocalDateTimeUtil.offset((LocalDateTime)time, (long)RhoTimeEnum.SECOND_OF_90_DAY.getTime(), (TemporalUnit)ChronoUnit.SECONDS);
    }

    public static LocalDateTime sub90Days(LocalDateTime time) {
        return LocalDateTimeUtil.offset((LocalDateTime)time, (long)(-RhoTimeEnum.SECOND_OF_90_DAY.getTime().longValue()), (TemporalUnit)ChronoUnit.SECONDS);
    }

    public static LocalDateTime add2Year(LocalDateTime time) {
        return LocalDateTimeUtil.offset((LocalDateTime)time, (long)2L, (TemporalUnit)ChronoUnit.YEARS);
    }

    public static LocalDateTime sub2Year(LocalDateTime time) {
        return LocalDateTimeUtil.offset((LocalDateTime)time, (long)-2L, (TemporalUnit)ChronoUnit.YEARS);
    }

    public static LocalDateTime add240Days(LocalDateTime time) {
        return LocalDateTimeUtil.offset((LocalDateTime)time, (long)RhoTimeEnum.SECOND_OF_240_DAY.getTime(), (TemporalUnit)ChronoUnit.SECONDS);
    }

    public static boolean timeCheck(LocalDateTime checkData, LocalDateTime referenceTime) {
        Integer warnType = RiskGenHCManagerV3.calculateWarnType(checkData, referenceTime);
        return warnType == RiskWarningStatusEnum.NONE.getValue();
    }

    public static Integer calculateWarnType(LocalDateTime checkData, LocalDateTime referenceTime) {
        LocalDateTime expireDate = LocalDateTimeUtil.offset((LocalDateTime)checkData, (long)2L, (TemporalUnit)ChronoUnit.YEARS);
        Duration diffTime = LocalDateTimeUtil.between((LocalDateTime)referenceTime, (LocalDateTime)expireDate);
        return RiskGenHCManagerV3.calculateHasDataWarningType(diffTime.getSeconds());
    }

    public static Integer calculateHasDataWarningType(long diffTimes) {
        Integer warnType = RiskWarningStatusEnum.NONE.getValue();
        long abs = Math.abs(diffTimes);
        warnType = diffTimes > 0L ? (RhoTimeEnum.SECOND_OF_90_DAY.getTime() < abs ? RiskWarningStatusEnum.NONE.getValue() : (RhoTimeEnum.SECOND_OF_30_DAY.getTime() < abs && abs <= RhoTimeEnum.SECOND_OF_90_DAY.getTime() ? RiskWarningStatusEnum.FIRST.getValue() : (abs <= RhoTimeEnum.SECOND_OF_30_DAY.getTime() ? RiskWarningStatusEnum.YELLOW.getValue() : RiskWarningStatusEnum.NONE.getValue()))) : (abs < RhoTimeEnum.SECOND_OF_30_DAY.getTime() ? RiskWarningStatusEnum.RED.getValue() : RiskWarningStatusEnum.ACTIVATE_LAW.getValue());
        return warnType;
    }

    @Generated
    public RiskGenHCManagerV3(ICHealthCheckDataService healthCheckDataService, ICTrainingCertService trainingCertService, ICStaffBaseInfoService staffBaseInfoService, ICStaffService staffService, ICDoseDataService doseDataService, IBCompanyService companyService, ISysAreaService areaService, IBCertService cmCertService, IEDeviceCommonService deviceService, IEMachineRoomCommonService machineRoomService, ICStaffWorkExperienceService staffWorkExperienceService, IRiskBasicSourceCommonService riskBasicSourceService, ApplicationContext applicationContext, IRiskAcceptanceRecordCommonService riskAcceptanceRecordService, RedissonClient redissonClient) {
        this.healthCheckDataService = healthCheckDataService;
        this.trainingCertService = trainingCertService;
        this.staffBaseInfoService = staffBaseInfoService;
        this.staffService = staffService;
        this.doseDataService = doseDataService;
        this.companyService = companyService;
        this.areaService = areaService;
        this.cmCertService = cmCertService;
        this.deviceService = deviceService;
        this.machineRoomService = machineRoomService;
        this.staffWorkExperienceService = staffWorkExperienceService;
        this.riskBasicSourceService = riskBasicSourceService;
        this.applicationContext = applicationContext;
        this.riskAcceptanceRecordService = riskAcceptanceRecordService;
        this.redissonClient = redissonClient;
    }

    class ParamCollect {
        List<AddRiskForCommonParam> genInfoListParam;
        List<Long> defuseInfoIdList;

        public ParamCollect(List<AddRiskForCommonParam> genInfoListParam, List<Long> defuseInfoIdList) {
            this.genInfoListParam = genInfoListParam;
            this.defuseInfoIdList = defuseInfoIdList;
        }

        @Generated
        public List<AddRiskForCommonParam> getGenInfoListParam() {
            return this.genInfoListParam;
        }

        @Generated
        public List<Long> getDefuseInfoIdList() {
            return this.defuseInfoIdList;
        }

        @Generated
        public void setGenInfoListParam(List<AddRiskForCommonParam> genInfoListParam) {
            this.genInfoListParam = genInfoListParam;
        }

        @Generated
        public void setDefuseInfoIdList(List<Long> defuseInfoIdList) {
            this.defuseInfoIdList = defuseInfoIdList;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ParamCollect)) {
                return false;
            }
            ParamCollect other = (ParamCollect)o;
            if (!other.canEqual(this)) {
                return false;
            }
            List<AddRiskForCommonParam> this$genInfoListParam = this.getGenInfoListParam();
            List<AddRiskForCommonParam> other$genInfoListParam = other.getGenInfoListParam();
            if (this$genInfoListParam == null ? other$genInfoListParam != null : !((Object)this$genInfoListParam).equals(other$genInfoListParam)) {
                return false;
            }
            List<Long> this$defuseInfoIdList = this.getDefuseInfoIdList();
            List<Long> other$defuseInfoIdList = other.getDefuseInfoIdList();
            return !(this$defuseInfoIdList == null ? other$defuseInfoIdList != null : !((Object)this$defuseInfoIdList).equals(other$defuseInfoIdList));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ParamCollect;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            List<AddRiskForCommonParam> $genInfoListParam = this.getGenInfoListParam();
            result = result * 59 + ($genInfoListParam == null ? 43 : ((Object)$genInfoListParam).hashCode());
            List<Long> $defuseInfoIdList = this.getDefuseInfoIdList();
            result = result * 59 + ($defuseInfoIdList == null ? 43 : ((Object)$defuseInfoIdList).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "RiskGenHCManagerV3.ParamCollect(genInfoListParam=" + String.valueOf(this.getGenInfoListParam()) + ", defuseInfoIdList=" + String.valueOf(this.getDefuseInfoIdList()) + ")";
        }

        @Generated
        public ParamCollect() {
        }
    }
}

