/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.rho.modules.sys.manger.risk;

import cn.hutool.core.collection.CollUtil;
import cn.smarthse.rho.modules.sys.entity.b.BCert;
import cn.smarthse.rho.modules.sys.entity.b.BCompany;
import cn.smarthse.rho.modules.sys.entity.r.RRiskBasicSource;
import cn.smarthse.rho.modules.sys.enums.risk.RiskSourceEnum;
import cn.smarthse.rho.modules.sys.enums.risk.RiskTypeEnum;
import cn.smarthse.rho.modules.sys.enums.risk.RiskWarningStatusEnum;
import cn.smarthse.rho.modules.sys.manger.license.CycleLicenseManager;
import cn.smarthse.rho.modules.sys.model.b.param.license.BCycleLicenseBatchGenParam;
import cn.smarthse.rho.modules.sys.model.r.param.AddRiskForCommonParam;
import cn.smarthse.rho.modules.sys.model.r.param.RiskMangerGenParam;
import cn.smarthse.rho.modules.sys.provider.risk.IRiskProvider;
import cn.smarthse.rho.modules.sys.service.b.IBCertService;
import cn.smarthse.rho.modules.sys.service.b.IBCompanyService;
import cn.smarthse.rho.modules.sys.service.b.IBLicenseManagementSettingService;
import cn.smarthse.rho.modules.sys.service.risk.IRiskBasicSourceCommonService;
import cn.smarthse.rho.modules.sys.utils.company.CompanyCertUtil;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.redisson.api.RLock;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class RiskGenCompanyCertManager {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RiskGenCompanyCertManager.class);
    private final IBCompanyService companyService;
    private final IBCertService cmCertService;
    private final CycleLicenseManager cycleLicenseManager;
    private final RedissonClient redissonClient;
    private final IRiskProvider riskProvider;
    private final IRiskBasicSourceCommonService riskBasicSourceService;
    private final IBLicenseManagementSettingService licenseManagementSettingService;
    private static final String LOCK_KEY = "RiskGenManager";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void genPermitCertRisk(RiskMangerGenParam param) {
        String title = "\u98ce\u9669\u7ef4\u62a4\uff1a\u8bb8\u53ef\u8bc1";
        String methodName = "genPermitCertRisk()";
        log.debug(title + methodName + "start");
        StringBuilder sb = new StringBuilder(LOCK_KEY).append("_genPermitCertRisk_").append(param.getYear()).append(param.getThirdLevelAreaId());
        RLock lock = this.redissonClient.getLock(sb.toString());
        boolean resLock = false;
        try {
            resLock = lock.tryLock(1L, 3600L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        if (resLock) {
            try {
                this.genPermitCertRiskLock(param);
                log.debug(title + methodName + "end");
            }
            catch (Exception e) {
                log.error("\u3010\u533b\u9662\u8bb8\u53ef\u98ce\u9669\u751f\u6210\u3011\u3010\u6574\u4f53\u3011\u5931\u8d25\uff0ce:{}", (Throwable)e);
            }
            finally {
                lock.unlock();
            }
        } else {
            log.error("{}\uff1aPending lock timeout\uff0cmethod:" + methodName, (Object)LOCK_KEY);
        }
    }

    public void genPermitCertRiskLock(RiskMangerGenParam param) {
        List<BCompany> companyList = this.companyService.getListForGenCertRisk(param);
        ArrayList<BCycleLicenseBatchGenParam> cycleLicenseGenParamList = new ArrayList<BCycleLicenseBatchGenParam>();
        ArrayList<AddRiskForCommonParam> genListParam = new ArrayList<AddRiskForCommonParam>();
        for (BCompany company : companyList) {
            BCert cert = this.cmCertService.getByCid(company.getId());
            if (cert != null) {
                this.genHasDataInfo(company, cert, genListParam, cycleLicenseGenParamList);
                continue;
            }
            this.genNonDataInfo(company, genListParam);
        }
        this.genRisk(genListParam);
    }

    private void genHasDataInfo(BCompany company, BCert cert, List<AddRiskForCommonParam> genListParam, List<BCycleLicenseBatchGenParam> cycleLicenseGenParamList) {
        Long certId = cert.getId();
        Long cid = company.getId();
        LocalDateTime beginDate = this.cmCertService.getBeginDateForGenRisk(company.getId());
        LocalDateTime lastVerificationDate = this.cmCertService.getLastVerificationDateForGenRisk(company.getId());
        RRiskBasicSource risk = this.riskBasicSourceService.getCmCertRiskForGen(company.getId());
        if (risk != null) {
            return;
        }
        if (cert.getBeginDate() == null) {
            log.error("\u3010\u533b\u9662\u8bb8\u53ef\u98ce\u9669\u751f\u6210\u3011\u3010\u6709\u6570\u636e\u60c5\u51b5\u3011\u7f3a\u5c11\u53d1\u8bc1\u65f6\u95f4,cid:{},certId{}", (Object)company.getId(), (Object)certId);
            return;
        }
        Integer cycleYear = RiskGenCompanyCertManager.calculateCycleYear(company);
        if (cycleYear == null) {
            log.error("\u3010\u533b\u9662\u8bb8\u53ef\u98ce\u9669\u751f\u6210\u3011\u3010\u6709\u6570\u636e\u60c5\u51b5\u3011\u5468\u671f\u6570\u636e\u8ba1\u7b97\u5931\u8d25,cid{},certId{}", (Object)company.getId(), (Object)certId);
            return;
        }
        Integer pushType = this.licenseManagementSettingService.getPushTypeForSup(company.getAreaId());
        if (pushType == null) {
            log.error("\u3010\u533b\u9662\u8bb8\u53ef\u98ce\u9669\u751f\u6210\u3011\u3010\u6709\u6570\u636e\u60c5\u51b5\u3011\u63a8\u9001\u6807\u51c6\u83b7\u53d6\u5931\u8d25,cid:{},certId{}", (Object)company.getId(), (Object)certId);
            return;
        }
        LocalDateTime expireTime = RiskGenCompanyCertManager.calculateExpireDate(certId, beginDate, lastVerificationDate, company, pushType);
        if (expireTime == null) {
            log.error("\u3010\u533b\u9662\u8bb8\u53ef\u98ce\u9669\u751f\u6210\u3011\u3010\u6709\u6570\u636e\u60c5\u51b5\u3011\u3010\u8fc7\u671f\u65f6\u95f4\u3011\u8ba1\u7b97\u5931\u8d25cid:{},certId{}", (Object)company.getId(), (Object)certId);
            return;
        }
        LocalDateTime startTime = RiskGenCompanyCertManager.calculateStartDate(company, expireTime);
        if (startTime == null) {
            log.error("\u3010\u533b\u9662\u8bb8\u53ef\u98ce\u9669\u751f\u6210\u3011\u3010\u6709\u6570\u636e\u60c5\u51b5\u3011\u3010\u5f00\u59cb\u65f6\u95f4\u3011\u8ba1\u7b97\u5931\u8d25cid:{},certId{}", (Object)company.getId(), (Object)certId);
            return;
        }
        Integer warnType = RiskGenCompanyCertManager.calculateHasDataWarningTypeForCompanyCert(LocalDateTime.now(), expireTime, cycleYear);
        if (warnType == null) {
            log.error("\u3010\u533b\u9662\u8bb8\u53ef\u98ce\u9669\u751f\u6210\u3011\u3010\u6709\u6570\u636e\u60c5\u51b5\u3011\u3010\u9884\u8b66\u7c7b\u578b\u3011\u8ba1\u7b97\u5931\u8d25cid:{},certId{}", (Object)company.getId(), (Object)certId);
            return;
        }
        if (warnType.equals(RiskWarningStatusEnum.NONE.getValue())) {
            return;
        }
        AddRiskForCommonParam genParam = new AddRiskForCommonParam();
        genParam.setCid(cid);
        genParam.setThirdOrgId(null);
        genParam.setBusinessId(certId);
        genParam.setSubBusinessId(cid);
        genParam.setName(null);
        genParam.setSource(RiskSourceEnum.PORTRAIT.getValue());
        genParam.setType(RiskTypeEnum.LICENSE_MANAGEMENT.getValue());
        genParam.setFinderName("\u5b9a\u65f6\u4efb\u52a1");
        genParam.setDescription(null);
        genParam.setFiles(null);
        genParam.setStartTime(LocalDate.from(startTime));
        genParam.setExpireTime(LocalDate.from(expireTime));
        genParam.setRequireFinishTime(null);
        genParam.setIsGenerateByData(Integer.valueOf(1));
        genListParam.add(genParam);
        if (genListParam.size() > 500) {
            this.genRisk(genListParam);
        }
    }

    private void genCycleLicense(List<BCycleLicenseBatchGenParam> cycleLicenseGenParamList) {
        try {
            this.cycleLicenseManager.genCycleLicenseBatch(cycleLicenseGenParamList);
        }
        catch (Exception e) {
            log.error("\u8bb8\u53ef\u8bc1\u98ce\u9669\u751f\u6210\u5931\u8d25:{}", (Throwable)e);
        }
        finally {
            cycleLicenseGenParamList.clear();
        }
    }

    private void genRisk(List<AddRiskForCommonParam> genListParam) {
        if (CollUtil.isEmpty(genListParam)) {
            return;
        }
        try {
            this.riskProvider.genRiskOfCommon(genListParam);
        }
        catch (Exception e) {
            log.error("\u8bb8\u53ef\u8bc1\u98ce\u9669\u751f\u6210\u5931\u8d25:{}", (Throwable)e);
        }
        finally {
            genListParam.clear();
        }
    }

    private void genNonDataInfo(BCompany company, List<AddRiskForCommonParam> genListParam) {
        RRiskBasicSource risk = this.riskBasicSourceService.getCmCertRiskForGen(company.getId());
        if (risk != null) {
            return;
        }
        LocalDateTime startTime = company.getCreateDate();
        if (startTime == null) {
            log.error("\u3010\u533b\u9662\u8bb8\u53ef\u98ce\u9669\u751f\u6210\u3011\u3010\u65e0\u6570\u636e\u60c5\u51b5\u3011\u7f3a\u5c11\u521b\u5efa\u65f6\u95f4(\u8d77\u59cb\u65f6\u95f4),cid:{}", (Object)company.getId());
            return;
        }
        AddRiskForCommonParam genParam = new AddRiskForCommonParam();
        genParam.setCid(company.getId());
        genParam.setThirdOrgId(null);
        genParam.setBusinessId(null);
        genParam.setSubBusinessId(company.getId());
        genParam.setName(null);
        genParam.setSource(RiskSourceEnum.PORTRAIT.getValue());
        genParam.setType(RiskTypeEnum.LICENSE_MANAGEMENT.getValue());
        genParam.setFinderName("\u5b9a\u65f6\u4efb\u52a1");
        genParam.setDescription(null);
        genParam.setFiles(null);
        genParam.setStartTime(LocalDate.from(startTime));
        genParam.setExpireTime(null);
        genParam.setRequireFinishTime(null);
        genParam.setIsGenerateByData(Integer.valueOf(0));
        genListParam.add(genParam);
        if (genListParam.size() > 500) {
            this.genRisk(genListParam);
        }
    }

    public static Integer calculateCycleYear(BCompany company) {
        return CompanyCertUtil.calculateCycleYear((Integer)company.getType(), (Integer)company.getFloorNum());
    }

    public static LocalDateTime calculateExpireDate(Long certId, LocalDateTime beginDate, LocalDateTime lastVerificationDate, BCompany company, int pushType) {
        Integer cycleYear = RiskGenCompanyCertManager.calculateCycleYear(company);
        return CompanyCertUtil.calculateExpireDate((LocalDateTime)beginDate, (LocalDateTime)lastVerificationDate, (Integer)cycleYear, (int)pushType);
    }

    public static LocalDateTime calculateStartDate(BCompany company, LocalDateTime expireTime) {
        Integer cycleYear = RiskGenCompanyCertManager.calculateCycleYear(company);
        return CompanyCertUtil.calculateStartDate((Integer)cycleYear, (LocalDateTime)expireTime);
    }

    public static Integer calculateHasDataWarningTypeForCompanyCert(LocalDateTime now, LocalDateTime expireDate, Integer cycleYear) {
        return CompanyCertUtil.calculateHasDataWarningTypeForCompanyCert((LocalDateTime)now, (LocalDateTime)expireDate, (Integer)cycleYear);
    }

    @Generated
    public RiskGenCompanyCertManager(IBCompanyService companyService, IBCertService cmCertService, CycleLicenseManager cycleLicenseManager, RedissonClient redissonClient, IRiskProvider riskProvider, IRiskBasicSourceCommonService riskBasicSourceService, IBLicenseManagementSettingService licenseManagementSettingService) {
        this.companyService = companyService;
        this.cmCertService = cmCertService;
        this.cycleLicenseManager = cycleLicenseManager;
        this.redissonClient = redissonClient;
        this.riskProvider = riskProvider;
        this.riskBasicSourceService = riskBasicSourceService;
        this.licenseManagementSettingService = licenseManagementSettingService;
    }
}

