/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.rho.modules.sys.manger.risk;

import cn.hutool.core.collection.CollUtil;
import cn.smarthse.rho.modules.sys.entity.c.CStaff;
import cn.smarthse.rho.modules.sys.entity.c.CTrainingCert;
import cn.smarthse.rho.modules.sys.entity.r.RRiskBasicSource;
import cn.smarthse.rho.modules.sys.enums.risk.RiskWarningStatusEnum;
import cn.smarthse.rho.modules.sys.enums.risk.defuse.TrainingDefsuseMeasureEnum;
import cn.smarthse.rho.modules.sys.enums.staff.PostStatusEnum;
import cn.smarthse.rho.modules.sys.manger.risk.RiskGenTrainingManager;
import cn.smarthse.rho.modules.sys.model.c.vo.staff.RiskStaffBaseInfo;
import cn.smarthse.rho.modules.sys.model.r.param.ResolveRiskForCommonParam;
import cn.smarthse.rho.modules.sys.model.r.param.RiskManagerDefuseParam;
import cn.smarthse.rho.modules.sys.model.r.vo.RiskDefuseDto;
import cn.smarthse.rho.modules.sys.provider.risk.IRiskProvider;
import cn.smarthse.rho.modules.sys.service.c.ICStaffBaseInfoService;
import cn.smarthse.rho.modules.sys.service.c.ICStaffService;
import cn.smarthse.rho.modules.sys.service.c.ICStaffWorkExperienceService;
import cn.smarthse.rho.modules.sys.service.c.ICTrainingCertService;
import cn.smarthse.rho.modules.sys.service.risk.IRiskBasicSourceCommonService;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.redisson.api.RLock;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class RiskDefuseTrainingManager {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RiskDefuseTrainingManager.class);
    private final RedissonClient redissonClient;
    private final IRiskBasicSourceCommonService riskSourceService;
    private final ICTrainingCertService trainingCertService;
    private final ICStaffBaseInfoService staffBaseInfoService;
    private final ICStaffService staffService;
    private final ICStaffWorkExperienceService staffWorkExperienceService;
    private final IRiskProvider riskProvider;
    private final String MEASURES_DT_POST = "\u4eba\u5458\u5c97\u4f4d\u72b6\u6001\u53d1\u751f\u53d8\u66f4\uff0c\u98ce\u9669\u9700\u91cd\u65b0\u8bc6\u522b\u8bc4\u4f30";
    private static final String LOCK_KEY = "RiskGenManager";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void defuseTrainingRisk(RiskManagerDefuseParam param) {
        String title = "\u3010\u57f9\u8bad\u98ce\u9669\u5316\u89e3\u3011\u3010\u6574\u4f53\u3011";
        String methodName = "defuseTrainingRisk()";
        log.debug(title + methodName + "start");
        StringBuilder sb = new StringBuilder(LOCK_KEY).append("_").append(methodName).append("_").append(param.getYear());
        RLock lock = this.redissonClient.getLock(sb.toString());
        boolean resLock = false;
        try {
            resLock = lock.tryLock(1L, 3600L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        if (resLock) {
            try {
                this.defuseTrainingHCRiskLock(param);
                log.debug(title + methodName + "end");
            }
            catch (Exception e) {
                log.error(title + "\u5931\u8d25{}", (Throwable)e);
            }
            finally {
                lock.unlock();
            }
        } else {
            log.error("{}\uff1aPending lock timeout\uff0cmethod:" + methodName, (Object)LOCK_KEY);
        }
    }

    public void defuseTrainingHCRiskLock(RiskManagerDefuseParam param) {
        List<Long> list = this.riskSourceService.getTrainingRiskIdListForDefuse(param);
        ArrayList<RiskDefuseDto> riskDefuseDtoList = new ArrayList<RiskDefuseDto>();
        for (Long rid : list) {
            try {
                RRiskBasicSource vo = this.riskSourceService.getExEnFieldForRisk(rid);
                this.defuseOne(vo, riskDefuseDtoList);
            }
            catch (Exception e) {
                log.error("\u3010\u57f9\u8bad\u98ce\u9669\u5316\u89e3\u3011\u3010\u5355\u4e2a\u3011\u5931\u8d25,riskId{}", (Object)rid, (Object)e);
            }
            if (riskDefuseDtoList.size() < 500) continue;
            this.defuseList(riskDefuseDtoList);
        }
        if (CollUtil.isNotEmpty(riskDefuseDtoList)) {
            this.defuseList(riskDefuseDtoList);
        }
    }

    public void defuseOne(RRiskBasicSource vo, List<RiskDefuseDto> riskDefuseDtoList) {
        Integer isGenerateByData = vo.getIsGenerateByData();
        Long sbId = vo.getSubBusinessId();
        Long cid = vo.getCid();
        Long riskId = vo.getId();
        CStaff staff = null;
        if (isGenerateByData == null) {
            log.error("\u3010\u57f9\u8bad\u98ce\u9669\u5316\u89e3\u3011\u3010\u5355\u4e2a\u3011\u7f3a\u5c11\u751f\u6210\u6570\u636e\u6807\u8bc6:{}", (Object)riskId);
            return;
        }
        if (cid == null) {
            log.error("\u3010\u57f9\u8bad\u98ce\u9669\u5316\u89e3\u3011\u3010\u5355\u4e2a\u3011\u7f3a\u5c11\u516c\u53f8id:{}", (Object)riskId);
            return;
        }
        if (sbId == null) {
            log.error("\u3010\u57f9\u8bad\u98ce\u9669\u5316\u89e3\u3011\u3010\u5355\u4e2a\u3011\u7f3a\u5c11\u4eba\u5458id:{}", (Object)riskId);
            return;
        }
        RiskStaffBaseInfo staffBaseInfo = this.staffBaseInfoService.getInfoUnDeFieldForRisk(sbId);
        if (staffBaseInfo == null) {
            riskDefuseDtoList.add(RiskDefuseDto.createSpecialMeasuresDefuse((Long)riskId, (String)TrainingDefsuseMeasureEnum.STAFF_REMOVED.getMeasure()));
            return;
        }
        if (staffBaseInfo != null) {
            staff = this.staffService.getByBaseIdAndCidForRisk(sbId, cid);
            if (staff == null) {
                riskDefuseDtoList.add(RiskDefuseDto.createSpecialMeasuresDefuse((Long)riskId, (String)TrainingDefsuseMeasureEnum.STAFF_REMOVED.getMeasure()));
                return;
            }
            if (staff != null && staff.getStaffType() != null && staff.getStaffType() != 1) {
                riskDefuseDtoList.add(RiskDefuseDto.createSpecialMeasuresDefuse((Long)riskId, (String)TrainingDefsuseMeasureEnum.RAY_TRUE_TO_FALSE.getMeasure()));
                return;
            }
            if (staff != null && staff.getPostStatus() != null && staff.getPostStatus() != PostStatusEnum.ON_POST.getValue()) {
                riskDefuseDtoList.add(RiskDefuseDto.createSpecialMeasuresDefuse((Long)riskId, (String)TrainingDefsuseMeasureEnum.JOB_ON_TO_DT.getMeasure()));
                return;
            }
        }
        CTrainingCert oldCert = null;
        if (isGenerateByData == 1) {
            Long certId = vo.getBusinessId();
            if (certId == null) {
                log.error("\u3010\u57f9\u8bad\u98ce\u9669\u5316\u89e3\u3011\u3010\u5355\u4e2a\u3011\u7f3a\u5c11\u8bc1\u4e66id:{}", (Object)riskId);
                return;
            }
            oldCert = this.trainingCertService.getInfoExEnForRisk(certId);
            if (oldCert == null) {
                riskDefuseDtoList.add(RiskDefuseDto.createSpecialMeasuresDefuse((Long)riskId, (String)TrainingDefsuseMeasureEnum.CERT_REMOVED.getMeasure()));
                return;
            }
        }
        LocalDateTime current = LocalDateTime.now();
        CTrainingCert lastValid = this.trainingCertService.getLastTrainingCheckDataTimeLimitForGenRisk(vo.getSubBusinessId(), current);
        if (lastValid == null) {
            return;
        }
        if (lastValid != null && isGenerateByData == 0) {
            riskDefuseDtoList.add(RiskDefuseDto.createCommonMeasuresDefuse((Long)riskId, (String)TrainingDefsuseMeasureEnum.COMMON.getMeasure()));
            return;
        }
        if (lastValid != null && isGenerateByData == 1) {
            boolean oldWarningTypeIsRedQdzf;
            LocalDate issuanceDate = lastValid.getIssuanceDate();
            LocalDate certValidDate = lastValid.getCertValidDate();
            if (issuanceDate == null) {
                log.error("\u3010\u57f9\u8bad\u98ce\u9669\u5316\u89e3\u3011\u3010\u6709\u6570\u636e\u3011\u3010\u7f3a\u5c11\u53d1\u8bc1\u65f6\u95f4\u3011\u751f\u6210\u5931\u8d25:riskId{},certId{}", (Object)riskId, (Object)lastValid.getId());
                return;
            }
            if (certValidDate == null) {
                log.error("\u3010\u57f9\u8bad\u98ce\u9669\u5316\u89e3\u3011\u3010\u6709\u6570\u636e\u3011\u3010\u7f3a\u5c11\u6709\u6548\u65f6\u95f4\u3011\u751f\u6210\u5931\u8d25:riskId{},certId{}", (Object)riskId, (Object)lastValid.getId());
                return;
            }
            Integer warningType = RiskGenTrainingManager.calculateWarnType(lastValid);
            if (warningType.equals(RiskWarningStatusEnum.NONE.getValue())) {
                riskDefuseDtoList.add(RiskDefuseDto.createCommonMeasuresDefuse((Long)riskId, (String)TrainingDefsuseMeasureEnum.COMMON.getMeasure()));
                return;
            }
            Integer oldWarningType = RiskDefuseTrainingManager.getOldWarningType(vo, oldCert);
            boolean newestWarningTypeIsFirstYellow = warningType.equals(RiskWarningStatusEnum.FIRST.getValue()) || warningType.equals(RiskWarningStatusEnum.YELLOW.getValue());
            boolean bl = oldWarningTypeIsRedQdzf = oldWarningType.equals(RiskWarningStatusEnum.RED.getValue()) || oldWarningType.equals(RiskWarningStatusEnum.ACTIVATE_LAW.getValue());
            if (newestWarningTypeIsFirstYellow && oldWarningTypeIsRedQdzf) {
                riskDefuseDtoList.add(RiskDefuseDto.createCommonMeasuresDefuse((Long)riskId, (String)TrainingDefsuseMeasureEnum.COMMON.getMeasure()));
                return;
            }
            return;
        }
    }

    public static Integer getOldWarningType(RRiskBasicSource vo, CTrainingCert oldCert) {
        Integer oldWarningType;
        if (vo.getIsGenerateByData() == 0) {
            oldWarningType = RiskWarningStatusEnum.RED.getValue();
        } else {
            LocalDate oldIssuanceDate = oldCert.getIssuanceDate();
            LocalDate oldCertValidDate = oldCert.getCertValidDate();
            oldWarningType = oldIssuanceDate == null || oldCertValidDate == null ? vo.getWarningStatus() : RiskGenTrainingManager.calculateWarnType(oldCert);
        }
        return oldWarningType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void defuseList(List<RiskDefuseDto> riskDefuseDtoList) {
        try {
            for (RiskDefuseDto dto : riskDefuseDtoList) {
                try {
                    ResolveRiskForCommonParam defuseParam = new ResolveRiskForCommonParam();
                    defuseParam.setSourceIdList(List.of(dto.getRiskId()));
                    defuseParam.setReformMeasure(dto.getReformMeasure());
                    defuseParam.setAcceptanceWay(dto.getAcceptanceWay());
                    this.riskProvider.resolveRiskOfCommon(defuseParam);
                }
                catch (Exception e) {
                    log.error("\u3010\u57f9\u8bad\u98ce\u9669\u5316\u89e3\u3011\u3010\u5355\u4e2a\u3011\u3010\u8c03\u7528\u5316\u89e3\u65b9\u6cd5\u3011\u5931\u8d25,risk:{}", (Object)dto.getRiskId(), (Object)e);
                }
            }
        }
        catch (Exception e) {
            log.error("\u3010\u57f9\u8bad\u98ce\u9669\u5316\u89e3\u3011\u4f53\u68c0\u98ce\u9669\u5316\u89e3\u5931\u8d25,e:{}", (Throwable)e);
        }
        finally {
            riskDefuseDtoList.clear();
        }
    }

    @Generated
    public RiskDefuseTrainingManager(RedissonClient redissonClient, IRiskBasicSourceCommonService riskSourceService, ICTrainingCertService trainingCertService, ICStaffBaseInfoService staffBaseInfoService, ICStaffService staffService, ICStaffWorkExperienceService staffWorkExperienceService, IRiskProvider riskProvider) {
        this.redissonClient = redissonClient;
        this.riskSourceService = riskSourceService;
        this.trainingCertService = trainingCertService;
        this.staffBaseInfoService = staffBaseInfoService;
        this.staffService = staffService;
        this.staffWorkExperienceService = staffWorkExperienceService;
        this.riskProvider = riskProvider;
    }
}

