/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.rho.modules.sys.manger.risk;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.date.LocalDateTimeUtil;
import cn.hutool.core.util.StrUtil;
import cn.smarthse.rho.modules.sys.entity.c.CHealthCheckData;
import cn.smarthse.rho.modules.sys.entity.c.CStaff;
import cn.smarthse.rho.modules.sys.entity.c.CStaffWorkExperience;
import cn.smarthse.rho.modules.sys.entity.r.RRiskBasicSource;
import cn.smarthse.rho.modules.sys.enums.RhoTimeEnum;
import cn.smarthse.rho.modules.sys.enums.health.HealthCheckResultEnum;
import cn.smarthse.rho.modules.sys.enums.risk.RiskAcceptanceWayEnum;
import cn.smarthse.rho.modules.sys.enums.risk.RiskPostStatusEnum;
import cn.smarthse.rho.modules.sys.enums.risk.RiskPostSubStatusEnum;
import cn.smarthse.rho.modules.sys.enums.risk.RiskTypeEnum;
import cn.smarthse.rho.modules.sys.enums.risk.RiskWarningStatusEnum;
import cn.smarthse.rho.modules.sys.enums.staff.PostStatusEnum;
import cn.smarthse.rho.modules.sys.manger.risk.RiskGenHCManagerV3;
import cn.smarthse.rho.modules.sys.model.c.vo.staff.RiskStaffBaseInfo;
import cn.smarthse.rho.modules.sys.model.r.param.ResolveRiskForCommonParam;
import cn.smarthse.rho.modules.sys.model.r.param.RiskManagerDefuseParam;
import cn.smarthse.rho.modules.sys.model.r.vo.RiskDefuseDto;
import cn.smarthse.rho.modules.sys.provider.risk.IRiskProvider;
import cn.smarthse.rho.modules.sys.service.c.ICHealthCheckDataService;
import cn.smarthse.rho.modules.sys.service.c.ICStaffBaseInfoService;
import cn.smarthse.rho.modules.sys.service.c.ICStaffService;
import cn.smarthse.rho.modules.sys.service.c.ICStaffWorkExperienceService;
import cn.smarthse.rho.modules.sys.service.risk.IRiskAcceptanceRecordCommonService;
import cn.smarthse.rho.modules.sys.service.risk.IRiskBasicSourceCommonService;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalUnit;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.dubbo.config.annotation.DubboReference;
import org.redisson.api.RLock;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class RiskDefuseHCManagerV3 {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RiskDefuseHCManagerV3.class);
    private final RedissonClient redissonClient;
    private final ICStaffBaseInfoService staffBaseInfoService;
    private final ICStaffService staffService;
    private final IRiskBasicSourceCommonService riskSourceService;
    private final ICHealthCheckDataService healthCheckDataService;
    private final ICStaffWorkExperienceService staffWorkExperienceService;
    private final RiskGenHCManagerV3 riskGenHCManagerV3;
    private final IRiskAcceptanceRecordCommonService riskAcceptanceRecordService;
    @DubboReference
    private IRiskProvider riskProvider;
    private static final String LOCK_KEY = "RiskGenManager";
    private static final String WORK_TIME_DIFF_DEFUSE_MEASURE = "\u4eba\u5458\u4e0a\u5c97/\u79bb\u5c97\u65f6\u95f4\u5df2\u4fee\u6539\uff0c\u9700\u91cd\u65b0\u8bc4\u4f30\u98ce\u9669";
    private static final String POST_STATUS_DEFUSE_MEASURE = "\u5c97\u4f4d\u72b6\u6001\u53d8\u66f4\uff0c\u9700\u91cd\u65b0\u8bc4\u4f30\u98ce\u9669";
    private static final int RISK_POST_TYPE_PRE = RiskPostStatusEnum.PRE_POST.getValue();
    private static final int RISK_POST_TYPE_ON = RiskPostStatusEnum.ON_POST.getValue();
    private static final int RISK_POST_TYPE_DT = RiskPostStatusEnum.DT_POST.getValue();
    private static final int RISK_POST_SUB_TYPE_ON = RiskPostSubStatusEnum.ON_POST.getValue();
    private static final int RISK_POST_SUB_TYPE_DT = RiskPostSubStatusEnum.DT_POST.getValue();
    public static final Integer CURR_YEAR = RiskGenHCManagerV3.CURR_YEAR;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void defuseHCRisk(RiskManagerDefuseParam param) {
        String title = "\u98ce\u9669\u7ef4\u62a4\uff1a\u4f53\u68c0-\u5316\u89e3";
        String methodName = "defuseHCRisk()";
        log.debug(title + methodName + "start");
        StringBuilder sb = new StringBuilder(LOCK_KEY).append("_").append(methodName).append("_").append(param.getYear());
        RLock lock = this.redissonClient.getLock(sb.toString());
        boolean resLock = false;
        try {
            resLock = lock.tryLock(1L, 3600L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        if (resLock) {
            try {
                this.defuseHCRiskLock(param);
                log.debug(title + methodName + "end");
            }
            catch (Exception e) {
                log.error(title + "\u5931\u8d25{}", (Throwable)e);
            }
            finally {
                lock.unlock();
            }
        } else {
            log.error("{}\uff1aPending lock timeout\uff0cmethod:" + methodName, (Object)LOCK_KEY);
        }
    }

    public void defuseHCRiskLock(RiskManagerDefuseParam param) {
        try {
            this.defusePreJob(param);
        }
        catch (Exception e) {
            log.error("\u3010\u4f53\u68c0\u98ce\u9669\u5316\u89e3V3\u3011\u3010\u5c97\u524d\u3011\u3010\u6574\u4f53\u3011\u98ce\u9669\u751f\u6210\u5931\u8d25\u5f02\u5e38\u5f02\u5e38\u5982\u4e0b\uff1a:{}", (Throwable)e);
        }
        try {
            this.defuseOnJob(param);
        }
        catch (Exception e) {
            log.error("\u3010\u4f53\u68c0\u98ce\u9669\u5316\u89e3V3\u3011\u3010\u79bb\u4e2d\u3011\u3010\u6574\u4f53\u3011\u98ce\u9669\u751f\u6210\u5931\u8d25\u5f02\u5e38\u5f02\u5e38\u5982\u4e0b\uff1a:{}", (Throwable)e);
        }
        try {
            this.defuseDtJob(param);
        }
        catch (Exception e) {
            log.error("\u3010\u4f53\u68c0\u98ce\u9669\u5316\u89e3V3\u3011\u3010\u79bb\u5c97\u3011\u3010\u6574\u4f53\u3011\u98ce\u9669\u751f\u6210\u5931\u8d25\u5f02\u5e38\u5f02\u5e38\u5982\u4e0b\uff1a:{}", (Throwable)e);
        }
    }

    public void defusePreJob(RiskManagerDefuseParam param) {
        List<Long> riskList = this.riskSourceService.getHealthCheckPreJobRiskIdList2Defuse(param.getCidList());
        ArrayList<RiskDefuseDto> riskDefuseDtoList = new ArrayList<RiskDefuseDto>();
        for (Long rid : riskList) {
            try {
                RRiskBasicSource risk = this.riskSourceService.getExEnFieldForRisk(rid);
                this.defuseOnePreJob(risk, riskDefuseDtoList);
            }
            catch (Exception e) {
                log.error("\u3010\u4f53\u68c0\u98ce\u9669\u5316\u89e3V3\u3011\u3010\u5c97\u524d\u3011\u5931\u8d25\uff1arId{}", (Object)rid, (Object)e);
            }
            if (riskDefuseDtoList.size() < 500) continue;
            this.defuseList(riskDefuseDtoList);
        }
        if (CollUtil.isNotEmpty(riskDefuseDtoList)) {
            this.defuseList(riskDefuseDtoList);
        }
    }

    private void defuseOnePreJob(RRiskBasicSource risk, List<RiskDefuseDto> riskDefuseDtoList) {
        Long hcId = risk.getBusinessId();
        Long sbId = risk.getSubBusinessId();
        Long weId = risk.getWorkExperienceId();
        Long rId = risk.getId();
        Integer riskType = risk.getType();
        Integer riskPostType = risk.getPostType();
        LocalDateTime wePostStartTime = null;
        LocalDateTime wePostDepartureTime = null;
        LocalDateTime riskPostStartTime = null;
        LocalDateTime riskPostDepartureTime = null;
        RiskStaffBaseInfo staffBaseInfo = null;
        CStaffWorkExperience workExperience = null;
        CHealthCheckData healthCheckData = null;
        if (sbId == null) {
            log.error("\u3010\u4f53\u68c0\u98ce\u9669\u5316\u89e3V3\u3011\u3010\u5c97\u524d\u3011\u4f53\u68c0\u98ce\u9669\u7f3a\u5c11\u7528\u6237id,\u5316\u89e3\u5931\u8d25\u3002riskId:{}", (Object)rId);
            return;
        }
        staffBaseInfo = this.staffBaseInfoService.getInfoUnDeFieldForRisk(sbId);
        if (staffBaseInfo == null) {
            riskDefuseDtoList.add(RiskDefuseDto.createSpecialDefuse((Long)rId));
            return;
        }
        if (weId == null) {
            log.error("\u3010\u4f53\u68c0\u98ce\u9669\u5316\u89e3V3\u3011\u3010\u5c97\u524d\u3011\u4f53\u68c0\u98ce\u9669\u7f3a\u5c11wordExperienceId,\u5316\u89e3\u5931\u8d25\u3002sbId{},riskId:{}", (Object)sbId, (Object)rId);
            return;
        }
        workExperience = this.staffWorkExperienceService.getForRiskById(weId);
        if (workExperience == null) {
            riskDefuseDtoList.add(RiskDefuseDto.createSpecialDefuse((Long)rId));
            return;
        }
        wePostStartTime = workExperience.getPostStartTime();
        wePostDepartureTime = workExperience.getPostDepartureTime();
        riskPostStartTime = risk.getPostStartTime() == null ? null : LocalDateTimeUtil.of((TemporalAccessor)risk.getPostStartTime());
        LocalDateTime localDateTime = riskPostDepartureTime = risk.getPostDepartureTime() == null ? null : LocalDateTimeUtil.of((TemporalAccessor)risk.getPostDepartureTime());
        if (wePostStartTime == null) {
            log.error("\u3010\u4f53\u68c0\u98ce\u9669\u5316\u89e3V3\u3011\u3010\u5c97\u524d\u3011\u4f53\u68c0\u98ce\u9669\u5bf9\u5e94\u5de5\u4f5c\u7ecf\u5386\u7f3a\u5c11\u4e0a\u5c97\u65f6\u95f4,\u5316\u89e3\u5931\u8d25\u3002sbId{},riskId:{}", (Object)sbId, (Object)rId);
            return;
        }
        if (risk.getIsGenerateByData() == 1) {
            if (hcId == null) {
                log.error("\u3010\u4f53\u68c0\u98ce\u9669\u5316\u89e3V3\u3011\u3010\u5c97\u524d\u3011\u4f53\u68c0\u98ce\u9669\u7f3a\u5c11healthCheckDataId,\u5316\u89e3\u5931\u8d25\u3002sbId{},riskId:{}", (Object)sbId, (Object)rId);
                return;
            }
            healthCheckData = this.healthCheckDataService.getInfoExEnForRisk(hcId);
            if (healthCheckData == null) {
                riskDefuseDtoList.add(RiskDefuseDto.createSpecialDefuse((Long)rId));
                return;
            }
        }
        if (this.timeDiff(wePostStartTime, wePostDepartureTime, riskPostStartTime, riskPostDepartureTime)) {
            riskDefuseDtoList.add(RiskDefuseDto.createSpecialMeasuresDefuse((Long)rId, (String)WORK_TIME_DIFF_DEFUSE_MEASURE));
            return;
        }
        if (wePostStartTime.isBefore(RiskGenHCManagerV3.TRIAL_RUN_TIME)) {
            riskDefuseDtoList.add(RiskDefuseDto.createSpecialDefuse((Long)rId));
            return;
        }
        if (RiskDefuseHCManagerV3.isPassRiskType(risk)) {
            return;
        }
        if (riskType.equals(RiskTypeEnum.PHYSICAL_EXCEPTION_REVIEW.getValue())) {
            LocalDate e;
            LocalDate s = healthCheckData.getCheckDate();
            CHealthCheckData lastData = this.healthCheckDataService.getLastDataForFcRisk(sbId, s, e = LocalDate.from(RiskDefuseHCManagerV3.add240Days(LocalDateTimeUtil.of((TemporalAccessor)s))));
            if (lastData != null && lastData.getResultCode() != null && !lastData.getResultCode().equals(HealthCheckResultEnum.FC.getValue())) {
                riskDefuseDtoList.add(RiskDefuseDto.createCommonDefuse((Long)rId));
            }
            return;
        }
        if (riskType.equals(RiskTypeEnum.PHYSICAL_EXAMINATION.getValue())) {
            CHealthCheckData validData = this.riskGenHCManagerV3.getValidDataForPreJob(sbId, wePostStartTime);
            if (validData == null) {
                return;
            }
            riskDefuseDtoList.add(RiskDefuseDto.createCommonDefuse((Long)rId));
            return;
        }
    }

    private static boolean isPassRiskType(RRiskBasicSource risk) {
        return risk.getType().equals(RiskTypeEnum.PHYSICAL_EXCEPTION_OCC.getValue()) || risk.getType().equals(RiskTypeEnum.PHYSICAL_EXCEPTION_CONTRAINDICATION.getValue());
    }

    public void defuseDtJob(RiskManagerDefuseParam param) {
        List<Long> riskList = this.riskSourceService.getHealthCheckDtJobRiskIdList2Defuse(param.getCidList());
        ArrayList<RiskDefuseDto> riskDefuseDtoList = new ArrayList<RiskDefuseDto>();
        for (Long rid : riskList) {
            try {
                RRiskBasicSource risk = this.riskSourceService.getExEnFieldForRisk(rid);
                this.defuseOneDtJob(risk, riskDefuseDtoList);
            }
            catch (Exception e) {
                log.error("\u3010\u4f53\u68c0\u98ce\u9669\u5316\u89e3V3\u3011\u3010\u79bb\u5c97\u3011\u5931\u8d25\uff1arId{}", (Object)rid, (Object)e);
            }
            if (riskDefuseDtoList.size() < 500) continue;
            this.defuseList(riskDefuseDtoList);
        }
        if (CollUtil.isNotEmpty(riskDefuseDtoList)) {
            this.defuseList(riskDefuseDtoList);
        }
    }

    private void defuseOneDtJob(RRiskBasicSource risk, List<RiskDefuseDto> riskDefuseDtoList) {
        Long hcId = risk.getBusinessId();
        Long sbId = risk.getSubBusinessId();
        Long weId = risk.getWorkExperienceId();
        Long rId = risk.getId();
        Integer isGenerateByData = risk.getIsGenerateByData();
        LocalDateTime wePostStartTime = null;
        LocalDateTime wePostDepartureTime = null;
        LocalDateTime riskPostStartTime = null;
        LocalDateTime riskPostDepartureTime = null;
        RiskStaffBaseInfo staffBaseInfo = null;
        CStaffWorkExperience workExperience = null;
        CHealthCheckData healthCheckData = null;
        Integer riskType = risk.getType();
        Integer riskPostType = risk.getPostType();
        if (sbId == null) {
            log.error("\u3010\u4f53\u68c0\u98ce\u9669\u5316\u89e3V3\u3011\u3010\u79bb\u5c97\u3011\u4f53\u68c0\u98ce\u9669\u7f3a\u5c11\u7528\u6237id,\u5316\u89e3\u5931\u8d25\u3002riskId:{}", (Object)rId);
            return;
        }
        staffBaseInfo = this.staffBaseInfoService.getInfoUnDeFieldForRisk(sbId);
        if (staffBaseInfo == null) {
            riskDefuseDtoList.add(RiskDefuseDto.createSpecialDefuse((Long)rId));
            return;
        }
        if (weId == null) {
            log.error("\u3010\u4f53\u68c0\u98ce\u9669\u5316\u89e3V3\u3011\u3010\u79bb\u5c97\u3011\u4f53\u68c0\u98ce\u9669\u7f3a\u5c11wordExperienceId,\u5316\u89e3\u5931\u8d25\u3002sbId{},riskId:{}", (Object)sbId, (Object)rId);
            return;
        }
        workExperience = this.staffWorkExperienceService.getForRiskById(weId);
        if (workExperience == null) {
            riskDefuseDtoList.add(RiskDefuseDto.createSpecialDefuse((Long)rId));
            return;
        }
        wePostStartTime = workExperience.getPostStartTime();
        wePostDepartureTime = workExperience.getPostDepartureTime();
        riskPostStartTime = risk.getPostStartTime() == null ? null : LocalDateTimeUtil.of((TemporalAccessor)risk.getPostStartTime());
        LocalDateTime localDateTime = riskPostDepartureTime = risk.getPostDepartureTime() == null ? null : LocalDateTimeUtil.of((TemporalAccessor)risk.getPostDepartureTime());
        if (wePostDepartureTime == null) {
            log.error("\u3010\u4f53\u68c0\u98ce\u9669\u5316\u89e3V3\u3011\u3010\u79bb\u5c97\u3011\u4f53\u68c0\u98ce\u9669\u5bf9\u5e94\u5de5\u4f5c\u7ecf\u5386\u7f3a\u5c11\u79bb\u5c97\u65f6\u95f4,\u5316\u89e3\u5931\u8d25\u3002sbId{},riskId:{}", (Object)sbId, (Object)rId);
            return;
        }
        if (isGenerateByData == 1) {
            if (hcId == null) {
                log.error("\u3010\u4f53\u68c0\u98ce\u9669\u5316\u89e3V3\u3011\u3010\u79bb\u5c97\u3011\u4f53\u68c0\u98ce\u9669\u7f3a\u5c11healthCheckDataId,\u5316\u89e3\u5931\u8d25\u3002sbId{},riskId:{}", (Object)sbId, (Object)rId);
                return;
            }
            healthCheckData = this.healthCheckDataService.getInfoExEnForRisk(hcId);
            if (healthCheckData == null) {
                riskDefuseDtoList.add(RiskDefuseDto.createSpecialDefuse((Long)rId));
                return;
            }
        }
        if (wePostDepartureTime.isBefore(RiskGenHCManagerV3.TRIAL_RUN_TIME)) {
            riskDefuseDtoList.add(RiskDefuseDto.createSpecialDefuse((Long)rId));
            return;
        }
        if (this.timeDiff(wePostStartTime, wePostDepartureTime, riskPostStartTime, riskPostDepartureTime)) {
            riskDefuseDtoList.add(RiskDefuseDto.createSpecialMeasuresDefuse((Long)rId, (String)WORK_TIME_DIFF_DEFUSE_MEASURE));
            return;
        }
        if (RiskDefuseHCManagerV3.isPassRiskType(risk)) {
            return;
        }
        if (riskType.equals(RiskTypeEnum.PHYSICAL_EXCEPTION_REVIEW.getValue())) {
            LocalDate e;
            LocalDate s = healthCheckData.getCheckDate();
            CHealthCheckData lastData = this.healthCheckDataService.getLastDataForFcRisk(sbId, s, e = LocalDate.from(RiskDefuseHCManagerV3.add240Days(LocalDateTimeUtil.of((TemporalAccessor)s))));
            if (lastData != null && lastData.getResultCode() != null && !lastData.getResultCode().equals(HealthCheckResultEnum.FC.getValue())) {
                riskDefuseDtoList.add(RiskDefuseDto.createCommonDefuse((Long)rId));
            }
            return;
        }
        if (riskType.equals(RiskTypeEnum.PHYSICAL_EXAMINATION.getValue())) {
            CHealthCheckData validData = this.riskGenHCManagerV3.getValidForDtJob(sbId, wePostDepartureTime);
            if (validData == null) {
                return;
            }
            riskDefuseDtoList.add(RiskDefuseDto.createCommonDefuse((Long)rId));
        }
    }

    public void defuseOnJob(RiskManagerDefuseParam param) {
        List<Long> riskList = this.riskSourceService.getHealthCheckOnJobRiskIdList2Defuse(param.getCidList());
        ArrayList<RiskDefuseDto> riskDefuseDtoList = new ArrayList<RiskDefuseDto>();
        for (Long rid : riskList) {
            try {
                RRiskBasicSource risk = this.riskSourceService.getExEnFieldForRisk(rid);
                this.defuseOneOnJob(risk, riskDefuseDtoList);
            }
            catch (Exception e) {
                log.error("\u3010\u4f53\u68c0\u98ce\u9669\u5316\u89e3V3\u3011\u3010\u5c97\u4e2d\u3011\u5931\u8d25\uff1arId{}", (Object)rid, (Object)e);
            }
            if (riskDefuseDtoList.size() < 500) continue;
            this.defuseList(riskDefuseDtoList);
        }
        if (CollUtil.isNotEmpty(riskDefuseDtoList)) {
            this.defuseList(riskDefuseDtoList);
        }
    }

    private void defuseOneOnJob(RRiskBasicSource risk, List<RiskDefuseDto> riskDefuseDtoList) {
        Long hcId = risk.getBusinessId();
        Long sbId = risk.getSubBusinessId();
        Long weId = risk.getWorkExperienceId();
        Long rId = risk.getId();
        LocalDateTime currentTime = LocalDateTime.now();
        LocalDateTime wePostStartTime = null;
        LocalDateTime wePostDepartureTime = null;
        LocalDateTime riskPostStartTime = null;
        LocalDateTime riskPostDepartureTime = null;
        RiskStaffBaseInfo staffBaseInfo = null;
        CStaffWorkExperience workExperience = null;
        CHealthCheckData oldCheckData = null;
        Integer riskPostSubType = risk.getPostSubType();
        LocalDateTime referenceTime = null;
        Integer riskType = risk.getType();
        Integer riskPostType = risk.getPostType();
        Integer isGenerateByData = risk.getIsGenerateByData();
        Integer postStatus = null;
        if (sbId == null) {
            log.error("\u3010\u4f53\u68c0\u98ce\u9669\u5316\u89e3V3\u3011\u3010\u5c97\u4e2d\u3011\u4f53\u68c0\u98ce\u9669\u7f3a\u5c11\u7528\u6237id,\u5316\u89e3\u5931\u8d25\u3002riskId:{}", (Object)rId);
            return;
        }
        staffBaseInfo = this.staffBaseInfoService.getInfoUnDeFieldForRisk(sbId);
        if (staffBaseInfo == null) {
            riskDefuseDtoList.add(RiskDefuseDto.createSpecialDefuse((Long)rId));
            return;
        }
        CStaff staff = this.staffService.getByBaseIdAndCidForRisk(sbId, risk.getCid());
        if (staff == null || staff.getPostStatus() == null || StrUtil.isBlank((CharSequence)PostStatusEnum.getName((Integer)staff.getPostStatus()))) {
            return;
        }
        postStatus = staff.getPostStatus();
        if (riskPostSubType == null) {
            log.error("\u3010\u4f53\u68c0\u98ce\u9669\u5316\u89e3V3\u3011\u3010\u5c97\u4e2d\u3011\u4f53\u68c0\u98ce\u9669\u7f3a\u5c11riskPostSubType,\u5316\u89e3\u5931\u8d25\u3002sbId{},riskId:{}", (Object)sbId, (Object)rId);
            return;
        }
        if (weId == null) {
            log.error("\u3010\u4f53\u68c0\u98ce\u9669\u5316\u89e3V3\u3011\u3010\u5c97\u4e2d\u3011\u4f53\u68c0\u98ce\u9669\u7f3a\u5c11wordExperienceId,\u5316\u89e3\u5931\u8d25\u3002sbId{},riskId:{}", (Object)sbId, (Object)rId);
            return;
        }
        workExperience = this.staffWorkExperienceService.getForRiskById(weId);
        if (workExperience == null) {
            riskDefuseDtoList.add(RiskDefuseDto.createSpecialDefuse((Long)rId));
            return;
        }
        wePostStartTime = workExperience.getPostStartTime();
        wePostDepartureTime = workExperience.getPostDepartureTime();
        riskPostStartTime = risk.getPostStartTime() == null ? null : LocalDateTimeUtil.of((TemporalAccessor)risk.getPostStartTime());
        LocalDateTime localDateTime = riskPostDepartureTime = risk.getPostDepartureTime() == null ? null : LocalDateTimeUtil.of((TemporalAccessor)risk.getPostDepartureTime());
        if (riskPostSubType.equals(RiskPostSubStatusEnum.ON_POST.getValue())) {
            if (wePostStartTime == null) {
                log.error("\u3010\u4f53\u68c0\u98ce\u9669\u5316\u89e3V3\u3011\u3010\u5c97\u4e2d\u3011\u4f53\u68c0\u98ce\u9669\u5bf9\u5e94\u5de5\u4f5c\u7ecf\u5386\u7f3a\u5c11\u4e0a\u5c97\u65f6\u95f4,\u5316\u89e3\u5931\u8d25\u3002sbId{},riskId:{}", (Object)sbId, (Object)rId);
                return;
            }
            if (riskPostStartTime == null) {
                log.error("\u3010\u4f53\u68c0\u98ce\u9669\u5316\u89e3V3\u3011\u3010\u5c97\u4e2d\u3011\u4f53\u68c0\u98ce\u9669\u7f3a\u5c11\u5197\u4f59\u7684\u4e0a\u5c97\u65f6\u95f4\uff0c\u5316\u89e3\u5931\u8d25\u3002sbId{},riskId:{}", (Object)sbId, (Object)rId);
                return;
            }
            referenceTime = currentTime;
        }
        if (riskPostSubType.equals(RiskPostSubStatusEnum.DT_POST.getValue())) {
            if (wePostStartTime == null) {
                log.error("\u3010\u4f53\u68c0\u98ce\u9669\u5316\u89e3V3\u3011\u3010\u5c97\u4e2d\u3011\u4f53\u68c0\u98ce\u9669\u5bf9\u5e94\u5de5\u4f5c\u7ecf\u5386\u7f3a\u5c11\u4e0a\u5c97\u65f6\u95f4,\u5316\u89e3\u5931\u8d25\u3002sbId{},riskId:{}", (Object)sbId, (Object)rId);
                return;
            }
            if (wePostDepartureTime == null) {
                log.error("\u3010\u4f53\u68c0\u98ce\u9669\u5316\u89e3V3\u3011\u3010\u5c97\u4e2d\u3011\u4f53\u68c0\u98ce\u9669\u5bf9\u5e94\u5de5\u4f5c\u7ecf\u5386\u7f3a\u5c11\u79bb\u5c97\u65f6\u95f4,\u5316\u89e3\u5931\u8d25\u3002sbId{},riskId:{}", (Object)sbId, (Object)rId);
                return;
            }
            if (riskPostDepartureTime == null) {
                log.error("\u3010\u4f53\u68c0\u98ce\u9669\u5316\u89e3V3\u3011\u3010\u5c97\u4e2d\u3011\u4f53\u68c0\u98ce\u9669\u7f3a\u5c11\u5197\u4f59\u7684\u79bb\u5c97\u65f6\u95f4\uff0c\u5316\u89e3\u5931\u8d25\u3002sbId{},riskId:{}", (Object)sbId, (Object)rId);
                return;
            }
            referenceTime = riskPostDepartureTime;
        }
        if (isGenerateByData == 1) {
            if (hcId == null) {
                log.error("\u3010\u4f53\u68c0\u98ce\u9669\u5316\u89e3V3\u3011\u3010\u5c97\u4e2d\u3011\u4f53\u68c0\u98ce\u9669\u7f3a\u5c11healthCheckDataId,\u5316\u89e3\u5931\u8d25\u3002sbId{},riskId:{}", (Object)sbId, (Object)rId);
                return;
            }
            oldCheckData = this.healthCheckDataService.getInfoExEnForRisk(hcId);
            if (oldCheckData == null) {
                riskDefuseDtoList.add(RiskDefuseDto.createSpecialDefuse((Long)rId));
                return;
            }
        }
        if (this.timeDiff(wePostStartTime, wePostDepartureTime, riskPostStartTime, riskPostDepartureTime)) {
            riskDefuseDtoList.add(RiskDefuseDto.createSpecialMeasuresDefuse((Long)rId, (String)WORK_TIME_DIFF_DEFUSE_MEASURE));
            return;
        }
        LocalDateTime offset1 = LocalDateTimeUtil.offset((LocalDateTime)wePostStartTime, (long)2L, (TemporalUnit)ChronoUnit.YEARS);
        LocalDateTime offset2 = LocalDateTimeUtil.offset((LocalDateTime)offset1, (long)(-RhoTimeEnum.SECOND_OF_90_DAY.getTime().longValue()), (TemporalUnit)ChronoUnit.SECONDS);
        if (currentTime.isBefore(offset2)) {
            riskDefuseDtoList.add(RiskDefuseDto.createSpecialDefuse((Long)rId));
            return;
        }
        if ((postStatus.equals(PostStatusEnum.ON_POST.getValue()) || postStatus.equals(PostStatusEnum.TP_NON_POST.getValue())) && riskPostSubType.equals(RiskPostSubStatusEnum.DT_POST.getValue())) {
            riskDefuseDtoList.add(RiskDefuseDto.createSpecialMeasuresDefuse((Long)rId, (String)POST_STATUS_DEFUSE_MEASURE));
            return;
        }
        if (postStatus.equals(PostStatusEnum.NON_POST.getValue()) && riskPostSubType.equals(RiskPostSubStatusEnum.ON_POST.getValue())) {
            riskDefuseDtoList.add(RiskDefuseDto.createSpecialMeasuresDefuse((Long)rId, (String)POST_STATUS_DEFUSE_MEASURE));
            return;
        }
        if (riskPostSubType.equals(RiskPostSubStatusEnum.DT_POST.getValue())) {
            if (wePostDepartureTime.isBefore(RiskGenHCManagerV3.TRIAL_RUN_TIME)) {
                riskDefuseDtoList.add(RiskDefuseDto.createSpecialDefuse((Long)rId));
                return;
            }
            if (wePostStartTime.isAfter(LocalDateTimeUtil.offset((LocalDateTime)wePostDepartureTime, (long)-2L, (TemporalUnit)ChronoUnit.YEARS))) {
                riskDefuseDtoList.add(RiskDefuseDto.createSpecialDefuse((Long)rId));
                return;
            }
        }
        if (RiskDefuseHCManagerV3.isPassRiskType(risk)) {
            return;
        }
        if (riskType.equals(RiskTypeEnum.PHYSICAL_EXCEPTION_REVIEW.getValue())) {
            LocalDate e;
            LocalDate s = oldCheckData.getCheckDate();
            CHealthCheckData lastData = this.healthCheckDataService.getLastDataForFcRisk(sbId, s, e = LocalDate.from(RiskDefuseHCManagerV3.add240Days(LocalDateTimeUtil.of((TemporalAccessor)s))));
            if (lastData != null && lastData.getResultCode() != null && !lastData.getResultCode().equals(HealthCheckResultEnum.FC.getValue())) {
                riskDefuseDtoList.add(RiskDefuseDto.createCommonDefuse((Long)rId));
            }
            return;
        }
        if (riskType.equals(RiskTypeEnum.PHYSICAL_EXAMINATION.getValue())) {
            boolean oldWarningTypeIsRedQdzf;
            CHealthCheckData validData = this.riskGenHCManagerV3.getValidForOnJob(sbId, referenceTime);
            if (validData == null) {
                return;
            }
            boolean checkTimePass = RiskGenHCManagerV3.timeCheck(LocalDateTimeUtil.of((TemporalAccessor)validData.getCheckDate()), referenceTime);
            if (checkTimePass || !checkTimePass && isGenerateByData == 0) {
                riskDefuseDtoList.add(RiskDefuseDto.createCommonDefuse((Long)rId));
                return;
            }
            Integer oldWarningType = RiskGenHCManagerV3.calculateWarnType(LocalDateTimeUtil.of((TemporalAccessor)oldCheckData.getCheckDate()), referenceTime);
            Integer warningType = RiskGenHCManagerV3.calculateWarnType(LocalDateTimeUtil.of((TemporalAccessor)validData.getCheckDate()), referenceTime);
            boolean newestWarningTypeIsFirstYellow = warningType.equals(RiskWarningStatusEnum.FIRST.getValue()) || warningType.equals(RiskWarningStatusEnum.YELLOW.getValue());
            boolean bl = oldWarningTypeIsRedQdzf = oldWarningType.equals(RiskWarningStatusEnum.RED.getValue()) || oldWarningType.equals(RiskWarningStatusEnum.ACTIVATE_LAW.getValue());
            if (newestWarningTypeIsFirstYellow && oldWarningTypeIsRedQdzf) {
                riskDefuseDtoList.add(RiskDefuseDto.createCommonDefuse((Long)rId));
                return;
            }
        }
    }

    private boolean timeDiff(LocalDateTime wePostStartTime, LocalDateTime wePostDepartureTime, LocalDateTime riskPostStartTime, LocalDateTime riskPostDepartureTime) {
        LocalDate wePostStartTimeTemp = wePostStartTime == null ? null : LocalDate.from(wePostStartTime);
        LocalDate wePostDepartureTimeTemp = wePostDepartureTime == null ? null : LocalDate.from(wePostDepartureTime);
        LocalDate riskPostStartTimeTemp = riskPostStartTime == null ? null : LocalDate.from(riskPostStartTime);
        LocalDate riskPostDepartureTimeTemp = riskPostDepartureTime == null ? null : LocalDate.from(riskPostDepartureTime);
        long riskPostStartSecond = LocalDateTimeUtil.of((TemporalAccessor)((Object)(riskPostStartTimeTemp == null ? LocalDateTimeUtil.of((long)0L) : riskPostStartTimeTemp))).atZone(ZoneId.systemDefault()).toEpochSecond();
        long riskPostDepartureSecond = LocalDateTimeUtil.of((TemporalAccessor)((Object)(riskPostDepartureTimeTemp == null ? LocalDateTimeUtil.of((long)0L) : riskPostDepartureTimeTemp))).atZone(ZoneId.systemDefault()).toEpochSecond();
        long workExperiencePostStartSecond = LocalDateTimeUtil.of((TemporalAccessor)((Object)(wePostStartTimeTemp == null ? LocalDateTimeUtil.of((long)0L) : wePostStartTimeTemp))).atZone(ZoneId.systemDefault()).toEpochSecond();
        long workExperiencePostDepartureSecond = LocalDateTimeUtil.of((TemporalAccessor)((Object)(wePostDepartureTimeTemp == null ? LocalDateTimeUtil.of((long)0L) : wePostDepartureTimeTemp))).atZone(ZoneId.systemDefault()).toEpochSecond();
        return riskPostStartSecond != workExperiencePostStartSecond || riskPostDepartureSecond != workExperiencePostDepartureSecond;
    }

    private void defuseList(List<RiskDefuseDto> riskDefuseDtoList) {
        try {
            Map<Integer, List<RiskDefuseDto>> riskDefuseDtoListMap = riskDefuseDtoList.stream().collect(Collectors.groupingBy(RiskDefuseDto::getAcceptanceWay));
            riskDefuseDtoListMap.forEach((acceptanceWay, list) -> {
                if (acceptanceWay.equals(RiskAcceptanceWayEnum.DATA.getValue())) {
                    ResolveRiskForCommonParam defuseParam = new ResolveRiskForCommonParam();
                    defuseParam.setSourceIdList(list.stream().map(v -> v.getRiskId()).collect(Collectors.toList()));
                    defuseParam.setAcceptanceWay(acceptanceWay);
                    this.riskProvider.resolveRiskOfCommon(defuseParam);
                }
                if (acceptanceWay.equals(RiskAcceptanceWayEnum.SPECIAL_FOREVER.getValue())) {
                    Map<String, List<RiskDefuseDto>> measureWayMap = list.stream().collect(Collectors.groupingBy(v -> v.getReformMeasure()));
                    measureWayMap.forEach((measure, specialList) -> {
                        ResolveRiskForCommonParam defuseParam = new ResolveRiskForCommonParam();
                        defuseParam.setSourceIdList(specialList.stream().map(v -> v.getRiskId()).collect(Collectors.toList()));
                        defuseParam.setAcceptanceWay(acceptanceWay);
                        defuseParam.setReformMeasure(measure.equals("NULL") ? null : measure);
                        this.riskProvider.resolveRiskOfCommon(defuseParam);
                    });
                }
            });
        }
        catch (Exception e) {
            log.error("\u3010\u4f53\u68c0\u98ce\u9669\u5316\u89e3\u3011\u4f53\u68c0\u98ce\u9669\u5316\u89e3\u5931\u8d25,e:{}", (Throwable)e);
        }
        finally {
            riskDefuseDtoList.clear();
        }
    }

    public static LocalDateTime sub30Days(LocalDateTime time) {
        return RiskGenHCManagerV3.sub30Days(time);
    }

    public static LocalDateTime add90Days(LocalDateTime time) {
        return RiskGenHCManagerV3.add90Days(time);
    }

    public static LocalDateTime add240Days(LocalDateTime time) {
        return LocalDateTimeUtil.offset((LocalDateTime)time, (long)RhoTimeEnum.SECOND_OF_240_DAY.getTime(), (TemporalUnit)ChronoUnit.SECONDS);
    }

    public static LocalDateTime sub2Year(LocalDateTime time) {
        return RiskGenHCManagerV3.sub2Year(time);
    }

    public static LocalDateTime sub90Days(LocalDateTime time) {
        return RiskGenHCManagerV3.sub90Days(time);
    }

    @Generated
    public RiskDefuseHCManagerV3(RedissonClient redissonClient, ICStaffBaseInfoService staffBaseInfoService, ICStaffService staffService, IRiskBasicSourceCommonService riskSourceService, ICHealthCheckDataService healthCheckDataService, ICStaffWorkExperienceService staffWorkExperienceService, RiskGenHCManagerV3 riskGenHCManagerV3, IRiskAcceptanceRecordCommonService riskAcceptanceRecordService) {
        this.redissonClient = redissonClient;
        this.staffBaseInfoService = staffBaseInfoService;
        this.staffService = staffService;
        this.riskSourceService = riskSourceService;
        this.healthCheckDataService = healthCheckDataService;
        this.staffWorkExperienceService = staffWorkExperienceService;
        this.riskGenHCManagerV3 = riskGenHCManagerV3;
        this.riskAcceptanceRecordService = riskAcceptanceRecordService;
    }
}

