/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.rho.modules.sys.manger.risk;

import cn.hutool.core.collection.CollUtil;
import cn.smarthse.rho.modules.sys.entity.b.BCert;
import cn.smarthse.rho.modules.sys.entity.b.BCompany;
import cn.smarthse.rho.modules.sys.entity.r.RRiskBasicSource;
import cn.smarthse.rho.modules.sys.enums.risk.RiskAcceptanceWayEnum;
import cn.smarthse.rho.modules.sys.enums.risk.RiskWarningStatusEnum;
import cn.smarthse.rho.modules.sys.manger.risk.RiskGenCompanyCertManager;
import cn.smarthse.rho.modules.sys.model.r.param.ResolveRiskForCommonParam;
import cn.smarthse.rho.modules.sys.model.r.param.RiskManagerDefuseParam;
import cn.smarthse.rho.modules.sys.model.r.vo.RiskDefuseDto;
import cn.smarthse.rho.modules.sys.provider.risk.IRiskProvider;
import cn.smarthse.rho.modules.sys.service.b.IBCertService;
import cn.smarthse.rho.modules.sys.service.b.IBCompanyService;
import cn.smarthse.rho.modules.sys.service.b.IBLicenseManagementSettingService;
import cn.smarthse.rho.modules.sys.service.risk.IRiskBasicSourceCommonService;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import lombok.Generated;
import org.redisson.api.RLock;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class RiskDefuseCompanyCertManager {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RiskDefuseCompanyCertManager.class);
    private final IBCertService cmCertService;
    private final IBCompanyService companyService;
    private final RedissonClient redissonClient;
    private final IRiskBasicSourceCommonService riskSourceService;
    private final IRiskProvider riskProvider;
    private final RiskGenCompanyCertManager companyCertManager;
    private final IBLicenseManagementSettingService licenseManagementSettingService;
    private static final String LOCK_KEY = "RiskGenManager";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void defusePermitCertRisk(RiskManagerDefuseParam param) {
        String title = "\u98ce\u9669\u7ef4\u62a4\uff1a\u8bb8\u53ef\u8bc1-\u5316\u89e3";
        String methodName = "defusePermitCertRisk()";
        log.debug(title + methodName + "start");
        StringBuilder sb = new StringBuilder(LOCK_KEY).append("_").append(methodName).append("_").append(param.getYear());
        RLock lock = this.redissonClient.getLock(sb.toString());
        boolean resLock = false;
        try {
            resLock = lock.tryLock(30L, 30L, TimeUnit.MINUTES);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        if (resLock) {
            try {
                this.defuseCompanyCertRiskLock(param);
                log.debug(title + methodName + "end");
            }
            catch (Exception e) {
                log.error(title + "\u5931\u8d25{}", (Throwable)e);
            }
            finally {
                lock.unlock();
            }
        } else {
            log.error("{}\uff1aPending lock timeout\uff0cmethod:" + methodName, (Object)LOCK_KEY);
        }
    }

    public void defuseCompanyCertRiskLock(RiskManagerDefuseParam param) {
        List<RRiskBasicSource> list = this.riskSourceService.getCmCertRiskForManager(param);
        ArrayList<RiskDefuseDto> riskDefuseDtoList = new ArrayList<RiskDefuseDto>();
        ArrayList riskSourceIdList = new ArrayList();
        for (RRiskBasicSource vo : list) {
            this.defuseOne(vo, riskDefuseDtoList);
            if (riskDefuseDtoList.size() < 500) continue;
            this.defuseList(riskDefuseDtoList);
        }
        if (CollUtil.isNotEmpty(riskDefuseDtoList)) {
            this.defuseList(riskDefuseDtoList);
        }
    }

    private void defuseOne(RRiskBasicSource risk, List<RiskDefuseDto> riskDefuseDtoList) {
        BCert db;
        Long rId = risk.getId();
        Long cid = risk.getCid();
        BCompany company = null;
        if (cid == null) {
            log.error("\u3010\u533b\u9662\u8bb8\u53ef\u8bc1\u98ce\u9669\u5316\u89e3\u3011\u7f3a\u5c11\u516c\u53f8id\uff0c\u5931\u8d25\uff0crId", (Object)rId);
            return;
        }
        company = (BCompany)this.companyService.getById(risk.getCid());
        if (company == null) {
            riskDefuseDtoList.add(RiskDefuseDto.createSpecialDefuse((Long)rId));
            return;
        }
        if (risk.getBusinessId() != null && (db = (BCert)this.cmCertService.getById(risk.getCid())) == null) {
            riskDefuseDtoList.add(RiskDefuseDto.createSpecialDefuse((Long)rId));
            return;
        }
        db = this.cmCertService.getByCid(risk.getCid());
        if (db == null) {
            return;
        }
        Long certId = db.getId();
        LocalDateTime beginDate = this.cmCertService.getBeginDateForGenRisk(cid);
        LocalDateTime lastVerificationDate = this.cmCertService.getLastVerificationDateForGenRisk(cid);
        Integer pushType = this.licenseManagementSettingService.getPushTypeForSup(company.getAreaId());
        if (pushType == null) {
            log.error("\u3010\u533b\u9662\u8bb8\u53ef\u8bc1\u98ce\u9669\u5316\u89e3\u3011\u3010\u6709\u6570\u636e\u60c5\u51b5\u3011\u63a8\u9001\u6807\u51c6\u83b7\u53d6\u5931\u8d25,cid:{},certId{}", (Object)company.getId(), (Object)certId);
            return;
        }
        Integer cycleYear = RiskGenCompanyCertManager.calculateCycleYear(company);
        if (cycleYear == null) {
            log.error("\u3010\u533b\u9662\u8bb8\u53ef\u8bc1\u98ce\u9669\u5316\u89e3\u3011\u3010\u6709\u6570\u636e\u60c5\u51b5\u3011\u5468\u671f\u6570\u636e\u8ba1\u7b97\u5931\u8d25,cid{},certId{}", (Object)company.getId(), (Object)certId);
            return;
        }
        LocalDateTime expireTime = RiskGenCompanyCertManager.calculateExpireDate(certId, beginDate, lastVerificationDate, company, pushType);
        if (expireTime == null) {
            log.error("\u3010\u533b\u9662\u8bb8\u53ef\u8bc1\u98ce\u9669\u5316\u89e3\u3011\u3010\u6709\u6570\u636e\u60c5\u51b5\u3011\u3010\u8fc7\u671f\u65f6\u95f4\u3011\u8ba1\u7b97\u5931\u8d25cid:{},certId{}", (Object)company.getId(), (Object)certId);
            return;
        }
        Integer warningType = RiskGenCompanyCertManager.calculateHasDataWarningTypeForCompanyCert(LocalDateTime.now(), expireTime, cycleYear);
        if (warningType == null) {
            log.error("\u3010\u533b\u9662\u8bb8\u53ef\u8bc1\u98ce\u9669\u5316\u89e3\u3011\u3010\u9884\u8b66\u7c7b\u578b\u3011\u8ba1\u7b97\u5931\u8d25:{}", (Object)rId);
            return;
        }
        if (warningType.equals(RiskWarningStatusEnum.NONE.getValue())) {
            riskDefuseDtoList.add(RiskDefuseDto.createCommonDefuse((Long)rId));
            return;
        }
    }

    private void defuseList(List<RiskDefuseDto> riskDefuseDtoList) {
        try {
            Map<Integer, List<RiskDefuseDto>> riskDefuseDtoListMap = riskDefuseDtoList.stream().collect(Collectors.groupingBy(RiskDefuseDto::getAcceptanceWay));
            riskDefuseDtoListMap.forEach((acceptanceWay, list) -> {
                if (acceptanceWay.equals(RiskAcceptanceWayEnum.DATA.getValue())) {
                    ResolveRiskForCommonParam defuseParam = new ResolveRiskForCommonParam();
                    defuseParam.setSourceIdList(list.stream().map(v -> v.getRiskId()).collect(Collectors.toList()));
                    defuseParam.setAcceptanceWay(acceptanceWay);
                    this.riskProvider.resolveRiskOfCommon(defuseParam);
                }
                if (acceptanceWay.equals(RiskAcceptanceWayEnum.SPECIAL_FOREVER.getValue())) {
                    Map<String, List<RiskDefuseDto>> measureWayMap = list.stream().collect(Collectors.groupingBy(v -> v.getReformMeasure()));
                    measureWayMap.forEach((measure, specialList) -> {
                        ResolveRiskForCommonParam defuseParam = new ResolveRiskForCommonParam();
                        defuseParam.setSourceIdList(specialList.stream().map(v -> v.getRiskId()).collect(Collectors.toList()));
                        defuseParam.setAcceptanceWay(acceptanceWay);
                        defuseParam.setReformMeasure(measure.equals("NULL") ? null : measure);
                        this.riskProvider.resolveRiskOfCommon(defuseParam);
                    });
                }
            });
        }
        catch (Exception e) {
            log.error("\u3010\u533b\u9662\u8bb8\u53ef\u8bc1\u98ce\u9669\u5316\u89e3\u3011\u4f53\u68c0\u98ce\u9669\u5316\u89e3\u5931\u8d25,e:{}", (Throwable)e);
        }
        finally {
            riskDefuseDtoList.clear();
        }
    }

    @Generated
    public RiskDefuseCompanyCertManager(IBCertService cmCertService, IBCompanyService companyService, RedissonClient redissonClient, IRiskBasicSourceCommonService riskSourceService, IRiskProvider riskProvider, RiskGenCompanyCertManager companyCertManager, IBLicenseManagementSettingService licenseManagementSettingService) {
        this.cmCertService = cmCertService;
        this.companyService = companyService;
        this.redissonClient = redissonClient;
        this.riskSourceService = riskSourceService;
        this.riskProvider = riskProvider;
        this.companyCertManager = companyCertManager;
        this.licenseManagementSettingService = licenseManagementSettingService;
    }
}

