/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.rho.modules.sys.manger.license;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import cn.smarthse.modules.excel.BaseImportDto;
import cn.smarthse.rho.core.framework.ShiroCommonUtil;
import cn.smarthse.rho.modules.sys.entity.b.BCycleLicense;
import cn.smarthse.rho.modules.sys.entity.e.EDevice;
import cn.smarthse.rho.modules.sys.model.easyexcel.CycleLicenseImportDto;
import cn.smarthse.rho.modules.sys.service.b.IBCycleLicenseService;
import cn.smarthse.rho.modules.sys.service.e.IEDeviceCommonService;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.smarthse.framework.exception.ServiceException;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class CycleLicenseImportManager {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CycleLicenseImportManager.class);
    @Autowired
    private IBCycleLicenseService cycleLicenseService;
    @Autowired
    private IEDeviceCommonService deviceService;

    @Transactional
    public void LicenseCycleByImporting(List<CycleLicenseImportDto> importDtoList) {
        ArrayList<CycleLicenseImportDto> canImportDtoList = new ArrayList<CycleLicenseImportDto>();
        ArrayList<BaseImportDto> errorDtoList = new ArrayList<BaseImportDto>();
        this.checkImportInfo(importDtoList, canImportDtoList, errorDtoList);
        for (CycleLicenseImportDto dto : canImportDtoList) {
            EDevice device = this.deviceService.getByFactoryNo(dto.getDeviceNo());
            List<BCycleLicense> cycleLicenseList = this.cycleLicenseService.getForImportLicense(device.getId());
            for (BCycleLicense db : cycleLicenseList) {
                BCycleLicense upEntity = new BCycleLicense();
                upEntity.setId(db.getId());
                upEntity.setAdminLicenseStatus(Integer.valueOf(1));
                upEntity.setAdminLicenseTime(LocalDateTime.now());
                upEntity.setAdminLicenseId(ShiroCommonUtil.getJWTUserId());
                this.cycleLicenseService.updateById(upEntity);
            }
        }
    }

    private void checkImportInfo(List<CycleLicenseImportDto> importDtoList, List<CycleLicenseImportDto> canImportDtoList, List<BaseImportDto> errorDtoList) {
        if (CollUtil.isEmpty(importDtoList)) {
            throw new ServiceException("\u6570\u636e\u4e0d\u53ef\u4e3a\u7a7a");
        }
        StringBuilder sbPre = new StringBuilder();
        Map<String, List<CycleLicenseImportDto>> deviceNoGroup = importDtoList.stream().collect(Collectors.groupingBy(v -> v.getDeviceNo()));
        deviceNoGroup.forEach((deviceNo, list) -> {
            if (list.size() >= 2) {
                sbPre.append("\u8bbe\u5907\u7f16\u53f7").append((String)deviceNo).append("excel\u4e2d\u5b58\u5728\u91cd\u590d\u586b\u5199\u7684\u7f16\u53f7\u3002");
            }
        });
        if (sbPre.length() > 0) {
            throw new ServiceException(sbPre.toString());
        }
        for (CycleLicenseImportDto dto : importDtoList) {
            List<BCycleLicense> cycleLicenseList;
            EDevice device;
            StringBuilder sb = new StringBuilder();
            if (StrUtil.isBlank((CharSequence)dto.getDeviceNo())) {
                sb.append("\u8bbe\u5907\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if ((device = this.deviceService.getByFactoryNo(dto.getDeviceNo())) == null) {
                sb.append("\u8bbe\u5907\u4e0d\u5b58\u5728");
            }
            if (CollUtil.isEmpty(cycleLicenseList = this.cycleLicenseService.getForImportLicense(device.getId()))) {
                sb.append("\u8bbe\u5907\u65e0\u8bb8\u53ef\u6821\u9a8c\u6570\u636e");
            }
            if (sb.length() > 0) {
                dto.setHaveError(Boolean.valueOf(true));
                dto.setErrorReason(sb.toString());
                errorDtoList.add((BaseImportDto)dto);
                continue;
            }
            canImportDtoList.add(dto);
        }
    }
}

