/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.rho.modules.sys.manger.license;

import cn.hutool.core.util.NumberUtil;
import cn.hutool.core.util.StrUtil;
import cn.smarthse.rho.core.framework.ShiroCommonUtil;
import cn.smarthse.rho.core.framework.utils.ChangeLicenseUtil;
import cn.smarthse.rho.modules.sys.entity.b.BChangeLicense;
import cn.smarthse.rho.modules.sys.entity.b.BCompany;
import cn.smarthse.rho.modules.sys.entity.e.EDevice;
import cn.smarthse.rho.modules.sys.entity.e.EMachineRoom;
import cn.smarthse.rho.modules.sys.enums.company.EdeviceLicenseStatusEnum;
import cn.smarthse.rho.modules.sys.enums.license.AdminLicenseStatusEnum;
import cn.smarthse.rho.modules.sys.enums.license.LicenseChangeTypeEnum;
import cn.smarthse.rho.modules.sys.enums.license.LicenseStatusEnum;
import cn.smarthse.rho.modules.sys.manger.license.LicenseLogManager;
import cn.smarthse.rho.modules.sys.model.b.param.license.BChangeLicenseGenParam;
import cn.smarthse.rho.modules.sys.model.b.param.license.ChangeLicenseParam;
import cn.smarthse.rho.modules.sys.model.b.param.license.LicenseChangeParam;
import cn.smarthse.rho.modules.sys.model.b.param.license.LicenseOptLogEditParam;
import cn.smarthse.rho.modules.sys.model.b.vo.license.ChangeLicenseDetailVo;
import cn.smarthse.rho.modules.sys.model.sys.vo.SysAreaVo;
import cn.smarthse.rho.modules.sys.service.b.IBChangeLicenseDeviceRelationService;
import cn.smarthse.rho.modules.sys.service.b.IBChangeLicenseService;
import cn.smarthse.rho.modules.sys.service.b.IBCompanyService;
import cn.smarthse.rho.modules.sys.service.e.IEDeviceCommonService;
import cn.smarthse.rho.modules.sys.service.e.IEMachineRoomCommonService;
import cn.smarthse.rho.modules.sys.service.sys.ISysAreaService;
import cn.smarthse.rho.modules.sys.service.sys.ISysFileService;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.smarthse.framework.exception.ServiceException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
@Transactional(readOnly=true)
public class ChangeLicenseManager {
    @Autowired
    private IBChangeLicenseService changeLicenseService;
    @Autowired
    private ISysAreaService areaService;
    @Autowired
    @Lazy
    private ChangeLicenseManager self;
    @Autowired
    private IBCompanyService companyService;
    @Autowired
    private IEDeviceCommonService deviceService;
    @Autowired
    private IEMachineRoomCommonService machineRoomService;
    @Autowired
    private LicenseLogManager licenseLogManager;
    @Autowired
    private IBChangeLicenseDeviceRelationService licenseDeviceRelationService;
    @Autowired
    private ISysFileService sysFileService;

    @Transactional
    public void applyChange(BChangeLicenseGenParam param) {
        String subType = param.getSubType();
        if (param.getId() != null) {
            BChangeLicense dbLicense = (BChangeLicense)this.changeLicenseService.getById(param.getId());
            subType = dbLicense.getSubType();
            Integer beforeLicenseStatus = dbLicense.getAdminLicenseStatus();
            if (dbLicense == null) {
                throw new ServiceException("\u4e0d\u5b58\u5728\u7684\u53d8\u66f4\u7533\u8bf7");
            }
            if (!Objects.equals(dbLicense.getSubType(), param.getSubType())) {
                throw new ServiceException("\u65e0\u6cd5\u8fdb\u884c\u6b64\u7c7b\u64cd\u4f5c\u7c7b\u578b");
            }
            if ((Objects.equals(param.getAdminLicenseStatus(), LicenseStatusEnum.WAIT_CONFIRM.getStatus()) || Objects.equals(param.getAdminLicenseStatus(), LicenseStatusEnum.TERMINATED.getStatus())) && !Objects.equals(dbLicense.getAdminLicenseStatus(), LicenseStatusEnum.RETURNED.getStatus())) {
                throw new ServiceException("\u5f53\u524d\u72b6\u6001\u65e0\u6cd5\u8fdb\u884c\u6b64\u64cd\u4f5c");
            }
            if (!Objects.equals(param.getAdminLicenseStatus(), LicenseStatusEnum.WAIT_CONFIRM.getStatus()) && !Objects.equals(param.getAdminLicenseStatus(), LicenseStatusEnum.TERMINATED.getStatus())) {
                throw new ServiceException("\u65e0\u6cd5\u63d0\u4ea4\u5f85\u786e\u8ba4\u548c\u7ec8\u6b62\u4ee5\u5916\u7684\u64cd\u4f5c");
            }
            dbLicense.setAdminLicenseStatus(param.getAdminLicenseStatus());
            if (Objects.equals(param.getAdminLicenseStatus(), LicenseStatusEnum.TERMINATED.getStatus())) {
                dbLicense.setIsCur(Integer.valueOf(0));
                this.licenseDeviceRelationService.deleteLicenseChangeRelationByLicenseId(dbLicense.getId());
            } else {
                dbLicense.setIsCur(Integer.valueOf(1));
                dbLicense.setSdFileId(param.getFileId());
            }
            this.changeLicenseService.updateById(dbLicense);
            if (subType.equals(LicenseChangeTypeEnum.CHANGE_THERAPY_DEVICE_PLACE.getSubType()) && !CollectionUtils.isEmpty((Collection)param.getRelationDtoList())) {
                this.licenseDeviceRelationService.updateLicenseChangeRelationForCompany(param.getRelationDtoList(), dbLicense.getId());
            }
            LicenseOptLogEditParam logEditParam = new LicenseOptLogEditParam();
            logEditParam.setLicenseId(dbLicense.getId());
            logEditParam.setType(Integer.valueOf(1));
            logEditParam.setBeforeStatus(beforeLicenseStatus);
            logEditParam.setAfterStatus(dbLicense.getAdminLicenseStatus());
            logEditParam.setReturnReason(null);
            logEditParam.setSdFileId(dbLicense.getSdFileId());
            this.licenseLogManager.addLog(logEditParam);
            return;
        }
        if (subType.equals(LicenseChangeTypeEnum.CHANGE_UNIT_NAME.getSubType()) || subType.equals(LicenseChangeTypeEnum.CHANGE_UNIT_ADDRESS.getSubType()) || subType.equals(LicenseChangeTypeEnum.CHANGE_UNIT_LEGAL.getSubType()) || subType.equals(LicenseChangeTypeEnum.CHANGE_UNIT_LEADER.getSubType())) {
            this.changeLicenseService.applyChange(param);
            return;
        }
        if (CollectionUtils.isEmpty((Collection)param.getDeviceIdList())) {
            return;
        }
        this.handleDeviceApply(param);
    }

    @Transactional
    public void handleDeviceApply(BChangeLicenseGenParam param) {
        String subType = param.getSubType();
        Map<String, Predicate<EDevice>> deviceFilterMap = Map.of(LicenseChangeTypeEnum.CHANGE_THERAPY_DEVICE_ADD.getSubType(), device -> device != null && !Objects.equals(device.getLicenseStatus(), EdeviceLicenseStatusEnum.AUTHORIZED.getValue()), LicenseChangeTypeEnum.CHANGE_THERAPY_DEVICE_SUB.getSubType(), device -> device != null && !Objects.equals(device.getLicenseStatus(), EdeviceLicenseStatusEnum.CANCELED.getValue()), LicenseChangeTypeEnum.CHANGE_THERAPY_DEVICE_PLACE.getSubType(), device -> device != null && Objects.equals(device.getLicenseStatus(), EdeviceLicenseStatusEnum.AUTHORIZED.getValue()));
        Predicate<EDevice> devicePredicate = deviceFilterMap.get(subType);
        if (devicePredicate == null) {
            this.changeLicenseService.applyChange(param);
            return;
        }
        Map<Long, EDevice> deviceMap = this.deviceService.listByIds(param.getDeviceIdList()).stream().collect(Collectors.toMap(EDevice::getId, d -> d));
        List<BChangeLicense> dbLicenses = this.changeLicenseService.listLicenseByTargetIds(param.getDeviceIdList());
        Set curLicenseIds = dbLicenses.stream().filter(l -> l.getIsCur() == 1).map(BChangeLicense::getTargetId).collect(Collectors.toSet());
        List addList = param.getDeviceIdList().stream().map(deviceMap::get).filter(devicePredicate).filter(device -> !curLicenseIds.contains(device.getId())).map(device -> {
            BChangeLicense license = new BChangeLicense();
            license.setId(Long.valueOf(IdWorker.getId()));
            license.setCid(param.getCid());
            license.setTitle("\u3010" + device.getName() + "\u3011" + LicenseChangeTypeEnum.getNameBySubType((String)subType));
            license.setType(LicenseChangeTypeEnum.getTypeBySubType((String)subType));
            license.setSubType(subType);
            license.setTargetId(device.getId());
            license.setGenTime(LocalDateTime.now());
            license.setAdminLicenseStatus(LicenseStatusEnum.WAIT_CONFIRM.getStatus());
            license.setIsCur(Integer.valueOf(1));
            return license;
        }).collect(Collectors.toList());
        if (!addList.isEmpty()) {
            this.changeLicenseService.saveBatch(addList);
            if (Objects.equals(LicenseChangeTypeEnum.CHANGE_THERAPY_DEVICE_PLACE.getSubType(), subType) && param.getDeviceIdList().size() == 1 && !CollectionUtils.isEmpty((Collection)param.getRelationDtoList()) && !addList.isEmpty()) {
                this.licenseDeviceRelationService.addLicenseChangeRelationForCompany(param.getRelationDtoList(), ((BChangeLicense)addList.get(0)).getId());
            }
        }
    }

    @Transactional
    public void licenseChangeBatchForSup(LicenseChangeParam param) {
        if (CollectionUtils.isEmpty((Collection)param.getLicenseIdList())) {
            return;
        }
        for (Long licenseId : param.getLicenseIdList()) {
            LicenseOptLogEditParam logEditParam;
            if (licenseId == null || param.getLicenseResult() == null) {
                throw new ServiceException("\u53c2\u6570\u4e0d\u6b63\u786e");
            }
            if (param.getLicenseResult() != 1 && param.getLicenseResult() != 2) {
                throw new ServiceException("\u7ed3\u679c\u53c2\u6570\u4e0d\u6b63\u786e");
            }
            BChangeLicense dbLicense = (BChangeLicense)this.changeLicenseService.getById(licenseId);
            if (dbLicense == null) {
                throw new ServiceException("\u8bb8\u53ef\u6570\u636e\u4e0d\u5b58\u5728");
            }
            String subType = dbLicense.getSubType();
            Integer beforeLicenseStatus = dbLicense.getAdminLicenseStatus();
            Integer licenseResult = param.getLicenseResult();
            if (licenseResult == 1) {
                LambdaUpdateWrapper updateWrapper;
                dbLicense.setAdminLicenseStatus(LicenseStatusEnum.CONFIRMED.getStatus());
                dbLicense.setAdminLicenseId(param.getUserId());
                dbLicense.setAdminLicenseTime(LocalDateTime.now());
                dbLicense.setIsCur(Integer.valueOf(0));
                this.changeLicenseService.updateById(dbLicense);
                logEditParam = new LicenseOptLogEditParam();
                logEditParam.setLicenseId(dbLicense.getId());
                logEditParam.setType(Integer.valueOf(2));
                logEditParam.setBeforeStatus(beforeLicenseStatus);
                logEditParam.setAfterStatus(dbLicense.getAdminLicenseStatus());
                logEditParam.setReturnReason(null);
                logEditParam.setSdFileId(dbLicense.getSdFileId());
                this.licenseLogManager.addLog(logEditParam);
                if (subType.equals(LicenseChangeTypeEnum.CHANGE_THERAPY_DEVICE_ADD.getSubType())) {
                    updateWrapper = new LambdaUpdateWrapper();
                    ((LambdaUpdateWrapper)updateWrapper.eq(EDevice::getId, (Object)dbLicense.getTargetId())).set(EDevice::getLicenseStatus, (Object)EdeviceLicenseStatusEnum.AUTHORIZED.getValue());
                    this.deviceService.update((Wrapper)updateWrapper);
                    continue;
                }
                if (subType.equals(LicenseChangeTypeEnum.CHANGE_THERAPY_DEVICE_SUB.getSubType())) {
                    updateWrapper = new LambdaUpdateWrapper();
                    ((LambdaUpdateWrapper)updateWrapper.eq(EDevice::getId, (Object)dbLicense.getTargetId())).set(EDevice::getLicenseStatus, (Object)EdeviceLicenseStatusEnum.CANCELED.getValue());
                    this.deviceService.update((Wrapper)updateWrapper);
                    continue;
                }
                if (!subType.equals(LicenseChangeTypeEnum.CHANGE_THERAPY_DEVICE_PLACE.getSubType())) continue;
                this.deviceService.updateERelationBySupConfirm(dbLicense.getTargetId(), this.licenseDeviceRelationService.listRelationByLicenseId(dbLicense.getId()));
                continue;
            }
            if (licenseResult != 2) continue;
            dbLicense.setAdminLicenseStatus(LicenseStatusEnum.RETURNED.getStatus());
            dbLicense.setAdminLicenseId(param.getUserId());
            dbLicense.setAdminLicenseTime(LocalDateTime.now());
            dbLicense.setIsCur(Integer.valueOf(1));
            this.changeLicenseService.updateById(dbLicense);
            logEditParam = new LicenseOptLogEditParam();
            logEditParam.setLicenseId(dbLicense.getId());
            logEditParam.setType(Integer.valueOf(0));
            logEditParam.setBeforeStatus(beforeLicenseStatus);
            logEditParam.setAfterStatus(dbLicense.getAdminLicenseStatus());
            logEditParam.setReturnReason(param.getReturnReason());
            logEditParam.setSdFileId(dbLicense.getSdFileId());
            this.licenseLogManager.addLog(logEditParam);
        }
    }

    @Transactional
    public void licenseChange(LicenseChangeParam param) {
        if (param.getLicenseId() == null || param.getLicenseResult() == null) {
            throw new ServiceException("\u53c2\u6570\u4e0d\u6b63\u786e");
        }
        if (param.getLicenseResult() != 0 && param.getLicenseResult() != 1) {
            throw new ServiceException("\u53c2\u6570\u4e0d\u6b63\u786e");
        }
        BChangeLicense db = (BChangeLicense)this.changeLicenseService.getById(param.getLicenseId());
        if (db == null) {
            throw new ServiceException("\u6570\u636e\u4e0d\u5b58\u5728");
        }
        if (db.getNeedLicense() == 0) {
            throw new ServiceException("\u65e0\u9700\u8bb8\u53ef");
        }
        BCompany company = (BCompany)this.companyService.getById(db.getTargetId());
        if (company == null) {
            throw new ServiceException("\u9662\u533a\u4e0d\u5b58\u5728");
        }
        String subType = db.getSubType();
        Integer licenseResult = param.getLicenseResult();
        if (!db.getAdminLicenseStatus().equals(AdminLicenseStatusEnum.NOT_PERMITTED.getStatus())) {
            return;
        }
        if (licenseResult == 1) {
            if (subType.equals(LicenseChangeTypeEnum.CHANGE_UNIT_NAME.getSubType())) {
                this.self.licenseChangeForUnitName(param);
            } else if (subType.equals(LicenseChangeTypeEnum.CHANGE_UNIT_ADDRESS.getSubType())) {
                this.self.licenseChangeForUnitAddress(param);
            } else if (subType.equals(LicenseChangeTypeEnum.CHANGE_UNIT_LEGAL.getSubType())) {
                this.self.licenseChangeForUnitLegal(param);
            } else if (subType.equals(LicenseChangeTypeEnum.CHANGE_UNIT_LEADER.getSubType())) {
                this.self.licenseChangeForUnitLeader(param);
            } else if (subType.equals(LicenseChangeTypeEnum.CHANGE_THERAPY_DEVICE_ADD.getSubType())) {
                this.self.licenseChangeForDeviceAdd(param);
            } else if (subType.equals(LicenseChangeTypeEnum.CHANGE_THERAPY_DEVICE_SUB.getSubType())) {
                this.self.licenseChangeForDeviceSub(param);
            } else if (subType.equals(LicenseChangeTypeEnum.CHANGE_THERAPY_DEVICE_PLACE.getSubType())) {
                this.self.licenseChangeForDevicePlace(param);
            }
        }
        BChangeLicense upEntity = new BChangeLicense();
        upEntity.setId(db.getId());
        upEntity.setAdminLicenseStatus(param.getLicenseResult() == 0 ? AdminLicenseStatusEnum.NOT_PERMITTED.getStatus() : AdminLicenseStatusEnum.PERMITTED.getStatus());
        upEntity.setAdminLicenseId(ShiroCommonUtil.getJWTUserId());
        upEntity.setAdminLicenseId(ShiroCommonUtil.getJWTUserId());
        this.changeLicenseService.updateById(upEntity);
    }

    public void licenseChangeForUnitName(LicenseChangeParam param) {
        if (param.getLicenseResult() == 0) {
            return;
        }
        BChangeLicense db = (BChangeLicense)this.changeLicenseService.getById(param.getLicenseId());
        if (StrUtil.isBlank((CharSequence)db.getAfterValue())) {
            throw new ServiceException("\u53d8\u66f4\u5355\u4f4d\u540d\u79f0\u4e0d\u5b58\u5728");
        }
        BCompany cmUpEntity = new BCompany();
        cmUpEntity.setId(db.getTargetId());
        cmUpEntity.setName(db.getAfterValue());
        this.companyService.updateById(cmUpEntity);
    }

    public void licenseChangeForUnitAddress(LicenseChangeParam param) {
        Object company = null;
        SysAreaVo area = null;
        BChangeLicense db = null;
        List afterValueList = null;
        if (param.getLicenseResult() == 0) {
            return;
        }
        db = (BChangeLicense)this.changeLicenseService.getById(param.getLicenseId());
        if (StrUtil.isBlank((CharSequence)db.getAfterValue())) {
            throw new ServiceException("\u53d8\u66f4\u5355\u4f4d\u5730\u5740\u4e0d\u5b58\u5728");
        }
        afterValueList = ChangeLicenseUtil.genValueList((String)db.getAfterValue());
        if (afterValueList.size() == 1) {
            throw new ServiceException("\u53d8\u66f4\u5355\u4f4d\u5730\u5740\u4e0d\u5b8c\u6574");
        }
        if (!NumberUtil.isNumber((CharSequence)((CharSequence)afterValueList.get(0)))) {
            throw new ServiceException("\u53d8\u66f4\u5355\u4f4d\u5730\u5740\u683c\u5f0f\u9519\u8bef");
        }
        area = this.areaService.getAreaById(Long.valueOf((String)afterValueList.get(0)));
        if (area == null) {
            throw new ServiceException("\u53d8\u66f4\u5355\u4f4d\u5730\u5740\u4e0d\u5b58\u5728");
        }
        BCompany cmUpEntity = new BCompany();
        cmUpEntity.setId(db.getTargetId());
        cmUpEntity.setAreaId(area.getId());
        cmUpEntity.setAddress((String)afterValueList.get(1));
        this.companyService.updateById(cmUpEntity);
    }

    public void licenseChangeForUnitLegal(LicenseChangeParam param) {
        Object company = null;
        Object area = null;
        BChangeLicense db = null;
        List afterValueList = null;
        if (param.getLicenseResult() == 0) {
            return;
        }
        db = (BChangeLicense)this.changeLicenseService.getById(param.getLicenseId());
        if (StrUtil.isBlank((CharSequence)db.getAfterValue())) {
            throw new ServiceException("\u65e0\u6cd5\u83b7\u53d6\u53d8\u66f4\u540e\u6cd5\u5b9a\u4ee3\u8868\u4eba\u4fe1\u606f");
        }
        afterValueList = ChangeLicenseUtil.genValueList((String)db.getAfterValue());
        if (afterValueList.size() == 1) {
            throw new ServiceException("\u6cd5\u5b9a\u4ee3\u8868\u4eba\u4fe1\u606f\u4e0d\u5b8c\u6574");
        }
        BCompany cmUpEntity = new BCompany();
        cmUpEntity.setId(db.getTargetId());
        cmUpEntity.setLegalName((String)afterValueList.get(0));
        cmUpEntity.setLegalTel((String)afterValueList.get(1));
        this.companyService.updateById(cmUpEntity);
    }

    public void licenseChangeForUnitLeader(LicenseChangeParam param) {
        Object company = null;
        Object area = null;
        BChangeLicense db = null;
        List afterValueList = null;
        if (param.getLicenseResult() == 0) {
            return;
        }
        db = (BChangeLicense)this.changeLicenseService.getById(param.getLicenseId());
        if (StrUtil.isBlank((CharSequence)db.getAfterValue())) {
            throw new ServiceException("\u65e0\u6cd5\u83b7\u53d6\u53d8\u66f4\u540e\u7684\u4e3b\u8981\u8d1f\u8d23\u4eba\u4fe1\u606f");
        }
        afterValueList = ChangeLicenseUtil.genValueList((String)db.getAfterValue());
        if (afterValueList.size() == 1) {
            throw new ServiceException("\u4e3b\u8981\u8d1f\u8d23\u4eba\u4fe1\u606f\u4e0d\u5b8c\u6574");
        }
        BCompany cmUpEntity = new BCompany();
        cmUpEntity.setId(db.getTargetId());
        cmUpEntity.setMainLeaderName((String)afterValueList.get(0));
        cmUpEntity.setMainLeaderTel((String)afterValueList.get(1));
        this.companyService.updateById(cmUpEntity);
    }

    public void licenseChangeForDeviceAdd(LicenseChangeParam param) {
        Object company = null;
        EDevice device = null;
        Object area = null;
        BChangeLicense db = null;
        Object afterValueList = null;
        if (param.getLicenseResult() == 0) {
            return;
        }
        db = (BChangeLicense)this.changeLicenseService.getById(param.getLicenseId());
        device = (EDevice)this.deviceService.getById(db.getTargetId());
        if (device == null) {
            throw new ServiceException("\u8bbe\u5907\u4e0d\u5b58\u5728");
        }
        EDevice deviceUpEntity = new EDevice();
        deviceUpEntity.setId(db.getTargetId());
        this.deviceService.updateById(deviceUpEntity);
    }

    public void licenseChangeForDeviceSub(LicenseChangeParam param) {
        Object company = null;
        EDevice device = null;
        Object area = null;
        BChangeLicense db = null;
        Object afterValueList = null;
        if (param.getLicenseResult() == 0) {
            return;
        }
        db = (BChangeLicense)this.changeLicenseService.getById(param.getLicenseId());
        device = (EDevice)this.deviceService.getById(db.getTargetId());
        if (device == null) {
            throw new ServiceException("\u8bbe\u5907\u4e0d\u5b58\u5728");
        }
        EDevice deviceUpEntity = new EDevice();
        deviceUpEntity.setId(db.getTargetId());
        this.deviceService.updateById(deviceUpEntity);
    }

    public void licenseChangeForDevicePlace(LicenseChangeParam param) {
        Object company = null;
        EDevice device = null;
        EMachineRoom machineRoom = null;
        Object area = null;
        BChangeLicense db = null;
        Object afterValueList = null;
        if (param.getLicenseResult() == 0) {
            return;
        }
        db = (BChangeLicense)this.changeLicenseService.getById(param.getLicenseId());
        device = (EDevice)this.deviceService.getById(db.getTargetId());
        if (device == null) {
            throw new ServiceException("\u8bbe\u5907\u4e0d\u5b58\u5728");
        }
        if (StrUtil.isBlank((CharSequence)db.getAfterValue())) {
            throw new ServiceException("\u53d8\u66f4\u540e\u83b7\u53d6\u573a\u6240\u9519\u8bef");
        }
        if (!NumberUtil.isNumber((CharSequence)db.getAfterValue())) {
            throw new ServiceException("\u65e0\u6cd5\u83b7\u53d6\u573a\u6240\u4fe1\u606f");
        }
        machineRoom = (EMachineRoom)this.machineRoomService.getById(Long.valueOf(db.getAfterValue()));
        if (machineRoom == null) {
            throw new ServiceException("\u573a\u6240\u4e0d\u5b58\u5728");
        }
        EDevice deviceUpEntity = new EDevice();
        deviceUpEntity.setId(db.getTargetId());
        this.deviceService.updateById(deviceUpEntity);
    }

    public ChangeLicenseDetailVo getDetailForSup(ChangeLicenseParam param) {
        BChangeLicense license = (BChangeLicense)this.changeLicenseService.getById((Serializable)((Object)param.getLicenseId()));
        ChangeLicenseDetailVo rst = new ChangeLicenseDetailVo();
        if (LicenseChangeTypeEnum.isAboutDevice((String)license.getSubType()).booleanValue()) {
            rst = this.deviceService.getDeviceDetailForLicense(license.getTargetId());
            rst.setLicenseDeviceRelationList(this.licenseDeviceRelationService.listRelationDtoByLicenseId(license.getId()));
            rst.setId(license.getId());
            rst.setCid(license.getCid());
            rst.setType(license.getType());
            rst.setSubType(license.getSubType());
            rst.setSdFileId(license.getSdFileId());
            rst.setSdFileUrl(this.sysFileService.getUrl(license.getSdFileId()));
            rst.setOptLogList(this.licenseLogManager.getListByLicenseId(license.getId()));
        }
        return rst;
    }
}

