/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.rho.modules.sys.manger.hc;

import cn.hutool.core.util.IdcardUtil;
import cn.smarthse.rho.modules.sys.entity.b.BCompany;
import cn.smarthse.rho.modules.sys.entity.c.CHealthCheckData;
import cn.smarthse.rho.modules.sys.entity.c.CStaffBaseInfo;
import cn.smarthse.rho.modules.sys.enums.health.HealthBodyCheckTypeEnum;
import cn.smarthse.rho.modules.sys.enums.health.HealthCheckResultEnum;
import cn.smarthse.rho.modules.sys.enums.health.HealthCheckSourceEnum;
import cn.smarthse.rho.modules.sys.enums.health.HealthHazardFactorsEnum;
import cn.smarthse.rho.modules.sys.model.c.param.hc.HCRiskSdFileModelAddParam;
import cn.smarthse.rho.modules.sys.model.c.param.hc.HealthInitParam;
import cn.smarthse.rho.modules.sys.service.b.IBCompanyService;
import cn.smarthse.rho.modules.sys.service.c.ICHealthCheckDataService;
import cn.smarthse.rho.modules.sys.service.c.ICHealthCheckService;
import cn.smarthse.rho.modules.sys.service.c.ICStaffBaseInfoService;
import javax.smarthse.framework.exception.ServiceException;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@Transactional(readOnly=true)
public class HcEditRiskModelManager {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(HcEditRiskModelManager.class);
    @Autowired
    private ICStaffBaseInfoService staffBaseInfoService;
    @Autowired
    private ICHealthCheckDataService healthCheckDataService;
    @Autowired
    private ICHealthCheckService healthCheckService;
    @Autowired
    private IBCompanyService companyService;

    @Transactional
    public void addForOtherProvinces(HCRiskSdFileModelAddParam param) {
        Long cid = param.getCid();
        Long staffBaseInfoId = param.getStaffBaseInfoId();
        String bodyCheckType = param.getBodyCheckType();
        String resultCode = param.getResultCode();
        String factorCode = param.getFactorCode();
        String factorName = null;
        BCompany company = (BCompany)this.companyService.getById(param.getCid());
        if (company == null) {
            throw new ServiceException("\u9662\u533a\u4e0d\u5b58\u5728");
        }
        CStaffBaseInfo staffBaseInfo = (CStaffBaseInfo)this.staffBaseInfoService.getById(param.getStaffBaseInfoId());
        if (staffBaseInfo == null) {
            throw new ServiceException("\u4eba\u5458\u57fa\u7840\u4fe1\u606f\u4e0d\u5b58\u5728");
        }
        if (!HealthBodyCheckTypeEnum.containValue((String)bodyCheckType)) {
            throw new ServiceException("\u4f53\u68c0\u7c7b\u578b\u4e0d\u5b58\u5728");
        }
        if (!HealthCheckResultEnum.containValue((String)resultCode)) {
            throw new ServiceException("\u4f53\u68c0\u7ed3\u8bba\u4e0d\u5b58\u5728");
        }
        factorName = HealthHazardFactorsEnum.getName((String)factorCode);
        if (StringUtils.isBlank((CharSequence)factorName)) {
            throw new ServiceException("\u653e\u5c04\u5371\u5bb3\u56e0\u7d20\u4e0d\u5b58\u5728\u4e0d\u5b58\u5728");
        }
        CHealthCheckData addEntity = new CHealthCheckData();
        addEntity.setCid(cid);
        addEntity.setSource(HealthCheckSourceEnum.COMPANY_SD_FILE_RISK_OTHER_PROVINCES.getValue());
        addEntity.setStaffBaseInfoId(staffBaseInfoId);
        addEntity.setBodyCheckType(bodyCheckType);
        addEntity.setTechName(param.getTechName());
        addEntity.setCheckDate(param.getCheckDate());
        addEntity.setResultCode(resultCode);
        addEntity.setRiskFactorCode(factorCode);
        addEntity.setRiskFactorName(factorName);
        addEntity.setAssessment(param.getAssessment());
        String idcard = staffBaseInfo.getIdcard();
        boolean validCard = IdcardUtil.isValidCard((String)idcard);
        Integer sex = validCard ? Integer.valueOf(IdcardUtil.getGenderByIdCard((String)idcard)) : staffBaseInfo.getSex();
        Integer age = validCard ? Integer.valueOf(IdcardUtil.getAgeByIdCard((String)idcard)) : staffBaseInfo.getAge();
        addEntity.setName(staffBaseInfo.getName());
        addEntity.setIdcard(staffBaseInfo.getIdcard());
        addEntity.setSex(sex == null ? null : Boolean.valueOf(sex == 1));
        addEntity.setAge(age == null ? null : age);
        this.healthCheckDataService.save(addEntity);
        HealthInitParam healthInitParam = new HealthInitParam();
        healthInitParam.setHcId(addEntity.getId());
        if (healthInitParam.getHcId() == null) {
            throw new ServiceException("\u521d\u59cb\u5316\u4fe1\u606f\u5931\u8d25");
        }
        this.healthCheckService.initInfoTotal(healthInitParam);
    }
}

