/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.rho.modules.sys.manger.dose;

import cn.smarthse.rho.core.framework.ShiroCommonUtil;
import cn.smarthse.rho.modules.sys.entity.c.CDoseData;
import cn.smarthse.rho.modules.sys.entity.c.CDoseDataAuditLog;
import cn.smarthse.rho.modules.sys.entity.c.CStaffBaseInfo;
import cn.smarthse.rho.modules.sys.enums.dose.DoseAuditLogOptTypeEnum;
import cn.smarthse.rho.modules.sys.enums.dose.DoseAuditStatusEnum;
import cn.smarthse.rho.modules.sys.enums.dose.DoseSourceEnum;
import cn.smarthse.rho.modules.sys.model.c.param.dose.DoseAuditParam;
import cn.smarthse.rho.modules.sys.model.c.param.dose.DoseEditParam;
import cn.smarthse.rho.modules.sys.service.c.ICDoseDataAuditLogService;
import cn.smarthse.rho.modules.sys.service.c.ICDoseDataService;
import cn.smarthse.rho.modules.sys.service.c.ICStaffBaseInfoService;
import java.time.LocalDateTime;
import javax.smarthse.framework.exception.ServiceException;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@Transactional
public class DoseSdDataManager {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DoseSdDataManager.class);
    @Autowired
    private ICStaffBaseInfoService staffBaseInfoService;
    @Autowired
    private ICDoseDataService doseDataService;
    @Autowired
    private ICDoseDataAuditLogService doseDataAuditLogService;

    @Transactional
    public void addDose(DoseEditParam param) {
        if (ShiroCommonUtil.getJWTUserId() == null) {
            throw new ServiceException("\u767b\u5f55\u4fe1\u606f\u6821\u9a8c\u5931\u8d25\uff0c\u65e0\u6cd5\u6dfb\u52a0");
        }
        if (param.getId() != null) {
            throw new ServiceException("\u975e\u6cd5\u8bf7\u6c42");
        }
        if (param.getCid() == null) {
            throw new ServiceException("\u9662\u533a\u4fe1\u606f\u6821\u9a8c\u4e0d\u901a\u8fc7");
        }
        if (param.getStaffBaseInfoId() == null) {
            throw new ServiceException("\u8bf7\u9009\u62e9\u4eba\u5458");
        }
        CDoseData db = this.doseDataService.getSdDataForAdding(param.getStaffBaseInfoId());
        if (db != null) {
            throw new ServiceException("\u4f50\u8bc1\u6750\u6599\u5df2\u7ecf\u5b58\u5728\uff0c\u4e0d\u53ef\u91cd\u590d\u6dfb\u52a0");
        }
        CStaffBaseInfo staffBaseInfo = (CStaffBaseInfo)this.staffBaseInfoService.getById(param.getStaffBaseInfoId());
        if (staffBaseInfo == null) {
            throw new ServiceException("\u6570\u636e\u6821\u9a8c\u4e0d\u901a\u8fc7");
        }
        CDoseData addEntity = new CDoseData();
        addEntity.setSource(DoseSourceEnum.COMPANY_SD_FILE_RAY_CERT.getValue());
        addEntity.setAuditStatus(DoseAuditStatusEnum.PENDING_REVIEW.getValue());
        addEntity.setCid(param.getCid());
        addEntity.setStaffBaseInfoId(param.getStaffBaseInfoId());
        addEntity.setName(staffBaseInfo.getName());
        addEntity.setIdcardType(staffBaseInfo.getIdcardType());
        addEntity.setIdcard(staffBaseInfo.getIdcard());
        addEntity.setTechName(param.getTechName());
        addEntity.setBeginDate(param.getBeginDate());
        addEntity.setEndDate(param.getEndDate());
        addEntity.setResult(param.getResult());
        addEntity.setIsSdFile(Integer.valueOf(1));
        addEntity.setSdFileId(param.getSdFileId());
        this.doseDataService.save(addEntity);
        CDoseDataAuditLog doseLog = new CDoseDataAuditLog();
        doseLog.setOptType(DoseAuditLogOptTypeEnum.SUBMIT.getValue());
        doseLog.setDoseDataId(addEntity.getId());
        doseLog.setReturnReason(null);
        doseLog.setOptTime(LocalDateTime.now());
        doseLog.setOptUserId(ShiroCommonUtil.getJWTUserId());
        doseLog.setOptUserName(ShiroCommonUtil.getJWTUsername());
        this.doseDataAuditLogService.save(doseLog);
    }

    @Transactional
    public void editDoseByOldData(DoseEditParam param) {
        if (ShiroCommonUtil.getJWTUserId() == null) {
            throw new ServiceException("\u767b\u5f55\u4fe1\u606f\u6821\u9a8c\u5931\u8d25\uff0c\u65e0\u6cd5\u7f16\u8f91");
        }
        if (param.getId() == null) {
            throw new ServiceException("\u975e\u6cd5\u8bf7\u6c42");
        }
        CDoseData db = (CDoseData)this.doseDataService.getById(param.getId());
        if (db.getIsSdFile() == 0) {
            throw new ServiceException("\u65e0\u6cd5\u4fee\u6539\u975e\u4f50\u8bc1\u6750\u6599\u6570\u636e");
        }
        CDoseData upEntity = new CDoseData();
        upEntity.setId(param.getId());
        upEntity.setAuditStatus(param.getAuditStatus());
        upEntity.setTechName(param.getTechName());
        upEntity.setBeginDate(param.getBeginDate());
        upEntity.setEndDate(param.getEndDate());
        upEntity.setResult(param.getResult());
        upEntity.setSdFileId(param.getSdFileId());
        this.doseDataService.updateById(upEntity);
    }

    @Transactional
    public void audit(DoseAuditParam param) {
        if (ShiroCommonUtil.getJWTUserId() == null) {
            throw new ServiceException("\u767b\u5f55\u4fe1\u606f\u6821\u9a8c\u5931\u8d25\uff0c\u65e0\u6cd5\u5ba1\u6838");
        }
        if (param.getId() == null) {
            throw new ServiceException("\u975e\u6cd5\u8bf7\u6c42");
        }
        CDoseData db = (CDoseData)this.doseDataService.getById(param.getId());
        if (db.getIsSdFile() == 0) {
            throw new ServiceException("\u65e0\u6cd5\u5ba1\u6838\u975e\u4f50\u8bc1\u6750\u6599\u6570\u636e");
        }
        CDoseData upEntity = new CDoseData();
        upEntity.setId(param.getId());
        upEntity.setAuditStatus(param.getAuditStatus());
        upEntity.setReturnReason(param.getReturnReason());
        this.doseDataService.updateById(upEntity);
        Integer valueByAuditStatus = DoseAuditLogOptTypeEnum.getValueByAuditStatus((Integer)param.getAuditStatus());
        if (valueByAuditStatus == null) {
            throw new ServiceException("\u6570\u636e\u6821\u9a8c\u5931\u8d25");
        }
        CDoseDataAuditLog doseLog = new CDoseDataAuditLog();
        doseLog.setOptType(valueByAuditStatus);
        doseLog.setDoseDataId(db.getId());
        doseLog.setReturnReason(param.getReturnReason());
        doseLog.setOptTime(LocalDateTime.now());
        doseLog.setOptUserId(ShiroCommonUtil.getJWTUserId());
        doseLog.setOptUserName(ShiroCommonUtil.getJWTUsername());
        this.doseDataAuditLogService.save(doseLog);
    }

    @Generated
    public DoseSdDataManager() {
    }
}

