/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.rho.modules.sys.manger.company;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import cn.smarthse.framework.core.domain.ResponseStateEnum;
import cn.smarthse.modules.datacentre.enums.CompanyBelongTypeEnum;
import cn.smarthse.modules.datacentre.provider.system.ISysAreaProvideService;
import cn.smarthse.modules.health.supervise.entity.basic.Organization;
import cn.smarthse.modules.health.supervise.service.basic.IOrganizationService;
import cn.smarthse.rho.core.framework.ShiroCommonUtil;
import cn.smarthse.rho.core.framework.model.IdsParam;
import cn.smarthse.rho.modules.sys.entity.b.BCompany;
import cn.smarthse.rho.modules.sys.entity.sys.SysArea;
import cn.smarthse.rho.modules.sys.enums.company.BusinessStatusEnum;
import cn.smarthse.rho.modules.sys.enums.staff.CmSourceEnum;
import cn.smarthse.rho.modules.sys.model.b.param.BCompanyAddressEditParam;
import cn.smarthse.rho.modules.sys.model.easyexcel.CompanyImportDto;
import cn.smarthse.rho.modules.sys.model.sys.param.SysAreaParam;
import cn.smarthse.rho.modules.sys.service.b.IBCompanyAddressService;
import cn.smarthse.rho.modules.sys.service.b.IBCompanyErrorService;
import cn.smarthse.rho.modules.sys.service.b.IBCompanyPushService;
import cn.smarthse.rho.modules.sys.service.b.IBCompanyService;
import cn.smarthse.rho.modules.sys.service.sys.ISysAreaService;
import cn.smarthse.rho.modules.sys.service.sys.ISysUserService;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.smarthse.framework.exception.ServiceException;
import lombok.Generated;
import org.apache.dubbo.config.annotation.DubboReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@Transactional(readOnly=true)
public class CompanyImportManager {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CompanyImportManager.class);
    @Autowired
    private IBCompanyService companyService;
    @Autowired
    private ISysAreaService sysAreaService;
    @Autowired
    private ISysUserService sysUserService;
    @Autowired
    private IBCompanyAddressService companyAddressService;
    @Autowired
    private IBCompanyPushService companyPushService;
    @Autowired
    private IBCompanyErrorService companyErrorService;
    @DubboReference(registry={"public_nacos"})
    private IOrganizationService organizationService;
    @DubboReference(registry={"public_nacos"}, version="1.0.0")
    private ISysAreaProvideService sysAreaProvideService;

    @Transactional
    public void importCompany(List<CompanyImportDto> paramList) {
        this.checkImportInfo(paramList);
        this.importOrUpInfo(paramList);
    }

    private void checkImportInfo(List<CompanyImportDto> paramList) {
        StringBuilder sbPre = new StringBuilder();
        ArrayList<CompanyImportDto> errorInfoList = new ArrayList<CompanyImportDto>();
        Map<String, List<CompanyImportDto>> mncMap = paramList.stream().filter(v -> StrUtil.isNotEmpty((CharSequence)v.getMedicalNucode())).collect(Collectors.groupingBy(v -> v.getMedicalNucode()));
        Map<String, List<CompanyImportDto>> nameMap = paramList.stream().filter(v -> StrUtil.isNotEmpty((CharSequence)v.getName())).collect(Collectors.groupingBy(v -> v.getName()));
        mncMap.forEach((k, list) -> {
            if (list.size() >= 2) {
                sbPre.append("excel\u4e2d\u5b58\u5728\u91cd\u590d\u552f\u4e00\u6807\u8bc6\u7801:").append((String)k).append("\u3002");
            }
        });
        nameMap.forEach((k, list) -> {
            if (list.size() >= 2) {
                sbPre.append("excel\u4e2d\u5b58\u5728\u91cd\u590d\u540d\u79f0:").append((String)k).append("\u3002");
            }
        });
        if (sbPre.length() > 0) {
            throw new ServiceException(sbPre.toString());
        }
        for (CompanyImportDto dto : paramList) {
            BCompany byMedicalNucodeIncludeDel;
            StringBuilder sb = new StringBuilder();
            if (StrUtil.isBlank((CharSequence)dto.getHospitalName())) {
                sb.append("\u533b\u9662\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StrUtil.isBlank((CharSequence)dto.getCreditCode())) {
                sb.append("\u7edf\u4e00\u793e\u4f1a\u4fe1\u7528\u4ee3\u7801\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StrUtil.isBlank((CharSequence)dto.getMedicalNucode())) {
                // empty if block
            }
            BCompany company = this.companyService.getByMedicalNucode(dto.getMedicalNucode());
            if (StrUtil.isNotBlank((CharSequence)dto.getCreditCode()) && company != null && !dto.getCreditCode().equals(company.getCreditCode())) {
                sb.append("\u552f\u4e00\u7801\u5df2\u5b58\u5728\uff0c\u4f46\u7edf\u4e00\u793e\u4f1a\u4fe1\u7528\u4ee3\u7801\u4e0e\u552f\u4e00\u7801\u4e0d\u5339\u914d");
            }
            if (StrUtil.isNotBlank((CharSequence)dto.getName()) && company != null && !dto.getName().equals(company.getName())) {
                sb.append("\u552f\u4e00\u7801\u5df2\u5b58\u5728\uff0c\u4f46\u9662\u533a\u540d\u79f0\u4e0e\u552f\u4e00\u7801\u4e0d\u5339\u914d");
            }
            if (StrUtil.isBlank((CharSequence)dto.getName())) {
                sb.append("\u9662\u533a\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
            } else {
                BCompany byName = this.companyService.getByName(dto.getName());
                if (byName != null) {
                    if (!StrUtil.equals((CharSequence)byName.getCreditCode(), (CharSequence)dto.getCreditCode())) {
                        sb.append("\u540d\u79f0\u5df2\u7ecf\u5b58\u5728\uff0c\u4f46\u9662\u533a\u540d\u79f0\u4e0e\u7edf\u4e00\u7801\u4e0d\u5339\u914d");
                    }
                    if (!StrUtil.equals((CharSequence)byName.getMedicalNucode(), (CharSequence)dto.getMedicalNucode())) {
                        sb.append("\u540d\u79f0\u5df2\u7ecf\u5b58\u5728\uff0c\u4f46\u9662\u533a\u540d\u79f0\u4e0e\u552f\u4e00\u7801\u4e0d\u5339\u914d");
                    }
                }
            }
            if (StrUtil.isNotBlank((CharSequence)dto.getName()) && StrUtil.isNotBlank((CharSequence)dto.getMedicalNucode()) && (byMedicalNucodeIncludeDel = this.companyService.getByMedicalNucodeIncludeDel(dto.getMedicalNucode())) != null && !dto.getName().equals(byMedicalNucodeIncludeDel.getName())) {
                sb.append("\u5168\u56fd\u552f\u4e00\u6807\u8bc6\u7801\u5df2\u7ecf\u88ab\u5176\u4ed6\u9662\u533a\u7ed1\u5b9a");
            }
            if (StrUtil.isBlank((CharSequence)dto.getIsTestRun())) {
                sb.append("\u662f\u5426\u4f5c\u4e3a\u8bd5\u8fd0\u884c\u653e\u5c04\u8bca\u7597\u673a\u6784\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StrUtil.isBlank((CharSequence)dto.getArea())) {
                sb.append("\u884c\u653f\u533a\u5212\u4e0d\u80fd\u4e3a\u7a7a");
            } else if (!dto.getArea().contains(">") && !dto.getArea().contains("\uff1e")) {
                sb.append("\u884c\u653f\u533a\u5212\u5206\u9694\u7b26\u9519\u8bef");
            } else {
                SysArea area = this.getSysArea(dto.getArea());
                if (area == null) {
                    sb.append("\u884c\u653f\u533a\u5212\u4e0d\u5b58\u5728");
                } else {
                    Integer belongType = StrUtil.isNotBlank((CharSequence)dto.getIsBelongCityLevel()) && "\u662f".equals(dto.getIsBelongCityLevel()) ? 2 : 0;
                    Long areaId = Objects.equals(belongType, CompanyBelongTypeEnum.SHI.getValue()) ? area.getCityId() : (Objects.equals(belongType, CompanyBelongTypeEnum.SHENG.getValue()) ? area.getProvinceId() : area.getAreaId());
                    Organization org = this.organizationService.getOrganizationByAreaId(areaId);
                    if (org == null) {
                        sb.append("\u65e0\u6cd5\u67e5\u8be2\u5230\u76d1\u7ba1\u5355\u4f4d");
                    }
                }
            }
            if (StrUtil.isBlank((CharSequence)dto.getRegisterArea())) {
                sb.append("\u6ce8\u518c\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a");
            } else if (!(dto.getRegisterArea().contains(">") || dto.getRegisterArea().contains("\uff1e") || dto.getRegisterArea().equals("\u6d59\u6c5f\u7701"))) {
                sb.append("\u6ce8\u518c\u5730\u5740\u5206\u9694\u7b26\u9519\u8bef");
            } else {
                SysArea registerArea = this.getSysArea(dto.getRegisterArea());
                if (registerArea == null) {
                    sb.append("\u6ce8\u518c\u5730\u5740\u4e0d\u5b58\u5728");
                }
            }
            if (sb.length() <= 0) continue;
            dto.setHaveError(Boolean.valueOf(true));
            dto.setErrorReason(sb.toString());
            errorInfoList.add(dto);
        }
        if (errorInfoList.size() > 0) {
            throw new ServiceException(ResponseStateEnum.fail_deal.getValue(), "\u5bfc\u5165\u5931\u8d25\uff0c\u8bf7\u6839\u636e\u9519\u8bef\u4fe1\u606f\u4fee\u6539\u540e\u91cd\u65b0\u5bfc\u5165", errorInfoList);
        }
    }

    private SysArea getSysArea(String areaStr) {
        String separator = StrUtil.contains((CharSequence)areaStr, (CharSequence)"\uff1e") ? "\uff1e" : ">";
        List areaArray = StrUtil.split((CharSequence)areaStr, (CharSequence)separator);
        if ((areaArray = areaArray.stream().filter(v -> StrUtil.isNotBlank((CharSequence)v)).collect(Collectors.toList())).size() == 0 || areaArray.size() > 4) {
            return null;
        }
        int level = areaArray.size();
        SysAreaParam areaParam = new SysAreaParam();
        if (level >= 1) {
            areaParam.setProvinceName((String)areaArray.get(0));
        }
        if (level >= 2) {
            areaParam.setCityName((String)areaArray.get(1));
        }
        if (level >= 3) {
            areaParam.setAreaName((String)areaArray.get(2));
        }
        if (level >= 4) {
            areaParam.setStreetName((String)areaArray.get(3));
        }
        areaParam.setLevel(Integer.valueOf(level));
        SysArea area = this.sysAreaService.getByNameAndLevel(areaParam);
        return area;
    }

    @Transactional
    public void importOrUpInfo(List<CompanyImportDto> paramList) {
        ArrayList<BCompany> entityList = new ArrayList<BCompany>();
        for (CompanyImportDto dto : paramList) {
            BCompany entity = this.dto2Entity(dto);
            if (entity == null) continue;
            entityList.add(entity);
        }
        if (CollUtil.isEmpty(entityList)) {
            return;
        }
        for (List entitySubList : CollUtil.split(entityList, (int)500)) {
            this.companyService.saveBatch(entitySubList);
            ArrayList<BCompanyAddressEditParam> addressEditParamList = new ArrayList<BCompanyAddressEditParam>();
            for (BCompany company : entitySubList) {
                BCompanyAddressEditParam addressEditParam = new BCompanyAddressEditParam();
                addressEditParam.setCid(company.getId());
                addressEditParam.setAreaId(company.getAreaId());
                addressEditParam.setAddress(company.getAddress());
                addressEditParam.setName("\u6267\u4e1a\u5730\u57401");
                addressEditParamList.add(addressEditParam);
            }
            this.companyAddressService.saveBatch(addressEditParamList);
            List<Long> cidList = entitySubList.stream().map(v -> v.getId()).collect(Collectors.toList());
            if (CollUtil.isNotEmpty(cidList)) {
                IdsParam idsParam = new IdsParam();
                idsParam.setIdList(cidList);
                this.sysUserService.addUserByCidListForSup(idsParam);
            }
            this.companyPushService.pushCompanyInfo(entitySubList);
            this.companyErrorService.manualMaintenanceList(cidList);
        }
    }

    private BCompany dto2Entity(CompanyImportDto dto) {
        BCompany company = null;
        if (StrUtil.isNotBlank((CharSequence)dto.getMedicalNucode())) {
            company = this.companyService.getByMedicalNucodeIncludeDel(dto.getMedicalNucode());
        } else if (StrUtil.isNotBlank((CharSequence)dto.getName())) {
            company = this.companyService.getNewestByNameIncludeDel(dto.getName());
        } else {
            throw new ServiceException("\u5bfc\u5165\u7684\u6570\u636e\u5b58\u5728\u5f02\u5e38");
        }
        SysArea area = this.getSysArea(dto.getArea());
        SysArea registerArea = this.getSysArea(dto.getRegisterArea());
        BCompany result = new BCompany();
        if (company != null) {
            return null;
        }
        LocalDateTime now = LocalDateTime.now();
        result.setSourceId(dto.getWandaSourceId());
        result.setMedicalNucode(dto.getMedicalNucode());
        result.setHospitalName(dto.getHospitalName());
        result.setName(dto.getName());
        result.setCreditCode(dto.getCreditCode());
        result.setBusinessStatus(BusinessStatusEnum.NORMAL.getValue());
        result.setState(Integer.valueOf(1));
        result.setSource(CmSourceEnum.RHO_IMPORT.getValue());
        result.setEntryTime(now);
        result.setSyncTime(now);
        result.setAreaId(area.getId());
        result.setRegisteredAreaId(registerArea.getId());
        result.setLegalName(dto.getLegalName());
        result.setBelongType(Integer.valueOf(StrUtil.isNotBlank((CharSequence)dto.getIsBelongCityLevel()) && "\u662f".equals(dto.getIsBelongCityLevel()) ? 2 : 0));
        result.setNeedAddAccount(Integer.valueOf("\u662f".equals(dto.getIsTestRun()) ? 1 : 0));
        result.setCreateBy(ShiroCommonUtil.getJWTUserId());
        if (result.getId() == null) {
            result.setOutId(IdWorker.get32UUID());
        }
        try {
            if (Objects.isNull(area)) {
                throw new ServiceException("\u8be5\u533a\u57df\u4e0d\u5b58\u5728");
            }
            Long areaId = Objects.equals(result.getBelongType(), CompanyBelongTypeEnum.SHI.getValue()) ? area.getCityId() : (Objects.equals(result.getBelongType(), CompanyBelongTypeEnum.SHENG.getValue()) ? area.getProvinceId() : area.getAreaId());
            Organization org = this.organizationService.getOrganizationByAreaId(areaId);
            if (org == null) {
                throw new ServiceException("\u65e0\u6cd5\u67e5\u8be2\u5230\u76d1\u7ba1\u5355\u4f4d");
            }
            result.setSupervisionUnit(org.getId());
            result.setSupervisionAreaId(org.getAreaId());
        }
        catch (Exception e) {
            log.error("\u8fdc\u7a0b\u83b7\u53d6\u76d1\u7ba1\u5355\u4f4d\u5931\u8d25{}\uff1a{}", (Object)result.getAreaId(), (Object)e);
        }
        return result;
    }
}

