/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.rho.modules.sys.manger.company;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import cn.smarthse.framework.sensitive.utils.DesensitizationUtils;
import cn.smarthse.modules.datacentre.enums.CompanyBelongTypeEnum;
import cn.smarthse.modules.datacentre.provider.system.ISysAreaProvideService;
import cn.smarthse.modules.health.supervise.entity.basic.Organization;
import cn.smarthse.modules.health.supervise.service.basic.IOrganizationService;
import cn.smarthse.modules.platform.model.v3.sysArea.SysAreaV3OneVo;
import cn.smarthse.rho.core.framework.model.IdsParam;
import cn.smarthse.rho.modules.sys.converter.b.BcompanyConverter;
import cn.smarthse.rho.modules.sys.entity.b.BCompany;
import cn.smarthse.rho.modules.sys.enums.company.BusinessStatusEnum;
import cn.smarthse.rho.modules.sys.enums.staff.CmSourceEnum;
import cn.smarthse.rho.modules.sys.enums.staff.StaffSourceEnum;
import cn.smarthse.rho.modules.sys.manger.staff.StaffEditManager;
import cn.smarthse.rho.modules.sys.model.b.param.BCompanyAddressEditParam;
import cn.smarthse.rho.modules.sys.model.b.param.BCompanyAdminEditParam;
import cn.smarthse.rho.modules.sys.model.b.param.BCompanyEditParam;
import cn.smarthse.rho.modules.sys.model.c.param.CStaffBaseInfoEditParam;
import cn.smarthse.rho.modules.sys.model.c.param.CStaffEditParam;
import cn.smarthse.rho.modules.sys.service.b.IBCompanyAddressService;
import cn.smarthse.rho.modules.sys.service.b.IBCompanyErrorService;
import cn.smarthse.rho.modules.sys.service.b.IBCompanyPushService;
import cn.smarthse.rho.modules.sys.service.b.IBCompanyService;
import cn.smarthse.rho.modules.sys.service.sys.ISysUserService;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javax.smarthse.framework.exception.ServiceException;
import lombok.Generated;
import org.apache.dubbo.config.annotation.DubboReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@Transactional(readOnly=true)
public class CompanyEditManager {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CompanyEditManager.class);
    @Autowired
    private IBCompanyService companyService;
    @Autowired
    private ISysUserService sysUserService;
    @Autowired
    private IBCompanyPushService companyPushService;
    @Autowired
    private BcompanyConverter bCompanyConverter;
    @Autowired
    private StaffEditManager staffEditManager;
    @Autowired
    private IBCompanyErrorService companyErrorService;
    @Autowired
    private IBCompanyAddressService companyAddressService;
    @DubboReference(registry={"public_nacos"}, version="1.0.0")
    private ISysAreaProvideService sysAreaProvideService;
    @DubboReference(registry={"public_nacos"})
    private IOrganizationService organizationService;

    @Transactional
    public void addInfo(BCompanyAdminEditParam param) {
        SysAreaV3OneVo area;
        this.trim(param);
        String name = param.getName();
        String creditCode = param.getCreditCode();
        String medicalNucode = param.getMedicalNucode();
        if (StrUtil.isBlank((CharSequence)name)) {
            throw new ServiceException("\u8bf7\u586b\u5199\u533b\u9662\u540d\u79f0");
        }
        if (StrUtil.isBlank((CharSequence)creditCode)) {
            throw new ServiceException("\u8bf7\u586b\u5199\u7edf\u4e00\u793e\u4f1a\u4fe1\u7528\u4ee3\u7801");
        }
        if (StrUtil.isBlank((CharSequence)medicalNucode)) {
            throw new ServiceException("\u8bf7\u586b\u5199\u552f\u4e00\u6807\u8bc6\u7801");
        }
        BCompany byName = this.companyService.getByName(name);
        if (byName != null) {
            throw new ServiceException("\u9644\u5c5e\u5bf9\u8c61\uff08\u9662\u533a\uff09\u540d\u79f0\u5df2\u5b58\u5728");
        }
        if (this.companyService.isHaveThisMedicalNucode(param.getMedicalNucode(), null).booleanValue()) {
            throw new ServiceException("\u8be5\u5168\u56fd\u552f\u4e00\u6807\u8bc6\u7801\u5df2\u5b58\u5728\uff01");
        }
        if (CollUtil.isNotEmpty((Collection)param.getAddressEditParamList())) {
            param.setAreaId(((BCompanyAddressEditParam)param.getAddressEditParamList().get(0)).getAreaId());
        }
        if (Objects.isNull(area = this.sysAreaProvideService.getAreaByIdV3(param.getAreaId()))) {
            throw new ServiceException("\u8be5\u533a\u57df\u4e0d\u5b58\u5728");
        }
        Long areaId = Objects.equals(param.getBelongType(), CompanyBelongTypeEnum.SHI.getValue()) ? area.getCityId() : (Objects.equals(param.getBelongType(), CompanyBelongTypeEnum.SHENG.getValue()) ? area.getProvinceId() : area.getAreaId());
        Organization org = this.organizationService.getOrganizationByAreaId(areaId);
        if (org == null) {
            throw new ServiceException("\u65e0\u6cd5\u67e5\u8be2\u5230\u76d1\u7ba1\u5355\u4f4d");
        }
        BCompany addEntity = new BCompany();
        addEntity.setHospitalName(param.getHospitalName());
        addEntity.setName(name);
        addEntity.setCreditCode(creditCode);
        addEntity.setMedicalNucode(medicalNucode);
        addEntity.setMipLicenseNumber(param.getMipLicenseNumber());
        addEntity.setAreaId(param.getAreaId());
        addEntity.setAddress(param.getAddress());
        addEntity.setRegisteredAreaId(param.getRegisteredAreaId());
        addEntity.setRegisteredAddress(param.getRegisteredAddress());
        addEntity.setLegalName(param.getLegalName());
        addEntity.setLegalTel(param.getLegalTel());
        addEntity.setMainLeaderName(param.getMainLeaderName());
        addEntity.setMainLeaderTel(param.getMainLeaderTel());
        addEntity.setBelongType(param.getBelongType());
        addEntity.setSupervisionUnit(org.getId());
        addEntity.setSupervisionAreaId(org.getAreaId());
        addEntity.setSource(CmSourceEnum.RHO_ADMIN.getValue());
        if (CollUtil.isNotEmpty((Collection)param.getAddressEditParamList())) {
            addEntity.setAreaId(((BCompanyAddressEditParam)param.getAddressEditParamList().get(0)).getAreaId());
        }
        addEntity.setBusinessStatus(BusinessStatusEnum.NORMAL.getValue());
        addEntity.setIsTest(Integer.valueOf(0));
        addEntity.setEntryTime(LocalDateTime.now());
        if (addEntity.getId() == null) {
            addEntity.setOutId(IdWorker.get32UUID());
        }
        this.companyService.save(addEntity);
        if (CollUtil.isNotEmpty((Collection)param.getAddressEditParamList())) {
            for (BCompanyAddressEditParam companyAddressEditParam : param.getAddressEditParamList()) {
                if (companyAddressEditParam.getId() != null) continue;
                companyAddressEditParam.setCid(addEntity.getId());
                if (companyAddressEditParam.getName() != null) continue;
                companyAddressEditParam.setName("\u6267\u4e1a\u5730\u57401");
            }
        } else {
            throw new ServiceException("\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.companyAddressService.saveBatch(param.getAddressEditParamList());
        if (StrUtil.isNotBlank((CharSequence)param.getManagerName()) && StrUtil.isNotBlank((CharSequence)param.getManagerTel())) {
            CStaffBaseInfoEditParam managerAddParam = new CStaffBaseInfoEditParam();
            CStaffEditParam managerAddSubParam = new CStaffEditParam();
            managerAddParam.setSource(StaffSourceEnum.ADMIN.getValue());
            managerAddParam.setName(param.getManagerName());
            managerAddParam.setPhone(param.getManagerTel());
            managerAddSubParam.setCid(addEntity.getId());
            managerAddParam.setStaffEditParam(managerAddSubParam);
            this.staffEditManager.addManager(managerAddParam);
        }
        IdsParam idsParam = new IdsParam();
        idsParam.setIdList((List)CollUtil.toList((Object[])new Long[]{addEntity.getId()}));
        this.sysUserService.addUserByCidListForSup(idsParam);
        this.companyPushService.pushCompanyInfo(CollUtil.toList((Object[])new BCompany[]{addEntity}));
        this.companyErrorService.manualMaintenanceOne(addEntity.getId());
    }

    @Transactional
    public BCompany editBaseInfo(BCompanyEditParam param) {
        BCompany companyByName;
        this.trim(param);
        if (param.getId() == null) {
            throw new ServiceException("id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        BCompany db = (BCompany)this.companyService.getById(param.getId());
        BCompany old = (BCompany)ObjectUtil.cloneByStream((Object)db);
        if (!param.getId().equals(db.getId())) {
            throw new ServiceException("\u5f02\u5e38!");
        }
        BCompany bCompany = this.bCompanyConverter.editParam2Entity(param);
        bCompany.setUpdateBy(param.getLoginUserId());
        if (StrUtil.isNotEmpty((CharSequence)bCompany.getName()) && (companyByName = this.companyService.getCompanyByName(bCompany.getName())) != null && !companyByName.getId().equals(bCompany.getId())) {
            throw new ServiceException("\u533b\u9662\u540d\u79f0\u5df2\u5b58\u5728");
        }
        List addressEditParamList = param.getAddressEditParamList();
        if (db.getAddressType() == 0 && CollUtil.isNotEmpty((Collection)addressEditParamList) && addressEditParamList.size() >= 2) {
            throw new ServiceException("\u5355\u5730\u5740\u9662\u533a\u65e0\u6cd5\u7f16\u8f91\u591a\u5730\u5740");
        }
        Long areaId = null;
        if (CollUtil.isNotEmpty((Collection)addressEditParamList)) {
            areaId = ((BCompanyAddressEditParam)addressEditParamList.get(0)).getAreaId();
        }
        bCompany.setAreaId(areaId);
        bCompany.setMainLeaderName(DesensitizationUtils.ignoreSetDesensitizationField((String)bCompany.getMainLeaderName()));
        bCompany.setMainLeaderTel(DesensitizationUtils.ignoreSetDesensitizationField((String)bCompany.getMainLeaderTel()));
        bCompany.setLegalName(DesensitizationUtils.ignoreSetDesensitizationField((String)bCompany.getLegalName()));
        bCompany.setLegalTel(DesensitizationUtils.ignoreSetDesensitizationField((String)bCompany.getLegalTel()));
        this.companyService.updateById(bCompany);
        if (CollUtil.isNotEmpty((Collection)param.getAddressEditParamList())) {
            for (BCompanyAddressEditParam companyAddressEditParam : param.getAddressEditParamList()) {
                if (companyAddressEditParam.getId() == null) {
                    throw new ServiceException("\u5730\u5740id\u4e0d\u80fd\u4e3a\u7a7a");
                }
                companyAddressEditParam.setCid(param.getId());
            }
        } else {
            throw new ServiceException("\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.companyAddressService.saveBatch(param.getAddressEditParamList());
        BCompany newest = (BCompany)this.companyService.getById(param.getId());
        this.companyPushService.pushCompanyInfo(old, newest);
        this.companyErrorService.manualMaintenanceOne(newest.getId());
        return bCompany;
    }

    @Transactional
    public boolean editLicence(BCompanyAdminEditParam param) {
        if (param.getId() == null) {
            throw new ServiceException("\u7f3a\u5c11\u53c2\u6570");
        }
        if (param.getLicenceStatus() == null) {
            throw new ServiceException("\u7f3a\u5c11\u53c2\u6570");
        }
        BCompany company = (BCompany)this.companyService.getById(param.getId());
        if (company != null) {
            BCompany upEntity = new BCompany();
            upEntity.setId(param.getId());
            upEntity.setLicenceStatus(param.getLicenceStatus());
            this.companyService.updateById(upEntity);
        }
        return true;
    }

    private void trim(BCompanyAdminEditParam param) {
        param.setHospitalName(StrUtil.trim((CharSequence)param.getHospitalName()));
        param.setName(StrUtil.trim((CharSequence)param.getName()));
        param.setCreditCode(StrUtil.toUpperCase((CharSequence)StrUtil.trim((CharSequence)param.getCreditCode())));
        param.setMedicalNucode(StrUtil.trim((CharSequence)param.getMedicalNucode()));
        param.setAddress(StrUtil.trim((CharSequence)param.getAddress()));
        param.setRegisteredAddress(StrUtil.trim((CharSequence)param.getRegisteredAddress()));
        param.setLegalName(StrUtil.trim((CharSequence)param.getLegalName()));
        param.setLegalTel(StrUtil.trim((CharSequence)param.getLegalTel()));
        param.setMainLeaderName(StrUtil.trim((CharSequence)param.getMainLeaderName()));
        param.setMainLeaderTel(StrUtil.trim((CharSequence)param.getMainLeaderTel()));
    }

    private void trim(BCompanyEditParam param) {
        param.setName(StrUtil.trim((CharSequence)param.getName()));
        param.setCreditCode(StrUtil.toUpperCase((CharSequence)StrUtil.trim((CharSequence)param.getCreditCode())));
        param.setAddress(StrUtil.trim((CharSequence)param.getAddress()));
        param.setRegisteredAddress(StrUtil.trim((CharSequence)param.getRegisteredAddress()));
        param.setLegalName(StrUtil.trim((CharSequence)param.getLegalName()));
        param.setLegalTel(StrUtil.trim((CharSequence)param.getLegalTel()));
        param.setMainLeaderName(StrUtil.trim((CharSequence)param.getMainLeaderName()));
        param.setMainLeaderTel(StrUtil.trim((CharSequence)param.getMainLeaderTel()));
    }

    @Transactional
    public void editPilotUnit(List<Long> cidList, int isPilotUnit) {
        if (CollUtil.isEmpty(cidList)) {
            return;
        }
        ArrayList<BCompany> upEntityList = new ArrayList<BCompany>();
        for (Long cid : cidList) {
            BCompany upEntity = new BCompany();
            upEntity.setId(cid);
            upEntity.setIsPilotUnit(Integer.valueOf(isPilotUnit));
            upEntityList.add(upEntity);
        }
        this.companyService.updateBatchById(upEntityList);
    }
}

