/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.rho.modules.sys.manger.company;

import cn.smarthse.rho.modules.sys.entity.b.BCert;
import cn.smarthse.rho.modules.sys.entity.b.BCompany;
import cn.smarthse.rho.modules.sys.model.r.param.CompanyCertTimeUpdateParam;
import cn.smarthse.rho.modules.sys.service.b.IBCertService;
import cn.smarthse.rho.modules.sys.service.b.IBCompanyService;
import cn.smarthse.rho.modules.sys.service.b.IBLicenseManagementSettingService;
import cn.smarthse.rho.modules.sys.utils.company.CompanyCertUtil;
import java.time.LocalDateTime;
import java.util.List;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.redisson.api.RLock;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class CompanyCertTimeUpdateManager {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CompanyCertTimeUpdateManager.class);
    private final IBCompanyService companyService;
    private final IBCertService cmCertService;
    private final RedissonClient redissonClient;
    private final IBLicenseManagementSettingService licenseManagementSettingService;
    private static final String LOCK_KEY = "CompanyCertTimeUpdateManager";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateCertTime(CompanyCertTimeUpdateParam param) {
        log.debug("\u3010\u8bb8\u53ef\u8bc1\u65f6\u95f4\u7ef4\u62a4\u3011 start");
        StringBuilder sb = new StringBuilder(LOCK_KEY).append("_updateNextVerificationDate_").append(param.getLevel3AreaId());
        RLock lock = this.redissonClient.getLock(sb.toString());
        boolean resLock = false;
        try {
            resLock = lock.tryLock(5L, 600L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        if (resLock) {
            try {
                this.updateCertTimeLoc(param);
                log.debug("\u3010\u8bb8\u53ef\u8bc1\u65f6\u95f4\u7ef4\u62a4\u3011 end");
            }
            catch (Exception e) {
                log.error(e.toString());
            }
            finally {
                lock.unlock();
            }
        } else {
            log.error("{}\uff1a\u3010\u8bb8\u53ef\u8bc1\u65f6\u95f4\u7ef4\u62a4\u3011\u9501\u8d85\u65f6", (Object)LOCK_KEY);
        }
    }

    private void updateCertTimeLoc(CompanyCertTimeUpdateParam param) {
        List<Long> cidList = this.cmCertService.getNeedMaintainCertCidList(param);
        for (Long cid : cidList) {
            try {
                this.maintainOne(cid);
            }
            catch (Exception e) {
                log.error("\u3010\u8bb8\u53ef\u8bc1\u65f6\u95f4\u7ef4\u62a4\u3011\u5931\u8d25\uff0ccid{},e{}", (Object)cid, (Object)e);
            }
        }
    }

    private void maintainOne(Long cid) {
        BCompany company = (BCompany)this.companyService.getById(cid);
        BCert certDB = this.cmCertService.getByCid(cid);
        LocalDateTime beginDateDB = certDB.getBeginDate();
        LocalDateTime expireTimeDB = certDB.getEndDate();
        Integer pushType = this.licenseManagementSettingService.getPushTypeForSup(company.getAreaId());
        Integer cycleYear = CompanyCertUtil.calculateCycleYear((Integer)company.getType(), (Integer)company.getFloorNum());
        if (cycleYear == null) {
            log.error("\u3010\u8bb8\u53ef\u8bc1\u65f6\u95f4\u7ef4\u62a4\u3011cycleYear\u4e3a\u7a7a\uff0ccid{}", (Object)cid);
            return;
        }
        LocalDateTime beginDate = this.cmCertService.getBeginDateForGenRisk(cid);
        LocalDateTime lastVerificationDate = this.cmCertService.getLastVerificationDateForGenRisk(cid);
        LocalDateTime expireTime = CompanyCertUtil.calculateExpireDate((LocalDateTime)beginDate, (LocalDateTime)lastVerificationDate, (Integer)cycleYear, (int)pushType);
        BCert upEntity = new BCert();
        upEntity.setId(certDB.getId());
        upEntity.setBeginDate(beginDate);
        upEntity.setEndDate(expireTime);
        upEntity.setLastVerificationDate(lastVerificationDate);
        upEntity.setNextVerificationDate(expireTime);
        this.cmCertService.updateForMtTime(upEntity);
    }

    @Generated
    public CompanyCertTimeUpdateManager(IBCompanyService companyService, IBCertService cmCertService, RedissonClient redissonClient, IBLicenseManagementSettingService licenseManagementSettingService) {
        this.companyService = companyService;
        this.cmCertService = cmCertService;
        this.redissonClient = redissonClient;
        this.licenseManagementSettingService = licenseManagementSettingService;
    }
}

