/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.rho.modules.sys.manger.company;

import cn.smarthse.rho.modules.sys.entity.b.BCert;
import cn.smarthse.rho.modules.sys.model.r.param.CompanyCertMaintainParam;
import cn.smarthse.rho.modules.sys.service.b.IBCertService;
import java.time.LocalDateTime;
import java.util.List;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.redisson.api.RLock;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class CompanyCertManager {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CompanyCertManager.class);
    private final IBCertService companyCertService;
    private final RedissonClient redissonClient;
    private static final String LOCK_KEY = "CompanyCertManager";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void maintainCompanyCert(CompanyCertMaintainParam param) {
        log.debug("\u3010\u8bb8\u53ef\u8bc1\u7ef4\u62a4\u3011\u5f00\u59cb");
        StringBuilder sb = new StringBuilder(LOCK_KEY).append("maintainCompanyCert");
        RLock lock = this.redissonClient.getLock(sb.toString());
        boolean resLock = false;
        try {
            resLock = lock.tryLock(10L, 10L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        if (resLock) {
            try {
                this.maintainCompanyCertLock(param);
                log.debug("\u3010\u8bb8\u53ef\u8bc1\u7ef4\u62a4\u3011\u7ed3\u675f");
            }
            catch (Exception e) {
                log.error(e.toString());
            }
            finally {
                lock.unlock();
            }
        } else {
            log.error("{}\uff1a\u3010\u8bb8\u53ef\u8bc1\u7ef4\u62a4\u3011\u9501\u8d85\u65f6", (Object)LOCK_KEY);
        }
    }

    public void maintainCompanyCertLock(CompanyCertMaintainParam param) {
        this.companyCertService.initCertChangeLogCid(param);
        List<Long> cidList = this.companyCertService.getNeedSyncCertCidList(param);
        for (Long cid : cidList) {
            try {
                this.maintainOne(cid);
            }
            catch (Exception e) {
                log.error("\u3010\u8bb8\u53ef\u8bc1\u7ef4\u62a4\u3011\u5931\u8d25\uff0ccid{},e{}", (Object)cid, (Object)e);
            }
        }
    }

    private void maintainOne(Long cid) {
        BCert cert = this.companyCertService.getSyncBaseInfo(cid);
        LocalDateTime beginDate = this.companyCertService.getBeginDateForGenRisk(cid);
        LocalDateTime lastVerificationDate = this.companyCertService.getLastVerificationDateForGenRisk(cid);
        cert.setBeginDate(beginDate);
        cert.setLastVerificationDate(lastVerificationDate);
        BCert byCid = this.companyCertService.getByCid(cid);
        if (byCid != null) {
            cert.setId(byCid.getId());
        }
        this.companyCertService.saveOrUpdate(cert);
    }

    @Generated
    public CompanyCertManager(IBCertService companyCertService, RedissonClient redissonClient) {
        this.companyCertService = companyCertService;
        this.redissonClient = redissonClient;
    }
}

