/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.rho.modules.sys.manger.company;

import cn.hutool.core.collection.CollUtil;
import cn.smarthse.modules.datacentre.enums.CompanyBelongTypeEnum;
import cn.smarthse.modules.datacentre.provider.system.ISysAreaProvideService;
import cn.smarthse.modules.health.supervise.entity.basic.Organization;
import cn.smarthse.modules.health.supervise.service.basic.IOrganizationService;
import cn.smarthse.modules.platform.model.v3.sysArea.SysAreaV3OneVo;
import cn.smarthse.rho.core.framework.Constant;
import cn.smarthse.rho.modules.sys.entity.b.BCompany;
import cn.smarthse.rho.modules.sys.entity.b.BCompanyAddress;
import cn.smarthse.rho.modules.sys.service.b.IBCompanyAddressService;
import cn.smarthse.rho.modules.sys.service.b.IBCompanyService;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.dubbo.config.annotation.DubboReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class CompanyAddressManager {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CompanyAddressManager.class);
    private final IBCompanyService companyService;
    private final IBCompanyAddressService companyAddressService;
    @DubboReference(registry={"public_nacos"}, version="1.0.0")
    private ISysAreaProvideService sysAreaProvideService;
    @DubboReference(registry={"public_nacos"})
    private IOrganizationService organizationService;

    @Transactional
    public void CompanyAddressInit() {
        List existingCidList = this.companyAddressService.list().stream().map(BCompanyAddress::getCid).collect(Collectors.toList());
        HashSet existingCidSet = new HashSet(existingCidList);
        List companyList = this.companyService.list();
        ArrayList<BCompanyAddress> toInsert = new ArrayList<BCompanyAddress>();
        for (BCompany company : companyList) {
            if (existingCidSet.contains(company.getId())) continue;
            BCompanyAddress addr = new BCompanyAddress();
            addr.setId(Long.valueOf(IdWorker.getId()));
            addr.setCid(company.getId());
            addr.setName("\u6267\u4e1a\u5730\u57401");
            addr.setAreaId(company.getAreaId());
            addr.setAddress(company.getAddress());
            addr.setIsMain(Integer.valueOf(1));
            if (company.getAreaId() == null) {
                addr.setAreaId(Long.valueOf(330000000000L));
                addr.setAddress("\u6d59\u6c5f\u7701");
            }
            addr.setCreateBy(Constant.TASK_OPERATOR_ID);
            addr.setCreateDate(LocalDateTime.now());
            toInsert.add(addr);
        }
        if (!toInsert.isEmpty()) {
            this.companyAddressService.saveBatch(toInsert);
            log.info("companyAddress\u8868\u6279\u91cf\u65b0\u63d2\u5165\u4e86 {} \u6761\u6570\u636e", (Object)toInsert.size());
        }
    }

    @Transactional
    public void companyAddressMaintain() {
        List<BCompanyAddress> mainList = this.companyAddressService.getMainCompanyAddressList();
        if (CollUtil.isEmpty(mainList)) {
            return;
        }
        List<BCompany> companyList = this.companyService.getNeedMaintanceAddressCompanyList();
        if (CollUtil.isEmpty(companyList)) {
            return;
        }
        Map companyMap = companyList.stream().collect(Collectors.toMap(BCompany::getId, Function.identity()));
        for (BCompanyAddress main : mainList) {
            BCompany company = (BCompany)companyMap.get(main.getCid());
            if (company == null || company.getSupervisoryJurisdictionType() != 0) continue;
            boolean needUpdate1 = false;
            boolean needUpdate2 = false;
            BCompany param = new BCompany();
            param.setId(company.getId());
            if (!Objects.equals(main.getAreaId(), company.getAreaId())) {
                param.setAreaId(main.getAreaId());
                needUpdate1 = true;
            }
            if (!Objects.equals(main.getAddress(), company.getAddress())) {
                param.setAddress(main.getAddress());
                needUpdate2 = true;
            }
            if (needUpdate1 || needUpdate2) {
                param.setUpdateBy(Constant.TASK_OPERATOR_ID);
                param.setUpdateDate(LocalDateTime.now());
                this.companyService.updateById(param);
            }
            if (!needUpdate1) continue;
            company.setAreaId(main.getAreaId());
            this.maintanceCompanySupervision(company);
        }
    }

    private void maintanceCompanySupervision(BCompany company) {
        SysAreaV3OneVo area = this.sysAreaProvideService.getAreaByIdV3(company.getAreaId());
        if (Objects.isNull(area)) {
            return;
        }
        Long areaId = Objects.equals(company.getBelongType(), CompanyBelongTypeEnum.SHI.getValue()) ? area.getCityId() : (Objects.equals(company.getBelongType(), CompanyBelongTypeEnum.SHENG.getValue()) ? area.getProvinceId() : area.getAreaId());
        Organization org = this.organizationService.getOrganizationByAreaId(areaId);
        if (Objects.isNull(org)) {
            return;
        }
        company.setSupervisionUnit(org.getId());
        company.setSupervisionAreaId(org.getAreaId());
        company.setUpdateBy(Constant.TASK_OPERATOR_ID);
        company.setUpdateDate(LocalDateTime.now());
        this.companyService.updateById(company);
    }

    @Generated
    public CompanyAddressManager(IBCompanyService companyService, IBCompanyAddressService companyAddressService) {
        this.companyService = companyService;
        this.companyAddressService = companyAddressService;
    }
}

